/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.AdditionNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.NumberNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;

public class ExponentNode
extends ExpressionTreeNode {
    public ExponentNode(ArrayList<ExpressionTreeNode> children, Boolean negated, ExpressionTreeProperties properties) {
        super(children, negated, properties);
        if (this.children.size() != 2) {
            throw new Error("ExponentNode constructor being called with children.size !=2");
        }
    }

    @Override
    public ExponentNode clone() {
        ArrayList<ExpressionTreeNode> newChildren = new ArrayList<ExpressionTreeNode>();
        newChildren.add(this.getBase().clone());
        newChildren.add(this.getPower().clone());
        return new ExponentNode(newChildren, this.negated, this.properties);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("XN ");
        if (this.stringNeedsRecreation) {
            sb.append('{');
            if (this.negated) {
                sb.append('!');
            }
            sb.append(this.getBase()).append('^').append(this.getPower());
            sb.append('}');
        } else {
            sb.append(this.myString);
        }
        return sb.toString();
    }

    @Override
    protected void orderTerms() {
    }

    @Override
    protected void orderTermsRecursive() {
        this.getBase().orderTermsRecursive();
        this.getPower().orderTermsRecursive();
        this.stringNeedsRecreation = true;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getSimpleName() + ".orderTermsRecursive() result: " + this.toCanonicalString(4));
        }
    }

    @Override
    protected ExpressionTreeNode removeIdentityOperandsAndDemote(boolean simpleTermsOnly) {
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "XN.removeIdentityOperandsAndDemote() " + this.getNegatedString() + " recursing down on base " + this.getBase().getNegatedString() + ", power " + this.getPower().getNegatedString());
        }
        this.setBase(this.getBase().removeIdentityOperandsAndDemote(simpleTermsOnly));
        this.setPower(this.getPower().removeIdentityOperandsAndDemote(simpleTermsOnly));
        this.stringNeedsRecreation = true;
        if (this.isIdentity(this.getPower(), null)) {
            boolean newNegated = this.getBase().negated ^ this.negated;
            if (trace.getDebugCode("functions")) {
                trace.out("functions", "XN.removeIdentityOperandsAndDemote() " + this.getNegatedString() + " returning base node " + this.getBase().getNegatedString() + " with base.negated " + this.getBase().negated + " ^ this.negated" + this.negated + " = " + newNegated);
            }
            this.getBase().negated = newNegated;
            return this.getBase();
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "XN.removeIdentityOperandsAndDemote() " + this.getNegatedString() + " returning original node with base " + this.getBase().getNegatedString() + ", power " + this.getPower().getNegatedString());
        }
        return this;
    }

    @Override
    protected boolean isIdentity(ExpressionTreeNode operand, boolean[] negated) {
        if (!(operand instanceof NumberNode)) {
            return false;
        }
        double value = ((NumberNode)operand).getNegatedValue();
        if (negated != null && negated.length > 0) {
            negated[0] = value < 0.0;
        }
        return value == 1.0;
    }

    @Override
    protected String toCanonicalString(int callerLevel) {
        StringBuilder sb = new StringBuilder();
        if (callerLevel < this.getNodeLevel()) {
            sb.append('(');
        }
        sb.append('(').append(this.getBase().toCanonicalString(this.getNodeLevel())).append(')');
        sb.append('^');
        sb.append('(').append(this.getPower().toCanonicalString(this.getNodeLevel())).append(')');
        if (callerLevel < this.getNodeLevel()) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public ExpressionTreeNode performComplexSimplification() {
        ExpressionTreeNode result = this.getBase().performComplexSimplification();
        if (result != null) {
            this.setBase(result);
        }
        if ((result = this.getPower().performComplexSimplification()) != null) {
            this.setPower(result);
        }
        if (this.getBase().getClass().equals(NumberNode.class) && this.getPower().getClass().equals(NumberNode.class)) {
            Double base = ((NumberNode)this.getBase()).getNegatedValue();
            Double power = ((NumberNode)this.getPower()).getNegatedValue();
            return new NumberNode(Double.toString(Math.pow(base, power)), this.properties);
        }
        return this;
    }

    @Override
    protected ExponentNode mergeMultiplicands(ExpressionTreeNode candidate) {
        ExpressionTreeNode cbase = candidate;
        ExpressionTreeNode cpower = new NumberNode("1", this.properties);
        if (cbase.getClass().equals(ExponentNode.class)) {
            cbase = ((ExponentNode)candidate).getBase();
            cpower = ((ExponentNode)candidate).getPower();
        }
        if (this.getBase().getNegatedString().equals(cbase.getNegatedString())) {
            this.stringNeedsRecreation = true;
            if (this.getPower().getClass().equals(NumberNode.class) && cpower.getClass().equals(NumberNode.class)) {
                Double sum2 = ((NumberNode)this.getPower()).getNegatedValue();
                sum2 = sum2 + ((NumberNode)cpower).getNegatedValue();
                this.setPower(new NumberNode(Double.toString(sum2), this.properties));
            } else {
                ArrayList<ExpressionTreeNode> addends = new ArrayList<ExpressionTreeNode>();
                addends.add(this.getPower());
                addends.add(cpower);
                AdditionNode newPower = new AdditionNode(addends, false, this.properties);
                this.setPower(newPower.performComplexSimplification());
            }
            if (candidate.negated) {
                this.negate();
            }
            return this;
        }
        return null;
    }

    @Override
    protected ExpressionTreeNode attemptCancelTerms(ExpressionTreeNode divisor) {
        ExpressionTreeNode dbase = divisor;
        ExpressionTreeNode dpower = new NumberNode("1.0", this.properties);
        if (dbase.getClass().equals(ExponentNode.class)) {
            dbase = ((ExponentNode)divisor).getBase();
            dpower = ((ExponentNode)divisor).getPower();
        }
        if (this.getBase().getNegatedString().equals(dbase.getNegatedString())) {
            Boolean isNegated = dbase.negated ^ this.negated;
            if (this.getPower().getNegatedString().equals(dpower.getNegatedString())) {
                NumberNode result = new NumberNode("1.0", this.properties);
                if (isNegated.booleanValue()) {
                    result.negate();
                }
                return result;
            }
            if (this.getPower().getClass() == NumberNode.class && dpower.getClass() == NumberNode.class) {
                Double sum2 = ((NumberNode)this.getPower()).getNegatedValue() - ((NumberNode)dpower).getNegatedValue();
                if (sum2 == 0.0) {
                    throw new Error("WTF sum = 0 divideby.. exponentNode");
                }
                if (sum2 == 1.0) {
                    this.getBase().negated = isNegated;
                    return this.getBase();
                }
                this.setPower(new NumberNode(Double.toString(sum2), this.properties));
                this.negated = isNegated;
                return this;
            }
            ArrayList<ExpressionTreeNode> children = new ArrayList<ExpressionTreeNode>();
            children.add(this.getPower());
            dpower.negate();
            children.add(dpower);
            ExpressionTreeNode power = new AdditionNode(children, false, this.properties);
            power = ((ExpressionTreeNode)power).performComplexSimplification();
            this.setPower(power);
            this.negated = isNegated;
            return this;
        }
        return null;
    }

    @Override
    protected Boolean eval_internal() {
        Boolean eval_success = true;
        eval_success = this.getBase().eval_internal() != false && eval_success != false;
        eval_success = this.getPower().eval_internal() != false && eval_success != false;
        Double total = 0.0;
        if (eval_success.booleanValue()) {
            total = Math.pow(this.getBase().getEvalValue(), this.getPower().getEvalValue());
            if (this.negated) {
                total = -1.0 * total;
            }
            this.setEvalValue(total);
        }
        return eval_success;
    }

    @Override
    protected String getNonNegatedString(boolean preserveSimpleTerms) {
        if (!this.stringNeedsRecreation) {
            return this.myString;
        }
        String tot = "";
        tot = tot + "(";
        if (this.children.size() < 2) {
            return "ERROR";
        }
        tot = tot + this.getBase().getNegatedString(preserveSimpleTerms) + "^" + this.getPower().getNegatedString(preserveSimpleTerms) + ")";
        this.setString(tot);
        this.stringNeedsRecreation = false;
        return this.myString;
    }

    public ExpressionTreeNode getBase() {
        return (ExpressionTreeNode)this.children.get(0);
    }

    public ExpressionTreeNode getPower() {
        return (ExpressionTreeNode)this.children.get(1);
    }

    public void setBase(ExpressionTreeNode x) {
        this.children.set(0, x);
        this.stringNeedsRecreation = true;
    }

    public void setPower(ExpressionTreeNode x) {
        this.children.set(1, x);
        this.stringNeedsRecreation = true;
    }
}

