/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateWriter;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphNode;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphVertexView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphController;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphPanel;
import edu.cmu.pact.Utilities.trace;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import org.jgraph.graph.GraphLayoutCache;

public class ProblemNode
implements Serializable {
    private static final long serialVersionUID = -1362273373937073806L;
    public static final String ELEMENT_NAME = "node";
    private NodeView nodeView;
    private int outDegree;
    private int correctOutDegree;
    private int nodeOrder;
    private int uniqueID;
    private ProblemNode nextNode;
    private ProblemNode prevNode;
    private ProblemModel problemModel;
    private BR_JGraphNode jGraphNode;
    private boolean doneState = false;
    private String name;
    public final String ATTEMPT_SUCCESS = "SUCCESS";
    public final String ATTEMPT_ERROR = "ERROR";

    public String toString() {
        return this.getName();
    }

    public ProblemNode() {
    }

    public ProblemNode(ProblemModel problemModel, String name) {
        this(null, name, problemModel);
    }

    public ProblemNode(NodeView nodeView, ProblemModel problemModel) {
        this(nodeView, null, problemModel);
    }

    public ProblemNode(NodeView nodeView, String name, ProblemModel problemModel) {
        if (trace.getDebugCode(ELEMENT_NAME)) {
            trace.out(ELEMENT_NAME, ">>>ProblemNode(" + nodeView + "," + name + "," + problemModel + ")");
        }
        if (nodeView != null) {
            this.nodeView = nodeView;
            this.nodeView.setProblemNode(this);
            this.name = nodeView.getText();
        } else {
            this.name = name;
        }
        this.problemModel = problemModel;
        this.uniqueID = problemModel.getNodeUniqueIDGenerator();
        this.outDegree = 0;
        this.setPrevNode(null);
        this.setNextNode(null);
    }

    public NodeView getNodeView() {
        return this.nodeView;
    }

    public void setNextNode(ProblemNode nextNode) {
        this.nextNode = nextNode;
    }

    public ProblemNode getNextNode() {
        return this.nextNode;
    }

    public void setPrevNode(ProblemNode prevNode) {
        this.prevNode = prevNode;
    }

    public ProblemNode getPrevNode() {
        return this.prevNode;
    }

    void setCorrectOutDegree(int correctOutDegree) {
        this.correctOutDegree = correctOutDegree;
    }

    public int getCorrectOutDegree() {
        return this.correctOutDegree;
    }

    void setOutDegree(int outDegree) {
        this.outDegree = outDegree;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    void setNodeOrder(int nodeOrder) {
        this.nodeOrder = nodeOrder;
    }

    int getNodeOrder() {
        return this.nodeOrder;
    }

    public int getInDegree() {
        return this.getIncomingEdges().size();
    }

    public List<ProblemEdge> getIncomingEdges() {
        ArrayList<ProblemEdge> list = new ArrayList<ProblemEdge>();
        Enumeration<ProblemEdge> iterEdges = this.problemModel.getProblemGraph().getIncomingEdges(this);
        while (iterEdges.hasMoreElements()) {
            ProblemEdge edge = iterEdges.nextElement();
            list.add(edge);
        }
        return list;
    }

    public List<ProblemEdge> getConnectingEdges() {
        ArrayList<ProblemEdge> list = new ArrayList<ProblemEdge>();
        Enumeration<ProblemEdge> iterEdges = this.problemModel.getProblemGraph().getConnectingEdges(this);
        while (iterEdges.hasMoreElements()) {
            ProblemEdge edge = iterEdges.nextElement();
            list.add(edge);
        }
        return list;
    }

    public List<ProblemEdge> getOutgoingEdges() {
        return this.getOutgoingEdges(null);
    }

    public List<ProblemEdge> getCorrectOutgoingEdges() {
        return this.getOutgoingEdges("Correct Action");
    }

    private List<ProblemEdge> getOutgoingEdges(String actionType) {
        ArrayList<ProblemEdge> list = new ArrayList<ProblemEdge>();
        Enumeration<ProblemEdge> iterEdges = this.problemModel.getProblemGraph().getOutgoingEdges(this);
        while (iterEdges.hasMoreElements()) {
            ProblemEdge edge = iterEdges.nextElement();
            if (actionType != null && !actionType.equalsIgnoreCase(edge.getActionType())) continue;
            list.add(edge);
        }
        return list;
    }

    private boolean hasSingleValidOutLink(ProblemNode nodeTest) {
        ProblemEdge edgeTemp = null;
        int validLinkcount = 0;
        Enumeration<ProblemEdge> iterEdges = this.problemModel.getProblemGraph().getOutgoingEdges(nodeTest);
        while (iterEdges.hasMoreElements()) {
            edgeTemp = iterEdges.nextElement();
            if (edgeTemp.isCorrectorFireableBuggy()) {
                ++validLinkcount;
            }
            if (validLinkcount <= 1) continue;
            return false;
        }
        return validLinkcount != 0;
    }

    private boolean isEdgeExist(ProblemEdge edgeTest) {
        Enumeration<ProblemEdge> iter = this.problemModel.getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge edgeTemp = iter.nextElement();
            if (edgeTemp != edgeTest) continue;
            return true;
        }
        return false;
    }

    public Vector findPathDepthFirst_forJessOracle(ProblemNode startNode, ProblemNode endNode) {
        if (startNode == endNode) {
            return null;
        }
        ProblemEdge edge = null;
        edge = startNode.isChildNode(endNode);
        if (edge != null) {
            Vector<ProblemEdge> path = new Vector<ProblemEdge>();
            path.add(0, edge);
            return path;
        }
        Vector<ProblemNode> children = startNode.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        for (int i = 0; i < children.size(); ++i) {
            ProblemNode childNode = children.elementAt(i);
            Vector path = this.findPathDepthFirst_forJessOracle(childNode, endNode);
            if (path == null) continue;
            path.add(0, startNode.isChildNode(childNode));
            return path;
        }
        return null;
    }

    public static boolean isEdgesListsOverlap(Vector edgesList1, Vector edgesList2) {
        if (edgesList1 == null || edgesList2 == null) {
            return false;
        }
        if (edgesList1.size() == 0 || edgesList2.size() == 0) {
            return false;
        }
        for (int i = 0; i < edgesList1.size(); ++i) {
            ProblemEdge edgeTemp1 = (ProblemEdge)edgesList1.elementAt(i);
            EdgeData myEdgeTemp = edgeTemp1.getEdgeData();
            Vector selection1 = myEdgeTemp.getSelection();
            for (int j = 0; j < edgesList2.size(); ++j) {
                ProblemEdge edgeTemp2 = (ProblemEdge)edgesList2.elementAt(j);
                myEdgeTemp = edgeTemp2.getEdgeData();
                Vector selection2 = myEdgeTemp.getSelection();
                if (!selection1.toString().equalsIgnoreCase(selection2.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public void findDescendentEdgesList(ProblemNode atNode, Vector descendentEdgesList) {
        if (this.problemModel.isLeaf(atNode)) {
            return;
        }
        Enumeration<ProblemEdge> iter = this.problemModel.getProblemGraph().getOutgoingEdges(atNode);
        while (iter.hasMoreElements()) {
            ProblemEdge edgeTemp = iter.nextElement();
            if (ProblemModel.testEdgeInVector(edgeTemp, descendentEdgesList)) continue;
            descendentEdgesList.addElement(edgeTemp);
            this.findDescendentEdgesList(edgeTemp.getNodes()[1], descendentEdgesList);
        }
    }

    public Vector findLockedParentEdgesList(Vector parentEdgesList) {
        Vector lockedParentEdgesList = new Vector();
        for (int i = 0; i < parentEdgesList.size(); ++i) {
            ProblemEdge edgeTemp = (ProblemEdge)parentEdgesList.elementAt(i);
            this.addEdgeToList(edgeTemp, lockedParentEdgesList);
        }
        return lockedParentEdgesList;
    }

    private void addEdgeToList(ProblemEdge edgeAdd, Vector lockedParentEdgesList) {
        if (edgeAdd == null || lockedParentEdgesList == null) {
            return;
        }
        EdgeData myEdgeAdd = edgeAdd.getEdgeData();
        if (!myEdgeAdd.getActionType().equalsIgnoreCase("Correct Action")) {
            return;
        }
        for (int i = 0; i < lockedParentEdgesList.size(); ++i) {
            ProblemEdge edgeTemp = (ProblemEdge)lockedParentEdgesList.elementAt(i);
            if (!this.problemModel.compareTwoStatesSame(edgeAdd, edgeTemp, false)) continue;
            return;
        }
        lockedParentEdgesList.addElement(edgeAdd);
    }

    public boolean isLeaf() {
        return this.problemModel.isLeaf(this);
    }

    public boolean isBuggyNode() {
        return this.problemModel.isBuggyNode(this);
    }

    public Vector getParents() {
        Vector<ProblemNode> v = new Vector<ProblemNode>();
        Enumeration<ProblemNode> parents = this.problemModel.getProblemGraph().parents(this);
        while (parents.hasMoreElements()) {
            ProblemNode node1 = parents.nextElement();
            v.addElement(node1);
        }
        return v;
    }

    public boolean hasOutGoingPreferredEdge(ProblemEdge excludeEdge) {
        List<ProblemEdge> targetOutEdges = this.getOutgoingEdges();
        for (int i = 0; i < targetOutEdges.size(); ++i) {
            ProblemEdge tempEdge = targetOutEdges.get(i);
            if (tempEdge == excludeEdge || !tempEdge.isPreferredEdge()) continue;
            return true;
        }
        return false;
    }

    public Vector getNeighbors() {
        Vector<ProblemNode> v = new Vector<ProblemNode>();
        Enumeration<ProblemNode> neighbors = this.problemModel.getProblemGraph().neighbors(this);
        while (neighbors.hasMoreElements()) {
            ProblemNode node1 = neighbors.nextElement();
            v.addElement(node1);
        }
        return v;
    }

    public ProblemEdge isChildNode(ProblemNode node) {
        List<ProblemEdge> outgoingEdges = this.getOutgoingEdges();
        for (int i = 0; i < outgoingEdges.size(); ++i) {
            ProblemEdge problemEdge = outgoingEdges.get(i);
            if (!node.equals(problemEdge.getDest())) continue;
            return problemEdge;
        }
        return null;
    }

    public Vector<ProblemNode> getChildren() {
        Vector<ProblemNode> children = new Vector<ProblemNode>();
        List<ProblemEdge> outgoingEdges = this.getOutgoingEdges();
        for (ProblemEdge problemEdge : outgoingEdges) {
            children.add(problemEdge.getDest());
        }
        return children;
    }

    public String getName() {
        return this.name != null && this.name.length() > 0 ? this.name : Integer.toString(this.uniqueID);
    }

    public void setName(String name) {
        String oldName = this.name;
        if (trace.getDebugCode(ELEMENT_NAME)) {
            trace.out(ELEMENT_NAME, ">>>ProblemNode.setName(" + name + ") oldName " + oldName);
        }
        this.name = name;
        if (this.problemModel != null) {
            this.problemModel.renameNode(this, oldName, name);
        }
    }

    public ProblemNode getDeadEnd() {
        return this.getNextCorrectChild() == null ? this : this.getNextCorrectChild().getDeadEnd();
    }

    private ProblemNode getNextCorrectChild() {
        ProblemNode result = null;
        ProblemGraph pg = this.problemModel.getProblemGraph();
        Vector<ProblemNode> children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ProblemNode child = children.get(i);
            ProblemEdge edge = pg.lookupProblemEdge(this, child);
            if (!edge.isCorrect() && !edge.isGiven()) continue;
            result = child;
            break;
        }
        return result;
    }

    public void setJGraphNode(BR_JGraphNode jGraphNode) {
        this.jGraphNode = jGraphNode;
    }

    public BR_JGraphNode getJGraphNode() {
        return this.jGraphNode;
    }

    public boolean isSelectedNode() {
        if (this.problemModel.getController() != null) {
            return this.problemModel.getController().getSolutionState().getCurrentNode() == this;
        }
        return false;
    }

    public boolean isDoneState() {
        return this.getDoneState();
    }

    public boolean isAncestorNode(ProblemNode testNode) {
        Vector ancestorNodesList = new Vector();
        this.problemModel.findAncestorNodesList(this, ancestorNodesList);
        return this.problemModel.testNodeInVector(testNode, ancestorNodesList);
    }

    public BR_Controller getController() {
        return this.problemModel.getController();
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public boolean getDoneState() {
        return this.doneState;
    }

    public void setDoneState(boolean isDoneState) {
        this.doneState = isDoneState;
    }

    public void setUniqueID(int uniqueIDValue) {
        this.uniqueID = uniqueIDValue;
        if (this.problemModel == null) {
            return;
        }
        this.problemModel.updateNodeUniqueIDGenerator(uniqueIDValue);
    }

    public String cltLogStatus() {
        String result = "SUCCESS";
        List<ProblemEdge> outgoingEdges = this.getOutgoingEdges();
        for (int i = 0; i < outgoingEdges.size(); ++i) {
            ProblemEdge problemEdge = outgoingEdges.get(i);
            if (problemEdge.isCorrect()) continue;
            result = "ERROR";
            break;
        }
        return result;
    }

    public ProblemModel getProblemModel() {
        return this.problemModel;
    }

    public boolean isStudentBeginsHereState() {
        ProblemNode sbhNode;
        ProblemNode problemNode = sbhNode = this.problemModel == null ? null : this.problemModel.getStudentBeginsHereState();
        if (sbhNode == null) {
            return false;
        }
        return sbhNode.getUniqueID() == this.getUniqueID();
    }

    public boolean isBeforeStartState() {
        return this.problemModel.isBeforeStudentBegins(this);
    }

    public Vector<ProblemEdge> findSolutionPathAlgebra() {
        return this.findSolutionPathAlgebra(new String[2]);
    }

    public Vector<ProblemEdge> findSolutionPathAlgebra(String[] equation) {
        if (this.isLeaf()) {
            return new Vector<ProblemEdge>();
        }
        List<ProblemEdge> outEdges = this.getOutgoingEdges();
        ProblemEdge backupWrongAnswer = null;
        for (ProblemEdge edge : outEdges) {
            if (edge.isCorrect()) {
                String selection = edge.getSelection();
                String input = edge.getInput();
                if (selection.equalsIgnoreCase("DONE")) {
                    Vector<ProblemEdge> path = new Vector<ProblemEdge>();
                    path.add(0, edge);
                    return path;
                }
                int idx = selection.indexOf("_") - 1;
                if (idx < 0) {
                    return null;
                }
                char c = selection.charAt(idx);
                int col = c - 49 + 1;
                switch (col) {
                    case 1: {
                        equation[0] = input;
                        break;
                    }
                    case 2: {
                        equation[1] = input;
                        break;
                    }
                    case 3: {
                        equation[1] = null;
                        equation[0] = null;
                    }
                }
                ProblemNode child = edge.getDest();
                Vector<ProblemEdge> path = child.findSolutionPathAlgebra(equation);
                if (path != null) {
                    path.add(0, edge);
                    return path;
                }
                path = new Vector();
                path.add(0, edge);
                return path;
            }
            if (edge.getInput().equalsIgnoreCase("FALSE")) continue;
            if (backupWrongAnswer != null) {
                if (!backupWrongAnswer.getDest().isLeaf() || edge.getDest().isLeaf()) continue;
                backupWrongAnswer = edge;
                continue;
            }
            backupWrongAnswer = edge;
        }
        if (backupWrongAnswer != null) {
            ProblemNode child = backupWrongAnswer.getDest();
            Vector<ProblemEdge> path = child.findSolutionPathAlgebra(equation);
            if (path != null) {
                path.add(0, backupWrongAnswer);
                return path;
            }
            path = new Vector();
            path.add(0, backupWrongAnswer);
            return path;
        }
        return null;
    }

    private boolean isAlgebraEqSolved(String[] equation) {
        if (this.isVarTerm(equation[0])) {
            return this.isConstTerm(equation[1]);
        }
        if (this.isConstTerm(equation[0])) {
            return this.isVarTerm(equation[1]);
        }
        return false;
    }

    private boolean isConstTerm(String string) {
        if (string == null) {
            return false;
        }
        boolean isConstantTerm = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-' || '0' <= c && c <= '9') continue;
            isConstantTerm = false;
            break;
        }
        return isConstantTerm;
    }

    private boolean isVarTerm(String string) {
        boolean isVarTerm = string != null && string.length() == 1 && "a".compareToIgnoreCase(string) <= 0 && string.compareToIgnoreCase("z") <= 0;
        return isVarTerm;
    }

    public Element toElement() {
        GraphLayoutCache graphView;
        Element elt = new Element(ELEMENT_NAME);
        elt.setAttribute("locked", Boolean.toString(this.nodeView == null ? false : this.nodeView.getLocked()));
        elt.setAttribute("doneState", Boolean.toString(this.getDoneState()));
        Element child = new Element("text").setText(this.nodeView == null ? this.name : this.nodeView.getText());
        elt.addContent((Content)child);
        child = new Element("uniqueID").setText(Integer.toString(this.getUniqueID()));
        elt.addContent((Content)child);
        Rectangle2D rect = new Rectangle(1, 1, 1, 1);
        BR_JGraphNode graphNode = this.getJGraphNode();
        JGraphPanel jgWindow = this.getController() == null ? null : this.getController().getJGraphWindow();
        JGraphController jgController = jgWindow == null ? null : jgWindow.getJGraphController();
        GraphLayoutCache graphLayoutCache = graphView = jgController == null ? null : jgController.getGraphView();
        if (graphView != null && graphNode != null) {
            BR_JGraphVertexView jgraphNodeView = (BR_JGraphVertexView)graphView.getMapping((Object)graphNode, false);
            rect = jgraphNodeView.getBounds();
        } else {
            trace.err("jgraphNodeView null: graphNode " + graphNode + ", graphNode " + graphNode + ", nodeView " + this.nodeView + ", .text " + this.nodeView.getText());
        }
        child = new Element("dimension");
        child.addContent((Content)new Element("x").setText(Integer.toString((int)rect.getX())));
        child.addContent((Content)new Element("y").setText(Integer.toString((int)rect.getY())));
        elt.addContent((Content)child);
        return elt;
    }

    public String toXMLString() {
        return ProblemStateWriter.multiLineOutputter.outputString(this.toElement());
    }
}

