/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import edu.cmu.hcii.runcc.MemorySerializedParser;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.UsesProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions.UsesVariableTable;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import fri.patterns.interpreter.parsergenerator.Parser;
import fri.patterns.interpreter.parsergenerator.Semantic;
import fri.patterns.interpreter.parsergenerator.semantics.ReflectSemantic;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class CTATFunctions
extends ReflectSemantic {
    private static final String[][] rules = new String[][]{{"EXPRESSION", "TERM"}, {"EXPRESSION", "EXPRESSION", "'+'", "TERM"}, {"EXPRESSION", "EXPRESSION", "'-'", "TERM"}, {"TERM", "FACTOR"}, {"TERM", "TERM", "'*'", "FACTOR"}, {"TERM", "TERM", "'/'", "FACTOR"}, {"FACTOR", "SFACTOR"}, {"FACTOR", "'-'", "FACTOR"}, {"SFACTOR", "'('", "EXPRESSION", "')'"}, {"SFACTOR", "FUNCALL"}, {"SFACTOR", "VARREF"}, {"SFACTOR", "LITERAL"}, {"FUNCALL", "`identifier`", "'('", "')'"}, {"FUNCALL", "`identifier`", "'('", "ARGS", "')'"}, {"ARGS", "ARGS", "','", "ARG"}, {"ARGS", "ARG"}, {"ARG", "EXPRESSION"}, {"LITERAL", "RESERVED"}, {"LITERAL", "NUMBER"}, {"LITERAL", "STRING"}, {"RESERVED", "\"null\""}, {"RESERVED", "\"true\""}, {"RESERVED", "\"false\""}, {"STRING", "`stringdef`"}, {"NUMBER", "`number`"}, {"VARREF", "VAR"}, {"VAR", "VAR", "'.'", "SIMPLEVAR"}, {"VAR", "SIMPLEVAR"}, {"SIMPLEVAR", "`identifier`"}, {"ignored", "`whitespaces`"}};
    private boolean _validateMode = false;
    private boolean _valid = true;
    private String _validMsg;
    private Class _returnType = null;
    private String _selection = null;
    private String _action = null;
    private String _input = null;
    private VariableTable _variableTable;
    private ProblemModel _problemModel;
    private static final String NO_VALUE = "NULL";
    private static final char[] elementTypeEncodings = new char[]{'Z', 'B', 'C', 'D', 'F', 'I', 'J', 'S'};
    private static final Class[] elementTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private ByteArrayOutputStream _parserStream;
    private Parser _parser;
    private static final Pattern interpolateSplitPattern = Pattern.compile("<%=|%>");

    public CTATFunctions(VariableTable variableTable, ProblemModel problemModel) {
        this(variableTable, problemModel, null);
    }

    public CTATFunctions(VariableTable variableTable, ProblemModel problemModel, Parser parser) {
        this._variableTable = variableTable;
        this._problemModel = problemModel;
        this._parser = parser;
        if (this._parser != null) {
            this._parser.setPrintStream(new PrintStream(this.parserStream()));
        }
    }

    private Object getVariableReference(Object variable) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "looking up variable reference " + variable + " in vt #" + this._variableTable.getInstance());
        }
        if ("selection".equals(variable)) {
            return this._selection;
        }
        if ("action".equals(variable)) {
            return this._action;
        }
        if ("input".equals(variable)) {
            return this._input;
        }
        Object o = this._variableTable.get(variable, this._problemModel);
        return o == null && this._validateMode ? NO_VALUE : o;
    }

    protected Class paramClass(Object param) {
        if (param instanceof Integer) {
            return Integer.TYPE;
        }
        if (param instanceof Double) {
            return Double.TYPE;
        }
        if (param instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (param == null) {
            return null;
        }
        return param.getClass();
    }

    protected static boolean isSuperclass(Class c1, Class c2) {
        for (Class superClass = c2; superClass != null; superClass = superClass.getSuperclass()) {
            if (superClass != c1) continue;
            return true;
        }
        return false;
    }

    public static Class varArgClass(Method m) {
        int i;
        if (m.getParameterTypes().length == 0) {
            return null;
        }
        Class<?> lastParam = m.getParameterTypes()[m.getParameterTypes().length - 1];
        if (!m.isVarArgs() || !lastParam.isArray()) {
            return null;
        }
        String lastParamName = lastParam.getName();
        int lastParamLen = lastParamName.length();
        for (i = 0; i < lastParamLen && lastParamName.charAt(i) == '['; ++i) {
        }
        char lastParamChar = lastParamName.charAt(i);
        if (lastParamChar == 'L') {
            String className = lastParamName.substring(i + 1, lastParamLen - 1);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                System.err.println("no class found: " + className);
                return null;
            }
        }
        for (int eltTypeIdx = 0; eltTypeIdx < elementTypes.length; ++eltTypeIdx) {
            if (elementTypeEncodings[eltTypeIdx] != lastParamChar) continue;
            return elementTypes[eltTypeIdx];
        }
        return null;
    }

    protected boolean matchSignature(Method m, String name, Class[] params, List args) {
        if (!name.equals(m.getName())) {
            return false;
        }
        if (!CTATFunctions.argCountOk(m, params)) {
            return false;
        }
        if (this._validateMode) {
            return true;
        }
        Class varArgClass = CTATFunctions.varArgClass(m);
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            if (varArgClass != null && i == m.getParameterTypes().length - 1) {
                for (int j = i; j < params.length; ++j) {
                    if (this.isAssignableFrom(varArgClass, params[j]) || this.canCastArg(varArgClass, args, j) || this.canConvertToNumber(varArgClass, args, j)) continue;
                    return false;
                }
                continue;
            }
            Class<?> argClass = m.getParameterTypes()[i];
            if (this.isAssignableFrom(argClass, params[i]) || this.canCastArg(argClass, args, i) || this.canConvertToNumber(argClass, args, i)) continue;
            return false;
        }
        return true;
    }

    private boolean canConvertToNumber(Class cls, List args, int i) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "cls " + cls + ", arg[" + i + "] " + args.get(i) + ", isInstance(Number) " + cls.isInstance(Number.class) + ", toNumber() " + CTATFunctions.toNumber(args.get(i)));
        }
        if (!(cls.isPrimitive() && cls != Boolean.TYPE && cls != Character.TYPE || Number.class.isAssignableFrom(cls))) {
            return false;
        }
        return CTATFunctions.toNumber(args.get(i)) != null;
    }

    private boolean canCastArg(Class tgtClass, List args, int j) {
        if (args == null) {
            return false;
        }
        return this.canCast(tgtClass, args.get(j));
    }

    private boolean canCast(Class tgtClass, Object arg) {
        try {
            if (arg == null) {
                return !tgtClass.isPrimitive();
            }
            if (!tgtClass.isPrimitive()) {
                return tgtClass.isInstance(arg);
            }
            if (arg instanceof Boolean) {
                return tgtClass.equals(Boolean.TYPE);
            }
            if (arg instanceof Character) {
                return tgtClass.equals(Character.TYPE);
            }
            if (!(arg instanceof Number)) {
                return false;
            }
            if (tgtClass.equals(Double.TYPE)) {
                return true;
            }
            if (arg instanceof Double) {
                return false;
            }
            if (tgtClass.equals(Float.TYPE)) {
                return true;
            }
            if (arg instanceof Float) {
                return false;
            }
            if (tgtClass.equals(Long.TYPE)) {
                return true;
            }
            return !(arg instanceof Long);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    private boolean isAssignableFrom(Class lhsClass, Class rhsClass) {
        if (lhsClass == null) {
            return false;
        }
        if (rhsClass == null) {
            return !lhsClass.isPrimitive();
        }
        return lhsClass.isAssignableFrom(rhsClass);
    }

    private static boolean argCountOk(Method m, Class[] actualParamClasses) {
        if (m.isVarArgs()) {
            return m.getParameterTypes().length <= actualParamClasses.length;
        }
        return m.getParameterTypes().length == actualParamClasses.length;
    }

    protected Object varArgsInvoke(Method m, Object o, List args) throws Exception {
        Class<?>[] paramTypes = m.getParameterTypes();
        int lastParamIdx = paramTypes.length - 1;
        Class varArgCls = CTATFunctions.varArgClass(m);
        Object varArgs = Array.newInstance(varArgCls, args.size() - lastParamIdx);
        for (int i = lastParamIdx; i < args.size(); ++i) {
            Array.set(varArgs, i - lastParamIdx, this.convertArg(varArgCls, args.get(i)));
        }
        if (args.size() > lastParamIdx) {
            switch (lastParamIdx) {
                case 0: {
                    return m.invoke(o, varArgs);
                }
                case 1: {
                    return m.invoke(o, this.convertArg(paramTypes[0], args.get(0)), varArgs);
                }
                case 2: {
                    return m.invoke(o, this.convertArg(paramTypes[0], args.get(0)), this.convertArg(paramTypes[1], args.get(1)), varArgs);
                }
                case 3: {
                    return m.invoke(o, this.convertArg(paramTypes[0], args.get(0)), this.convertArg(paramTypes[1], args.get(1)), this.convertArg(paramTypes[2], args.get(2)), varArgs);
                }
                case 4: {
                    return m.invoke(o, this.convertArg(paramTypes[0], args.get(0)), this.convertArg(paramTypes[1], args.get(1)), this.convertArg(paramTypes[2], args.get(2)), this.convertArg(paramTypes[3], args.get(3)), varArgs);
                }
            }
            throw new IllegalStateException("var args method with more than " + lastParamIdx + " fixed arguments: " + m);
        }
        return null;
    }

    Object argsInvoke(Method m, Object o, List args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] actualArgs = new Object[args.size()];
        Class<?>[] formalArgTypes = m.getParameterTypes();
        for (int i = 0; i < Math.min(actualArgs.length, formalArgTypes.length); ++i) {
            actualArgs[i] = this.convertArg(formalArgTypes[i], args.get(i));
        }
        return m.invoke(o, actualArgs);
    }

    private Object convertArg(Class cls, Object obj) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "cls " + cls + ", obj " + obj + (obj == null ? "" : ", type " + obj.getClass().getSimpleName()) + (obj == null ? "" : ", assignable " + cls.isAssignableFrom(obj.getClass())));
        }
        if (obj == null) {
            return obj;
        }
        if (cls.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (!cls.isPrimitive()) {
            return obj;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.parseBoolean(obj.toString());
        }
        if (cls == Character.TYPE) {
            return Character.valueOf(obj.toString().charAt(0));
        }
        Number result = CTATFunctions.toNumber(obj);
        if (result == null) {
            return null;
        }
        if (cls == Float.TYPE && result.getClass() == Double.class) {
            return Float.valueOf((float)result.doubleValue());
        }
        return result;
    }

    protected static Method compareMethods(Class[] desiredTypes, Method m1, Method m2) {
        int i;
        if (m1 == null) {
            return m2;
        }
        Class<?>[] m1Types = m1.getParameterTypes();
        Class<?>[] m2Types = m2.getParameterTypes();
        for (i = 0; i < m1Types.length; ++i) {
            if (m1Types[i] == m2Types[i]) continue;
            if (m1Types[i] == desiredTypes[i]) {
                return m1;
            }
            if (m2Types[i] != desiredTypes[i]) continue;
            return m2;
        }
        for (i = 0; i < m1Types.length; ++i) {
            if (m1Types[i] == m2Types[i]) continue;
            if (CTATFunctions.isSuperclass(m1Types[i], m2Types[i])) {
                return m2;
            }
            if (!CTATFunctions.isSuperclass(m2Types[i], m1Types[i])) continue;
            return m1;
        }
        return m1;
    }

    protected Method lookupMethod(Class c, String name, Class[] params, List args) {
        Method[] methods = c.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!this.matchSignature(methods[i], name, params, args)) continue;
            method = CTATFunctions.compareMethods(params, method, methods[i]);
        }
        return method;
    }

    protected Method lookupMethod(Class c, String name, List args) {
        Class[] params = new Class[args.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.paramClass(args.get(i));
        }
        return this.lookupMethod(c, name, params, args);
    }

    public Object FUNCALL(Object IDENTIFIER, Object leftParen, Object rightParen) throws IllegalStateException {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "parsing function " + IDENTIFIER + "() w/ no arguments");
        }
        return this.FUNCALL(IDENTIFIER, leftParen, new ArrayList(), rightParen);
    }

    public Object FUNCALL(Object IDENTIFIER, Object leftParen, Object ARGS, Object rightParen) throws IllegalStateException {
        ArrayList<Object> paramArgs;
        Object[] obj;
        String id = (String)IDENTIFIER;
        List<Object> args = (ArrayList<Object>)ARGS;
        Object[] objectArray = obj = args.size() > 0 ? new Object[1] : null;
        if (obj != null) {
            obj[0] = args.get(0);
        }
        List<Object> list = paramArgs = args.size() > 0 ? args.subList(1, args.size()) : new ArrayList<Object>();
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "function name: " + IDENTIFIER + ", args: " + this.showArgs(args));
        }
        try {
            Object o = null;
            Method m = obj == null || obj[0] == null ? null : this.lookupMethod(obj[0].getClass(), id, paramArgs);
            m = this.omitObjectEquals(m);
            if (m != null) {
                o = obj[0];
                args = paramArgs;
            } else {
                m = this.lookupMethod(Class.forName("java.lang.Math"), id, args);
                if ((m = this.omitObjectEquals(m)) == null) {
                    String functionId = "edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions." + id;
                    Class<?> functionClass = null;
                    try {
                        functionClass = Class.forName(functionId);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (trace.getDebugCode("functions")) {
                            trace.out("functions", "no such class: " + functionId);
                        }
                        functionClass = null;
                    }
                    if (functionClass != null) {
                        m = this.lookupMethod(functionClass, id, args);
                        if (m == null && (m = this.lookupStringArgsMethod(functionClass, id, args)) != null) {
                            args = CTATFunctions.stringify(args);
                        }
                        if (m != null) {
                            o = functionClass.newInstance();
                            this.setProblemModelVariableTableInFunction(o);
                        }
                    }
                }
                if (m == null && (this._validateMode || obj != null && obj[0] == null)) {
                    m = this.lookupMethod(String.class, id, paramArgs);
                    o = new String("null");
                    args = paramArgs;
                }
            }
            if (trace.getDebugCode("functions")) {
                trace.outNT("functions", "CTATFunctions.FUNCALL(ID,(,ARGs,)) found method\n " + (m == null ? "null" : m.toGenericString()));
            }
            if (m != null) {
                this.setReturnType(m.getReturnType());
                if (m.isVarArgs()) {
                    return this._validateMode ? NO_VALUE : this.varArgsInvoke(m, o, args);
                }
                return this._validateMode ? NO_VALUE : this.argsInvoke(m, o, args);
            }
            throw new IllegalStateException("no method found: " + id + "(" + this.showArgs(args) + ")");
        }
        catch (Exception e) {
            System.err.println(e);
            if (this._validateMode) {
                this._valid = false;
                this._validMsg = "Function not found: " + id + "(";
                try {
                    if (args != null) {
                        for (int i = 0; i < args.size(); ++i) {
                            if (i > 0) {
                                this._validMsg = this._validMsg + ", ";
                            }
                            this._validMsg = this._validMsg + args.get(i).getClass().getName();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                this._validMsg = this._validMsg + ")";
                return NO_VALUE;
            }
            throw new IllegalStateException(e);
        }
    }

    private void setProblemModelVariableTableInFunction(Object fn) {
        if (fn instanceof UsesProblemModel) {
            ((UsesProblemModel)fn).setProblemModel(this._problemModel);
        }
        if (fn instanceof UsesVariableTable) {
            ((UsesVariableTable)fn).setVariableTable(this._variableTable);
        }
    }

    private Method omitObjectEquals(Method m) {
        if (m == null) {
            return null;
        }
        if (!"equals".equals(m.getName())) {
            return m;
        }
        Class<?>[] params = m.getParameterTypes();
        if (params.length != 1) {
            return m;
        }
        if (Object.class.equals(params[0])) {
            return null;
        }
        return m;
    }

    private String showArgs(List args) {
        if (args == null) {
            return "**null list**";
        }
        StringBuffer sb = new StringBuffer("(");
        for (Object arg : args) {
            if (arg == null) {
                sb.append("null");
            } else {
                sb.append(arg.getClass().getSimpleName()).append(' ').append(arg.toString());
            }
            sb.append(", ");
        }
        if (args.size() > 0) {
            sb.replace(sb.length() - 2, sb.length(), ")");
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public static List<String> stringify(List args) {
        ArrayList<String> result = new ArrayList<String>(args.size());
        for (Object element2 : args) {
            result.add(CTATFunctions.stringify(element2));
        }
        return result;
    }

    public static String stringify(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return CTATFunctions.stringifyNumber((Number)obj);
        }
        return obj.toString();
    }

    public static String stringifyNumber(Number n) {
        String result = n.toString();
        if (n instanceof Double || n instanceof Float) {
            return result.endsWith(".0") ? result.substring(0, result.length() - 2) : result;
        }
        return result;
    }

    private Method lookupStringArgsMethod(Class functionClass, String id, List<Object> args) {
        int nArgs = args == null ? 0 : args.size();
        Object[] stringArgs = new Class[nArgs];
        Arrays.fill(stringArgs, String.class);
        return this.lookupMethod(functionClass, id, (Class[])stringArgs, args);
    }

    public Object ARGS(Object ARGS, Object comma, Object ARG) {
        ((List)ARGS).add(ARG);
        return ARGS;
    }

    public Object ARGS(Object ARG) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ARG);
        return list;
    }

    public Object ARG(Object o) {
        return o;
    }

    public Object LITERAL(Object o) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "LITERAL(" + (o == null ? "" : o.getClass().getSimpleName()) + " " + o + ")");
        }
        this.setReturnType(o);
        return o;
    }

    public Object RESERVED(Object o) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "RESERVED(" + (o == null ? "" : o.getClass().getSimpleName()) + " " + o + ")");
        }
        if (o instanceof String) {
            if ("null".equals(o)) {
                o = null;
            } else if ("true".equals(o)) {
                o = Boolean.TRUE;
            } else if ("false".equals(o)) {
                o = Boolean.FALSE;
            }
        }
        return o;
    }

    public Object NUMBER(Object numdef) {
        try {
            Integer result = Integer.valueOf(numdef.toString());
            if (trace.getDebugCode("functions")) {
                trace.outNT("functions", "NUMBER(" + (numdef == null ? "" : numdef.getClass().getSimpleName()) + " " + numdef + ") rtns (Integer) " + result);
            }
            this.setReturnType(Integer.class);
            return result;
        }
        catch (NumberFormatException nfe) {
            Double result = Double.valueOf(numdef.toString());
            if (trace.getDebugCode("functions")) {
                trace.outNT("functions", "NUMBER(" + (numdef == null ? "" : numdef.getClass().getSimpleName()) + " " + numdef + ") rtns (Double) " + result);
            }
            this.setReturnType(Double.class);
            return result;
        }
    }

    public Object STRING(Object stringdef) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "STRING(" + (stringdef == null ? "" : stringdef.getClass().getSimpleName()) + " " + stringdef + ")");
        }
        this.setReturnType(String.class);
        return ((String)stringdef).substring(1, ((String)stringdef).length() - 1);
    }

    public Object VARREF(Object VAR) {
        Object value = this.getVariableReference(VAR);
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "VARREF(" + VAR + ") -> " + (value == null ? "null" : value.getClass().getSimpleName()) + " " + value);
        }
        this.setReturnType(value);
        return value;
    }

    public Object VAR(Object VAR, Object dot, Object SIMPLEVAR) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "VAR(" + (VAR == null ? "" : VAR.getClass().getSimpleName()) + " " + VAR + ") '" + dot + "' " + (SIMPLEVAR == null ? "" : SIMPLEVAR.getClass().getSimpleName()) + " " + SIMPLEVAR + ")");
        }
        return (String)VAR + "." + (String)SIMPLEVAR;
    }

    public Object VAR(Object SIMPLEVAR) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "VAR(" + (SIMPLEVAR == null ? "" : SIMPLEVAR.getClass().getSimpleName()) + " " + SIMPLEVAR + ")");
        }
        return SIMPLEVAR;
    }

    public Object EXPRESSION(Object TERM) {
        return TERM;
    }

    public Object EXPRESSION(Object EXPRESSION, Object operator, Object TERM) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "EXPRESSION(" + EXPRESSION + ", " + operator + ", " + TERM + ")");
        }
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "EXPRESSION is a " + (EXPRESSION == null ? "null" : EXPRESSION.getClass().getName()));
        }
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "TERM is a " + (TERM == null ? "null" : TERM.getClass().getName()));
        }
        this.setReturnType(Double.class);
        if (this._validateMode) {
            return NO_VALUE;
        }
        return this.binaryArithmeticOperation((String)operator, EXPRESSION, TERM);
    }

    private Object binaryArithmeticOperation(Object operator, Object expression, Object term) {
        char op = ((String)operator).charAt(0);
        Integer i1 = CTATFunctions.toInteger(expression);
        Integer i2 = CTATFunctions.toInteger(term);
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "binaryArithmeticOp(" + operator + "," + expression + "," + term + "): i1 " + i1 + ",i2 " + i2);
        }
        if (i1 != null && i2 != null) {
            this.setReturnType(Integer.class);
            switch (op) {
                case '+': {
                    return new Integer(i1 + i2);
                }
                case '-': {
                    return new Integer(i1 - i2);
                }
                case '*': {
                    return new Integer(i1 * i2);
                }
                case '/': {
                    Number result = this.divideInteger(i1, i2);
                    this.setReturnType(result.getClass());
                    return result;
                }
            }
            throw new IllegalArgumentException("CTATFunctions: undefined arithmetic operator \"" + op + "\"");
        }
        Double d1 = CTATFunctions.toDouble(expression);
        Double d2 = CTATFunctions.toDouble(term);
        if (d1 != null && d2 != null) {
            Double result = null;
            switch (op) {
                case '+': {
                    result = new Double(d1 + d2);
                    break;
                }
                case '-': {
                    result = new Double(d1 - d2);
                    break;
                }
                case '*': {
                    result = new Double(d1 * d2);
                    break;
                }
                case '/': {
                    if (d2 == 0.0) {
                        throw new IllegalArgumentException("CTATFunctions: divide by zero \"" + op + "\"");
                    }
                    result = new Double(d1 / d2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("CTATFunctions: undefined arithmetic operator \"" + op + "\"");
                }
            }
            Integer intResult = CTATFunctions.toInteger(result);
            if (intResult != null) {
                this.setReturnType(Integer.class);
                return intResult;
            }
            this.setReturnType(Double.class);
            return result;
        }
        this.setReturnType(null);
        return null;
    }

    private Number divideInteger(Integer dividend, Integer divisor) {
        int n = dividend;
        int d = divisor;
        if (d == 0) {
            throw new IllegalArgumentException("CTATFunctions: divide by zero \"" + dividend + "/" + divisor + "\"");
        }
        if (n % d == 0) {
            return new Integer(n / d);
        }
        return new Double(dividend.doubleValue() / divisor.doubleValue());
    }

    public Object TERM(Object FACTOR) {
        return FACTOR;
    }

    public Object TERM(Object TERM, Object operator, Object FACTOR) {
        this.setReturnType(Double.class);
        if (this._validateMode) {
            return NO_VALUE;
        }
        return this.binaryArithmeticOperation((String)operator, TERM, FACTOR);
    }

    public Object FACTOR(Object SFACTOR) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "FACTOR(" + (SFACTOR == null ? "" : SFACTOR.getClass().getSimpleName()) + " " + SFACTOR + ")");
        }
        this.setReturnType(SFACTOR);
        return SFACTOR;
    }

    public Object SFACTOR(Object value) {
        if (trace.getDebugCode("functions")) {
            trace.outNT("functions", "SFACTOR(" + (value == null ? "" : value.getClass().getSimpleName()) + " " + value + ")");
        }
        this.setReturnType(value);
        return value;
    }

    public Object FACTOR(Object minus, Object FACTOR) {
        this.setReturnType(Double.class);
        if (this._validateMode) {
            return NO_VALUE;
        }
        Double factor = CTATFunctions.toDouble(FACTOR);
        if (factor == null) {
            this.setReturnType(null);
            return null;
        }
        return new Double(-factor.doubleValue());
    }

    public Object SFACTOR(Object leftParenthesis, Object EXPRESSION, Object rightParenthesis) {
        this.setReturnType(EXPRESSION);
        return EXPRESSION;
    }

    public String getValidMsg() {
        return this._validMsg;
    }

    public Class getReturnType() {
        return this._returnType;
    }

    public void setReturnType(Object o) {
        if (NO_VALUE == o) {
            return;
        }
        this._returnType = o == null || o instanceof Class ? (Class)o : o.getClass();
    }

    private ByteArrayOutputStream parserStream() {
        if (this._parserStream == null) {
            this._parserStream = new ByteArrayOutputStream();
        }
        return this._parserStream;
    }

    public String errorString() {
        String err = this.parserStream().toString();
        if (err == null || err.length() == 0) {
            err = this._validMsg;
        }
        return err;
    }

    private Parser parser() throws Exception {
        long now = new Date().getTime();
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "before parser constr: _parser " + this._parser);
        }
        if (this._parser == null) {
            this._parser = new MemorySerializedParser().get(CTATFunctions.getRules(), "CTATFunctions");
            this._parser.setPrintStream(new PrintStream(this.parserStream()));
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", " after parser constr: took (ms) " + (new Date().getTime() - now));
        }
        return this._parser;
    }

    private static String[] interpolateSplit(String message) {
        return interpolateSplitPattern.split(message);
    }

    public static boolean interpolatable(String message) {
        if (message == null) {
            return false;
        }
        String[] parts = CTATFunctions.interpolateSplit(message);
        return parts != null && parts.length > 1;
    }

    public String interpolate(String message, String selection, String action, String input) {
        if (trace.getDebugCode("interpolate")) {
            trace.outln("interpolate", "will interploate: " + message);
        }
        String[] parts = CTATFunctions.interpolateSplit(message);
        StringBuffer interpolated = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            String nextPart;
            try {
                nextPart = i % 2 == 1 ? this.evaluate(parts[i], selection, action, input) : parts[i];
            }
            catch (Exception e) {
                System.err.println("Error evaluating " + parts[i] + ": " + e);
                e.printStackTrace(System.err);
                nextPart = "#!ERROR";
            }
            interpolated.append((Object)nextPart);
        }
        if (trace.getDebugCode("interpolate")) {
            trace.outln("interpolate", "interploated: " + interpolated);
        }
        return interpolated.toString();
    }

    public String interpolate(String message) {
        return this.interpolate(message, null, null, null);
    }

    public Object evaluate(String expression, String selection, String action, String input) throws Exception {
        boolean ok;
        Object result;
        this._selection = selection;
        this._action = action;
        this._input = input;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "evaluate to parse expression [" + expression + "]");
        }
        Object object = result = (ok = this.parser().parse((Object)expression, (Semantic)this)) ? this.parser().getResult() : null;
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "evaluated expression [" + expression + "]: ok? " + ok + ", result " + result);
        }
        if (ok) {
            return result;
        }
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "error string is " + this.errorString());
        }
        throw new IllegalStateException(this.errorString());
    }

    public Object evaluate(String expression) throws Exception {
        return this.evaluate(expression, null, null, null);
    }

    private String rootCause(Throwable e) {
        if (e.getCause() != null) {
            return this.rootCause(e.getCause());
        }
        return e.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(String input) {
        try {
            this._validateMode = true;
            this._valid = true;
            this.evaluate(input);
            this._validateMode = false;
            if (!this._valid) {
                if (trace.getDebugCode("functions")) {
                    trace.outln("functions", input + " is not valid");
                }
                if (trace.getDebugCode("functions")) {
                    trace.outln("functions", this._validMsg);
                }
            } else if (trace.getDebugCode("functions")) {
                trace.outln("functions", input + " is valid");
            }
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "return type: " + this.getReturnType());
            }
            boolean bl = this._valid;
            return bl;
        }
        catch (Exception e) {
            this._validMsg = input + " is not valid:\n" + e.getMessage();
            System.err.println(this._validMsg);
            boolean bl = false;
            return bl;
        }
        finally {
            this._validateMode = false;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length <= 0) {
            System.err.println("SYNTAX: java " + CTATFunctions.class.getName() + " \"function(arg1, arg2, ...)\"");
            System.exit(1);
        }
        String input = args[0];
        System.err.println("Processing input >" + input + "<");
        VariableTable vt = new VariableTable();
        vt.put("x", (Object)new Double(2.0));
        vt.put("y", (Object)new Double(3.0));
        vt.put("str", (Object)"abcdefg");
        CTATFunctions ctat = new CTATFunctions(vt, null);
        try {
            System.out.println(input + " = " + ctat.evaluate(input));
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace(System.err);
        }
    }

    public static Double toDouble(Object o) {
        Number n = CTATFunctions.toNumber(o);
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof Number) {
            return new Double(n.doubleValue());
        }
        return null;
    }

    public static Integer toInteger(Object o) {
        Long nL;
        Number n = CTATFunctions.toNumber(o);
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Double && (nL = new Long(Math.round(n.doubleValue()))).doubleValue() == n.doubleValue()) {
            return new Integer(nL.intValue());
        }
        return null;
    }

    public static Number toNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof String) {
            try {
                Integer i = Integer.valueOf((String)o);
                return i;
            }
            catch (NumberFormatException nfe) {
                try {
                    Double d = Double.valueOf((String)o);
                    return d;
                }
                catch (NumberFormatException nfe2) {
                    return null;
                }
            }
        }
        return null;
    }

    private static Number intOrDouble(Number n) {
        double i;
        if (n == null) {
            return null;
        }
        double d = n.doubleValue();
        if (d < -2.147483648E9 || 2.147483647E9 < d) {
            return new Double(d);
        }
        double d2 = i = d < 0.0 ? Math.ceil(d) : Math.floor(d);
        if (d == i) {
            return new Integer((int)i);
        }
        return new Double(d);
    }

    public static String[][] getRules() {
        return rules;
    }

    public Parser getParser() {
        return this._parser;
    }

    VariableTable getVariableTable() {
        return this._variableTable;
    }

    public void setVariableTable(VariableTable vt) {
        this._variableTable = vt;
    }
}

