/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class matchWithPrecision {
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    public static final Pattern fpPattern = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

    private void printMatches(String input, String label) {
        Matcher m = fpPattern.matcher(input);
        System.out.println(input);
        if (m.matches()) {
            System.out.println(input + " double value = " + Double.valueOf(input));
            System.out.println(input + " significant digits = " + this.significantDigits(m));
        } else {
            System.out.println("no " + label + " match found");
        }
        System.out.println("\n\n\n");
    }

    private int significantDigits(Matcher m) {
        int count = 0;
        int[] digitGroups = new int[]{5, 7, 12};
        boolean foundSignificant = false;
        for (int i : digitGroups) {
            String digitsGroup = m.group(i);
            if (digitsGroup == null) continue;
            for (char c : digitsGroup.toCharArray()) {
                if (c != '0') {
                    foundSignificant = true;
                }
                if (!foundSignificant) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean matchWithPrecision(String input, String number) {
        Matcher inputMatcher = fpPattern.matcher(input);
        Matcher numberMatcher = fpPattern.matcher(number);
        return inputMatcher.matches() && numberMatcher.matches() && Double.compare(Double.valueOf(input), Double.valueOf(number)) == 0 && this.significantDigits(inputMatcher) == this.significantDigits(numberMatcher);
    }

    public boolean matchWithPrecision(String input, double number) {
        return this.matchWithPrecision(input, Double.toString(number));
    }

    public boolean matchWithPrecision(double input, String number) {
        return this.matchWithPrecision(Double.toString(input), number);
    }

    public boolean matchWithPrecision(double input, double number) {
        return this.matchWithPrecision(Double.toString(input), Double.toString(number));
    }

    public void checkMatch(String input, String number) {
        boolean check = this.matchWithPrecision(input, number);
        System.out.println("matchWithPrecision(" + input + ", " + number + ") = " + check);
    }

    public static void main(String[] args) throws Exception {
        matchWithPrecision withPrec = new matchWithPrecision();
        withPrec.checkMatch("0.9", "0.900");
        withPrec.checkMatch("0.09", "9E-2");
        withPrec.checkMatch("0.09", "9.000E-2");
        withPrec.checkMatch("0.9", ".9");
        withPrec.checkMatch("0.9", "0.9");
        withPrec.checkMatch("9E-1", "90E-2");
    }
}

