/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.Dialogs.PackageEnumerator;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;

public class FunctionTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 201404011110L;
    private final TransferHandler delegate;

    public FunctionTransferHandler(TransferHandler orig) {
        super("text");
        if (trace.getDebugCode("transferhandler")) {
            trace.out("transferhandler", "FunctionTransferHandler.<init>() orig is " + trace.nh(orig));
        }
        this.delegate = orig;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        if (trace.getDebugCode("transferhandler")) {
            trace.out("transferhandler", "FunctionTransferHandler.exportAsDrag(" + trace.nh(comp) + "," + e + "," + action + ")");
        }
        this.delegate.exportAsDrag(comp, e, action);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        if (trace.getDebugCode("transferhandler")) {
            trace.out("transferhandler", "FunctionTransferHandler.exportToClipboard(" + trace.nh(comp) + "," + trace.nh(clip) + "," + action + ")");
        }
        this.delegate.exportToClipboard(comp, clip, action);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport ts) {
        if (trace.getDebugCode("transferhandler")) {
            trace.out("transferhandler", "FunctionTransferHandler.importData() isDrop " + ts.isDrop() + ", transferable " + trace.nh(ts.getTransferable()));
        }
        try {
            Component cmp;
            if (ts.isDrop() && (cmp = ts.getComponent()) instanceof JTextComponent) {
                JTextComponent txtCmp = (JTextComponent)cmp;
                Object value = ts.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (trace.getDebugCode("transferhandler")) {
                    trace.out("transferhandler", "FunctionTransferHandler.importData() getTransferData() returns" + trace.nh(value) + " \"" + value + "\"");
                }
                Point cursor = ts.getDropLocation().getDropPoint();
                if (value != null) {
                    String s = PackageEnumerator.extractMethodSignature(value.toString());
                    int pos = cursor != null ? txtCmp.viewToModel(cursor) : txtCmp.getDocument().getLength();
                    txtCmp.getDocument().insertString(pos, s, null);
                    return true;
                }
            }
        }
        catch (Exception e) {
            trace.errStack("VectorMatcherPanel.createTextArea() transferHandler.importData() error", e);
        }
        return this.delegate.importData(ts);
    }
}

