/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.WildcardMatcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WildcardMatcherPanel
extends MatcherPanel {
    private JTextField inputField;

    public WildcardMatcherPanel(EdgeData edgeData, boolean allow, int max_students) {
        this(edgeData, allow, max_students, 0);
    }

    public WildcardMatcherPanel(EdgeData edgeData, boolean allow, int max_students, int selectionIndex) {
        super(edgeData, allow, max_students, "<html>Wildcard Match will match student actions using patterns <br>you can specify below.  It uses a simple regular expression pattern where * <br>represents any number of characters.  Special characters such as {, \\, or & should be avoided. <br><br>Example 1:  \"*_text\" would match \"_text\", \"this_text\", \"xxx_text\", or \"123abc_text\"<br>Example 2:  \"abc*xyz\" would match \"abcxyz\", or \"abc123xyz\"", new Box(0));
        JLabel inputLabel = new JLabel("Input: ");
        inputLabel.setName("inputLabel");
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.SAIPane.add((Component)inputLabel, this.c);
        this.inputField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.inputField);
        this.inputField.setName("inputField");
        this.inputField.setColumns(30);
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.inputField, this.c);
        if (edgeData.getMatcher() instanceof WildcardMatcher) {
            WildcardMatcher m = (WildcardMatcher)edgeData.getMatcher();
            this.actionField.setText(m.getSimpleActionPattern());
            this.selectionField.setText(m.getSimpleSelectionPattern());
            this.inputField.setText(m.getSimpleInputPattern());
        } else {
            this.selectionField.setText(edgeData.getSelection().get(selectionIndex).toString());
            this.actionField.setText(edgeData.getAction().get(0).toString());
            this.inputField.setText(edgeData.getInput().get(0).toString());
        }
        Box actorBox = new Box(0);
    }

    @Override
    public Matcher createMatcher() {
        WildcardMatcher am = new WildcardMatcher();
        am.setActionPattern(this.actionField.getText());
        am.setSelectionPattern(this.selectionField.getText());
        am.setInputPattern(this.inputField.getText());
        am.setActorPattern("Student");
        Matcher m = this.edgeData.getMatcher();
        if (m != null) {
            am.setDefaultInput(m.getDefaultInput());
            am.setDefaultAction(m.getDefaultAction());
            am.setDefaultSelection(m.getDefaultSelection());
            am.setDefaultActor(m.getDefaultActor());
        }
        return am;
    }

    @Override
    public String getMatcherType() {
        return "Wildcard Match";
    }
}

