/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemRuleParser;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateReaderJDom;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.CtatFrame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProblemStateReader {
    private BR_Controller controller;
    private ProblemStateReaderJDom psrJDom;
    private byte[] savedImage = null;
    public static final String CURRENT_BRD_VERSION = "4.0";
    public static final String VERSION_ATTR = "version";
    private final File tmpFile = new File("./junk.txt");

    public ProblemStateReader(BR_Controller controller) {
        this.controller = controller;
    }

    public Vector<RuleProduction> loadProblemRules(String problemFullName) {
        Vector<RuleProduction> problemRules = new Vector<RuleProduction>();
        try {
            ProblemRuleParser handler = new ProblemRuleParser(problemRules);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new File(problemFullName), (DefaultHandler)handler);
        }
        catch (IOException e) {
            trace.err("Error reading file: " + problemFullName);
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        return problemRules;
    }

    private void doConclusionPart(String authorMode) {
        this.getProblemModel().setStartNodeCreatedFlag(true);
        if (authorMode != null && !Utils.isRuntime()) {
            this.controller.getCtatModeModel().setAuthorMode(authorMode, false);
        }
        Enumeration<ProblemEdge> enumeration = this.getProblemModel().getProblemGraph().edges();
        while (enumeration.hasMoreElements()) {
            ProblemEdge temp = enumeration.nextElement();
            temp.getEdgeData().updateToolTip();
        }
    }

    public boolean openBRDiagramFile(String filename) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        NewProblemEvent event = new NewProblemEvent((Object)this.controller, this.controller.getPreferencesModel().getBooleanValue("Commutativity"));
        this.getProblemModel().fireProblemModelEvent(event);
        InputStream is = null;
        File f = null;
        String absolutePath = null;
        String title = "Error loading graph file";
        URL url = null;
        try {
            trace.out("br", "READ FILE WITH JDOM: filename " + filename);
            url = new URL(filename);
            trace.out("br", "READ FILE WITH JDOM: url " + url);
            URLConnection conn = url.openConnection();
            trace.out("br", "READ FILE WITH JDOM: conn " + conn);
            is = conn.getInputStream();
            trace.out("br", "READ FILE WITH JDOM: is " + is);
            absolutePath = filename;
        }
        catch (Exception e) {
            trace.err("Error opening " + filename + " or reading as URL: " + e + "; cause " + e.getCause());
            try {
                f = Utils.getFileAsResource(url);
                absolutePath = f.getCanonicalPath();
                is = new FileInputStream(f);
            }
            catch (Exception d) {
                trace.err("Error on getFileAsResource(" + url + ") or getCanonicalPath(): " + d + "; cause " + d.getCause());
                absolutePath = filename;
                try {
                    f = new File(filename);
                    is = new FileInputStream(f);
                    absolutePath = f.getCanonicalPath();
                }
                catch (Exception e2) {
                    trace.errStack("Error on new File(" + filename + ") or getCanonicalPath(): " + e2, e2);
                    if (trace.getDebugCode("mg")) {
                        trace.out("mg", "ProblemStateReader (openBRDDiagramFile): Exception " + e2);
                    }
                    String message = "<html>Error opening file " + filename + ":<br/>" + e2 + (e2.getCause() == null ? "" : ".<br/>Cause: " + e2.getCause());
                    Utils.showExceptionOccuredDialog(null, message, title);
                    this.controller.getProblemModel().reset("", "");
                    return false;
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        long count = 0L;
        try {
            int c = -1;
            while (0 <= (c = is.read())) {
                ++count;
                baos.write(c);
            }
        }
        catch (Exception e2) {
            String message = "<html>Error reading file " + filename + " at " + count + ":<br/>" + e2 + (e2.getCause() == null ? "" : ".<br/>Cause: " + e2.getCause());
            e2.printStackTrace();
            Utils.showExceptionOccuredDialog(null, message, title);
            return false;
        }
        return this.openBRDFromByteArray(baos.toByteArray(), filename, absolutePath);
    }

    public boolean openBRDiagramByteArray(byte[] brdImage, String filename) {
        return this.openBRDFromByteArray(brdImage, filename, filename);
    }

    private boolean openBRDFromByteArray(byte[] brdImage, String filename, String absolutePath) {
        this.savedImage = brdImage;
        ByteArrayInputStream bais = new ByteArrayInputStream(brdImage);
        if (trace.getDebugCode("psw")) {
            try {
                trace.out("psw", String.format("PSR.openBRDiagramFile(%s) image length %d begins\n  %.130s", filename, brdImage.length, new String(Arrays.copyOf(brdImage, 130), "UTF-8")));
            }
            catch (Exception e) {
                trace.errStack("Programming error: UTF-8 gives error " + e, e);
            }
        }
        this.psrJDom = new ProblemStateReaderJDom(this.controller);
        boolean result = this.psrJDom.loadBRDFileIntoMainProblemState(bais, filename, absolutePath);
        this.doConclusionPart("Test Tutor");
        if (this.controller != null && this.controller.getStudentInterface() == null && result) {
            this.controller.setBRDDirectory(filename);
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "+++++return from doConclusionPart");
        }
        return result;
    }

    private ProblemModel getProblemModel() {
        return this.controller.getProblemModel();
    }

    public boolean openBRDiagramFile1337(InputStream inputStream, String authorMode) {
        System.out.println("***1337*** OPENBRDIAGRAMFILE");
        NewProblemEvent event = new NewProblemEvent((Object)this.controller, this.controller.getPreferencesModel().getBooleanValue("Commutativity"));
        this.getProblemModel().fireProblemModelEvent(event);
        String absolutePath = null;
        this.psrJDom = new ProblemStateReaderJDom(this.controller);
        boolean result = this.psrJDom.loadBRDFileIntoMainProblemState(inputStream, "DEFAULT", absolutePath);
        this.doConclusionPart(null);
        return result;
    }

    public ProblemStateReaderJDom getProblemStateReaderJDom() {
        return this.psrJDom;
    }

    public int trySaveAndTestForChange(ProblemStateWriter psw, ByteArrayOutputStream baos) {
        try {
            CtatFrame dockedFrame = this.controller.getCtatFrameController() == null ? null : this.controller.getCtatFrameController().getDockedFrame();
            String oldTTLabel = dockedFrame == null ? null : dockedFrame.getTutorTypeLabel();
            String errMsg = psw.saveBRDFile(baos);
            if (oldTTLabel != null && dockedFrame != null) {
                dockedFrame.setTutorTypeLabel(oldTTLabel);
            }
            if (errMsg != null) {
                return this.errorDialog(errMsg, true);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String errMsg = e.toString() + (cause == null ? "" : "; cause " + cause.toString());
            trace.errStack(errMsg, e);
            return this.errorDialog(errMsg, true);
        }
        if (trace.getDebugCode("psw")) {
            trace.out("psw", "PSR.trySaveAndTest() savedImage length " + (this.savedImage == null ? -1 : this.savedImage.length) + ", baos length " + baos.size());
        }
        if (this.savedImage != null) {
            byte[] imageToWrite = baos.toByteArray();
            boolean imageSame = Arrays.equals(this.savedImage, imageToWrite);
            if (imageSame) {
                return 1;
            }
            if (trace.getDebugCode("psw")) {
                try {
                    String diffLines = this.diff(this.savedImage, imageToWrite, 3);
                    this.tmpFile.delete();
                    FileOutputStream fos = new FileOutputStream(this.tmpFile);
                    fos.write(imageToWrite);
                    fos.close();
                    trace.out("psw", "PSR.trySave found difference; see " + this.tmpFile + ":" + diffLines);
                }
                catch (Exception e) {
                    trace.out("psw", "error trying to save to " + this.tmpFile + ": " + e + (e.getCause() == null ? "" : "; cause " + e.getCause()));
                }
            }
        }
        return 0;
    }

    private String diff(byte[] prev, byte[] curr, int maxLines) {
        StringBuffer sb = new StringBuffer();
        int len = Math.min(prev.length, curr.length);
        if (len < prev.length) {
            sb.append("\nprev is longer; ");
        } else if (len < curr.length) {
            sb.append("\ncurr is longer; ");
        }
        int lineNo = 1;
        for (int i = 0; i < len; ++i) {
            if (prev[i] == 10) {
                ++lineNo;
            }
            if (prev[i] == curr[i]) continue;
            if (--maxLines < 0) break;
            int j = 0;
            int k = 0;
            try {
                for (j = i; j >= 0 && prev[j] != 10; --j) {
                }
                for (k = j + 1; k < len && prev[k] != 10; ++k) {
                }
                String prevLine = new String(Arrays.copyOfRange(prev, j + 1, k));
                for (j = i; j >= 0 && curr[j] != 10; --j) {
                }
                for (k = j + 1; k < len && curr[k] != 10; ++k) {
                }
                String currLine = new String(Arrays.copyOfRange(curr, j + 1, k));
                sb.append("\nat line ").append(lineNo).append(":\n");
                sb.append(prevLine).append('\n').append(currLine);
                i = k;
                continue;
            }
            catch (Exception e) {
                sb.append("\nat line ").append(lineNo).append("mismatch at byte ").append(i);
            }
        }
        return sb.toString();
    }

    private int errorDialog(String errMsg, boolean getUserResponse) {
        int result = -1;
        if (!Utils.getSuppressDialogs()) {
            if (getUserResponse) {
                result = JOptionPane.showConfirmDialog(this.controller.getDockedFrame(), errMsg + "\nDo you want to continue?", "Error trying to save graph", 0, 2);
            } else {
                JOptionPane.showMessageDialog(this.controller.getDockedFrame(), "Warning: " + errMsg, "Error trying to serialize graph", 2);
            }
        }
        if (result == 0) {
            return 1;
        }
        return 2;
    }

    public int saveImage(ProblemStateWriter psw) {
        this.savedImage = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String errMsg = psw.saveBRDFile(baos);
            if (errMsg != null) {
                return this.errorDialog(errMsg, false);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String errMsg = e.toString() + (cause == null ? "" : "; cause " + cause.toString());
            return this.errorDialog(errMsg, false);
        }
        this.savedImage = baos.toByteArray();
        if (trace.getDebugCode("psw")) {
            trace.out("psw", "PSR.saveImage() savedImage length " + (this.savedImage == null ? -1 : this.savedImage.length));
        }
        return 1;
    }

    byte[] setSavedImage(byte[] savedImage) {
        byte[] oldImage = this.savedImage;
        this.savedImage = savedImage;
        if (trace.getDebugCode("psw")) {
            trace.out("psw", "PSR.setSavedImage() oldImage.length " + oldImage.length + ", savedImage.length " + savedImage.length);
        }
        return oldImage;
    }
}

