/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.SolutionStateModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SolutionState {
    private ProblemNode currentNode;
    private List<ProblemEdge> userVisitedEdges;
    private ProblemModel problemModel;

    public SolutionState(ProblemModel problemModel) {
        if (trace.getDebugCode("ss")) {
            trace.out("ss", "SolutionState.SolutionState(\"" + problemModel + "\")");
        }
        this.problemModel = problemModel;
        this.resetUserVisitedEdges();
    }

    public void setCurrentNode(ProblemNode currNode) {
        this.currentNode = currNode;
    }

    public ProblemNode getCurrentNode() {
        return this.currentNode;
    }

    public List<ProblemEdge> getUserVisitedEdges() {
        return this.userVisitedEdges;
    }

    public void addUserVisitedEdge(ProblemEdge visitedEdge) {
        if (trace.getDebugCode("ss")) {
            trace.outNT("ss", "SolutionState.addUserVisitedEdge(" + visitedEdge + "): size was " + (this.userVisitedEdges == null ? -1 : this.userVisitedEdges.size()));
        }
        this.userVisitedEdges.add(visitedEdge);
    }

    public void resetUserVisitedEdges() {
        if (trace.getDebugCode("ss")) {
            trace.out("ss", "SolutionState.resetUserVisitedEdges(): size was " + (this.userVisitedEdges == null ? -1 : this.userVisitedEdges.size()));
        }
        this.userVisitedEdges = new ArrayList<ProblemEdge>();
    }

    public boolean isCurrentNodeOrParent(ProblemNode nodeTest) {
        Vector parentEdgeslist = new Vector();
        this.problemModel.findParentEdgesList(this.getCurrentNode(), parentEdgeslist);
        for (int i = 0; i < parentEdgeslist.size(); ++i) {
            ProblemEdge edgeTemp = (ProblemEdge)parentEdgeslist.elementAt(i);
            ProblemNode nodeTemp = edgeTemp.getNodes()[1];
            if (nodeTest != nodeTemp) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.resetUserVisitedEdges();
        this.setCurrentNode(null);
    }
}

