/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CTATFileManager
extends CTATBase {
    public CTATFileManager() {
        this.setClassName("CTATFileManager");
        this.debug("CTATFileManager ()");
    }

    public boolean doesFileExist(String aFileURI) {
        this.debug("getContents (" + aFileURI + ")");
        File file = new File(aFileURI);
        boolean exists = file.exists();
        return exists;
    }

    public boolean createDirectory(String aDirURI) {
        this.debug("createDirectory (" + aDirURI + ")");
        if (this.doesFileExist(aDirURI)) {
            this.debug("Directory already exists");
        } else {
            boolean success = new File(aDirURI).mkdir();
            if (!success) {
                this.debug("Unable to create directory");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadContents(String aFileURI) {
        this.debug("loadContents (" + aFileURI + ")");
        File aFile = new File(aFileURI);
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            String string;
            try {
                string = null;
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            input.close();
            return string;
        }
        input.close();
        return contents.toString();
    }

    public Element loadContentsXML(String aFileURI) {
        this.debug("loadContentsXML (" + aFileURI + ")");
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(aFileURI);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc.getRootElement();
    }

    public boolean saveContents(String aFileURI, String aContents) {
        this.debug("saveContents (" + aFileURI + ")");
        File aFile = new File(aFileURI);
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
        }
        catch (IOException e) {
            this.debug("Exception: IOException while opening output file");
            return false;
        }
        try {
            output.write(aContents);
        }
        catch (IOException e) {
            this.debug("Exception: IOException while writing contents to disk");
            try {
                ((Writer)output).close();
            }
            catch (IOException closeException) {
                this.debug("Exception: closeException while closing file writer");
                return false;
            }
            return false;
        }
        try {
            ((Writer)output).flush();
        }
        catch (IOException e) {
            this.debug("Exception: IOException while flushing contents to disk");
        }
        try {
            ((Writer)output).close();
        }
        catch (IOException e) {
            this.debug("Exception: IOException closing output file");
        }
        return true;
    }
}

