/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.Utilities.trace;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CTATSerializable
extends CTATBase {
    protected static final XMLOutputter xmlOutp = new XMLOutputter(Format.getPrettyFormat());
    protected String value = "";
    protected String type = "";
    protected String format = "";
    protected IncludeIn includeIn = IncludeIn.minimal;
    private Boolean touched = false;

    public CTATSerializable() {
        this.setClassName("CTATSerializable");
        this.debug("CTATSerializable ()");
    }

    public void setTouched(Boolean touched) {
        this.touched = touched;
    }

    public Boolean getTouched() {
        return this.touched;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String getType() {
        return this.type;
    }

    public void setFormat(String aFormat) {
        this.format = aFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public void setIncludeIn(IncludeIn aValue) {
        this.includeIn = aValue;
    }

    public IncludeIn getIncludeIn() {
        return this.includeIn;
    }

    protected String getIncludeInString() {
        StringBuffer formatter = new StringBuffer();
        formatter.append(" includein=\"");
        formatter.append(this.includeIn.toString());
        formatter.append("\" ");
        return formatter.toString();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClassOpen() + "<name>" + this.getName() + "</name><value fmt=\"text\" type=\"" + this.getType() + "\" " + this.getIncludeInString() + ">" + this.getValue() + "</value>" + this.getClassClose());
        return buffer.toString();
    }

    public Element toStringElement() {
        Element newElement = this.getClassElement();
        Element nameElement = new Element("name");
        nameElement.setText(this.getName());
        newElement.addContent((Content)nameElement);
        Element valueElement = new Element("value");
        valueElement.setAttribute("fmt", "text");
        valueElement.setAttribute("type", this.getType());
        if (this.includeIn != IncludeIn.minimal) {
            valueElement.setAttribute("includein", this.includeIn.toString());
        }
        valueElement.setText(this.value);
        newElement.addContent((Content)valueElement);
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", this.getClass().getSimpleName() + ".toStringElement() result:\n" + xmlOutp.outputString(newElement));
        }
        return newElement;
    }

    @Override
    public void fromXML(Element node) {
        this.debug("fromXML ()");
        for (Element elem : node.getChildren()) {
            this.debug("Parsing text node (" + elem.getName() + ")...");
            if (elem.getName().equals("name")) {
                this.debug("Parsing selection: " + ((Element)elem.getChildren().get(0)).getValue());
                this.setName(((Element)elem.getChildren().get(0)).getValue());
            }
            if (!elem.getName().equals("value")) continue;
            this.setValue(((Element)elem.getChildren().get(0)).getValue());
            this.setType(elem.getAttributeValue("type"));
            if (elem.getAttributeValue("includein") == null) continue;
            try {
                this.includeIn = IncludeIn.valueOf(elem.getAttributeValue("includein").toLowerCase());
            }
            catch (Exception e) {
                trace.err("Invalid includeIn attribute \"" + elem.getAttributeValue("includein") + "\" for element " + node.getName() + "; default " + (Object)((Object)IncludeIn.full));
                this.includeIn = IncludeIn.minimal;
            }
        }
    }

    public static enum IncludeIn {
        minimal,
        sparse,
        full,
        never;

    }
}

