/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATComponent;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATJPanel;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSSELink;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;

public class CTATTutorPreview
extends CTATJPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private int tutorWidth = 1;
    private int tutorHeight = 1;
    private float displayWidth = 1.0f;
    private float displayHeight = 1.0f;
    private float scale = 1.0f;
    private float zoom = 0.75f;
    private float xOffset = 1.0f;
    private float yOffset = 1.0f;
    float divX = 1.0f;
    float divY = 1.0f;
    private Boolean isConnected = false;
    Dimension d;
    Font f = new Font("Verdana", 0, 12);
    FontMetrics fm;
    int fh;
    int ascent;
    int space;
    BR_Controller controller = null;

    public CTATTutorPreview() {
        this.debug("CTATTutorPreview ()");
        this.addMouseListener(this);
    }

    public void updatePreview() {
        this.debug("updatePreview ()");
        if (CTATSSELink.preview != null) {
            this.debug("Repaint");
            this.repaint();
        } else {
            this.debug("Nothing changed");
        }
    }

    public void setController(BR_Controller aController) {
        this.debug("setController ()");
        this.controller = aController;
    }

    public void setIsConnected(Boolean isConnected) {
        this.debug("setIsConnect (" + isConnected + ")");
        this.isConnected = isConnected;
        if (!this.isConnected.booleanValue()) {
            this.resetZoom();
        }
        this.repaint();
    }

    public Boolean getIsConnected() {
        return this.isConnected;
    }

    public void setTutorWidth(int aWidth) {
        this.tutorWidth = aWidth;
    }

    public int getTutorWidth() {
        return this.tutorWidth;
    }

    public void setTutorHeight(int aHeight) {
        this.tutorHeight = aHeight;
    }

    public int getTutorHeight() {
        return this.tutorHeight;
    }

    public void resetZoom() {
        this.zoom = 1.0f;
    }

    public void zoomIn() {
        this.zoom = (float)((double)this.zoom + 0.05);
        if ((double)this.zoom > 1.0) {
            this.zoom = 1.0f;
        }
        this.repaint();
    }

    public void zoomOut() {
        this.zoom = (float)((double)this.zoom - 0.05);
        if ((double)this.zoom < 0.05) {
            this.zoom = 0.05f;
        }
        this.repaint();
    }

    private void calcTransformation() {
        this.scale = this.tutorWidth < this.getWidth() && this.tutorHeight < this.getHeight() ? 1.0f : (this.tutorWidth - this.getWidth() >= this.tutorHeight - this.getHeight() ? (float)this.getWidth() / (float)this.tutorWidth : (float)this.getHeight() / (float)this.tutorHeight);
        this.displayWidth = (float)this.tutorWidth * this.scale * this.zoom;
        this.displayHeight = (float)this.tutorHeight * this.scale * this.zoom;
        this.divX = (float)((double)this.getWidth() / 2.0);
        this.divY = (float)((double)this.getHeight() / 2.0);
        float tutDivX = (float)((double)this.displayWidth / 2.0);
        float tutDivY = (float)((double)this.displayHeight / 2.0);
        this.xOffset = this.divX - tutDivX;
        this.yOffset = this.divY - tutDivY;
    }

    private float calcXPixel(float aValue) {
        float scaledX = aValue * this.scale;
        float zoomedX = scaledX * this.zoom;
        float movedX = zoomedX + this.xOffset;
        return movedX;
    }

    private float calcYPixel(float aValue) {
        float scaledY = aValue * this.scale;
        float zoomedY = scaledY * this.zoom;
        float movedY = zoomedY + this.yOffset;
        return movedY;
    }

    private float calcXWidth(float aValue) {
        float scaledX = aValue * this.scale;
        float zoomedX = scaledX * this.zoom;
        return zoomedX;
    }

    private float calcYHeight(float aValue) {
        float scaledY = aValue * this.scale;
        float zoomedY = scaledY * this.zoom;
        return zoomedY;
    }

    private void drawAxis(Graphics g) {
        g.setColor(new Color(150, 150, 150));
        g.drawLine((int)this.divX, 0, (int)this.divX, this.getHeight());
        g.drawLine(0, (int)this.divY, this.getWidth(), (int)this.divY);
    }

    private void paintLabel(Graphics g, String aLabel) {
        this.d = this.getSize();
        g.setFont(this.f);
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
            this.ascent = this.fm.getAscent();
            this.fh = this.ascent + this.fm.getDescent();
            this.space = this.fm.stringWidth(" ");
        }
        g.setColor(Color.black);
        StringTokenizer st = new StringTokenizer(aLabel);
        int x = 0;
        int nextx = 0;
        int y = (int)((double)this.getHeight() / 2.0);
        int wordCount = 0;
        String line = "";
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.equals("<BR>")) {
                this.drawString(g, line, wordCount, this.fm.stringWidth(line), y + this.ascent);
                line = "";
                wordCount = 0;
                x = 0;
                y += this.fh * 2;
                continue;
            }
            int w = this.fm.stringWidth(word);
            nextx = x + this.space + w;
            if (nextx > this.d.width) {
                this.drawString(g, line, wordCount, this.fm.stringWidth(line), y + this.ascent);
                line = "";
                wordCount = 0;
                x = 0;
                y += this.fh;
            }
            String sp = x != 0 ? " " : "";
            line = line + sp + word;
            x = x + this.space + w;
            ++wordCount;
        }
        this.drawString(g, line, wordCount, this.fm.stringWidth(line), y + this.ascent);
    }

    public void drawString(Graphics g, String line, int wc, int lineW, int y) {
        g.drawString(line, (this.d.width - lineW) / 2, y);
    }

    private CTATComponent findParent(CTATComponent aChild) {
        this.debug("findParent ()");
        String testName = aChild.getInstanceName();
        String[] parts = testName.split("\\.");
        this.debug("Using parent: " + parts[0]);
        for (int i = 0; i < CTATSSELink.components.size(); ++i) {
            CTATComponent ref = CTATSSELink.components.get(i);
            if (!ref.getInstanceName().equals(parts[0])) continue;
            this.debug("Found component");
            return ref;
        }
        return null;
    }

    private void drawComponent(Graphics2D g2d, CTATComponent component) {
        this.debug("drawComponent ()");
        if (component.getClassType().equals("CTATCommShell")) {
            if (CTATSSELink.preview != null && CTATSSELink.showPreview.booleanValue()) {
                g2d.drawImage(CTATSSELink.preview, component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight(), null);
            } else {
                g2d.fill3DRect(component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight(), true);
                if (!component.getSelected().booleanValue()) {
                    g2d.setColor(new Color(0, 0, 0));
                } else {
                    g2d.setColor(new Color(255, 255, 0));
                }
                g2d.drawRect(component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight());
            }
        } else if (CTATSSELink.preview != null && CTATSSELink.showPreview.booleanValue()) {
            if (component.getSelected().booleanValue()) {
                g2d.setColor(new Color(255, 255, 0));
                g2d.drawRect(component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight());
            }
        } else {
            g2d.fill3DRect(component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight(), true);
            if (!component.getSelected().booleanValue()) {
                g2d.setColor(new Color(0, 0, 0));
            } else {
                g2d.setColor(new Color(255, 255, 0));
            }
            g2d.drawRect(component.getPreviewX(), component.getPreviewY(), component.getPreviewWidth(), component.getPreviewHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        this.debug("paint ()");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(190, 190, 190));
        g2d.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        if (!this.getIsConnected().booleanValue()) {
            this.paintLabel(g, "No Tutor Connected");
        } else {
            CTATComponent component;
            this.paintLabel(g, "Connected");
            this.calcTransformation();
            this.drawAxis(g);
            for (int i = 0; i < CTATSSELink.components.size(); ++i) {
                component = CTATSSELink.components.get(i);
                if (component.getInstanceName().contains(".")) continue;
                this.debug("Drawing component [" + component.getInstanceName() + "] at: " + (int)this.calcXPixel(component.getX()) + "," + (int)this.calcYPixel(component.getY()) + "," + (int)this.calcXPixel(component.getWidth()) + "," + (int)this.calcXPixel(component.getHeight()));
                if (component.getClassType().equals("CTATCommShell")) {
                    g2d.setColor(new Color(255, 255, 255));
                } else {
                    g2d.setColor(new Color(200, 200, 200));
                }
                int placeX = (int)this.calcXPixel(component.getX());
                int placeY = (int)this.calcYPixel(component.getY());
                int placeWidth = (int)this.calcXWidth(component.getWidth());
                int placeHeight = (int)this.calcYHeight(component.getHeight());
                component.setPreviewDimensions(placeX, placeY, placeWidth, placeHeight);
                this.drawComponent(g2d, component);
            }
            for (int j = 0; j < CTATSSELink.components.size(); ++j) {
                component = CTATSSELink.components.get(j);
                if (!component.getInstanceName().contains(".")) continue;
                CTATComponent parent = this.findParent(component);
                if (parent != null) {
                    this.drawComponent(g2d, component);
                    continue;
                }
                this.debug("Error: parent not found");
            }
        }
        g2d.setColor(new Color(0, 0, 0));
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.debug("mouseClicked ()");
        int placeX = arg0.getX();
        int placeY = arg0.getY();
        this.debug("X: " + placeX + ",Y: " + placeY);
        for (int i = 0; i < CTATSSELink.components.size(); ++i) {
            CTATComponent component = CTATSSELink.components.get(i);
            if (component.getClassType().equals("CTATCommShell") || placeX <= component.getPreviewX() || placeX >= component.getPreviewX() + component.getPreviewWidth() || placeY <= component.getPreviewY() || placeY >= component.getPreviewY() + component.getPreviewHeight()) continue;
            this.debug("Found component click target");
            if (component.getSelected().booleanValue()) {
                component.setSelected(false);
                if (component.getChecker() == null) continue;
                component.getChecker().setSelected(false);
                continue;
            }
            component.setSelected(true);
            if (component.getChecker() == null) continue;
            component.getChecker().setSelected(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

