/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CTATXMLHandler
extends DefaultHandler {
    private JTree xmlJTree;
    int lineCounter;
    DefaultMutableTreeNode base = new DefaultMutableTreeNode("XML Viewer");

    public void setTree(JTree aTree) {
        this.xmlJTree = aTree;
    }

    private void debug(String aMessage) {
        CTATBase.debug("CTATXMLHandler", aMessage);
    }

    @Override
    public void startElement(String uri, String localName, String tagName, Attributes attr) throws SAXException {
        this.debug("startElement ()");
        DefaultMutableTreeNode current = new DefaultMutableTreeNode(tagName);
        this.base.add(current);
        this.base = current;
        for (int i = 0; i < attr.getLength(); ++i) {
            DefaultMutableTreeNode currentAtt = new DefaultMutableTreeNode(attr.getLocalName(i) + " = " + attr.getValue(i));
            this.base.add(currentAtt);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.debug("Skipped Entity: '" + name + "'");
    }

    @Override
    public void startDocument() throws SAXException {
        this.debug("startDocument ()");
        super.startDocument();
        this.base = new DefaultMutableTreeNode("XML Viewer");
        DefaultTreeModel model = (DefaultTreeModel)this.xmlJTree.getModel();
        if (model != null) {
            model.setRoot(this.base);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length).trim();
        if (!s.equals("")) {
            DefaultMutableTreeNode current = new DefaultMutableTreeNode("Descrioption : " + s);
            this.base.add(current);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.base = (DefaultMutableTreeNode)this.base.getParent();
    }

    @Override
    public void endDocument() throws SAXException {
        this.debug("endDocument ()");
        ((DefaultTreeModel)this.xmlJTree.getModel()).reload();
    }

    public void xmlSetUp(String aStream) {
        this.debug("xmlSetUp ()");
        if (aStream == null) {
            this.debug("Error: input is null");
            return;
        }
        SAXParserFactory fact = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = fact.newSAXParser();
        }
        catch (ParserConfigurationException e1) {
            this.debug("Error: ParserConfigurationException");
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            this.debug("Error: SAXException");
            e1.printStackTrace();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(aStream.getBytes());
        if (parser == null) {
            this.debug("No parser available, aborting");
            return;
        }
        try {
            parser.parse((InputStream)is, (DefaultHandler)this);
        }
        catch (Exception e) {
            this.debug("Error parsing XML stream:" + e);
            e.printStackTrace();
        }
    }
}

