/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pact.CommWidgets.UniversalToolProxy;

public class ConnectedIcon
extends JLabel
implements MouseListener,
Runnable {
    ImageIcon connectedIcon;
    ImageIcon notConnectedIcon;
    Thread thread;
    final int pauseTime = 30000;
    UniversalToolProxy utp;
    private BR_Controller controller;

    @Override
    public void run() {
        if (this.utp == null) {
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setConnected(true);
    }

    ConnectedIcon(BR_Controller controller) {
        this.controller = controller;
        this.setFont(new Font("SanSerif", 2, 11));
        try {
            URL iconURL = ClassLoader.getSystemResource("pact/Connected.gif");
            if (iconURL != null) {
                this.connectedIcon = new ImageIcon(iconURL, "connected");
            }
            if ((iconURL = ClassLoader.getSystemResource("pact/NotConnected.gif")) != null) {
                this.notConnectedIcon = new ImageIcon(iconURL, "not connected");
            }
        }
        catch (Exception e) {
            trace.out(5, this, "error loading images for connection icon: exception = " + e);
            return;
        }
        this.utp = controller.getUniversalToolProxy();
        this.thread = new Thread(this);
        this.thread.start();
    }

    private boolean checkConnection() {
        return this.utp.connectToTutor();
    }

    public void setConnected(boolean connected) {
        if (connected) {
            if (this.connectedIcon != null) {
                this.setIcon(this.connectedIcon);
            } else {
                this.setText("Connected");
            }
            this.setToolTipText("Connected to production system");
        } else {
            if (this.notConnectedIcon != null) {
                this.setIcon(this.notConnectedIcon);
            } else {
                this.setText("Not Connected");
            }
            this.setToolTipText("Not connected to production system.  Set useLisp property of UTP to true to connect.");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

