/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.VariableViewer;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTableChangeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTableModel;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VTDisplayPane;
import edu.cmu.pact.Utilities.trace;
import java.util.Comparator;
import javax.swing.JTable;

public class VariableTablePane
extends VTDisplayPane
implements ProblemModelListener {
    private JTable table;
    private VariableTableModel vtm;
    private String type = "VariableTablePane";
    private static int count = 0;
    private int instance;

    public VariableTablePane(ProblemModel pm) {
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTablePane constructor");
        }
        this.instance = count++;
        this.vtm = new VariableTableModel(pm.getVariableTable());
        pm.getVariableTable().setModel(this.vtm);
        if (trace.getDebugCode("vtm")) {
            trace.outNT("vtm", "VariableTablePane: Seeding TableModel #" + this.vtm.getInstance() + " with VariableTable #" + pm.getVariableTable().getInstance());
        }
        this.table = new JTable();
        this.table.setEnabled(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setToolTipText("Variable Table");
        this.table.setModel(this.vtm);
        pm.addProblemModelListener(this);
        this.vtm.addTableModelListener(this.table);
        this.setViewportView(this.table);
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        if (e instanceof VariableTableChangeEvent) {
            VariableTable vt = (VariableTable)e.getNewValue();
            if (trace.getDebugCode("sai")) {
                trace.out("sai", "VTPane[" + this.getInstance() + "].problemModeEventOccurred(" + e + ")");
            }
            this.vtm = new VariableTableModel(vt);
            vt.setModel(this.vtm);
            this.table.setModel(this.vtm);
            this.vtm.addTableModelListener(this.table);
            if (trace.getDebugCode("vtm")) {
                trace.printStack("vtm", "new VTM(VT #" + vt.getInstance() + ")");
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getInstance() {
        return this.instance;
    }

    private class KeyListComparator
    implements Comparator<Object> {
        private boolean aislink;
        private boolean bislink;

        private KeyListComparator() {
        }

        @Override
        public int compare(String a, String b) {
            if (trace.getDebugCode("klc")) {
                trace.outNT("klc", "compare (" + a + "," + b + ")");
            }
            this.aislink = a.length() >= 4 ? a.startsWith("link") : false;
            this.bislink = b.length() >= 4 ? b.startsWith("link") : false;
            if (this.aislink && !this.bislink) {
                return 1;
            }
            if (!this.aislink && this.bislink) {
                return -1;
            }
            if (this.aislink && this.bislink) {
                return a.compareTo(b);
            }
            return a.compareTo(b);
        }

        @Override
        public int compare(Object a, Object b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return this.compare(a.toString(), b.toString());
        }
    }
}

