/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreationFailedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Log.LogConsoleReplay;
import edu.cmu.pact.Log.LogDifferences.LogDifferences;
import edu.cmu.pact.Log.LogFormatUtils;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.LCLoggingSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MessagePlayer;
import edu.cmu.pact.ctat.MessagePlayerEvent;
import edu.cmu.pact.ctat.MessagePlayerListener;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.Skills;
import edu.cmu.pslc.logging.OliDiskLogger;
import edu.cmu.pslc.logging.TutorMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import pact.CommWidgets.UniversalToolProxy;

public class LogConsole
extends Box
implements MessagePlayerListener,
ProblemModelListener {
    public static String LOG_CONSOLE_REPLAY_DIRECTORY_PREF = "Log Console Replay Directory";
    private LCLoggingSupport lcls = null;
    private LogConsoleReplay lcr;
    private String lcrProblemName = "";
    private static final DateFormat timeFmtLong = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS");
    private static final DateFormat timeFmt = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean isCtatTutor = true;
    private boolean bootstrappedUntilErrorMode = false;
    private static CTATTabManager tabManager;
    private JTable table;
    private JButton sendBtn;
    private JButton selectAllBtn;
    private JButton unselectAllBtn;
    private JButton invertSelectionBtn;
    private JButton markLastAttemptBtn;
    private JButton bootstrapUntilErrorBtn;
    private JButton exportLogDiffsBtn;
    private JCheckBox isCtatTutorCheckBox;
    private HashMap<DataShopMessageObject, Integer> playedMessages;
    private BR_Controller controller;
    private MessagePlayer messagePlayer;
    private JDialog window;
    private LinkedHashSet<MessageObject> results = null;
    private StatusLabel statusLabel = new StatusLabel();
    private OliDiskLogger oli;

    private Date parseDate(Element elmt) throws ParseException {
        timeFmtLong.setTimeZone(TimeZone.getTimeZone(elmt.getAttributeValue("timezone")));
        trace.out("log", "the date is " + elmt.getAttributeValue("date_time"));
        return timeFmtLong.parse(elmt.getAttributeValue("date_time"));
    }

    public LogConsole(List logEntries, BR_Controller controller2) throws Exception {
        super(3);
        this.controller = controller2;
        this.table = new JTable(new MessageObjectTableModel());
        ((MessageObjectTableModel)this.table.getModel()).setData(logEntries);
        this.init();
    }

    public LogConsole(String logFileName, boolean convert, BR_Controller controller2, LogConsoleReplay lcr, String altName) throws Exception {
        super(3);
        this.controller = controller2;
        this.lcr = lcr;
        this.lcrProblemName = altName;
        if (trace.getDebugCode("log") || trace.getDebugCode("replay")) {
            trace.out("replay", "logconsole w/ 3 variables passed" + logFileName + " " + convert + " " + controller2);
            String lcrdp = this.controller.getPreferencesModel() == null ? null : this.controller.getPreferencesModel().getStringValue(LOG_CONSOLE_REPLAY_DIRECTORY_PREF);
            trace.out("replay", "LOG_CONSOLE_REPLAY_DIRECTORY_PREF = " + lcrdp);
        }
        this.controller.getLogger().setLogConsole(this);
        trace.out("replay", "set log console");
        this.table = new JTable(new MessageObjectTableModel());
        ((MessageObjectTableModel)this.table.getModel()).setDataFromFile(logFileName, convert);
        trace.out("replay", "populating table");
        this.init();
    }

    public LCLoggingSupport getLogger() {
        return this.lcls;
    }

    private void init() {
        if (this.controller != null) {
            this.getController().getProblemModel().addProblemModelListener(this);
            this.lcls = new LCLoggingSupport(this.controller.getServer().getAuthorLauncherServer());
            this.controller.setLogger(this.lcls);
        }
        this.table.setDefaultRenderer(JButton.class, new RowSendBtnRenderer());
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "init setdefaultrenderer");
        }
        this.table.setDefaultEditor(JButton.class, new RowSendBtnEditor());
        JLabel renderer = (JLabel)((Object)this.table.getDefaultRenderer(String.class));
        renderer.setHorizontalAlignment(0);
        this.setName("LogConsole");
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        this.add(LogConsole.createVerticalStrut(4));
        Box btnsPanel = new Box(0);
        this.sendBtn = new JButton("Send");
        this.sendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.bootstrappedUntilErrorMode = false;
                LogConsole.this.sendRows();
            }
        });
        this.sendBtn.setEnabled(false);
        btnsPanel.add(this.sendBtn);
        this.selectAllBtn = new JButton("Select All");
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.selectAll();
            }
        });
        this.selectAllBtn.setEnabled(true);
        btnsPanel.add(this.selectAllBtn);
        this.unselectAllBtn = new JButton("Unselect All");
        this.unselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.selectAll();
                LogConsole.this.invertSelection();
            }
        });
        this.unselectAllBtn.setEnabled(true);
        btnsPanel.add(this.unselectAllBtn);
        this.invertSelectionBtn = new JButton("Invert Selection");
        this.invertSelectionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.invertSelection();
            }
        });
        this.invertSelectionBtn.setEnabled(true);
        btnsPanel.add(this.invertSelectionBtn);
        this.markLastAttemptBtn = new JButton("Mark Last Attempts");
        this.markLastAttemptBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.markLastAttempts();
            }
        });
        this.markLastAttemptBtn.setEnabled(true);
        btnsPanel.add(this.markLastAttemptBtn);
        this.bootstrapUntilErrorBtn = new JButton("Bootstrap until Error");
        this.bootstrapUntilErrorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.bootstrappedUntilErrorMode = true;
                LogConsole.this.sendRows();
            }
        });
        this.bootstrapUntilErrorBtn.setEnabled(true);
        btnsPanel.add(this.bootstrapUntilErrorBtn);
        this.exportLogDiffsBtn = new JButton("Export Differences");
        this.exportLogDiffsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsole.this.outputLogDifferenceFile();
            }
        });
        this.exportLogDiffsBtn.setEnabled(true);
        btnsPanel.add(this.exportLogDiffsBtn);
        this.isCtatTutorCheckBox = new JCheckBox("CTAT Tutor", this.isCtatTutor);
        this.isCtatTutorCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogConsole.this.isCtatTutor = e.getStateChange() == 1;
            }
        });
        this.isCtatTutorCheckBox.setEnabled(true);
        btnsPanel.add(this.isCtatTutorCheckBox);
        this.add(btnsPanel);
        this.add(this.statusLabel.getPanel());
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        if (this.messagePlayer != null) {
            EdgeCreationFailedEvent ecf;
            if (e instanceof EdgeCreatedEvent && this.bootstrappedUntilErrorMode) {
                if (trace.getDebugCode("mp")) {
                    trace.out("mp", "would have called stopMessagePlayer()");
                }
            } else if (e instanceof EdgeCreationFailedEvent && EdgeCreationFailedEvent.Reason.LINK_AFTER_DONE_STATE == (ecf = (EdgeCreationFailedEvent)e).getCause()) {
                this.stopMessagePlayer();
            }
            if (e.isCompoundEventP()) {
                for (ProblemModelEvent V : e.getSubevents()) {
                    this.problemModelEventOccurred(V);
                }
            }
        }
    }

    private void stopMessagePlayer() {
        if (this.messagePlayer != null) {
            this.messagePlayer.setStopping(true);
        }
        this.messagePlayer = null;
    }

    @Override
    public void messagePlayerEventOccurred(MessagePlayerEvent e) {
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        ArrayList list = motm.getData();
        int rowNumber = this.playedMessages.get(e.getDataShopMessageObject());
        MessageRow row = (MessageRow)list.get(rowNumber);
        row.setBootstrapped(row.getBootstrapped() + 1);
        row.setToSend(Boolean.FALSE);
        motm.fireTableDataChanged();
    }

    public void selectAll() {
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        motm.setAllSend(true);
        motm.fireTableDataChanged();
    }

    private void invertSelection() {
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        ArrayList msgs = motm.getData();
        for (int i = 0; i < msgs.size(); ++i) {
            MessageRow row;
            row.setToSend((row = (MessageRow)msgs.get(i)).getToSend() == false);
        }
        motm.fireTableDataChanged();
    }

    private void markLastAttempts() {
        HashMap<String, Integer> tbl = new HashMap<String, Integer>();
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        ArrayList msgs = motm.getData();
        for (int i = 0; i < msgs.size(); ++i) {
            DataShopMessageObject msg = ((MessageRow)msgs.get(i)).getMessage();
            Vector sv = (Vector)msg.getProperty("Selection");
            if (sv == null) {
                sv = (Vector)msg.getProperty("selection");
            }
            String selection = sv == null || sv.size() < 1 ? "" : (String)sv.get(0);
            Vector av = (Vector)msg.getProperty("Action");
            if (av == null) {
                av = (Vector)msg.getProperty("action");
            }
            String action = av == null || av.size() < 1 ? "" : (String)av.get(0);
            String key = selection + " " + action;
            tbl.put(key, new Integer(i));
        }
        trace.out("boot", "table.size = " + tbl.size());
        motm.setAllSend(false);
        for (Integer i : tbl.values()) {
            MessageRow row = (MessageRow)msgs.get(i);
            row.setToSend(true);
        }
        motm.fireTableDataChanged();
    }

    public void sendRows() {
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        List msgs = motm.getMessagesToSend();
        Thread mpt = this.sendRows(motm, msgs);
        int x = 0;
        while (true) {
            try {
                if (!trace.getDebugCode("replay")) break;
                trace.out("replay", "LC.sendRows() mpt.join() returns after " + x + " exceptions");
            }
            catch (Exception e) {
                trace.err("LC.sendRows() mpt.join() exception " + e + ";\n  cause " + e.getCause());
                ++x;
                continue;
            }
            break;
        }
    }

    private Thread sendRow(int row) {
        MessageObjectTableModel motm = (MessageObjectTableModel)this.table.getModel();
        List msgs = motm.getMessageToSend(row);
        return this.sendRows(motm, msgs);
    }

    private Thread sendRows(MessageObjectTableModel motm, List msgs) {
        ProblemSummary ps = this.controller.getProblemModel().getProblemSummary();
        if (trace.getDebugCode("log")) {
            trace.out("log", "ProblemSummary: " + ps.toXML());
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "LogConsole sending messages " + msgs);
        }
        motm.fireTableDataChanged();
        MessageObject mo = MessageObject.create("StartProblem");
        mo.setProperty("ProblemName", this.lcls.getProblemName());
        msgs.add(0, new DataShopMessageObject(mo, true, this.lcls));
        this.messagePlayer = new MessagePlayer(this.getController(), msgs, this.isCtatTutor, this.lcr);
        this.messagePlayer.setLogger(this.lcls);
        this.messagePlayer.addMessagePlayerListener(this);
        this.messagePlayer.addMessagePlayerListener(this.statusLabel);
        UniversalToolProxy utp = this.getController() == null ? null : this.getController().getUniversalToolProxy();
        this.messagePlayer.setForwardToClientProxy(utp);
        Thread mpt = new Thread(this.messagePlayer);
        mpt.start();
        return mpt;
    }

    public static void createConsole(BR_Controller controller2) {
        String infName;
        if (controller2.getProblemName() == null || controller2.getProblemName().trim().length() < 1) {
            Utils.showExceptionOccuredDialog(null, "Please open a problem", "No problem loaded");
            return;
        }
        File inf = DialogUtilities.chooseFile(null, null, "Please choose the log file name", "Load", controller2);
        String string = infName = inf == null ? null : inf.getPath();
        if (infName == null || infName.length() < 1) {
            trace.out("inter", "No file chosen.");
            infName = null;
        }
        LogConsole logConsole = null;
        try {
            if (infName == null) {
                logConsole = new LogConsole(new ArrayList(), controller2);
            } else {
                String filePath = inf.getAbsolutePath();
                int periodLocation = filePath.lastIndexOf(46);
                String fileExtension = filePath.substring(periodLocation + 1);
                if (trace.getDebugCode("log")) {
                    trace.out("log", "file extension = " + fileExtension);
                }
                boolean needsFormatting = false;
                if (fileExtension.equals("xml")) {
                    needsFormatting = false;
                } else if (fileExtension.equals("log")) {
                    needsFormatting = true;
                }
                if (trace.getDebugCode("log")) {
                    trace.out("log", "LogConsole createConsole needsFormatting " + needsFormatting);
                }
                logConsole = new LogConsole(infName, needsFormatting, controller2, null, "");
            }
        }
        catch (Exception e) {
            String msg = "Could not read log file" + infName + " for replay:\n" + e;
            trace.errStack(msg, e);
            JOptionPane.showMessageDialog(null, msg, "Log File Processing Error", 2);
            return;
        }
        LogConsole.createAndShowGUI(logConsole, controller2 != null ? controller2.getDockedFrame() : null);
    }

    public static void createAndShowGUI(LogConsole logConsole, JFrame ownerFrame) {
        class ConsoleThread
        implements Runnable {
            private LogConsole logConsole;
            final /* synthetic */ JFrame val$ownerFrame;

            ConsoleThread(LogConsole logConsole2) {
                this.val$ownerFrame = logConsole2;
                this.logConsole = logConsole;
            }

            @Override
            public void run() {
                tabManager.createdLogConsole();
                String title = "Log Console" + (this.logConsole.getFileName() == null ? "" : ": " + this.logConsole.getFileName());
                this.logConsole.window = new JDialog((Frame)this.val$ownerFrame, title);
                trace.out("replay", "created JDialog window");
                this.logConsole.window.setDefaultCloseOperation(0);
                this.logConsole.window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        tabManager.closedLogConsole();
                        logConsole.window.dispose();
                    }
                });
                this.logConsole.setOpaque(true);
                this.logConsole.window.setContentPane(this.logConsole);
                this.logConsole.window.pack();
                this.logConsole.window.setVisible(true);
            }
        }
        ConsoleThread ct = new ConsoleThread(logConsole, ownerFrame);
        new Thread(ct).start();
    }

    public JDialog getWindow() {
        return this.window;
    }

    public String getFileName() {
        MessageObjectTableModel tm = (MessageObjectTableModel)this.table.getModel();
        return tm.getFileName();
    }

    public static void main(String[] args) {
        LogConsole logConsole = null;
        String infName = null;
        int i = 0;
        boolean convert = true;
        try {
            if (args.length < 1 || args[0].length() < 1) {
                throw new IllegalArgumentException("missing filename");
            }
            if ("-c".equalsIgnoreCase(args[i])) {
                convert = false;
                ++i;
            }
            infName = args[i];
            File f = new File(infName);
            logConsole = new LogConsole(infName, convert, null, null, "");
        }
        catch (Exception e) {
            System.err.println("Error reading log file " + infName + ": " + e);
            System.err.println("Usage:\n  java -cp ... " + LogConsole.class.getName() + " [-c] logFileName\nwhere--\n  -c means do not convert the log file from the OLI escaped format;\n  logFileName is a file in OLI disk log format or DataShop file format.");
            return;
        }
        LogConsole.createAndShowGUI(logConsole, null);
    }

    public void setData(List omoList) {
        MessageObjectTableModel tm = (MessageObjectTableModel)this.table.getModel();
        tm.setData(omoList);
        this.validate();
    }

    public BR_Controller getController() {
        return this.controller;
    }

    private CTATTabManager getTabManager() {
        return tabManager;
    }

    public static void setTabManager(CTATTabManager tab) {
        tabManager = tab;
    }

    public void sendMsgToLogConsole(MessageObject messageObject) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "LogConsole sendMsgToLogConsle " + messageObject.toString());
        }
        this.findLogDifferences(messageObject);
    }

    private void findLogDifferences(MessageObject messageObject) {
        MessageRow match = this.findMatchingTransactionID(messageObject);
        if (match == null) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "LogConsole findLogDifferences didn't find a match");
            }
            return;
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "LogConsole findLogDifferences row message " + match.getMessage().toXML());
        }
        TutorActionLogV4 tutorMessageOld = this.xmlToTutorActionLog(match.getTutorMessageElement());
        TutorActionLogV4 tutorMessageNew = this.convertAssociatedRulesToTutorActionLog(messageObject);
        if (trace.getDebugCode("log")) {
            trace.out("log", "Old time stamp " + tutorMessageOld.getTimeStamp());
        }
        match.setOldActionLog(tutorMessageOld);
        match.setNewActionLog(tutorMessageNew);
        if (this.lcls != null) {
            Date time = tutorMessageOld.getTimeStamp();
            this.lcls.setTimeStamp(time);
            this.lcls.setTimeZone("UTC");
            this.lcls.oliLog(tutorMessageNew);
        }
        if (trace.getDebugCode("month")) {
            trace.out("month", "tutorMessageNew: " + tutorMessageNew.getTimeStamp());
            trace.out("month", "tutorMessageOld: " + tutorMessageOld.getTimeStamp());
        }
        if (this.oli != null) {
            this.oli.log(tutorMessageNew.getMsg(), tutorMessageOld.getTimeStamp());
        }
    }

    private MessageRow findMatchingTransactionID(MessageObject messageObject) {
        String transactionId = messageObject.getTransactionId();
        ArrayList tableRows = ((MessageObjectTableModel)this.table.getModel()).getData();
        for (MessageRow row : tableRows) {
            String rowId = row.getMessage().getTransactionId();
            if (!rowId.equals(transactionId)) continue;
            if (trace.getDebugCode("log")) {
                trace.out("log", "LogConsole findMatchingTransactionID found");
            }
            return row;
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "LogConsole findMatchingTransactionID not found");
        }
        return null;
    }

    private TutorActionLogV4 convertAssociatedRulesToTutorActionLog(MessageObject messageObject) {
        Object test = messageObject.getProperty("TutorAdvice");
        if (trace.getDebugCode("log")) {
            trace.out("log", "messageObject " + messageObject.toXML());
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "LogConsole getPropertyNames()1 " + (test == null ? "null" : test));
        }
        DataShopMessageObject convert = new DataShopMessageObject(messageObject, true, this.controller.getLogger());
        TutorActionLogV4 tutorMessage = convert.getLogMsg();
        trace.out("log", "WRONG TUTORMESSAGE TIME: " + tutorMessage.getTimeStamp());
        return tutorMessage;
    }

    private LinkedHashMap<String, String> getCustomFieldsFromXML(Element message) {
        Element tutorToolMessage = this.getOnlyToolTutorMessage(message);
        LinkedHashMap<String, String> customFields = new LinkedHashMap<String, String>();
        List customFieldElements = tutorToolMessage.getChildren("custom_field");
        for (Element elt : customFieldElements) {
            String name = elt.getChild("name").getText();
            String value = elt.getChild("value").getText();
            customFields.put(name, value);
        }
        return customFields;
    }

    private Element getOnlyToolTutorMessage(Element message) {
        if (message.getName().equals("log_action")) {
            message = message.getChild("tutor_related_message_sequence");
        }
        if (message.getName().equals("tutor_related_message_sequence")) {
            if (message.getChild("tool_message") != null) {
                message = message.getChild("tool_message");
            } else if (message.getChild("tutor_message") != null) {
                message = message.getChild("tutor_message");
            } else {
                return null;
            }
        }
        return message;
    }

    private TutorActionLogV4 xmlToTutorActionLog(Element toolMessageElement) {
        XMLOutputter outputter = new XMLOutputter();
        Element tutorMessageElement = this.getOnlyToolTutorMessage(toolMessageElement);
        DataShopMessageObject tutorMessageObject = new DataShopMessageObject(outputter.outputString(tutorMessageElement), this.controller.getLogger());
        TutorMessage tutorMessage = (TutorMessage)tutorMessageObject.getLogMsg().getMsg();
        LinkedHashMap<String, String> customFields = this.getCustomFieldsFromXML(tutorMessageElement);
        Set<String> customFieldsKeys = customFields.keySet();
        for (String customFieldName : customFieldsKeys) {
            String customFieldValue = customFields.get(customFieldName);
            tutorMessage.addCustomField(customFieldName, customFieldValue);
        }
        TutorActionLogV4 tutorMessageLog = tutorMessageObject.getLogMsg();
        try {
            tutorMessageLog.setTimeStamp(this.parseDate(toolMessageElement));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (trace.getDebugCode("month")) {
            trace.out("month", "The new tutormessagelog: " + tutorMessageObject.getTimeStamp());
        }
        return tutorMessageLog;
    }

    public void outputLogDifferenceFile() {
        LogDifferences differences = new LogDifferences();
        MessageObjectTableModel tempTable = (MessageObjectTableModel)this.table.getModel();
        ArrayList tableRows = tempTable.getData();
        for (MessageRow row : tableRows) {
            TutorActionLogV4 oldActionLog = row.getOldActionLog();
            TutorActionLogV4 newActionLog = row.getNewActionLog();
            if (oldActionLog == null || newActionLog == null) continue;
            differences.addTutorMessagePair(oldActionLog, newActionLog);
        }
        differences.writeToFile(this.getController(), this, tempTable.getSessionId());
    }

    class MessageObjectTableModel
    extends AbstractTableModel {
        private String userId = "";
        private String sessionId = "";
        private String dateTime = "1970/01/01 00:00:00";
        private String timeZone = "UTC";
        private static final int ROW_NUMBER = 0;
        private static final int TIME_COLUMN = 1;
        private static final int SELECTION_COLUMN = 2;
        private static final int ACTION_COLUMN = 3;
        private static final int INPUT_COLUMN = 4;
        private static final int SEND_COLUMN = 5;
        private static final int ROW_SEND_COLUMN = 6;
        private static final int BOOTSTRAPPED = 7;
        private final XMLOutputter xmlout = new XMLOutputter();
        private String[] columnNames = new String[]{"#", "Time", "Selection", "Action", "Input", "Select", "Send Row", "Bootstrapped"};
        private ArrayList data = new ArrayList();
        private int lastBootstrappedRow = -1;
        private String fileName;
        private HashMap<String, Integer> problemIndicies = new HashMap();
        private List<Element> logElements = null;
        private HashSet<String> skillNameAndCategory = new HashSet();

        MessageObjectTableModel() {
        }

        public void setData(List omoList) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "running setData(List): " + omoList);
            }
            this.data = new ArrayList();
            int rowNumber = 1;
            for (DataShopMessageObject omo : omoList) {
                MessageRow row = new MessageRow(omo, rowNumber++);
                this.data.add(row);
            }
            LogConsole.this.statusLabel.showTotal(this.data.size());
        }

        public void setAllSend(boolean b) {
            ArrayList msgs = ((MessageObjectTableModel)LogConsole.this.table.getModel()).getData();
            for (int i = 0; i < msgs.size(); ++i) {
                MessageRow row = (MessageRow)msgs.get(i);
                row.setToSend(b ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void setDataFromFile(String logFileName, boolean convert) throws Exception {
            List<Element> logEntries = null;
            Element[] getRoot = new Element[1];
            this.fileName = logFileName;
            logEntries = LogFormatUtils.readLogFile(logFileName, convert, getRoot);
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "setDataFromFile logEntries list:" + logEntries);
            }
            this.logElements = logEntries;
            this.setNewProblemIndicies(logEntries);
            if (logEntries.size() > 0) {
                trace.out("replay", "logEntries[0]=" + this.xmlout.outputString(logEntries.get(0)));
            }
            if (logEntries.size() > 1) {
                trace.out("replay", "logEntries[1]=" + this.xmlout.outputString(logEntries.get(1)));
            }
            this.setDataFromLogElements(logEntries, getRoot[0]);
        }

        private void setNewProblemIndicies(List<Element> logEntries) {
            if (trace.getDebugCode("dsr")) {
                trace.out("dsr", "setNewProblemIndicies logEntries size " + logEntries.size());
            }
            int numIndices = this.problemIndicies.size();
            for (int i = 0; i < logEntries.size(); ++i) {
                String name;
                Element currentElt = logEntries.get(i);
                if (trace.getDebugCode("dsr")) {
                    trace.out("dsr", String.format("setNewProblemIndicies[%2d]: name %s, child %s", i, currentElt.getName(), currentElt.getChild("tutor_related_message_sequence")));
                }
                if (currentElt.getName().equals("log_action") && currentElt.getChild("tutor_related_message_sequence") != null) {
                    Element trms = currentElt.getChild("tutor_related_message_sequence");
                    if (trace.getDebugCode("dsr")) {
                        trace.out("dsr", String.format("setNewProblemIndicies[%2d]: trms %s, children %s", i, trms.getName(), trms.getChildren()));
                    }
                    if (trms.getChild("context_message") == null) continue;
                    String name2 = this.findProblemName(trms.getChild("context_message"));
                    String escapedContext = this.unescapeXMLNameToProblem(name2);
                    this.putWithoutOverwrite(escapedContext, i);
                    continue;
                }
                if (!currentElt.getName().equals("message") || currentElt.getChild("properties") == null || (name = currentElt.getChild("properties").getChildText("problem_name")) == null) continue;
                this.putWithoutOverwrite(name, i - 1);
            }
            if (this.problemIndicies.size() <= numIndices && logEntries.size() > 0) {
                this.putWithoutOverwrite(LogConsole.this.controller.getProblemName(), -1);
            }
            if (trace.getDebugCode("dsr")) {
                trace.out("dsr", "Problem Indicies: " + this.problemIndicies);
            }
        }

        private String unescapeXMLNameToProblem(String escapedString) {
            String unescapeSpace = escapedString.replaceAll(" ", "+");
            String unescapedEquals = unescapeSpace.replaceAll("=", "eq");
            return unescapedEquals;
        }

        private String findProblemName(Element child) {
            try {
                Element dataset = child.getChild("dataset");
                Element level = dataset.getChild("level");
                Element level2 = level.getChild("level");
                Element problem = level2.getChild("problem");
                Element name = problem.getChild("context");
                return name.getText();
            }
            catch (NullPointerException e) {
                System.err.println("Couldn't find the context_message's problem context");
                return null;
            }
        }

        private boolean putWithoutOverwrite(String key, int value) {
            if (this.problemIndicies.get(key) != null) {
                return false;
            }
            this.problemIndicies.put(key, value);
            return true;
        }

        private ArrayList getData() {
            return this.data;
        }

        public List getMessagesToSend() {
            int i = 0;
            ArrayList<DataShopMessageObject> result = new ArrayList<DataShopMessageObject>();
            LogConsole.this.playedMessages = new HashMap();
            for (MessageRow row : this.data) {
                if (row.getToSend().booleanValue()) {
                    result.add(row.getMessage());
                    LogConsole.this.playedMessages.put(row.getMessage(), i);
                }
                ++i;
            }
            return result;
        }

        public List getMessageToSend(int pressedRow) {
            ArrayList<DataShopMessageObject> result = new ArrayList<DataShopMessageObject>();
            LogConsole.this.playedMessages = new HashMap();
            MessageRow row = (MessageRow)this.data.get(pressedRow);
            result.add(row.getMessage());
            LogConsole.this.playedMessages.put(row.getMessage(), pressedRow);
            trace.out("logtime", "messagerow's string form : " + row.toString());
            return result;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int r, int c) {
            MessageRow row = (MessageRow)this.data.get(r);
            switch (c) {
                case 0: {
                    return row.getRowNumber();
                }
                case 1: {
                    return row.getTime();
                }
                case 2: {
                    return row.getSelection();
                }
                case 3: {
                    return row.getAction();
                }
                case 4: {
                    return row.getInput();
                }
                case 5: {
                    return row.getToSend();
                }
                case 6: {
                    return row.getRowSend();
                }
                case 7: {
                    return row.getBootstrapped();
                }
            }
            trace.err("MessageObjectTableModel.getValueAt(" + r + "," + c + ") bad column index " + c);
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 5: {
                    return Boolean.class;
                }
                case 6: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 5 || col == 6;
        }

        @Override
        public void setValueAt(Object value, int r, int c) {
            trace.out("log", "Setting value at " + r + "," + c + " to " + value + " (an instance of " + value.getClass() + ")");
            if (c != 5 && c != 6) {
                trace.err("MessageObjectTableModel.setValueAt(" + r + "," + c + ") bad column index " + c);
                return;
            }
            if (c == 5) {
                MessageRow row = (MessageRow)this.data.get(r);
                row.setToSend((Boolean)value);
            } else if (c == 6) {
                MessageRow row = (MessageRow)this.data.get(r);
                row.setRowSend((JButton)value);
            }
            this.fireTableCellUpdated(r, c);
            trace.out("log", "New value of data:\n" + this.dumpData());
        }

        private String dumpData() {
            if (!trace.getDebugCode("log")) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                sb.append("    row ").append(i).append(":");
                for (int j = 0; j < numCols; ++j) {
                    sb.append("  ").append(this.getValueAt(i, j));
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        public String getUserId() {
            return this.userId;
        }

        private void setUserId(String attributeValue) {
            if (attributeValue == null || attributeValue.length() < 1) {
                return;
            }
            this.userId = attributeValue;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String attributeValue) {
            if (attributeValue == null) {
                return;
            }
            this.sessionId = attributeValue;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(String attributeValue) {
            if (attributeValue == null || attributeValue.length() < 1) {
                return;
            }
            this.dateTime = attributeValue;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        private void setTimeZone(String attributeValue) {
            if (attributeValue == null || attributeValue.length() < 1) {
                return;
            }
            this.timeZone = attributeValue;
        }

        public void setDataFromLogElements(List<Element> logEntries, Element versionElt) {
            Attribute versionAttr = versionElt == null ? null : versionElt.getAttribute("version_number");
            trace.out("replay", "setDataFromLogElements(): logEntries.size() " + logEntries.size() + ", versionAttr " + versionAttr);
            this.setOnlyCurrentProblemRows(logEntries);
            this.createSkillsForReplay();
            trace.out("replay", "setDataFromLogElements(): data.size() " + this.data.size());
            LogConsole.this.statusLabel.showTotal(this.data.size());
            this.fireTableDataChanged();
        }

        private void createSkillsForReplay() {
            if (trace.getDebugCode("log")) {
                trace.out("log", "createSkillsForReplay " + new XMLOutputter().outputString(this.makeSkillsElement()));
            }
            Skills skillObj = null;
            try {
                skillObj = Skills.factory(this.makeSkillsElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            skillObj.setExternallyDefined(true);
            ProblemSummary ps = LogConsole.this.controller.getProblemModel().getProblemSummary();
            ps.setSkills(skillObj);
            LogConsole.this.controller.setRequiredSteps(ps);
            if (trace.getDebugCode("log")) {
                trace.out("log", "createSkillsForReplay projectSummary obj " + ps.toXML());
            }
        }

        private Element makeSkillsElement() {
            Element skills = new Element("skills");
            for (String nameCategory : this.skillNameAndCategory) {
                int spaceIndex = nameCategory.indexOf(" ");
                String name = spaceIndex == 0 ? null : nameCategory.substring(0, spaceIndex);
                String category = spaceIndex == nameCategory.length() - 1 ? null : nameCategory.substring(spaceIndex + 1, nameCategory.length() - 1);
                Element skill = new Element("skill");
                if (name != null) {
                    skill.setAttribute("name", name);
                }
                if (category != null) {
                    skill.setAttribute("category", category);
                }
                skills.addContent((Content)skill);
            }
            return skills;
        }

        private void setOnlyCurrentProblemRows(List<Element> logEntries) {
            this.data = new ArrayList();
            String problemName = LogConsole.this.controller.getProblemName();
            if (!LogConsole.this.lcrProblemName.equals("")) {
                problemName = LogConsole.this.lcrProblemName;
            }
            trace.out("replay", "setOnlyCurrentProblemRows");
            trace.out("replay", "problemIndicies " + this.problemIndicies);
            trace.out("replay", "problemName " + problemName);
            trace.out("replay", "first log entry: " + this.xmlout.outputString(logEntries.get(0)));
            trace.out("replay", "problemIndicies.get(problemName): " + this.problemIndicies.get(problemName));
            int elementIndex = this.problemIndicies.get(problemName) + 1;
            int rowNum = 1;
            MessageRow row = null;
            while (elementIndex < logEntries.size()) {
                DataShopMessageObject omo;
                Element currentElement = logEntries.get(elementIndex);
                trace.out("replay", "currentElement" + this.xmlout.outputString(currentElement));
                if (currentElement.getName().equals("log_session_start")) {
                    return;
                }
                if (this.isTutorPerformed(currentElement)) {
                    ++elementIndex;
                    continue;
                }
                String elementType = this.getMessageType(currentElement);
                if (elementType.equals("tool_message")) {
                    omo = this.createDataShopMessageObject(currentElement);
                    row = new MessageRow(omo, rowNum);
                } else if (elementType.equals("tutor_message")) {
                    row.setTutorMessageElement(currentElement);
                    this.data.add(row);
                    this.extractSkills(currentElement);
                    ++rowNum;
                } else {
                    omo = null;
                    try {
                        omo = this.dsmoFromMessageElt(currentElement);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    TutorActionLogV4 tut = omo.getLogMsg();
                    trace.out("replay", "checking " + problemName + " = " + omo.getProperty("problem_name"));
                    if (problemName.equalsIgnoreCase((String)omo.getProperty("problem_name"))) {
                        row = new MessageRow(omo, rowNum);
                        this.data.add(row);
                    }
                }
                ++elementIndex;
            }
            trace.out("replay", "elementIndex: " + elementIndex);
            trace.out("replay", "data size: " + this.data.size() + "  reached end of currentproblemrows");
        }

        private void extractSkills(Element currentElement) {
            List skills;
            block5: {
                skills = null;
                try {
                    Element trms = currentElement.getChild("tutor_related_message_sequence");
                    Element tutorMessage = trms.getChild("tutor_message");
                    skills = tutorMessage.getChildren("skill");
                }
                catch (NullPointerException e) {
                    if (!trace.getDebugCode("log")) break block5;
                    trace.out("log", "extractSkills can't traverse to skills");
                }
            }
            for (Element skill : skills) {
                String name = skill.getChildText("name");
                String category = skill.getChildText("category");
                if (name == null && category == null) continue;
                String nameAndCategoryConcat = "";
                if (name != null) {
                    nameAndCategoryConcat = nameAndCategoryConcat + name;
                }
                nameAndCategoryConcat = nameAndCategoryConcat + " ";
                if (category != null) {
                    nameAndCategoryConcat = nameAndCategoryConcat + category;
                }
                this.skillNameAndCategory.add(nameAndCategoryConcat);
            }
        }

        private boolean isTutorPerformed(Element element2) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "isTutorPerformed " + new XMLOutputter().outputString(element2));
            }
            Element trms = element2.getChild("tutor_related_message_sequence");
            Element msg = null;
            if (trms == null || (msg = trms.getChild(this.getMessageType(element2))) == null) {
                return false;
            }
            if (msg.getChild("semantic_event") == null) {
                return false;
            }
            Element semanticEvent = msg.getChild("semantic_event");
            String attributeValue = semanticEvent.getAttributeValue("subtype");
            return attributeValue != null && attributeValue.equals("tutor-performed");
        }

        private DataShopMessageObject dsmoFromMessageElt(Element elt) throws ParseException {
            String eltStr = this.xmlout.outputString(elt);
            if (trace.getDebugCode("log")) {
                trace.out("log", "eltStr is\n" + eltStr);
            }
            MessageObject mo = MessageObject.fromElement(elt);
            trace.out("log", "mo: " + mo);
            DataShopMessageObject omo = new DataShopMessageObject(mo, false, LogConsole.this.controller.getLogger());
            trace.out("log", "omo: " + omo);
            TutorActionLogV4 logMessage = omo.getLogMsg();
            trace.out("logtime", "omo log message: " + (Object)((Object)logMessage));
            omo.setOriginalElementString(eltStr);
            omo.setUserId(this.getUserId());
            omo.setSessionId(this.getSessionId());
            trace.out("logtime", "printing date and time: " + this.getDateTime() + " and " + this.getTimeZone());
            omo.setTimeStamp(TutorActionLog.getDate(this.getDateTime(), this.getTimeZone()));
            SimpleDateFormat dsTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            Object time = mo.getProperty("Time");
            if (time != null) {
                omo.setTimeStamp(dsTimeFormat.parse(time.toString()));
                trace.out("logtime", "difference between parse and not : " + time + "date" + dsTimeFormat.parse(time.toString()));
            }
            trace.out("logtime", "DataShopMessageObject made from Elements of the file:" + omo.toString());
            return omo;
        }

        private DataShopMessageObject createDataShopMessageObject(Element elt) {
            String logEltStr = this.xmlout.outputString(elt);
            if (trace.getDebugCode("log")) {
                trace.out("log", "logElt is\n" + logEltStr);
            }
            Element toolMsgElt = this.getToolMessageElement(elt);
            String eltStr = this.xmlout.outputString(toolMsgElt);
            if (trace.getDebugCode("log")) {
                trace.out("log", "tool_message element is\n" + eltStr);
            }
            if (trace.getDebugCode("log")) {
                trace.out("log", "controller.getLogger()" + LogConsole.this.controller.getLogger());
            }
            DataShopMessageObject omo = new DataShopMessageObject(eltStr, LogConsole.this.controller.getLogger());
            omo.setOriginalElementString(logEltStr);
            omo.setUserId(this.getUserId());
            omo.setSessionId(this.getSessionId());
            trace.out("logtime", "printing date and time: " + this.getDateTime() + " and " + this.getTimeZone());
            omo.setTimeStamp(TutorActionLog.getDate(this.getDateTime(), this.getTimeZone()));
            trace.out("logtime", "DataShopMessageObject made from Elements of the file:" + omo.toString());
            return omo;
        }

        private String getMessageType(Element elt) {
            Element message = elt.getChild("tutor_related_message_sequence");
            if (message == null) {
                return "message";
            }
            if (message.getChild("tool_message") != null) {
                return "tool_message";
            }
            if (message.getChild("tutor_message") != null) {
                return "tutor_message";
            }
            return "message";
        }

        private Element getToolMessageElement(Element elt) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "getToolMessageElement() elt.getName() is " + elt.getName());
            }
            if (trace.getDebugCode("log")) {
                trace.out("log", "getToolMessageElement() elt pprint is " + this.xmlout.outputString(elt));
            }
            if (trace.getDebugCode("log")) {
                trace.out("log", "getToolMessageElement() elt.getText() is " + elt.getText());
            }
            if ("log_session_start".equals(elt.getName())) {
                this.setUserId(elt.getAttributeValue("user_guid"));
                return null;
            }
            if ("tutor_related_message_sequence".equals(elt.getName())) {
                return elt;
            }
            if ("tool_message".equals(elt.getName())) {
                return elt;
            }
            if (!"log_action".equals(elt.getName())) {
                return null;
            }
            this.setUserId(elt.getAttributeValue("user_guid"));
            this.setSessionId(elt.getAttributeValue("session_id"));
            this.setDateTime(elt.getAttributeValue("date_time"));
            this.setTimeZone(elt.getAttributeValue("timezone"));
            Element child = elt.getChild("tutor_related_message_sequence");
            if (trace.getDebugCode("log")) {
                trace.out("log", "getToolMessageElement() children are " + elt.getChildren());
            }
            if (child == null) {
                return null;
            }
            Element grandchild = child.getChild("tool_message");
            if (grandchild == null) {
                return null;
            }
            return child;
        }

        public String getFileName() {
            return this.fileName;
        }

        public HashSet<String> getSkillNameAndCategory() {
            return this.skillNameAndCategory;
        }
    }

    class MessageRow {
        private Date time;
        private final DataShopMessageObject omo;
        private int rowNumber;
        private Boolean toSend = new Boolean(true);
        private JButton rowSend = new JButton("Send");
        private int bootstrapped = 0;
        private Element tutorMessageElement = null;
        private TutorActionLogV4 oldActionLog;
        private TutorActionLogV4 newActionLog;

        public MessageRow(DataShopMessageObject omo, int rowNumber) {
            this.time = omo.getTimeStamp();
            trace.out("logtime", "message row constructor time stamp : " + this.time);
            this.time = omo.getLogMsg().getTimeStamp();
            trace.out("logtime", "message row constructor RESET      : " + this.time);
            this.omo = omo;
            this.rowNumber = rowNumber;
        }

        public String getTime() {
            return timeFmt.format(this.time);
        }

        public String getSelection() {
            Object result = this.omo.getProperty("selection");
            if (result == null) {
                result = this.omo.getProperty("Selection");
            }
            return result == null ? "" : result.toString();
        }

        public String getAction() {
            Object result = this.omo.getProperty("action");
            if (result == null) {
                result = this.omo.getProperty("Action");
            }
            return result == null ? "" : result.toString();
        }

        public String getInput() {
            Object result = this.omo.getProperty("input");
            if (result == null) {
                result = this.omo.getProperty("Input");
            }
            return result == null ? "" : result.toString();
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public Boolean getToSend() {
            return this.toSend;
        }

        public JButton getRowSend() {
            return this.rowSend;
        }

        public int getBootstrapped() {
            return this.bootstrapped;
        }

        public void setRowNumber(int rowNumber) {
            this.rowNumber = rowNumber;
        }

        public void setToSend(Boolean toSend) {
            this.toSend = toSend;
        }

        public void setRowSend(JButton rowSend) {
            this.rowSend = rowSend;
        }

        public void setBootstrapped(int bootstrapped) {
            this.bootstrapped = bootstrapped;
        }

        public DataShopMessageObject getMessage() {
            return this.omo;
        }

        public Element getTutorMessageElement() {
            return this.tutorMessageElement;
        }

        public void setTutorMessageElement(Element tutorMessageElement) {
            this.tutorMessageElement = tutorMessageElement;
        }

        public TutorActionLogV4 getOldActionLog() {
            return this.oldActionLog;
        }

        public void setOldActionLog(TutorActionLogV4 oldActionLog) {
            this.oldActionLog = oldActionLog;
        }

        public TutorActionLogV4 getNewActionLog() {
            return this.newActionLog;
        }

        public void setNewActionLog(TutorActionLogV4 newActionLog) {
            this.newActionLog = newActionLog;
        }
    }

    class RowSendBtnRenderer
    extends JButton
    implements TableCellRenderer {
        public RowSendBtnRenderer() {
            this.setText("Send");
            this.setOpaque(true);
            System.out.println("RowSendBtnEditor constructor");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class RowSendBtnEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected static final String SEND_ROW = "Send";
        private JButton button = new JButton("Send");
        private int lastPressedSendRowBtn = -1;

        public RowSendBtnEditor() {
            this.button.setActionCommand(SEND_ROW);
            this.button.addActionListener(this);
            System.out.println("RowSendBtnEditor constructor");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("RowSendBtnEditor.actionPerformed");
            LogConsole.this.sendRow(this.lastPressedSendRowBtn);
        }

        @Override
        public Object getCellEditorValue() {
            System.out.println("RowSendBtnEditor.getCellEditorValue");
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            System.out.println("RowSendBtnEditor.getTableCellEditorComponent row = " + row + " column = " + column);
            this.lastPressedSendRowBtn = row;
            return this.button;
        }
    }

    private class StatusLabel
    implements MessagePlayerListener {
        JLabel label = new JLabel("Total 0 log entries");
        JPanel panel = new JPanel(new BorderLayout());

        StatusLabel() {
            this.label.setName("StatusLabel");
        }

        @Override
        public void messagePlayerEventOccurred(MessagePlayerEvent e) {
            int total = e.getTotalCount();
            int sent = e.getSentCount();
            boolean stopping = e.isStopping();
            this.panel.add((Component)this.label, "Center");
            this.setText("Sent " + sent + " of " + total + " message" + (total == 1 ? "" : "s") + (stopping ? " (stopped)" : ""));
        }

        JPanel getPanel() {
            return this.panel;
        }

        void setText(final String text) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusLabel.this.label.setText(text);
                    StatusLabel.this.panel.validate();
                }
            });
        }

        void showTotal(int total) {
            this.setText("Total " + total + " log " + (total == 1 ? "entry" : "entries"));
        }
    }
}

