/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.hcii.ctat.ExitableServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.Log.DataShopReader;
import edu.cmu.pact.Log.LogConsole;
import edu.cmu.pact.Log.ReplayLauncherServer;
import edu.cmu.pact.Log.ReplaySessionHolder;
import edu.cmu.pact.Utilities.ProblemNameParser;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MessagePlayerEvent;
import edu.cmu.pact.ctat.MessagePlayerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class LogConsoleReplay
implements MessagePlayerListener,
ProblemModelListener,
PropertyChangeListener,
ExitableServer {
    private static final int DEFAULT_REPLAY_UNIT_SECS = 120;
    private static final int DEFAULT_NTHREADS = 4;
    private static long replayUnitTimeout = 120L;
    private static int nextGuid = 0;
    private static int nThreads = 4;
    private static int gcFrequency = 5;
    private Box mainPanel;
    private static double speedFactor = 1.0;
    private static double maxWaitTime = -1.0;
    private static boolean saveMessages = false;
    private DataShopReader dsreader;
    private ProblemNameParser pnparse;
    private ArrayList<ArrayList<String>> replayUnits;
    private ArrayList<ArrayList<DataShopMessageObject>> replays;
    private CTATTabManager tabManager;
    private LogConsole logcon;
    private BR_Controller br;
    private JDialog window;
    private JButton goBtn;
    private StatusLabel statusLabel = new StatusLabel();
    private JTable table;
    private boolean goAll = false;
    static final int SESSION = 0;
    static final int USER = 1;
    static final int ASSIGNMENT = 2;
    static final int PROBSET = 3;
    static final int PROBNAME = 4;
    static final int ATTEMPT = 5;
    static final int TIME = 6;
    static final int SCHOOLNAME = 7;
    static final int CLASSNAME = 8;
    static final int CONDNAME = 9;
    static final int CONDTYPE = 10;
    private static final String LOG_REPLAY_SOURCE = "CTAT_LOG_REPLAY";
    private int currentUnit = 0;
    private String datasetName = null;
    private String defaultDatasetName = null;
    private MyInt ruIndex;
    private MyInt studentNum;
    private LinkedList<ReplaySessionHolder> rshList;
    private volatile boolean nowExiting = false;

    public LogConsoleReplay(String brdSWF, String dsExport, String brdLocation, BR_Controller ctlr) {
        if (trace.getDebugCode("replay")) {
            trace.out("replay", String.format("LogConsoleReplay(\n  brdSWF %s,\n  dsExport %s,\n  brdLocation %s,\n  ctlr %s\n)", brdSWF, dsExport, brdLocation, ctlr));
        }
        this.br = ctlr;
        if (this.br != null) {
            this.setTabManager(this.br.getServer().getTabManager());
        }
        try {
            this.dsreader = new DataShopReader(dsExport, brdSWF, brdLocation);
        }
        catch (IOException e) {
            String msg = "Could not read log file" + dsExport + " for replay:\n" + e;
            trace.errStack(msg, e);
            JOptionPane.showMessageDialog(null, msg, "Log File Processing Error", 2);
            return;
        }
        this.pnparse = this.dsreader.getParser();
        this.replayUnits = this.dsreader.getreplayUnitNames();
        this.replays = this.dsreader.getReplayUnitList();
        if (this.br != null) {
            this.table = new JTable(new ReplayUnitTableModel());
            trace.out("replay", "replay units: " + this.replayUnits.size());
            trace.out("replay", "replay unit list: " + this.replays.size());
            ((ReplayUnitTableModel)this.table.getModel()).setData(this.replayUnits);
            this.init();
        }
    }

    public static void main(String[] args) {
        LinkedHashSet<String> missingArgs = new LinkedHashSet<String>();
        String dataset = null;
        missingArgs.add("dataset");
        String dir = null;
        missingArgs.add("dir");
        String map = null;
        missingArgs.add("map");
        String dsExport = null;
        missingArgs.add("dsexport");
        Pattern argFmt = Pattern.compile("--([a-z]+)=(.*)");
        for (String arg : args) {
            Matcher m;
            if (arg.toLowerCase().contains("-h")) {
                LogConsoleReplay.usageExit(null);
            }
            if (!(m = argFmt.matcher(arg)).matches()) {
                LogConsoleReplay.usageExit("bad argument \"" + arg + "\"; arguments must be of the form \"--name=value\"");
            }
            String name = m.group(1);
            String value = m.group(2);
            if (value == null || value.length() < 1) {
                LogConsoleReplay.usageExit("missing value for argument \"--" + name + "\"");
            }
            if ("threads".equals(name)) {
                try {
                    nThreads = Integer.parseInt(value);
                    if (nThreads >= 0) continue;
                    LogConsoleReplay.usageExit("threads " + value + " cannot be less than 0");
                }
                catch (Exception e) {
                    LogConsoleReplay.usageExit("illegal value \"" + value + "\" for threads");
                }
                continue;
            }
            if ("gc".equals(name)) {
                try {
                    gcFrequency = Integer.parseInt(value);
                    if (gcFrequency >= 0) continue;
                    LogConsoleReplay.usageExit("gc frequency " + value + " cannot be less than 0");
                }
                catch (Exception e) {
                    LogConsoleReplay.usageExit("illegal value \"" + value + "\" for gc");
                }
                continue;
            }
            if ("timeout".equals(name)) {
                try {
                    replayUnitTimeout = Long.parseLong(value);
                    if (replayUnitTimeout >= 0L) continue;
                    LogConsoleReplay.usageExit("timeout " + value + " cannot be less than 0");
                }
                catch (Exception e) {
                    LogConsoleReplay.usageExit("illegal value \"" + value + "\" for timeout");
                }
                continue;
            }
            if ("dataset".equals(name)) {
                missingArgs.remove("dataset");
                if (value.trim().length() > 0) {
                    dataset = value;
                    continue;
                }
                LogConsoleReplay.usageExit("dataset name \"" + value + "\" invalid");
                continue;
            }
            if ("dir".equals(name)) {
                missingArgs.remove("dir");
                try {
                    File brdDir = new File(value);
                    if (brdDir.isDirectory() && brdDir.canRead()) {
                        dir = brdDir.toURI().toString();
                        continue;
                    }
                    LogConsoleReplay.usageExit("package directory \"" + value + "\" not found or not readable");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogConsoleReplay.usageExit("error getting absolute path for package directory \"" + value + "\": " + e);
                }
                continue;
            }
            if ("map".equals(name)) {
                missingArgs.remove("map");
                File mapFile = new File(value);
                if (mapFile.isFile() && mapFile.canRead()) {
                    map = value;
                    continue;
                }
                LogConsoleReplay.usageExit("problemToBRDMap file \"" + value + "\" not found or not readable");
                continue;
            }
            if ("dsexport".equals(name)) {
                missingArgs.remove("dsexport");
                File dsexportFile = new File(value);
                if (dsexportFile.isFile() && dsexportFile.canRead()) {
                    dsExport = value;
                    continue;
                }
                LogConsoleReplay.usageExit("dsexport file \"" + value + "\" not found or not readable");
                continue;
            }
            if ("speedfactor".equals(name)) {
                double toNum = Double.parseDouble(value);
                if (toNum > 0.0) {
                    speedFactor = toNum;
                    continue;
                }
                speedFactor = 0.0;
                continue;
            }
            if ("maxwait".equals(name)) {
                double toNum = Double.parseDouble(value);
                if (toNum >= 0.0) {
                    maxWaitTime = toNum;
                    continue;
                }
                maxWaitTime = -1.0;
                continue;
            }
            if ("messages".equals(name)) {
                if (value.equals("true")) {
                    saveMessages = true;
                    continue;
                }
                saveMessages = false;
                continue;
            }
            LogConsoleReplay.usageExit("unsupported argument \"" + name + "\"");
        }
        if (missingArgs.size() > 0) {
            LogConsoleReplay.usageExit("missing argument(s) " + missingArgs);
        }
        argFmt = null;
        missingArgs = null;
        LogConsoleReplay lcr = new LogConsoleReplay(map, dsExport, dir, null);
        lcr.setDatasetName(dataset);
        int exitCode = lcr.runBatchPlayer();
        System.exit(exitCode);
    }

    private static void usageExit(String errMsg) {
        String errMsgEnd = ".\n";
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() < 1) {
            errMsgEnd = "";
        }
        System.err.printf("LogConsoleReplay: %s%sUsage:\n    LogConsoleReplay [-h] [--help] [--gc={gcFrequency}] [--threads={numberThreads}] [--timeout={maxReplayUnitTime}] \\\n             --dataset={newDatasetName} --dir={package} --map={problemToBRDMap} --dsexport={dsFile} \\\n             [--maxwait={maximumTimeBetweenActions}] [--speedfactor={speedUpStudentActions}] [--messages={true/false}]\nwhere--\n    -h or --help        means print this help message and exit;\n    {gcFrequency}       is the fraction of replay units after which to garbage-collect; default 5;\n    {numberThreads}     is the number of sessions to replay concurrently; default 4;\n    {maxReplayUnitTime} is the maximum time to wait for a single replay unit, in seconds; default 120;\n    {newDatasetName}    is the dataset for the new log of replayed transactions;\n    {package}           is the parent directory containing FinalBRDs/, CognitiveModel/, etc.;\n    {problemToBRDMap}   is a file providing a mapping from DataShop context attributes to BRD file names.\n    {dsFile}            is the DataShop transaction export to read.\n    {maxwait}           is the maximum time in seconds, that a student can take to finish a problem.  Default is zero wait time.\n    {speedfactor}       is the factor at which to change the time a student takes to finish a problem.  Default is 1.\n    {messages}          is a boolean to decide whether to save the xml messages or not. Default is false.", errMsg, errMsgEnd);
        System.exit(1);
    }

    private int runBatchPlayer() {
        trace.out("replay", String.format("runBatchPlayer\n  nReplays     %4d,\n  nReplayUnits %4d,\n  pnparse.map %4d;\n", this.replays.size(), this.replayUnits.size(), this.pnparse.size()));
        if (trace.getDebugCode("replaybatch")) {
            int i;
            int n = Math.min(this.replays.size(), 5);
            for (i = 0; i < n; ++i) {
                List replay = this.replays.get(i);
                System.out.printf("replays[%d], size %d\n", i, replay.size());
                int m = Math.min(replay.size(), 5);
                for (int j = 0; j < m; ++j) {
                    System.out.printf("\n  [%d.%d] %s\n", i, j, replay.get(j));
                }
            }
            n = Math.min(this.replayUnits.size(), 5);
            for (i = 0; i < n; ++i) {
                System.out.printf("replayUnits[%d] %s\n", i, this.replayUnits.get(i));
            }
        }
        this.rshList = new LinkedList();
        for (int i = 0; i < nThreads; ++i) {
            this.rshList.add(new ReplaySessionHolder());
        }
        ReplayLauncherServer rls = new ReplayLauncherServer(this.rshList, this);
        rls.setSpeedFactor(speedFactor);
        rls.setMaxWaitTime(maxWaitTime);
        rls.setSaveMessages(saveMessages);
        rls.setLogDir(this.makeLogDir());
        this.ruIndex = new MyInt(0);
        this.studentNum = new MyInt(0);
        int result = -1;
        try {
            int sessionsAssigned = -1;
            do {
                sessionsAssigned = this.assignSessionsToThreads(rls, this.rshList, sessionsAssigned < 0);
            } while (!this.isExiting() && sessionsAssigned > 0);
            result = this.waitForCompletion();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    private String makeLogDir() {
        String dirName = this.getDatasetName();
        if (dirName == null || dirName.trim().length() < 1) {
            return ".";
        }
        try {
            File dirFile = new File(dirName);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            } else if (!dirFile.isDirectory()) {
                throw new IOException("datasetName " + dirName + " exists but is not a directory");
            }
            return dirName;
        }
        catch (Exception e) {
            trace.errStack("LCR.makeLogDir() error " + e + "; cause " + e.getCause(), e);
            return ".";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitForCompletion() {
        ReplaySessionHolder[] rshListCopy;
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "LCR.waitForCompletion() before synch(rshList)");
        }
        LinkedList<ReplaySessionHolder> linkedList = this.rshList;
        synchronized (linkedList) {
            rshListCopy = new ReplaySessionHolder[this.rshList.size()];
            this.rshList.toArray(rshListCopy);
        }
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "LCR.waitForCompletion() before join loop");
        }
        int leftoverCount = 0;
        for (int n = 0; n < rshListCopy.length; ++n) {
            long begin;
            ReplayLauncherServer.ReplaySession rs = rshListCopy[n].getSession();
            if (trace.getDebugCode("replay")) {
                trace.out("replay", "LCR.waitForCompletion() isExiting " + this.isExiting() + ", join wait[" + n + "]: rs " + rs);
            }
            if (rs == null) continue;
            long now = begin = System.currentTimeMillis();
            long then = now + this.getTimeout();
            while (!this.isExiting() && rs.isAlive() && now < then) {
                try {
                    rs.join(then - now + 1L);
                }
                catch (Exception e) {
                    trace.errStack("LCR.waitForCompletion() join wait[" + n + "] interrupted after (ms) " + (System.currentTimeMillis() - begin), e);
                }
                now = System.currentTimeMillis();
            }
            if (!rs.isAlive()) continue;
            trace.err("LCR.waitForCompletion(): Thread " + rs.getName() + " still alive after " + (System.currentTimeMillis() - begin) + " ms; enqueuing Quit message");
            rs.requestQuit();
            ++leftoverCount;
        }
        return leftoverCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int assignSessionsToThreads(ReplayLauncherServer rls, LinkedList<ReplaySessionHolder> rshList, boolean firstCall) {
        int nAssigned = 0;
        LinkedList<ReplaySessionHolder> linkedList = rshList;
        synchronized (linkedList) {
            ReplaySessionHolder rsh;
            long begin;
            long now = begin = System.currentTimeMillis();
            long then = now + this.getTimeout();
            while (!firstCall && begin > 0L && now < then) {
                try {
                    rshList.wait(then - now + 1L);
                    begin = -1L;
                }
                catch (InterruptedException ie) {
                    trace.errStack("LCR.assignSessionsToThreads interrupted: " + ie + "; cause " + ie.getCause(), ie);
                }
                now = System.currentTimeMillis();
            }
            if (begin > 0L && !firstCall) {
                trace.err("LCR.assignSessionsToThreads wait() time expired after " + (System.currentTimeMillis() - begin) + " ms");
                return 0;
            }
            while (this.ruIndex.num < this.replayUnits.size() && (rsh = rshList.peekFirst()) != null && rsh.getSession() == null) {
                boolean assigned = false;
                while (this.ruIndex.num < this.replayUnits.size() && !assigned) {
                    assigned = this.assignSessionToThread(rls, this.ruIndex, rsh);
                }
                if (!assigned) continue;
                rsh = rshList.removeFirst();
                rshList.addLast(rsh);
                ++nAssigned;
            }
            rshList.notifyAll();
        }
        return nAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignSessionToThread(ReplayLauncherServer rls, MyInt ruIdx, ReplaySessionHolder rsh) {
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "LCR.assignSessionToThread() replayUnits[" + ruIdx + "] into rsh " + rsh);
        }
        ArrayList<String> replayUnit = this.replayUnits.get(ruIdx.num);
        ArrayList<DataShopMessageObject> replay = this.replays.get(ruIdx.num + 1);
        String problemName = replayUnit.get(4);
        String datasetLevelName1 = replayUnit.get(2);
        String datasetLevelName2 = replayUnit.get(3);
        ProblemNameParser.ProblemBundle brdSwf = this.pnparse.findBundle(problemName, datasetLevelName1, datasetLevelName2);
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "LCR.assignSessionToThread() [" + brdSwf + "] <= findBundle(" + datasetLevelName1 + ", " + datasetLevelName2 + ", " + problemName + ")");
        }
        if (brdSwf == null) {
            return false;
        }
        String userGuid = replayUnit.get(1);
        String logSessionID = replayUnit.get(0);
        ReplayLauncherServer.ReplaySession rs = rls.addSession("Replay_" + Integer.toString(LogConsoleReplay.guidGenerator()), rsh, gcFrequency);
        rs.setUserGuid(userGuid);
        rs.setLogSessionID(logSessionID);
        MessageObject setPrefsMsg = LogConsoleReplay.createSetPreferencesMsg(userGuid, problemName, brdSwf.getBRD(), replayUnit.get(8), replayUnit.get(7), logSessionID, LOG_REPLAY_SOURCE, this.getDatasetName(), replayUnit.get(2), DataShopReader.getDatasetLevelType(1), replayUnit.get(3), DataShopReader.getDatasetLevelType(2), replayUnit.get(9), replayUnit.get(10));
        rs.setup(setPrefsMsg, replay);
        rs.setDatasetName(this.getDatasetName());
        LinkedList<ReplaySessionHolder> linkedList = this.rshList;
        synchronized (linkedList) {
            rs.setName("Replay_" + this.studentNum.num);
            ++this.studentNum.num;
        }
        rsh.setSession(rs);
        ArrayList<DataShopMessageObject> messages = new ArrayList<DataShopMessageObject>();
        ArrayList<ArrayList<String>> names = new ArrayList<ArrayList<String>>();
        String currUser = replayUnit.get(1);
        int i = 0;
        while (i + 1 < this.replays.size() && ruIdx.num < this.replayUnits.size() && ruIdx.num + 1 < this.replays.size()) {
            replayUnit = this.replayUnits.get(ruIdx.num);
            replay = this.replays.get(ruIdx.num + 1);
            String user = replayUnit.get(1);
            if (!user.equals(currUser)) break;
            for (int j = 0; j < replay.size(); ++j) {
                messages.add(replay.get(j));
                names.add(replayUnit);
            }
            ++ruIdx.num;
            ++i;
        }
        rs.setReplays(messages, names);
        rs.setParser(this.pnparse);
        rs.start();
        return true;
    }

    public static MessageObject createSetPreferencesMsg(String userGuid, String problemName, String questionFile, String className, String schoolName, String sessionId, String sourceId, String datasetName, String datasetLevelName1, String datasetLevelType1, String datasetLevelName2, String datasetLevelType2, String studyConditionName1, String studyConditionType1) {
        MessageObject setPrefs = MessageObject.create("SetPreferences", "NotePropertySet");
        setPrefs.setProperty("user_guid", userGuid);
        setPrefs.setProperty("problem_name", problemName);
        setPrefs.setProperty("question_file", questionFile);
        setPrefs.setProperty("class_name", className);
        setPrefs.setProperty("school_name", schoolName);
        setPrefs.setProperty("session_id", sessionId);
        setPrefs.setProperty("source_id", sourceId);
        setPrefs.setProperty("dataset_name", datasetName);
        setPrefs.setProperty("dataset_level_name1", datasetLevelName1);
        setPrefs.setProperty("dataset_level_type1", datasetLevelType1);
        setPrefs.setProperty("dataset_level_name2", datasetLevelName2);
        setPrefs.setProperty("dataset_level_type2", datasetLevelType2);
        setPrefs.setProperty("study_condition_name1", studyConditionName1);
        setPrefs.setProperty("study_condition_type1", studyConditionType1);
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "RLS.RS.createSetPreferences:\n" + setPrefs);
        }
        return setPrefs;
    }

    public String getDatasetName() {
        if (this.datasetName != null && this.datasetName.trim().length() > 0) {
            return this.datasetName;
        }
        if (this.defaultDatasetName == null) {
            this.defaultDatasetName = "LogReplay_" + new Date().toString().replaceAll(" ", "_");
        }
        try {
            throw new RuntimeException("Dataset name not set; default is\n  " + this.defaultDatasetName);
        }
        catch (Exception e) {
            trace.err("Error in LogConsoleReplay.getDatasetName(): " + e);
            return this.defaultDatasetName;
        }
    }

    private void setDatasetName(String dataset) {
        this.datasetName = dataset;
    }

    public long getTimeout() {
        return replayUnitTimeout * 1000L;
    }

    private static synchronized int guidGenerator() {
        return ++nextGuid;
    }

    public static void createConsole(BR_Controller brcontrol) {
        String dsExport;
        String brdLocString;
        trace.out("replay", "Got to createConsole");
        File brdLocation = DialogUtilities.chooseDirectory(null, null, null, "Please choose the directory where the .brd files are located", "Select folder", brcontrol.getActiveWindow());
        String string = brdLocString = brdLocation == null ? null : brdLocation.getPath();
        if (brdLocString == null || brdLocString.length() < 1) {
            trace.out("replay", "No folder was chosen.");
            return;
        }
        long now = System.currentTimeMillis();
        long then = now + 600L;
        do {
            try {
                Thread.sleep(then - now + 1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((now = System.currentTimeMillis()) < then);
        File brdswfFile = DialogUtilities.chooseFile(brdLocString, null, "Please choose the dictionary for BRD and SWF files", "Load", brcontrol);
        String brdFile = brdswfFile == null ? null : brdswfFile.getPath();
        trace.out("replay", "FRANCESKA: reading in brdFile: " + brdFile);
        if (brdFile == null || brdFile.length() < 1) {
            trace.out("replay", "No BRD dictionary file chosen.");
            return;
        }
        File rawExport = DialogUtilities.chooseFile(brdLocString, null, "Please choose the datashop export name", "Load", brcontrol);
        String string2 = dsExport = rawExport == null ? null : rawExport.getPath();
        if (dsExport == null || dsExport.length() < 1) {
            trace.out("replay", "No file chosen.");
            return;
        }
        LogConsoleReplay logReplay = null;
        try {
            logReplay = dsExport == null ? new LogConsoleReplay("", "", "", brcontrol) : new LogConsoleReplay(brdFile, dsExport, brdLocString, brcontrol);
        }
        catch (Exception e) {
            String msg = "Could not read data shop export " + dsExport + ":\n" + e;
            trace.errStack(msg, e);
            JOptionPane.showMessageDialog(null, msg, "DataShop Processing Error", 2);
            return;
        }
        logReplay.createAndShowGUI(brcontrol != null ? brcontrol.getDockedFrame() : null);
    }

    private void init() {
        if (this.br != null) {
            this.getController().getProblemModel().addProblemModelListener(this);
        }
        this.table.setDefaultRenderer(JButton.class, new RowSendBtnRenderer());
        this.table.setDefaultEditor(JButton.class, new RowSendBtnEditor());
        JLabel renderer = (JLabel)((Object)this.table.getDefaultRenderer(String.class));
        renderer.setHorizontalAlignment(0);
        this.mainPanel = new Box(3);
        this.mainPanel.setName("Select set of data to replay");
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.mainPanel.add(scrollPane);
        this.mainPanel.add(Box.createVerticalStrut(4));
        Box btnsPanel = new Box(0);
        this.goBtn = new JButton("Send All");
        this.goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogConsoleReplay.this.goAll = true;
                LogConsoleReplay.this.goAllRows(0);
            }
        });
        this.goBtn.setEnabled(true);
        btnsPanel.add(this.goBtn);
        this.mainPanel.add(btnsPanel);
        this.mainPanel.add(this.statusLabel.getPanel());
    }

    private BR_Controller getController() {
        return this.br;
    }

    private CTATTabManager getTabManager() {
        return this.tabManager;
    }

    public void setTabManager(CTATTabManager tab) {
        this.tabManager = tab;
    }

    public void replayUnitCompleted(PropertyChangeEvent e) {
        trace.out("replay", "event fired" + e.getPropertyName() + " new value " + e.getNewValue());
        if (this.goAll && e.getPropertyName() == "transactions left" && (Integer)e.getNewValue() <= 0) {
            this.tabManager.closedLogConsole();
            this.logcon.getWindow().dispose();
            if (this.currentUnit + 1 < this.replayUnits.size() && this.currentUnit >= 0) {
                ++this.currentUnit;
                this.goAllRows(this.currentUnit);
            } else {
                JOptionPane.showMessageDialog(this.br.getDockedFrame(), "All units finished replaying!");
            }
        }
    }

    public void chooseProblem(int i) {
        ArrayList<String> unitID = this.replayUnits.get(i);
        String replayUnit = this.dsreader.createTempFile(i);
        ProblemNameParser.ProblemBundle prob = this.dsreader.grabProblemBundle(unitID.get(4), unitID.get(2), unitID.get(3));
        String brd = prob.getBRD();
        String swf = prob.getSWF();
        trace.out("replay", "This is the brd name: " + brd + " and problem name " + unitID.get(4));
        trace.out("replay", "This is the swf name: " + swf);
        String problemNm = new File(brd).getName();
        problemNm = problemNm.substring(0, problemNm.lastIndexOf("."));
        this.br.getProblemModel().setProblemName(problemNm);
        this.br.getCtatModeModel().setAuthorMode("Test Tutor", false);
        Utils.setRuntime(true);
        try {
            new URI(brd);
        }
        catch (URISyntaxException e) {
            brd = new File(brd).toURI().toString();
            trace.out("replay", "brd file converted to URL " + brd);
        }
        try {
            URL brdURL = new URL("file://" + brd);
            this.br.openBR(brdURL, null, null, unitID.get(4), null, null);
        }
        catch (MalformedURLException e) {
            trace.err("MalformedURLException: Error converting the brd filename " + e);
            return;
        }
        try {
            this.logcon = new LogConsole(replayUnit, false, this.br, this, unitID.get(4));
            this.logcon.getLogger().setProblemName(unitID.get(4));
            this.logcon.getLogger().setSessionId(unitID.get(0));
            this.logcon.getLogger().addDatasetLevelName(unitID.get(2), 1);
            this.logcon.getLogger().addDatasetLevelType(DataShopReader.getDatasetLevelType(1), 1);
            this.logcon.getLogger().addDatasetLevelType(DataShopReader.getDatasetLevelType(2), 2);
            this.logcon.getLogger().addDatasetLevelName(unitID.get(3), 2);
            this.logcon.getLogger().setSchoolName(unitID.get(7));
            this.logcon.getLogger().setClassName(unitID.get(8));
            this.logcon.getLogger().setStudyConditionNames(unitID.get(9));
            this.logcon.getLogger().setStudyConditionTypes(unitID.get(10));
            this.logcon.getLogger().setStudentName(unitID.get(1));
            trace.out("replay", "exited constructor");
            LogConsole.createAndShowGUI(this.logcon, this.br != null ? this.br.getDockedFrame() : null);
            trace.out("replay", "createandshowGUI");
        }
        catch (Exception e) {
            trace.out("replay", "cannot create logconsole");
        }
    }

    public void goAllRows(int i) {
        this.goAll = true;
        if (this.replays.size() > 0 && i < this.replays.size()) {
            this.chooseProblem(i);
            trace.out("replay", "" + (this.logcon == null));
            this.logcon.selectAll();
            this.logcon.sendRows();
        }
    }

    private void createAndShowGUI(final JFrame ownerFrame) {
        class ConsoleThread
        implements Runnable {
            private LogConsoleReplay logConsole;

            ConsoleThread() {
                this.logConsole = logConsole;
            }

            @Override
            public void run() {
                LogConsoleReplay.this.tabManager.createdLogConsole();
                String title = "Log Console Replay";
                LogConsoleReplay.this.window = new JDialog((Frame)ownerFrame, title);
                LogConsoleReplay.this.window.setDefaultCloseOperation(0);
                LogConsoleReplay.this.window.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        LogConsoleReplay.this.tabManager.closedLogConsole();
                        LogConsoleReplay.this.window.dispose();
                    }
                });
                this.logConsole.mainPanel.setOpaque(true);
                LogConsoleReplay.this.window.setContentPane(this.logConsole.mainPanel);
                LogConsoleReplay.this.window.pack();
                LogConsoleReplay.this.window.setVisible(true);
            }
        }
        ConsoleThread ct = new ConsoleThread();
        new Thread(ct).start();
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
    }

    @Override
    public void messagePlayerEventOccurred(MessagePlayerEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.replayUnitCompleted(evt);
    }

    @Override
    public synchronized boolean isExiting() {
        return this.nowExiting;
    }

    @Override
    public synchronized boolean startExiting() {
        boolean result = this.nowExiting;
        this.nowExiting = true;
        return result;
    }

    public class ReplayUnitTableModel
    extends AbstractTableModel {
        private static final int ROW_NUM = 0;
        private static final int SESSION_COL = 1;
        private static final int USER_COL = 2;
        private static final int ASSIGNMENT_COL = 3;
        private static final int SET_COL = 4;
        private static final int NAME_COL = 5;
        private static final int ATTEMPT_COL = 6;
        private static final int TIME_COL = 7;
        private static final int SEND_COL = 8;
        private ArrayList<ReplayRow> data;
        private String[] columnNames = new String[]{"#", "Session ID", "User ID", "Assignment", "Problem Set", "Problem Name", "Attempt", "Time", "Send Row"};

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 8;
        }

        public Class getColumnClass(int c) {
            if (c == 8) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public void setData(ArrayList<ArrayList<String>> replayNameList) {
            LogConsoleReplay.this.table.setDefaultRenderer(JButton.class, new RowSendBtnRenderer());
            this.data = new ArrayList();
            int rowNumber = 1;
            for (ArrayList<String> rowBody : replayNameList) {
                trace.out("replay", rowBody.toString());
                ReplayRow row = new ReplayRow(rowBody, rowNumber++);
                this.data.add(row);
            }
            LogConsoleReplay.this.statusLabel.showTotal(this.data.size());
        }

        public ArrayList<ReplayRow> getData() {
            return this.data;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int r, int c) {
            ReplayRow row = this.data.get(r);
            switch (c) {
                case 0: {
                    return row.getRow();
                }
                case 7: {
                    return row.getTime();
                }
                case 2: {
                    return row.getUser();
                }
                case 1: {
                    return row.getSession();
                }
                case 3: {
                    return row.getAssignment();
                }
                case 4: {
                    return row.getProblemSet();
                }
                case 8: {
                    return row.getRowSend();
                }
                case 6: {
                    return row.getAttempt();
                }
                case 5: {
                    return row.getProblemName();
                }
            }
            trace.err("MessageObjectTableModel.getValueAt(" + r + "," + c + ") bad column index " + c);
            return "";
        }
    }

    public class ReplayRow {
        private int rowNum;
        private ArrayList<String> ru;
        private JButton rowSend = new JButton("Send");

        public ReplayRow(ArrayList<String> ru, int rowNumber) {
            this.rowNum = rowNumber;
            this.ru = ru;
        }

        public String getSession() {
            return this.ru.get(0);
        }

        public String getUser() {
            return this.ru.get(1);
        }

        public String getAssignment() {
            return this.ru.get(2);
        }

        public String getProblemSet() {
            return this.ru.get(3);
        }

        public String getProblemName() {
            return this.ru.get(4);
        }

        public String getAttempt() {
            return this.ru.get(5);
        }

        public String getTime() {
            return this.ru.get(6);
        }

        public int getRow() {
            return this.rowNum;
        }

        public JButton getRowSend() {
            return this.rowSend;
        }

        public ArrayList<String> getReplayID() {
            return this.ru;
        }

        public void setRow(int r) {
            this.rowNum = r;
        }

        public void setRowSend(JButton rs) {
            this.rowSend = rs;
        }
    }

    class RowSendBtnEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected static final String SEND_ROW = "Send";
        private JButton button = new JButton("Send");
        private int lastPressedSendRowBtn = -1;

        public RowSendBtnEditor() {
            this.button.setActionCommand(SEND_ROW);
            this.button.addActionListener(this);
            System.out.println("RowSendBtnEditor constructor");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("RowSendBtnEditor.actionPerformed");
            trace.out("replay", "last pressed send row button" + this.lastPressedSendRowBtn);
            LogConsoleReplay.this.goAll = false;
            LogConsoleReplay.this.chooseProblem(this.lastPressedSendRowBtn);
        }

        @Override
        public Object getCellEditorValue() {
            System.out.println("RowSendBtnEditor.getCellEditorValue");
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            System.out.println("RowSendBtnEditor.getTableCellEditorComponent row = " + row + " column = " + column);
            this.lastPressedSendRowBtn = row;
            return this.button;
        }
    }

    class RowSendBtnRenderer
    extends JButton
    implements TableCellRenderer {
        public RowSendBtnRenderer() {
            this.setText("Send");
            this.setOpaque(true);
            System.out.println("RowSendBtnEditor constructor");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    public class StatusLabel
    implements MessagePlayerListener {
        JLabel label = new JLabel("Total 0 replay units");
        JPanel panel = new JPanel(new BorderLayout());

        StatusLabel() {
            this.label.setName("StatusLabel");
        }

        @Override
        public void messagePlayerEventOccurred(MessagePlayerEvent e) {
            int total = e.getTotalCount();
            int sent = e.getSentCount();
            boolean stopping = e.isStopping();
            this.panel.add((Component)this.label, "Center");
            this.setText("Sent " + sent + " of " + total + " message" + (total == 1 ? "" : "s") + (stopping ? " (stopped)" : ""));
        }

        JPanel getPanel() {
            return this.panel;
        }

        void setText(final String text) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusLabel.this.label.setText(text);
                    StatusLabel.this.panel.validate();
                }
            });
        }

        void showTotal(int total) {
            this.setText("Total " + total + " log " + (total == 1 ? "entry" : "entries"));
        }
    }

    public class MyInt {
        public int num;

        public MyInt(int n) {
            this.num = n;
        }
    }
}

