/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences;

import edu.cmu.pact.Log.LogDifferences.Column;
import edu.cmu.pact.Log.LogDifferences.Content.ActionEvaluationContent;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import edu.cmu.pact.Log.LogDifferences.Content.CustomContent;
import edu.cmu.pact.Log.LogDifferences.Content.NameContent;
import edu.cmu.pact.Log.LogDifferences.Content.SAIContent;
import edu.cmu.pact.Log.LogDifferences.Content.SkillContent;
import edu.cmu.pact.Log.LogDifferences.Content.TutorAdviceContent;
import edu.cmu.pact.Log.LogDifferences.Contents;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;

public class AlphabetizedCustomsColumn
implements Column {
    private final List<Contents> originalContents;
    private final List<Contents> comparisonContents;
    private TreeSet<ContentCell> names = new TreeSet<ContentCell>(new NameContent.NameComparator());
    private TreeSet<ContentCell> sai = new TreeSet<ContentCell>(new SAIContent.SAIComparator());
    private TreeSet<ContentCell> actionEval = new TreeSet<ContentCell>(new ActionEvaluationContent.AEComparator());
    private TreeSet<ContentCell> advice = new TreeSet<ContentCell>(new TutorAdviceContent.TutorAdviceComparator());
    private TreeSet<ContentCell> skills = new TreeSet<ContentCell>(new SkillContent.SkillComparator());
    private TreeSet<ContentCell> customs = new TreeSet<ContentCell>(new CustomContent.AlphabetizedCustomComparator());
    private final LinkedHashMap<String, Integer> indicies;

    public AlphabetizedCustomsColumn(List<Contents> originalContents, List<Contents> comparisonContents) {
        this.originalContents = originalContents;
        this.comparisonContents = comparisonContents;
        this.indicies = this.makeColumnsMap();
    }

    @Override
    public Integer getIndex(String columnName) {
        return this.indicies.get(columnName);
    }

    @Override
    public String[] toArray() {
        return this.indicies.keySet().toArray(new String[this.indicies.size()]);
    }

    @Override
    public int getNumColumns() {
        return this.indicies.size();
    }

    private LinkedHashMap<String, Integer> makeColumnsMap() {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        this.addLeadingColumns(columns);
        this.addContentsListToTreeMaps(this.originalContents);
        this.addContentsListToTreeMaps(this.comparisonContents);
        this.addTreeMapsToColumns(columns);
        return this.setToNumberedMap(columns);
    }

    private void addLeadingColumns(LinkedHashSet<String> columns) {
        columns.add("Has differences");
        columns.add("# of differences");
        columns.add("old/new");
        columns.add("transaction_id");
    }

    private void addContentsListToTreeMaps(List<Contents> contentsList) {
        for (Contents contents : contentsList) {
            this.addContentToTree(this.names, contents.getName());
            this.addContentToTree(this.sai, contents.getSAI());
            this.addContentToTree(this.actionEval, contents.getActionEval());
            this.addContentListToTree(this.advice, contents.getTutorAdvices());
            this.addContentListToTree(this.skills, contents.getSkills());
            this.addContentListToTree(this.customs, contents.getCustomFields());
        }
    }

    private void addContentToTree(TreeSet<ContentCell> sortedContents, Content content) {
        if (content == null) {
            return;
        }
        for (ContentCell cell : content) {
            sortedContents.add(cell);
        }
    }

    private void addContentListToTree(TreeSet<ContentCell> sortedContents, List<? extends Content> contentList) {
        if (contentList == null) {
            return;
        }
        for (Content content : contentList) {
            this.addContentToTree(sortedContents, content);
        }
    }

    private void addTreeMapsToColumns(LinkedHashSet<String> columns) {
        this.addTreeAsColumnName(columns, this.names);
        this.addTreeAsColumnName(columns, this.sai);
        this.addTreeAsColumnName(columns, this.actionEval);
        this.addTreeAsColumnName(columns, this.advice);
        this.addTreeAsColumnName(columns, this.skills);
        this.addTreeAsColumnName(columns, this.customs);
    }

    private void addTreeAsColumnName(LinkedHashSet<String> columns, TreeSet<ContentCell> sortedSet) {
        LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
        for (ContentCell cell : sortedSet) {
            columnNames.add(cell.getColumnName());
        }
        columns.addAll(columnNames);
    }

    private LinkedHashMap<String, Integer> setToNumberedMap(LinkedHashSet<String> columns) {
        LinkedHashMap<String, Integer> tempIndicies = new LinkedHashMap<String, Integer>();
        int counter = 0;
        for (String columnName : columns) {
            tempIndicies.put(columnName, counter);
            ++counter;
        }
        return tempIndicies;
    }
}

