/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class TutorAdviceContent
implements Content {
    private static final String TUTOR_ADVICE = "tutor_advice";
    private final String advice;
    private final int index;

    public TutorAdviceContent(String tutorAdvice, int index) {
        this.advice = tutorAdvice;
        this.index = index;
    }

    @Override
    public Iterator<ContentCell> iterator() {
        ArrayList<ContentCell> adviceList = new ArrayList<ContentCell>();
        if (this.advice == null) {
            return adviceList.iterator();
        }
        ContentCell.ContentCellBuilder builder = new ContentCell.ContentCellBuilder();
        builder.fieldType(TUTOR_ADVICE).index(this.index).content(this.advice).formatter(new TutorAdviceColumnFormatter());
        adviceList.add(builder.buildCell());
        return Collections.unmodifiableList(adviceList).iterator();
    }

    public String getTutorAdvice() {
        return this.advice;
    }

    public static class TutorAdviceComparator
    implements Comparator<ContentCell> {
        @Override
        public int compare(ContentCell cell1, ContentCell cell2) {
            if (!cell1.getFieldType().equals(TutorAdviceContent.TUTOR_ADVICE) || !cell2.getFieldType().equals(TutorAdviceContent.TUTOR_ADVICE)) {
                throw new ClassCastException("Must compare two tutor_advice cells");
            }
            return Double.compare(cell1.getIndex(), cell2.getIndex());
        }
    }

    static class TutorAdviceColumnFormatter
    implements ColumnFormatter {
        TutorAdviceColumnFormatter() {
        }

        @Override
        public String makeColumnName(String fieldType, int index, String propertyName) {
            return fieldType + index;
        }
    }
}

