/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.TxtFilter;
import edu.cmu.pact.Log.LogConsole;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LogDifferencesWriter {
    ArrayList<String[]> file;
    BR_Controller controller;
    LogConsole logConsole;
    String sessionId = null;

    public LogDifferencesWriter(ArrayList<String[]> file, BR_Controller controller, LogConsole logConsole, String sessionId) {
        this.file = file;
        this.controller = controller;
        this.logConsole = logConsole;
        this.sessionId = sessionId;
    }

    public void writeDifferencesToFile() {
        File chosenFile;
        int overwrite;
        String dirName = this.getPreference("Disk Logging Directory", "log_to_disk_directory");
        String fileName = this.sessionId + "_replay.txt";
        do {
            if ((chosenFile = DialogUtilities.chooseFile(dirName, fileName, (FileFilter)new TxtFilter(), "Please set the file name", "Save", this.controller)) == null) {
                return;
            }
            if (!chosenFile.exists()) break;
            overwrite = JOptionPane.showConfirmDialog(this.controller.getCtatFrameController().getDockedFrame(), "File " + chosenFile.getPath() + " already exists. Overwrite?", "Overwrite prior log", 1, 2);
            if (overwrite == 2) {
                return;
            }
            dirName = chosenFile.getParent();
        } while (overwrite == 1);
        try {
            this.writeDifferencesHelper(chosenFile);
        }
        catch (Exception e) {
            String errMsg = "Error saving log difference " + chosenFile.getPath();
            trace.errStack(errMsg, e);
            Utils.showExceptionOccuredDialog(e, errMsg, "Error saving log difference");
        }
    }

    private void writeDifferencesHelper(File chosenFile) throws IOException {
        FileWriter fw = new FileWriter(chosenFile.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        Iterator<String[]> rows = this.file.iterator();
        if (rows.hasNext()) {
            bw.write(this.arrayToString(rows.next()));
            bw.newLine();
            bw.newLine();
        }
        while (rows.hasNext()) {
            bw.write(this.arrayToString(rows.next()));
            bw.newLine();
            bw.write(this.arrayToString(rows.next()));
            bw.newLine();
            bw.newLine();
        }
        bw.close();
    }

    private String arrayToString(String[] row) {
        StringBuilder concat2 = new StringBuilder();
        for (int i = 0; i < row.length; ++i) {
            if (row[i] != null) {
                concat2.append(row[i]);
            }
            concat2.append("\t");
        }
        return concat2.toString();
    }

    private String getPreference(String prefName, String propName) {
        String result = null;
        result = this.logConsole.getController().getPreferencesModel().getStringValue(prefName);
        if (result == null || result.length() < 1) {
            result = this.logConsole.getController().getPreferencesModel().getStringValue(propName);
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "getPref(" + prefName + ", " + propName + ") => " + result);
        }
        return result;
    }
}

