/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.TutoringService;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.Socket;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class RequestHandler
extends CTATBase
implements Runnable,
Cloneable {
    private transient Socket cSock = null;
    private transient Reader in;
    private transient PrintWriter out;

    public RequestHandler() {
        this.setClassName("RequestHandler");
        this.debug("RequestHandler ()");
    }

    protected RequestHandler clone() throws CloneNotSupportedException {
        this.debug("clone ()");
        RequestHandler newObj = (RequestHandler)super.clone();
        newObj.cSock = null;
        newObj.in = null;
        newObj.out = null;
        return newObj;
    }

    void setSocketIO(Socket sock, Reader in, PrintWriter out) {
        this.debug("setSocketIO ()");
        this.cSock = sock;
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        this.debug("run ()");
        while (true) {
            Element root = null;
            Element resp = null;
            String request = null;
            try {
                request = SocketProxy.readToEom(this.in, 0);
                if (trace.getDebugCode("ls")) {
                    trace.outNT("ls", "RequestHandler.handleRequest() '" + request + "'");
                }
                if (request == null || request.length() <= 0) {
                    if (trace.getDebugCode("ls")) {
                        trace.outNT("ls", "RequestHandler.run() got empty request '" + request + "'; exiting...");
                    }
                    this.close();
                    return;
                }
                if (this.gotQuitMessage(request)) {
                    return;
                }
            }
            catch (IOException ioe) {
                trace.errStack("Monitor: thread exiting upon error reading socket " + this.cSock + ": " + ioe + (ioe.getCause() == null ? "" : ";\n  cause " + ioe.getCause()), ioe);
                this.close();
                return;
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((Reader)new StringReader(request));
                root = doc.getRootElement();
                resp = this.handleRequest(root);
            }
            catch (Throwable t) {
                trace.errStack("Monitor: error handling request " + (root == null ? "(null)" : root.getName()), t);
                resp = new Element("error");
                resp.setAttribute("exception", t.getClass().getName());
                resp.addContent(t.getMessage());
            }
            try {
                Monitor.outputter.output(resp, (Writer)this.out);
                this.out.write(0);
                this.out.flush();
            }
            catch (Throwable t) {
                trace.errStack("Monitor: error writing socket to reply to request " + (root == null ? "(null)" : root.getName()), t);
                this.gotQuitMessage(null);
                return;
            }
        }
    }

    private boolean gotQuitMessage(String request) {
        this.debug("gotQuitMessage ()");
        if (request != null && request.length() > 0 && !"<quit/>".equals(request)) {
            return false;
        }
        if (trace.getDebugCode("ls")) {
            trace.out("ls", "Monitor.gotQuitMessage(" + request + ") from socket " + this.cSock);
        }
        this.close();
        return true;
    }

    private void close() {
        this.debug("close ()");
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cSock != null) {
            try {
                this.cSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.in = null;
        this.out = null;
        this.cSock = null;
    }

    public abstract Element handleRequest(Element var1);
}

