/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class ProcessRunner
extends CTATBase {
    private boolean verbose = false;
    private boolean execDone = false;
    private Process childProc = null;
    private List<String> cmd = null;
    private StringBuffer firstOutput;
    private Thread callingThread;

    public ProcessRunner() {
        this(false);
    }

    public ProcessRunner(boolean verbose) {
        this.setClassName("ProcessRunner");
        this.debug("ProcessRunner ()");
        this.verbose = verbose;
    }

    public String exec(String[] execCmd) {
        return this.exec(execCmd, true, null);
    }

    public String exec(String[] execCmd, boolean awaitEnd, StringBuffer firstOutput) {
        this.cmd = Arrays.asList(execCmd);
        this.firstOutput = firstOutput;
        if (null != this.firstOutput) {
            this.callingThread = Thread.currentThread();
        }
        StringBuffer cmdArr = new StringBuffer();
        try {
            for (int i = 0; i < execCmd.length; ++i) {
                cmdArr.append(execCmd[i]).append(' ');
            }
            if (this.verbose) {
                System.err.println("execCmd[" + cmdArr + "]");
            }
            this.childProc = Runtime.getRuntime().exec(execCmd);
        }
        catch (Exception e) {
            System.err.println("Exception on executing: " + execCmd);
            e.printStackTrace();
            return "";
        }
        StreamGobbler errorGobbler = new StreamGobbler(this.childProc.getErrorStream(), "ERROR");
        StringBuffer sb = awaitEnd ? new StringBuffer() : null;
        StreamGobbler outputGobbler = new StreamGobbler(this.childProc.getInputStream(), "OUTPUT", sb);
        errorGobbler.start();
        outputGobbler.start();
        this.execDone = true;
        if (!awaitEnd) {
            return null;
        }
        try {
            if (this.childProc.waitFor() != 0) {
                System.err.println("process " + cmdArr + " exit value = " + this.childProc.exitValue());
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        try {
            outputGobbler.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return sb.toString();
    }

    public boolean isExecDone() {
        return this.execDone;
    }

    public static boolean isLocalWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isLocalMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isLocalUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isLocalSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public String getLocalProcesses() {
        this.debug("getLocalProcesses ()");
        StringBuffer buffer = new StringBuffer();
        if (ProcessRunner.isLocalWindows()) {
            this.debug("Executing Windows version of ps ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        } else {
            this.debug("Executing Unix version of ps ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec("ps -e");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public String getLocalNetstat() {
        this.debug("getLocalNetstat ()");
        StringBuffer buffer = new StringBuffer();
        if (ProcessRunner.isLocalWindows()) {
            this.debug("Executing Windows version of netstat ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\netstat.exe -anot");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        } else {
            this.debug("Executing Unix version of netstat ...");
            try {
                String line;
                Process p = Runtime.getRuntime().exec("netstat -anop tcp");
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                input.close();
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public int kill(long waitMs) {
        long now;
        this.childProc.destroy();
        long begin = now = System.currentTimeMillis();
        long then = now + waitMs;
        while (now < then) {
            try {
                Thread.sleep(50L);
                int result = this.childProc.exitValue();
                if (trace.getDebugCode("js")) {
                    trace.out("js", String.format("ProcessRunner.kill(%s) returns %d after %d ms", this.cmd.toString(), result, System.currentTimeMillis() - begin));
                }
                return result;
            }
            catch (Exception e) {
                now = System.currentTimeMillis();
                if (!trace.getDebugCode("js")) continue;
                trace.out("js", String.format("Error %s (cause %s) awaiting destroy(%s) after %d ms", e, e.getCause(), this.cmd, then - begin));
            }
        }
        return -1;
    }

    private void interruptOnFirstOutput(String line) {
        if (this.firstOutput == null || this.firstOutput.length() > 0) {
            return;
        }
        if (line.length() < 1) {
            return;
        }
        this.firstOutput.append(line);
        this.callingThread.interrupt();
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String label;
        StringBuffer outBuf;

        StreamGobbler(InputStream is, String label) {
            this(is, label, null);
        }

        StreamGobbler(InputStream is, String label, StringBuffer outBuf) {
            this.is = is;
            this.label = label != null && label.length() > 0 ? label + "> " : "";
            this.outBuf = outBuf;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    ProcessRunner.this.interruptOnFirstOutput(line);
                    if (this.outBuf == null) {
                        if ("error".equalsIgnoreCase(this.label)) {
                            System.err.println(this.label + line);
                            continue;
                        }
                        System.out.println(this.label + line);
                        continue;
                    }
                    this.outBuf.append(line);
                    this.outBuf.append('\n');
                }
                if (this.outBuf != null && ProcessRunner.this.verbose) {
                    System.err.println("child process cumulative stdout " + this.label + ":\n" + this.outBuf);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

