/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview.wizardframe;

import edu.cmu.pact.ctatview.wizardframe.WizardPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WizardDialog
extends JFrame
implements ActionListener {
    private JButton nextButton;
    private JButton previousButton;
    private JButton cancelButton;
    private JPanel topPanel = new JPanel();
    private JButton finishButton;
    private HashMap panelTable = new HashMap();
    private WizardPanelInterface currentPanel;
    private String previousPanelName;
    private String currentPanelName;

    public WizardDialog() {
        this.nextButton = new JButton("Next-->");
        this.previousButton = new JButton("<--Previous");
        this.finishButton = new JButton("Finish");
        this.cancelButton = new JButton("Cancel");
        JPanel temp = new JPanel(new BorderLayout());
        Box box = new Box(2);
        box.add(this.cancelButton);
        box.add(Box.createHorizontalStrut(15));
        box.add(this.previousButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(15));
        box.add(this.finishButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        temp.add((Component)box, "East");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)temp, "South");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.topPanel, "Center");
        this.nextButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.pack();
    }

    public void setCurrentPanel(String name) {
        this.currentPanelName = name;
        this.currentPanel = this.getPanel(name);
        JPanel p = this.currentPanel.getJPanel();
        this.topPanel.removeAll();
        this.topPanel.add(p);
        this.validate();
        this.repaint();
        this.updateButtonState();
    }

    public String getCurrentPanelName() {
        return this.currentPanelName;
    }

    public void updateButtonState() {
        this.previousButton.setEnabled(this.currentPanel.getPreviousButtonState());
        this.nextButton.setEnabled(this.currentPanel.getNextButtonState());
        this.cancelButton.setEnabled(this.currentPanel.getCancelButtonState());
        this.finishButton.setEnabled(this.currentPanel.getFinishButtonState());
    }

    protected void addPanel(WizardPanelInterface panel1) {
        this.panelTable.put(panel1.getPanelName(), panel1);
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.cancelButton) {
            this.cancelButtonPressed();
            return;
        }
        if (source == this.nextButton) {
            this.previousPanelName = this.currentPanel.getPanelName();
            this.setCurrentPanel(this.currentPanel.getNextPanelName());
            return;
        }
        if (source == this.previousButton) {
            this.setCurrentPanel(this.previousPanelName);
            return;
        }
        if (source == this.finishButton) {
            this.finishButtonPressed();
        }
    }

    public void finishButtonPressed() {
    }

    public void cancelButtonPressed() {
    }

    private WizardPanelInterface getPanel(String panelName) {
        return (WizardPanelInterface)this.panelTable.get(panelName);
    }
}

