/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.ctatview.JHorizontalTable;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationTree;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class RuleActivationTreePanel
extends JRootPane {
    private static final long serialVersionUID = -1966295500520349947L;
    private CTAT_Launcher server;
    JScrollPane scrollPanel;
    JHorizontalTable currentTreeTable;
    private JPanel labelPanel;

    public RuleActivationTreePanel(CTAT_Launcher server) {
        this.server = server;
        this.labelPanel = this.constructDepthPanel();
        this.currentTreeTable = (JHorizontalTable)this.getFocusedTree().getTreeTable();
        this.scrollPanel = new JScrollPane(this.currentTreeTable);
        this.scrollPanel.setHorizontalScrollBarPolicy(30);
        if (this.currentTreeTable.getPreferredScrollableViewportSize().getWidth() > ((JViewport)this.currentTreeTable.getParent()).getPreferredSize().getWidth()) {
            this.currentTreeTable.setAutoResizeMode(3);
            this.currentTreeTable.doLayout();
        }
        this.getContentPane().add(this.scrollPanel);
        this.getContentPane().add((Component)this.labelPanel, "South");
        this.setSize(300, 300);
    }

    public void refresh() {
        this.scrollPanel.removeAll();
        this.getContentPane().remove(this.scrollPanel);
        this.getContentPane().remove(this.labelPanel);
        this.currentTreeTable = (JHorizontalTable)this.getFocusedTree().getTreeTable();
        this.scrollPanel = new JScrollPane(this.currentTreeTable);
        this.scrollPanel.setHorizontalScrollBarPolicy(30);
        this.labelPanel = this.constructDepthPanel();
        this.getContentPane().add(this.scrollPanel);
        this.getContentPane().add((Component)this.labelPanel, "South");
        this.revalidate();
        this.repaint(this.getFocusedTree());
    }

    private JPanel constructDepthPanel() {
        JPanel pane = new JPanel();
        JLabel maxDepthLbl = this.getFocusedTree().getDepthLabel();
        MTRete rete = this.getFocusedRete();
        if (rete != null) {
            maxDepthLbl.setText("Max Depth: " + rete.getMaxDepth());
        } else if (maxDepthLbl.getText() == "") {
            maxDepthLbl.setText("Max Depth: " + MTRete.DEFAULT_MAX_DEPTH);
        }
        pane.add(maxDepthLbl);
        return pane;
    }

    private RuleActivationTree getFocusedTree() {
        return this.getController().getRuleActivationTree();
    }

    private MTRete getFocusedRete() {
        return this.getController().getModelTracer().getRete();
    }

    private BR_Controller getController() {
        return this.server.getFocusedController();
    }

    public void repaint(RuleActivationTree tree) {
        if (tree.getTreeTable() != this.currentTreeTable) {
            return;
        }
        this.scrollPanel.setHorizontalScrollBarPolicy(30);
        this.currentTreeTable.setSize(this.currentTreeTable.getWidth(), this.currentTreeTable.getRowCount() * this.currentTreeTable.getRowHeight());
        this.currentTreeTable.setMinimumSize(new Dimension(this.currentTreeTable.getWidth(), this.currentTreeTable.getHeight()));
        this.repaint();
    }

    public void validate(RuleActivationTree tree) {
        if (tree.getTreeTable() != this.currentTreeTable) {
            return;
        }
        this.validate();
    }

    public void show(RuleActivationTree tree) {
        if (tree.getTreeTable() != this.currentTreeTable) {
            return;
        }
        this.setVisible(true);
    }
}

