/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.UIRecorder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jess.Deftemplate;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.Value;

public class UIComponentRecorder
extends UIRecorder {
    private static final int INPUT_STRING_INDEX = 3;
    private static final int INPUT_INDEX = 2;
    private final String[] slotNames = new String[]{"selection", "action", "input", "input_String"};
    private final String QUERY_NAME = "get-uiComponents";
    private final String QUERY = "(defquery get-uiComponents \"Retrieve the facts holding the results of student interface actions\"(declare (variables ?sel ?act))?result <- (uiComponent (selection ?sel) (action ?act)))";
    private final Set<String> messageTypesToProcess;

    public UIComponentRecorder(Rete rete, String ... messageTypes) {
        super(rete);
        if (trace.getDebugCode("uic")) {
            trace.out("uic", "UIComponentRecorder.<init>(" + Arrays.asList(messageTypes) + ")");
        }
        this.coerceSymbolsToStrings = true;
        this.messageTypesToProcess = new HashSet<String>();
        if (messageTypes != null) {
            for (String messageType : messageTypes) {
                if (messageType == null) continue;
                this.messageTypesToProcess.add(messageType.toLowerCase());
            }
        }
    }

    public Boolean update(String messageType, List selection, List action, List input) {
        if (trace.getDebugCode("uic")) {
            trace.out("uic", "UIComponentRecorder.update(" + messageType + ", " + selection + ", " + action + ", " + input + "): messageTypesToProcess: " + this.messageTypesToProcess);
        }
        if (!this.messageTypesToProcess.contains(messageType.toLowerCase())) {
            return null;
        }
        String s = selection == null || selection.size() < 1 ? null : (String)selection.get(0);
        String a = action == null || action.size() < 1 ? null : (String)action.get(0);
        String i = input == null || input.size() < 1 ? null : (String)input.get(0);
        return this.update(null, s, a, i);
    }

    public Boolean update(String messageType, String selection, String action, String input) {
        if (messageType != null && !this.messageTypesToProcess.contains(messageType.toLowerCase())) {
            return null;
        }
        return this.updateFirst(selection, action, input);
    }

    @Override
    protected Value[] makeSlotValues(Deftemplate deftemplate, String ... javaValues) throws JessException {
        Value[] slotValues = super.makeSlotValues(deftemplate, javaValues);
        slotValues[3] = javaValues[2] == null ? Funcall.NIL : new Value(javaValues[2], 2);
        return slotValues;
    }

    @Override
    protected int getNParams() {
        return 2;
    }

    @Override
    public String[] getSlotNames() {
        return this.slotNames;
    }

    @Override
    protected String getTemplateName() {
        return "uiComponent";
    }

    @Override
    public String getTemplate() {
        return "(deftemplate " + this.getTemplateName() + " (slot selection) (slot action) (slot input) (slot input_String))";
    }

    @Override
    protected String getQueryName() {
        return "get-uiComponents";
    }

    @Override
    public String getQuery() {
        return "(defquery get-uiComponents \"Retrieve the facts holding the results of student interface actions\"(declare (variables ?sel ?act))?result <- (uiComponent (selection ?sel) (action ?act)))";
    }
}

