/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.DStoBRD;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CTATtoBRD {
    private int numCtatTransactions = 0;
    private int numBrdTransactions = 0;
    private String[] skillsRequiringInput = new String[]{"add", "subtract", "multiply", "divide", "clt", "distribute", "mt", "rf"};
    int rowLHS;
    int rowRHS;
    int rowSKL;

    private void incNumCtatTransactions() {
        ++this.numCtatTransactions;
    }

    private void resetNumCtatTransactions() {
        this.numCtatTransactions = 0;
    }

    private int getNumCtatTransactions() {
        return this.numCtatTransactions;
    }

    private void incNumBrdTransactions() {
        ++this.numBrdTransactions;
    }

    private void resetNumBrdTransactions() {
        this.numBrdTransactions = 0;
    }

    private int getNumBrdTransactions() {
        return this.numBrdTransactions;
    }

    private ArrayList transactionList(String inputFile) throws IOException {
        ArrayList<CtatLogTransaction> transList = new ArrayList<CtatLogTransaction>();
        BufferedReader in = new BufferedReader(new FileReader(inputFile));
        String fileLine = in.readLine();
        while ((fileLine = in.readLine()) != null) {
            this.incNumCtatTransactions();
            String[] tokens = fileLine.split("\t");
            String id = tokens[0];
            String student = tokens[1];
            String problem = tokens[2];
            String skill = tokens[3];
            String selection = tokens[4];
            String input = tokens[5];
            String subgoal = tokens[6];
            String outcome = tokens[7];
            if (this.skillRequiresInput(skill)) {
                input = skill.concat(" " + input);
            } else if (!skill.equalsIgnoreCase("typein") && !skill.equalsIgnoreCase("auto-typein")) {
                input = skill;
            }
            CtatLogTransaction item = new CtatLogTransaction(id, student, problem, skill, selection, input, subgoal, outcome);
            transList.add(item);
        }
        System.out.println(transList.size() + " transactions found.");
        return transList;
    }

    void resetRowPositions() {
        this.rowLHS = 2;
        this.rowRHS = 2;
        this.rowSKL = 1;
    }

    void convertCTATtoBRD(String inputFile, String outputFile) throws IOException {
        this.resetNumCtatTransactions();
        this.resetNumBrdTransactions();
        ArrayList transactionList = this.transactionList(inputFile);
        FileWriter fout = new FileWriter(new File(outputFile));
        BufferedWriter out = new BufferedWriter(fout);
        String header = "id\tstudent_name\tproblem_name\tselection\taction\tinput\tskill\toutcome\n";
        out.write(header);
        String oldProblemName = "";
        String skillTemplate = "";
        String selectionTemplate = "commTable1_";
        String action = "UpdateTable";
        for (int i = 0; i < transactionList.size(); ++i) {
            CtatLogTransaction logTransaction = (CtatLogTransaction)transactionList.get(i);
            String id = logTransaction.id;
            String problemName = logTransaction.problem;
            String student = logTransaction.studentName;
            String selection = selectionTemplate;
            String input = logTransaction.input;
            String outcome = logTransaction.outcome;
            String skill = logTransaction.skill;
            if (!problemName.equalsIgnoreCase(oldProblemName)) {
                this.resetRowPositions();
                oldProblemName = problemName;
            }
            if (logTransaction.selection.equalsIgnoreCase("SKILL")) {
                selection = selection + "C3R" + this.rowSKL;
                skillTemplate = logTransaction.skill;
                if (outcome.equalsIgnoreCase("OK")) {
                    ++this.rowSKL;
                }
            } else if (logTransaction.selection.equalsIgnoreCase("LHS")) {
                selection = selection + "C1R" + this.rowLHS;
                skill = skillTemplate + "-" + skill;
                if (outcome.equalsIgnoreCase("OK")) {
                    ++this.rowLHS;
                }
            } else if (logTransaction.selection.equalsIgnoreCase("RHS")) {
                selection = selection + "C2R" + this.rowRHS;
                skill = skillTemplate + "-" + skill;
                if (outcome.equalsIgnoreCase("OK")) {
                    ++this.rowRHS;
                }
            }
            this.writeToFile(out, id, student, problemName, selection, action, input, skill, outcome);
        }
        out.close();
        System.out.println(this.getNumCtatTransactions() + " CTAT transactions read.");
        System.out.println(this.getNumBrdTransactions() + " BRD transactions wrote.");
    }

    private void writeToFile(BufferedWriter out, String id, String student, String problem, String selection, String action, String input, String skill, String outcome) throws IOException {
        String log = id + "\t";
        log = log + student + "\t";
        log = log + problem + "\t";
        log = log + selection + "\t";
        log = log + action + "\t";
        log = log + input + "\t";
        log = log + skill + "\t";
        log = log + outcome + "\n";
        out.write(log);
        this.incNumBrdTransactions();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please specify input file and output file names.");
            System.out.println("CTATtoBRD <input_file> <output_rule>");
            System.exit(-1);
        }
        CTATtoBRD converter = new CTATtoBRD();
        try {
            converter.convertCTATtoBRD(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean skillRequiresInput(String skillName) {
        for (int i = 0; i < this.skillsRequiringInput.length; ++i) {
            if (!this.skillsRequiringInput[i].equalsIgnoreCase(skillName)) continue;
            return true;
        }
        return false;
    }

    private static class CtatLogTransaction {
        String id;
        String studentName;
        String problem;
        String skill;
        String selection;
        String input;
        String subgoal;
        String outcome;

        public CtatLogTransaction(String id, String studentName, String problem, String skill, String selection, String input, String subgoal, String outcome) {
            this.id = id;
            this.studentName = studentName;
            this.problem = problem;
            this.skill = skill;
            this.selection = selection;
            this.input = input;
            this.subgoal = subgoal;
            this.outcome = outcome;
        }
    }
}

