/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.Describable;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import jess.Context;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

public abstract class FeaturePredicate
implements Userfunction,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4416689206189754101L;
    public int freqCount;
    private String name;
    protected boolean testAsWME = false;
    protected boolean isDecomposedRelationship = false;
    private Vector args = new Vector();
    private int arity;
    private boolean commutative = false;
    private HashMap applyCashe = new HashMap();
    protected Vector argNames = null;
    public static final int TYPE_OBJECT = 5;
    public static final int TYPE_ARITH_EXP = 1;
    public static final int TYPE_EXP_LIST = 2;
    public static final int TYPE_SIMPLE_SKILL = 3;
    public static final int TYPE_SKILL_OPERAND = 4;
    public static final int TYPE_REASON = 6;
    public static final int TYPE_UNIT = 7;
    public static final int TYPE_SUBSTANCE = 8;
    public static final int TYPE_CANCEL = 9;
    public static final int TYPE_TUPLE = 10;
    private int returnValueType;
    private int[] argValueType;
    private static int callCounter = 0;
    private Describable featureDescription = new Describable();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vector getArgs() {
        return this.args;
    }

    public void setArgs(Vector args) {
        this.args = args;
    }

    void addArgs(String arg) {
        this.args.add(arg);
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public boolean isCommutative() {
        return this.commutative;
    }

    void setIsCommutative(boolean test) {
        this.commutative = test;
    }

    public String getApplyCache(Vector args) {
        return (String)this.applyCashe.get(args);
    }

    private void putApplyCache(Vector args, String value) {
        int size = this.applyCashe.size();
        if (SimSt.FP_CACHE_CAPACITY >= 1) {
            if (size == SimSt.FP_CACHE_CAPACITY) {
                this.applyCashe.clear();
            }
            this.applyCashe.put(args, value);
        }
    }

    public static boolean isValidSimpleSkill(String exp) {
        return true;
    }

    public Iterator applyCasheKeys() {
        return this.applyCashe.keySet().iterator();
    }

    public void setReturnValueType(int type) {
        this.returnValueType = type;
    }

    int getReturnValueType() {
        return this.returnValueType;
    }

    public void setArgValueType(int[] argValueType) {
        this.argValueType = argValueType;
    }

    int getArgValueType(int idx) {
        if (idx >= this.argValueType.length) {
            return -1;
        }
        return this.argValueType[idx];
    }

    public static int valueType(String value) {
        int valueType = -1;
        String typeChecker = SimSt.getTypeChecker();
        String className = typeChecker.substring(0, typeChecker.lastIndexOf(46));
        String methodName = typeChecker.substring(typeChecker.lastIndexOf(46) + 1);
        Method method = null;
        Class[] argTypes = new Class[]{String.class};
        Object[] args = new Object[]{value};
        try {
            method = Class.forName(className).getMethod(methodName, argTypes);
            valueType = (Integer)method.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueType;
    }

    public static boolean isSkillValid(String value) {
        boolean valueType = false;
        String typeChecker = SimSt.getSsValidSkillChecker();
        String className = typeChecker.substring(0, typeChecker.lastIndexOf(46));
        String methodName = typeChecker.substring(typeChecker.lastIndexOf(46) + 1);
        Method method = null;
        Class[] argTypes = new Class[]{String.class};
        Object[] args = new Object[]{value};
        try {
            method = Class.forName(className).getMethod(methodName, argTypes);
            valueType = (Boolean)method.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueType;
    }

    public static boolean isCompatibleType(Integer typeUncertain, Integer typeRequired) {
        if (typeUncertain.equals(typeRequired)) {
            return true;
        }
        return typeRequired.equals(5);
    }

    public static boolean typeMatcher(Integer value1, Integer value2) {
        boolean valueType = false;
        String typeMatcher = SimSt.getTypeMatcher();
        String className = typeMatcher.substring(0, typeMatcher.lastIndexOf(46));
        String methodName = typeMatcher.substring(typeMatcher.lastIndexOf(46) + 1);
        Method method = null;
        Class[] argTypes = new Class[]{Integer.class, Integer.class};
        Object[] args = new Object[]{value1, value2};
        try {
            method = Class.forName(className).getMethod(methodName, argTypes);
            valueType = (Boolean)method.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueType;
    }

    public static Integer valueTypeForAlgebra(String value) {
        int valueType = -1;
        valueType = EqFeaturePredicate.isValidSimpleSkill(value) || EqFeaturePredicate.isSkillOperand(value) ? 4 : (EqFeaturePredicate.isArithmeticExpression(value) ? 1 : (EqFeaturePredicate.isExprList(value) ? 2 : 5));
        return new Integer(valueType);
    }

    private boolean isValidArgument(Vector args) {
        boolean isValidArgument = true;
        for (int i = 0; i < args.size(); ++i) {
            int givenType = FeaturePredicate.valueType((String)args.get(i));
            int expectedType = this.getArgValueType(i);
            if (FeaturePredicate.typeMatcher(givenType, expectedType)) continue;
            isValidArgument = false;
            break;
        }
        return isValidArgument;
    }

    public Value call(ValueVector jessArgs, Context c) throws JessException {
        Vector<String> argv = new Vector<String>();
        for (int i = 1; i < jessArgs.size(); ++i) {
            argv.add(jessArgs.get(i).stringValue(c));
        }
        String returnVal = null;
        if (this.isValidArgument(argv)) {
            returnVal = this.apply(argv);
        }
        return FeaturePredicate.applyReturnToValue(returnVal);
    }

    public abstract String apply(Vector var1);

    public String cachedApply(Vector args) {
        String value = null;
        if (this.isValidArgument(args)) {
            if (this.applyCashe.containsKey(args)) {
                value = this.getApplyCache(args);
            } else {
                block5: {
                    try {
                        value = this.apply(args);
                    }
                    catch (Exception e) {
                        if (!trace.getDebugCode("missalgebra")) break block5;
                        e.printStackTrace();
                    }
                }
                this.putApplyCache(args, value);
            }
        }
        return value;
    }

    public String actionStr(Vector args) {
        String argStr = "";
        if (args.size() > 0) {
            for (int i = 0; i < this.getArity(); ++i) {
                argStr = argStr + (String)args.get(i);
                if (i >= this.getArity() - 1) continue;
                argStr = argStr + " ";
            }
        }
        return "(" + this.getName() + " " + argStr + ")";
    }

    public String actionStr() {
        return "(" + this.getName() + ")";
    }

    public String inputMatcher(String exp1, String exp2) {
        String result = exp1.equals(exp2) ? "T" : null;
        return result;
    }

    public String convertBoolean(boolean b) {
        if (b) {
            return "T";
        }
        return null;
    }

    public String inputMatcher_nonstatic(String exp1, String exp2) {
        String result = exp1.equals(exp2) ? "T" : null;
        return result;
    }

    public void testUserDefSymbols(String testName, Object[] args, String expectedVal) {
        FeaturePredicate.testUserDefSymbols(testName, args, expectedVal, true);
    }

    public static boolean testUserDefSymbols(String testName, Object[] args, String expectedVal, boolean printIfPassed) {
        Vector<Object> argV = new Vector<Object>();
        for (int i = 0; i < args.length; ++i) {
            argV.add(args[i]);
        }
        String actualVal = FeaturePredicate.testUserDefSymbols(testName, argV);
        String methodCall = testName + "(";
        for (int i = 0; i < args.length; ++i) {
            methodCall = methodCall + (String)args[i] + (i < args.length - 1 ? "," : "");
        }
        String msg = methodCall = methodCall + ")";
        if (actualVal != null && !actualVal.equals(expectedVal) || actualVal == null && expectedVal != null) {
            msg = "NG === " + msg;
            msg = msg + " got " + actualVal + ", but should be " + expectedVal;
        } else {
            msg = "OK ... " + msg;
            msg = msg + " = " + actualVal;
        }
        boolean passed = expectedVal == null ? actualVal == null : expectedVal.equals(actualVal);
        if ((!passed || printIfPassed) && trace.getDebugCode("miss")) {
            trace.out("miss", msg);
        }
        return passed;
    }

    public static String testUserDefSymbols(String testName, Vector args) {
        String returnVal = null;
        Class<?> testClass = null;
        try {
            testClass = Class.forName(testName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (testClass != null) {
            Class[] argTypes = new Class[]{Vector.class};
            Object testingInstance = null;
            Method testingMethod = null;
            Object[] argArray = new Object[]{args};
            try {
                testingInstance = testClass.newInstance();
                testingMethod = testClass.getMethod("apply", argTypes);
                Object tempReturnVal = testingMethod.invoke(testingInstance, argArray);
                returnVal = (String)tempReturnVal;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnVal;
    }

    public String toString() {
        return this.actionStr(this.getArgs());
    }

    public Object clone() {
        FeaturePredicate cloneOp = null;
        try {
            cloneOp = (FeaturePredicate)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cloneOp.setArgs((Vector)cloneOp.getArgs().clone());
        return cloneOp;
    }

    public boolean equals(FeaturePredicate op) {
        boolean test = true;
        if (op.getName() == null) {
            return false;
        }
        if (op.getName().equals(this.getName()) && op.getArity() == this.getArity()) {
            for (int i = 0; i < this.getArity(); ++i) {
                String thisArg;
                String opArg = (String)op.getArgs().get(i);
                if (opArg.equals(thisArg = (String)this.getArgs().get(i))) continue;
                test = false;
                break;
            }
        } else {
            test = false;
        }
        return test;
    }

    public boolean doTestAsWME() {
        return this.testAsWME;
    }

    public void setTestAsWME(boolean testAsWME) {
        this.testAsWME = testAsWME;
    }

    public static FeaturePredicate getPredicateByClassName(String className) {
        FeaturePredicate predicate = null;
        try {
            Class<?> classDef = Class.forName(className);
            predicate = (FeaturePredicate)classDef.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return predicate;
    }

    public Vector getArgNames() {
        return this.argNames;
    }

    protected static Value applyReturnToValue(String returnValue) throws JessException {
        if (returnValue == null) {
            return new Value("FALSE", 1);
        }
        return new Value(returnValue, 2);
    }

    public boolean isDecomposedRelationship() {
        return this.isDecomposedRelationship;
    }

    public void setDecomposedRelationship(boolean isDecomposedRelationship) {
        this.isDecomposedRelationship = isDecomposedRelationship;
    }

    public Describable getFeatureDescription() {
        return this.featureDescription;
    }

    public void setFeatureDescription(Describable pDescription) {
        this.featureDescription = pDescription;
    }

    public void setFeatureDescription(String pFeatName, String pFeatDesc) {
        this.featureDescription = new Describable(pFeatName, pFeatDesc);
    }
}

