/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.Bucket;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Null NULL_KEY = new Null();
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static final long serialVersionUID = 362498820763181265L;
    transient int capacity;
    private transient int size;
    float loadFactor;
    private int threshold;
    private transient Bucket[] buckets;
    private transient int modCount;

    public HashMap() {
        this.init(11, 0.75f);
    }

    public HashMap(int initialCapacity, float initialLoadFactor) throws IllegalArgumentException {
        if (initialCapacity < 0 || initialLoadFactor <= 0.0f || initialLoadFactor > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.init(initialCapacity, initialLoadFactor);
    }

    public HashMap(int initialCapacity) throws IllegalArgumentException {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.init(initialCapacity, 0.75f);
    }

    public HashMap(Map t) {
        int mapSize = t.size() * 2;
        this.init(mapSize > 11 ? mapSize : 11, 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
        ++this.modCount;
        this.buckets = new Bucket[this.capacity];
    }

    @Override
    public Object clone() {
        Iterator it = this.entrySet().iterator();
        HashMap clone = new HashMap(this.capacity, this.loadFactor);
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            clone.internalPut(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public Set keySet() {
        return new HashMapSet(0);
    }

    public Set entrySet() {
        return new HashMapSet(2);
    }

    public Collection values() {
        return new HashMapCollection();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalGet(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.capacity; ++i) {
            Bucket list = this.buckets[i];
            if (list == null || !list.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Map.Entry oResult = this.internalGet(key);
        return oResult == null ? null : oResult.getValue();
    }

    public Object put(Object key, Object value) {
        return this.internalPut(key, value);
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        int index;
        Bucket list;
        Object result = null;
        if (this.size > 0 && (list = this.buckets[index = this.hash(key == null ? NULL_KEY : key)]) != null && (result = list.removeByKey(key)) != null) {
            --this.size;
            ++this.modCount;
            if (list.first == null) {
                this.buckets[index] = null;
            }
        }
        return result;
    }

    private Object internalPut(Object key, Object value) {
        Map.Entry oResult;
        Object oRealKey = key == null ? NULL_KEY : key;
        ++this.modCount;
        if (this.size == this.threshold) {
            this.rehash();
        }
        HashMapEntry entry = new HashMapEntry(oRealKey, value);
        int hashIndex = this.hash(oRealKey);
        Bucket list = this.buckets[hashIndex];
        if (list == null) {
            this.buckets[hashIndex] = list = new Bucket();
        }
        if ((oResult = list.add(entry)) == null) {
            ++this.size;
            return null;
        }
        return oResult.getValue();
    }

    private void init(int initialCapacity, float initialLoadFactor) {
        this.size = 0;
        this.modCount = 0;
        this.capacity = initialCapacity;
        this.loadFactor = initialLoadFactor;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.buckets = new Bucket[this.capacity];
    }

    private int hash(Object key) {
        return Math.abs(key.hashCode() % this.capacity);
    }

    private void rehash() {
        Bucket[] data = this.buckets;
        ++this.modCount;
        this.capacity = this.capacity * 2 + 1;
        this.size = 0;
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        this.buckets = new Bucket[this.capacity];
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            Bucket.Node node = data[i].first;
            while (node != null) {
                this.internalPut(node.getKey(), node.getValue());
                node = node.next;
            }
        }
    }

    private Map.Entry internalGet(Object key) {
        if (this.size == 0) {
            return null;
        }
        Bucket list = this.buckets[this.hash(key == null ? NULL_KEY : key)];
        return list == null ? null : list.getEntryByKey(key);
    }

    private boolean containsEntry(Map.Entry entry) {
        if (entry == null) {
            return false;
        }
        Map.Entry oInternalEntry = this.internalGet(entry.getKey());
        return oInternalEntry != null && oInternalEntry.equals(entry);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.capacity);
        s.writeInt(this.size);
        for (Map.Entry oEntry : this.entrySet()) {
            s.writeObject(oEntry.getKey());
            s.writeObject(oEntry.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.capacity = s.readInt();
        int iLen = s.readInt();
        this.size = 0;
        this.modCount = 0;
        this.buckets = new Bucket[this.capacity];
        for (int i = 0; i < iLen; ++i) {
            Object oKey = s.readObject();
            Object oValue = s.readObject();
            this.internalPut(oKey, oValue);
        }
    }

    public static void main(String[] args) {
        HashMap hm = new HashMap();
        int count = 100000000;
        long startTime = Calendar.getInstance().getTimeInMillis();
        for (int i = 0; i < count; ++i) {
            hm.put(new Integer(i), new Integer(i * 2));
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.println("duration: " + (endTime - startTime));
    }

    private static class HashMapEntry
    extends Bucket.Node
    implements Map.Entry {
        public HashMapEntry(Object key, Object value) {
            super(key, value);
        }

        @Override
        public Object getKey() {
            Object oResult = super.getKey();
            return oResult == NULL_KEY ? null : oResult;
        }
    }

    private static class Null {
        Null() {
        }
    }

    class HashMapIterator
    implements Iterator {
        private int myType;
        private int knownMods;
        private int position;
        private int bucketIndex;
        private Bucket.Node currentNode;
        private Object currentKey;

        HashMapIterator(int type) {
            this.myType = type;
            this.knownMods = HashMap.this.modCount;
            this.position = 0;
            this.bucketIndex = -1;
            this.currentNode = null;
            this.currentKey = null;
        }

        private void checkMod() {
            if (this.knownMods != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkMod();
            return this.position < HashMap.this.size();
        }

        public Object next() {
            Object result;
            Bucket list = null;
            this.checkMod();
            try {
                while (this.currentNode == null) {
                    while (list == null) {
                        list = HashMap.this.buckets[++this.bucketIndex];
                    }
                    this.currentNode = list.first;
                }
                this.currentKey = this.currentNode.getKey();
                result = this.myType == 0 ? this.currentKey : (this.myType == 1 ? this.currentNode.getValue() : this.currentNode);
                this.currentNode = this.currentNode.next;
            }
            catch (Exception e) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.currentKey);
            ++this.knownMods;
            this.currentKey = null;
        }
    }

    private class HashMapCollection
    extends AbstractCollection
    implements Collection {
        HashMapCollection() {
        }

        public boolean add(Object o) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        @Override
        public boolean isEmpty() {
            return HashMap.this.isEmpty();
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public Iterator iterator() {
            return new HashMapIterator(1);
        }
    }

    private class HashMapSet
    extends AbstractSet
    implements Set {
        private int setType;

        HashMapSet(int type) {
            this.setType = type;
        }

        @Override
        public boolean add(Object o) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (this.setType == 0) {
                return HashMap.this.containsKey(o);
            }
            return o instanceof Map.Entry ? HashMap.this.containsEntry((Map.Entry)o) : false;
        }

        @Override
        public boolean isEmpty() {
            return HashMap.this.isEmpty();
        }

        @Override
        public boolean remove(Object o) {
            if (this.setType == 0) {
                return HashMap.this.remove(o) != null;
            }
            return o instanceof Map.Entry ? HashMap.this.remove(((Map.Entry)o).getKey()) != null : false;
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public Iterator iterator() {
            return new HashMapIterator(this.setType);
        }
    }
}

