/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;

public class InquiryClAlgebraTutor {
    protected static final int MAX_NUM_WAIT = 10;
    protected final int WAIT_DURATION = 2000;
    Socket socket = null;
    BufferedReader in = null;
    PrintWriter out = null;
    protected static final String FLAG = "FLAG";
    protected static final String APPROVE = "APPROVE";
    protected static final String HINTMESSAGE = "HINTMESSAGE";
    private static final Object GOODBYE_GREETING = "%BYE%";
    private static final String YOU_HAVE_SOLVED = "You have solved the equation";
    private static final String YOU_ARE_DONE = "You are done with all steps";
    private String currentProblem = null;
    Thread incomingStreamMonitor = null;
    private Boolean dontReadSocket = new Boolean(false);
    String msgFromTutoringService = null;
    Vector hintMessage = new Vector();
    private boolean askingHintOn = false;

    public void setCurrentProblem(String problemName) {
        this.sendInquiryCreateProblem(problemName);
        this.currentProblem = problemName;
    }

    public String getCurrentProblem() {
        return this.currentProblem;
    }

    public InquiryClAlgebraTutor() {
    }

    public InquiryClAlgebraTutor(String serverName, String serverPort) {
        this.socket = null;
        while (this.socket == null) {
            try {
                this.socket = new Socket(serverName, Integer.parseInt(serverPort));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.socket != null) continue;
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.activateIncomingStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDontReadSocket() {
        Boolean bl = this.dontReadSocket;
        synchronized (bl) {
            this.dontReadSocket = new Boolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDontReadSocket() {
        Boolean bl = this.dontReadSocket;
        synchronized (bl) {
            this.dontReadSocket = new Boolean(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dontReadSocket() {
        Boolean bl = this.dontReadSocket;
        synchronized (bl) {
            return this.dontReadSocket;
        }
    }

    private void activateIncomingStream() {
        this.resetDontReadSocket();
        this.incomingStreamMonitor = new Thread(){

            @Override
            public void run() {
                while (!InquiryClAlgebraTutor.this.dontReadSocket()) {
                    String msg;
                    block3: {
                        msg = null;
                        try {
                            msg = InquiryClAlgebraTutor.this.in.readLine();
                        }
                        catch (IOException e) {
                            if (InquiryClAlgebraTutor.this.socket.isClosed()) break block3;
                            e.printStackTrace();
                        }
                    }
                    if (msg == null) continue;
                    InquiryClAlgebraTutor.this.handleMessage(msg);
                }
            }
        };
        this.incomingStreamMonitor.start();
    }

    protected void resetMsgFromTutoringService() {
        this.msgFromTutoringService = null;
    }

    void handleMessage(String msg) {
        String msgHeader = this.getMsgHeader(msg);
        String msgBody = this.getMsgBody(msg);
        while (this.msgFromTutoringService != null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (HINTMESSAGE.equals(msgHeader)) {
            this.msgFromTutoringService = msgBody;
        } else if (FLAG.equals(msgHeader)) {
            this.msgFromTutoringService = FLAG;
        } else if (APPROVE.equals(msgHeader)) {
            this.msgFromTutoringService = APPROVE;
        }
    }

    protected String getMsgBody(String msg) {
        int delimIndex = msg.indexOf(59);
        return delimIndex > 0 ? msg.substring(msg.indexOf(59) + 1) : null;
    }

    protected String getMsgHeader(String msg) {
        int delimIndex = msg.indexOf(59);
        return delimIndex > 0 ? msg.substring(0, delimIndex) : msg;
    }

    private void addHint(String hintMessage) {
        this.hintMessage.add(hintMessage);
    }

    private String getHint(int numPrevSteps) {
        return (String)this.hintMessage.get(numPrevSteps);
    }

    public String askHint(BR_Controller brController, ProblemNode currentNode, int numPrevSteps) {
        return this.getHint(numPrevSteps);
    }

    protected String waitForHintMessage() {
        String hintMsg = null;
        int numWait = 0;
        long startTime = new Date().getTime();
        try {
            while (this.msgFromTutoringService == null) {
                Thread.sleep(2000L);
                if (++numWait <= 10) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        if (this.msgFromTutoringService == null) {
            // empty if block
        }
        hintMsg = this.msgFromTutoringService;
        this.resetMsgFromTutoringService();
        return hintMsg;
    }

    public boolean isCorrectStep(String selection, String action, String input) throws TutorServerTimeoutException {
        String flaggedFeedback = null;
        while (this.msgFromTutoringService == null) {
            this.sendInquiryStepPerformed(selection, action, input);
            int numWait = 0;
            try {
                while (!APPROVE.equals(this.msgFromTutoringService) && !FLAG.equals(this.msgFromTutoringService)) {
                    Thread.sleep(2000L);
                    if (++numWait <= 10) continue;
                    this.resetMsgFromTutoringService();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.msgFromTutoringService == null) {
            // empty if block
        }
        flaggedFeedback = this.msgFromTutoringService;
        this.resetMsgFromTutoringService();
        if (flaggedFeedback == null && trace.getDebugCode("miss")) {
            trace.out("miss", "InquiryClAlgebraTutor.isCorrectStep() got null as feedback!!!");
        }
        return APPROVE.equals(flaggedFeedback);
    }

    void sendInquiryStepPerformed(String selection, String action, String input) {
        if (EqFeaturePredicate.isValidSimplificationSkill(input)) {
            input = EqFeaturePredicate.canBeSimplified(this.getCurrentProblem().split(" = ")[0]) != null ? input + " " + this.getCurrentProblem().split(" = ")[0] : input + " " + this.getCurrentProblem().split(" = ")[1];
        }
        if (this.isSkillOperand(input)) {
            this.sendInquiryRequestCreate(selection, input);
        } else {
            this.sendInquiryNoteValueSet(selection, input);
        }
    }

    private boolean isSkillOperand(String input) {
        boolean isSkillOperand = false;
        if (input.indexOf(32) > 0 && EqFeaturePredicate.isValidSimpleSkill(input.split(" ")[0])) {
            isSkillOperand = true;
        }
        return isSkillOperand;
    }

    private void sendInquiryRequestCreate(String selection, String input) {
        String inquiryMsg = "RequestCreate&";
        inquiryMsg = inquiryMsg + input.split(" ")[0] + "&";
        inquiryMsg = inquiryMsg + input.split(" ")[1];
        this.sendInquiryMsg(inquiryMsg);
    }

    private void sendInquiryNoteValueSet(String selection, String input) {
        int indexR;
        int indexC = selection.indexOf(67);
        String indexStr = selection.substring(indexC + 1, indexR = selection.indexOf(82));
        int index = Integer.parseInt(indexStr);
        String targetPlace = index == 1 ? "left" : "right";
        String inquiryMsg = "NoteValueSet&";
        inquiryMsg = inquiryMsg + targetPlace + "&";
        inquiryMsg = inquiryMsg + input;
        this.sendInquiryMsg(inquiryMsg);
    }

    private void sendInquiryCreateProblem(String problemName) {
        String varName = this.getVarName(problemName);
        String inquiryMsg = "CreateProblem&";
        inquiryMsg = inquiryMsg + "Solve for " + varName + "&";
        inquiryMsg = inquiryMsg + problemName;
        this.sendInquiryMsg(inquiryMsg);
    }

    private String getVarName(String problemName) {
        String varName = "";
        for (int i = 0; i < problemName.length(); ++i) {
            char c = problemName.charAt(i);
            if (('a' > c || c > 'z') && ('A' > c || c > 'Z')) continue;
            varName = varName + c;
            break;
        }
        return varName.toLowerCase();
    }

    protected void sendInquiryMsg(String inquiryMsg) {
        this.out.println(inquiryMsg);
    }

    public void shutdown() {
        this.out.println(GOODBYE_GREETING);
        this.setDontReadSocket();
        try {
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setAskingHintOn() {
        this.askingHintOn = true;
    }

    public void resetAskingHintOn() {
        this.askingHintOn = false;
    }

    private boolean isAskingHintOn() {
        return this.askingHintOn;
    }

    public int clAlgebraTutorGotoOneStateBefore(BR_Controller brController, ProblemNode node) {
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        ProblemEdge[] edgeQueue = new ProblemEdge[3];
        String[] problem = new String[]{startNode.getName()};
        int edgeCount = 0;
        if (node != startNode) {
            Vector pathEdges = InquiryClAlgebraTutor.findPathDepthFirst(startNode, node);
            edgeCount = this.searchLastEquation(problem, edgeQueue, pathEdges);
        }
        boolean hintDelivered = false;
        while (!hintDelivered) {
            this.setCurrentProblem(problem[0]);
            String[] hintMsg = new String[3];
            for (int i = 0; i < 3; ++i) {
                hintMsg[i] = this.waitForHintMessage();
                if (hintMsg[i] == null) {
                    this.resetMsgFromTutoringService();
                    break;
                }
                if (i != 2) continue;
                hintDelivered = true;
            }
            if (!hintDelivered) continue;
            if (!(hintMsg[0].equals(hintMsg[1]) && hintMsg[1].equals(hintMsg[2]) || hintMsg[0].startsWith(YOU_HAVE_SOLVED) && hintMsg[1].startsWith(YOU_HAVE_SOLVED) && hintMsg[2].startsWith(YOU_ARE_DONE))) {
                hintDelivered = false;
                this.resetMsgFromTutoringService();
                continue;
            }
            this.addHint(hintMsg[0]);
        }
        for (int i = 0; i < edgeQueue.length; ++i) {
            ProblemEdge edge = edgeQueue[i];
            if (edge == null) continue;
            EdgeData edgeData = edge.getEdgeData();
            String selection = (String)edgeData.getSelection().get(0);
            if (!SimSt.validSelection(selection, i)) {
                return -2;
            }
            String input = (String)edgeData.getInput().get(0);
            Vector<String> edgeSkillNames = edgeData.getSkills();
            String edgeSkillName = edgeSkillNames.get(0);
            if (edgeSkillName.indexOf(32) > 0) {
                edgeSkillName = edgeSkillName.substring(0, edgeSkillName.indexOf(32));
            }
            String msg = "  +++ sending stepPerformed for " + edge.getSource();
            msg = msg + ", skillName: " + edgeSkillName + ", selection: " + selection + ", input: " + input;
            try {
                boolean bl = this.isCorrectStep(selection, null, input);
            }
            catch (TutorServerTimeoutException e) {
                return -1;
            }
            String hintMsg = this.waitForHintMessage();
            if (hintMsg == null) {
                return -1;
            }
            this.addHint(hintMsg);
        }
        return edgeCount;
    }

    protected int searchLastEquation(String[] problem, ProblemEdge[] edgeQueue, Vector pathEdges) {
        int edgeCount = 0;
        for (int i = 0; i < pathEdges.size(); ++i) {
            edgeQueue[edgeCount++] = (ProblemEdge)pathEdges.get(i);
            if (edgeCount != 3) continue;
            String[] eqSide = new String[2];
            for (int j = 0; j < 2; ++j) {
                EdgeData edgeData = edgeQueue[j + 1].getEdgeData();
                String selection = (String)edgeData.getSelection().get(0);
                if (selection.length() < "dorminTable".length()) {
                    return -2;
                }
                char table = selection.charAt("dorminTable".length());
                if (table != '1') {
                    int rowIndex = selection.indexOf(82) + 1;
                    char row = selection.charAt(rowIndex);
                    selection = "dorminTable1_C" + table + "R" + row;
                }
                String input = (String)edgeData.getInput().get(0);
                if ("1".equals(this.getSelectionColumn(selection))) {
                    eqSide[0] = input;
                    continue;
                }
                if ("2".equals(this.getSelectionColumn(selection))) {
                    eqSide[1] = input;
                    continue;
                }
                return -2;
            }
            problem[0] = eqSide[0] + " = " + eqSide[1];
            edgeCount = 0;
            for (int k = 0; k < 3; ++k) {
                edgeQueue[k] = null;
            }
        }
        return edgeCount;
    }

    public static Vector findPathDepthFirst(ProblemNode startNode, ProblemNode endNode) {
        if (startNode == null || endNode == null) {
            return null;
        }
        if (startNode == endNode) {
            return null;
        }
        ProblemEdge theEdge = null;
        theEdge = startNode.isChildNode(endNode);
        if (theEdge != null) {
            Vector<ProblemEdge> path = new Vector<ProblemEdge>();
            path.add(theEdge);
            return path;
        }
        Vector<ProblemNode> childlen = startNode.getChildren();
        if (childlen.isEmpty()) {
            return null;
        }
        for (int i = 0; i < childlen.size(); ++i) {
            ProblemNode childNode = childlen.get(i);
            Vector path = InquiryClAlgebraTutor.findPathDepthFirst(childNode, endNode);
            if (path == null) continue;
            path.add(0, startNode.isChildNode(childNode));
            return path;
        }
        return null;
    }

    private Object getSelectionColumn(String selection) {
        int indexC = selection.indexOf(67);
        int indexR = selection.indexOf(82);
        String selectionColumn = selection.substring(indexC + 1, indexR);
        return selectionColumn;
    }

    public static void main(String[] args) {
        trace.setTraceLevel(5);
        String host = "matsuda-pro.pc.cs.cmu.edu";
        String port = "7878";
        InquiryClAlgebraTutor iCAT = new InquiryClAlgebraTutor(host, port);
        iCAT.setCurrentProblem("problemName");
        boolean result = false;
        try {
            result = iCAT.isCorrectStep("selection", "action", "input");
        }
        catch (TutorServerTimeoutException e) {
            e.printStackTrace();
        }
        System.out.println(result);
    }

    class TutorServerTimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TutorServerTimeoutException(String string) {
            super(string);
        }
    }
}

