/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import cl.tutors.solver.SolverTutor;
import cl.utilities.TestableTutor.InvalidParamException;
import cl.utilities.TestableTutor.InvalidStepException;
import cl.utilities.TestableTutor.SAI;
import cl.utilities.sm.BadExpressionError;
import cl.utilities.sm.Equation;
import cl.utilities.sm.Expression;
import cl.utilities.sm.SMParserSettings;
import cl.utilities.sm.SymbolManipulator;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.SAIConverter;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.util.Vector;

public class InquiryClSolverTutor
extends InquiryClAlgebraTutor {
    private static final String MSG_DELIM = "&";
    private static final String START_PROBLEM = "StartProblem";
    private static final String DO_STEP = "DoStep";
    private static final String TEST_SAI = "TestSAI";
    private static final String GET_NEXT_STEP = "GetNextStep";
    private String currentSkill = null;
    private SolverTutor solverTutor;
    private SymbolManipulator sm;
    private SAIConverter saiConverter = null;
    private String problemStep = null;
    private int basicSkillApplied = 0;
    private String[] typeinExpressions = new String[2];
    private static final String COMM_STEM = "dorminTable";
    static String problem = "3x+2 = -2x+9";
    static String selection = "commTable1_C2R2";
    static String action = "";
    static String input = "-2x+7";
    static String[] steps = new String[]{"commTable1_C3R1", "add -2", "commTable1_C1R2", "3x"};

    public String getCurrentSkill() {
        return this.currentSkill;
    }

    public void setCurrentSkill(String currentSkill) {
        this.currentSkill = currentSkill;
    }

    private void updateCurrentSkill(String input) {
        String skillName = input.split(" ")[0].toLowerCase();
        if (EqFeaturePredicate.isValidSimpleSkill(skillName)) {
            this.setCurrentSkill(skillName);
        }
    }

    private void resetCurrentSkill() {
        this.setCurrentSkill(null);
    }

    public SolverTutor getSolverTutor() {
        return this.solverTutor;
    }

    public void setSolverTutor(SolverTutor solverTutor) {
        this.solverTutor = solverTutor;
    }

    public SymbolManipulator getSm() {
        return this.sm;
    }

    public void setSm(SymbolManipulator sm) {
        this.sm = sm;
    }

    public SAIConverter getSAIConverter() {
        return this.saiConverter;
    }

    public void setSAIConverter(SAIConverter saiCon) {
        this.saiConverter = saiCon;
    }

    public InquiryClSolverTutor() {
        this.initSolverTutor();
    }

    private void initSolverTutor() {
        try {
            this.setSolverTutor(new SolverTutor());
            this.getSolverTutor().setParameter("Solver", "TypeInMode", "true");
            this.getSolverTutor().setParameter("Solver", "AutoSimplify", "true");
            this.getSolverTutor().setCltPmWholeSide(true);
            this.setSm(new SymbolManipulator(SMParserSettings.HS_DEFAULT));
        }
        catch (InvalidParamException e) {
            e.printStackTrace();
        }
    }

    public InquiryClSolverTutor(String serverName, String serverPort) {
        super(serverName, serverPort);
    }

    @Override
    void handleMessage(String msg) {
        super.handleMessage(msg);
    }

    public void startProblem(String problem) {
        String msg = "StartProblem&" + problem;
        this.dispatchClientMsg(msg);
    }

    public int goToState(BR_Controller brController, ProblemNode currentNode) {
        Vector pathEdges;
        ProblemNode startNode = null;
        if (brController.getMissController().getSimSt().isValidationMode()) {
            startNode = brController.getMissController().getSimSt().getValidationGraph().getStartNode();
        } else if (brController.getMissController().getSimSt().getSsInteractiveLearning() == null || !brController.getMissController().getSimSt().getSsInteractiveLearning().isTakingQuiz() ? (startNode = brController.getProblemModel().getStartNode()) == null : (startNode = brController.getMissController().getSimSt().getSsInteractiveLearning().getQuizGraph().getStartNode()) == null) {
            return -1;
        }
        ProblemEdge[] edgeQueue = new ProblemEdge[3];
        String[] problem = new String[]{startNode.getName()};
        int edgeCount = 0;
        if (currentNode != startNode && (pathEdges = InquiryClSolverTutor.findPathDepthFirst(startNode, currentNode)) != null) {
            edgeCount = this.searchLastEquation(problem, edgeQueue, pathEdges);
        }
        problem[0] = SimSt.convertFromSafeProblemName(problem[0]);
        this.startProblem(problem[0]);
        this.setProblemStep(problem[0]);
        this.resetCurrentSkill();
        for (int i = 0; i < edgeQueue.length; ++i) {
            ProblemEdge edge = edgeQueue[i];
            if (edge == null) continue;
            EdgeData edgeData = edge.getEdgeData();
            String selection = (String)edgeData.getSelection().get(0);
            if (selection.equalsIgnoreCase("DONE")) {
                return edgeCount;
            }
            String action = "";
            String input = (String)edgeData.getInput().get(0);
            this.doTheStep(selection, action, input);
            this.updateCurrentSkill(input);
        }
        return edgeCount;
    }

    public String getProblemStep() {
        return this.problemStep;
    }

    public void setProblemStep(String problemStep) {
        this.problemStep = problemStep;
    }

    private void doTheStep(String selection, String action, String input) {
        String msg = "DoStep&" + selection + MSG_DELIM + action + MSG_DELIM + input;
        this.dispatchClientMsg(msg);
    }

    @Override
    void sendInquiryStepPerformed(String selection, String action, String input) {
        String msg = "TestSAI&" + selection + MSG_DELIM + action + MSG_DELIM + input;
        this.dispatchClientMsg(msg);
    }

    public String askNextStep() {
        this.dispatchClientMsg(GET_NEXT_STEP);
        String hintMsg = this.waitForHintMessage();
        return hintMsg;
    }

    private boolean isBasicSkillApplied() {
        if (this.basicSkillApplied == 0) {
            new Exception("Skill has never been applied yet").printStackTrace();
        }
        return this.basicSkillApplied > 0;
    }

    private boolean isNonBasicSkillApplied() {
        return this.basicSkillApplied < 0;
    }

    private void resetBasicSkillApplied() {
        this.basicSkillApplied = 0;
    }

    private void setBasicSkillApplied(boolean flag) {
        this.basicSkillApplied = flag ? 1 : -1;
    }

    private boolean isBasicSkill(String action) {
        boolean isBasicSkill = "add".equals(action) || "subtract".equals(action) || "multiply".equals(action) || "divide".equals(action) || "glarb".equals(action);
        return isBasicSkill;
    }

    private void setTypeinExpressions(String equation) {
        this.typeinExpressions = equation.split(" = ");
    }

    private void resetTypeinExpressions() {
        for (int i = 0; i < 2; ++i) {
            this.typeinExpressions[i] = null;
        }
    }

    private void removeTypeinExpression(int side) {
        this.typeinExpressions[side] = null;
    }

    private void removeTypeinExpression(String input) {
        for (int i = 0; i < 2; ++i) {
            if (this.typeinExpressions[i] == null || !this.isEqualExpression(input, this.typeinExpressions[i])) continue;
            this.removeTypeinExpression(i);
            return;
        }
        new Exception("removeTypeinExpression: no such expression " + input + " in " + this.typeinExpressions);
    }

    private int lookupTypeinExpression(String input) {
        int typeinExpression = -1;
        for (int i = 0; i < this.typeinExpressions.length; ++i) {
            if (this.typeinExpressions[i] == null || !this.isEqualExpression(this.typeinExpressions[i], input)) continue;
            typeinExpression = i;
            break;
        }
        return typeinExpression;
    }

    private String[] getMessageArg(String clientMsg) {
        String[] msgArg = null;
        int idx = clientMsg.indexOf(MSG_DELIM);
        if (idx > 0) {
            String clientMsgArg = clientMsg.substring(idx + 1);
            msgArg = clientMsgArg.split(MSG_DELIM);
        }
        return msgArg;
    }

    private String getMessageCmd(String clientMsg) {
        return clientMsg.split(MSG_DELIM)[0];
    }

    private void dispatchClientMsg(String clientMsg) {
        String cmd = this.getMessageCmd(clientMsg);
        String[] arg = this.getMessageArg(clientMsg);
        if (START_PROBLEM.equals(cmd)) {
            this.startTheProblem(arg[0]);
        } else if (DO_STEP.equals(cmd)) {
            try {
                this.doStep(arg[0], arg[1], arg[2]);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else if (TEST_SAI.equals(cmd)) {
            this.testSAI(arg[0], arg[1], arg[2]);
        } else if (GET_NEXT_STEP.equals(cmd)) {
            this.getNextStep();
        } else {
            System.out.println("dispatchClientMsg: invalid msg >> " + clientMsg);
        }
    }

    private void startTheProblem(String problem) {
        this.startProblem(this.getSolverTutor(), problem);
    }

    public void startProblem(SolverTutor solverTutor, String problem) {
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "startProblem(" + problem + ")");
        }
        String solverProblem = problem + ";solve!";
        solverTutor.startProblem(solverProblem);
        this.resetBasicSkillApplied();
        this.resetTypeinExpressions();
    }

    private void doStep(String selection, String action, String input) throws IllegalStateException, NullPointerException {
        String clAction;
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "doStep(" + selection + "," + action + "," + input + ")");
        }
        SAI sai = null;
        ExampleTracerEvent result = new ExampleTracerEvent(new Object());
        if (this.getSAIConverter() != null) {
            sai = this.saiConverter.convertCtatSaiToClSai(selection, action, input);
        } else {
            clAction = null;
            String clInput = null;
            selection.indexOf("_");
            String table = selection.substring(COMM_STEM.length(), COMM_STEM.length() + 1);
            int tableVal = Integer.parseInt(table);
            String column = selection.substring(COMM_STEM.length() + 3, COMM_STEM.length() + 4);
            int colVal = Integer.parseInt(column);
            if (tableVal == 3 || colVal == 3) {
                String[] tokens = input.split(" ");
                if (tokens[0].toLowerCase().startsWith("combine")) {
                    clAction = "clt";
                    clInput = tokens.length == 4 ? tokens[3] : "";
                } else {
                    clAction = tokens[0];
                    clInput = tokens.length == 2 ? tokens[1] : "";
                }
                sai = new SAI("", clAction, clInput);
            } else {
                clAction = tableVal == 1 && colVal == 1 ? "left" : "right";
                clInput = input;
                sai = new SAI("", clAction, clInput);
            }
        }
        clAction = sai.getAction();
        if (!this.isRedundantTypein(clAction)) {
            try {
                this.getSolverTutor().doStep(sai, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.isTypeinAction(clAction)) {
                if (!this.isBasicSkill(clAction)) {
                    SAI nextStep = this.whatToDoNext();
                    String equation = nextStep.getSelection();
                    this.setTypeinExpressions(equation);
                }
                this.setBasicSkillApplied(this.isBasicSkill(clAction));
            }
        } else {
            this.removeTypeinExpression(input);
        }
    }

    public String[] getHintMessages(String selection, String action, String input) {
        String[] hintMessages = null;
        SAI sai = null;
        if (this.getSAIConverter() != null) {
            sai = this.saiConverter.convertCtatSaiToClSai(selection, action, input);
        } else {
            String clAction = null;
            String clInput = null;
            String table = selection.substring(COMM_STEM.length(), COMM_STEM.length() + 1);
            int tableVal = Integer.parseInt(table);
            String column = selection.substring(COMM_STEM.length() + 3, COMM_STEM.length() + 4);
            int colVal = Integer.parseInt(column);
            if (tableVal == 3 || colVal == 3) {
                String[] tokens = input.split(" ");
                if (tokens[0].toLowerCase().startsWith("combine")) {
                    clAction = "clt";
                    clInput = tokens.length == 4 ? tokens[3] : "";
                } else {
                    clAction = tokens[0];
                    clInput = tokens.length == 2 ? tokens[1] : "";
                }
                sai = new SAI("", clAction, clInput);
            } else {
                clAction = tableVal == 1 && colVal == 1 ? "left" : "right";
                clInput = input;
                sai = new SAI("", clAction, clInput);
            }
        }
        try {
            hintMessages = this.getSolverTutor().getHintMessage(sai);
        }
        catch (InvalidStepException e) {
            e.printStackTrace();
            System.out.println("-----e.getCause:------" + e.getCause());
        }
        return hintMessages;
    }

    public void performSteps(SolverTutor tutor, Vector stepsSoFar) {
        for (int i = 0; i < stepsSoFar.size(); ++i) {
            SAI sai = (SAI)stepsSoFar.get(i);
            try {
                tutor.doStep(sai);
                continue;
            }
            catch (InvalidStepException e) {
                e.printStackTrace();
            }
        }
    }

    private void getNextStep() {
        SAI nextStep = this.whatToDoNext();
        if (trace.getDebugCode("ss")) {
            trace.out("ss", "Selection: " + nextStep.getSelection());
        }
        trace.out("ss", "Action: " + nextStep.getAction());
        trace.out("ss", "Input: " + nextStep.getInput());
        String msg = "HINTMESSAGE;" + nextStep.getSelection() + ";" + nextStep.getAction() + ";" + nextStep.getInput();
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "getNextStep >> " + msg);
        }
        this.handleMessage(msg);
    }

    private SAI whatToDoNext() {
        SAI nextStep = null;
        if (this.isNonBasicSkillApplied()) {
            for (int i = 0; i < 2; ++i) {
                if (this.typeinExpressions[i] == null) continue;
                nextStep = new SAI("", i == 0 ? "left" : "right", this.typeinExpressions[i]);
                break;
            }
        } else {
            nextStep = this.solverTutor.getNextStep("tutor");
        }
        if (nextStep != null && nextStep.getSelection() == null) {
            nextStep.setSelection(this.solverTutor.getCurrentProblem().toString());
        }
        return nextStep;
    }

    private void testSAI(String selection, String action, String input) {
        boolean testSAI = this.isTheCorrectStep(selection, action, input);
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "testSAI(" + selection + "," + action + "," + input + ") = " + testSAI);
        }
        this.handleMessage(testSAI ? "APPROVE" : "FLAG");
    }

    private boolean isTheCorrectStep(String selection, String action, String input) {
        return this.isCorrectStep(this.getSolverTutor(), selection, action, input);
    }

    public boolean isCorrectStep(SolverTutor tutor, String selection, String action, String input) {
        boolean isCorrectStep = false;
        if (this.getSAIConverter() != null) {
            SAI sai = this.saiConverter.convertCtatSaiToClSai(selection, action, input);
            if (this.isRedundantTypein(sai.getAction())) {
                int side = this.lookupTypeinExpression(sai.getInput());
                if (side != -1) {
                    this.removeTypeinExpression(side);
                    isCorrectStep = true;
                }
            } else {
                try {
                    isCorrectStep = tutor.isStepOK(sai);
                }
                catch (InvalidStepException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return isCorrectStep;
    }

    private boolean isRedundantTypein(String action) {
        boolean isRedundantTypein = false;
        if (this.isTypeinAction(action)) {
            isRedundantTypein = this.isNonBasicSkillApplied();
        }
        return isRedundantTypein;
    }

    private boolean isTypeinAction(String action) {
        boolean isTypeinAction = "left".equals(action) || "right".equals(action);
        return isTypeinAction;
    }

    boolean isEqualExpression(String exp1, String exp2) {
        boolean isEqualExpression = false;
        try {
            Equation eq1 = new Equation(exp1);
            Expression ex1 = eq1.getLeft();
            Equation eq2 = new Equation(exp2);
            Expression ex2 = eq2.getLeft();
            Expression sub = ex1.subtract(ex2).simplify(true, true, true, true, true, true, true, true, true, true, true, true);
            isEqualExpression = sub.isZero();
        }
        catch (BadExpressionError e) {
            e.printStackTrace();
        }
        return isEqualExpression;
    }

    public static void main(String[] args) {
        trace.addDebugCode("miss-cl");
        trace.setTraceLevel(5);
        String host = "localhost";
        InquiryClSolverTutor clSolverTutor = new InquiryClSolverTutor();
        clSolverTutor.startProblem(problem);
        for (int i = 0; i < steps.length; i += 2) {
            clSolverTutor.doStep(steps[i], "", steps[i + 1]);
        }
        boolean flag = false;
        try {
            flag = clSolverTutor.isCorrectStep(selection, action, input);
        }
        catch (InquiryClAlgebraTutor.TutorServerTimeoutException e) {
            e.printStackTrace();
        }
        if (trace.getDebugCode("miss")) {
            System.out.println("isCorrectStep(" + selection + "," + action + "," + input + ") = " + flag);
        }
        SAI nextStep = clSolverTutor.whatToDoNext();
        if (trace.getDebugCode("miss")) {
            System.out.println("nextStep = " + nextStep);
        }
    }
}

