/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import aima.search.framework.GoalTest;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SuccessorFunction;
import aima.util.AbstractQueue;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.ExhaustiveIDS;
import edu.cmu.pact.miss.ExhaustiveSearchAgent;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.RhsExhaustiveGoalTest;
import edu.cmu.pact.miss.RhsState;
import edu.cmu.pact.miss.RhsSuccessorGeneric;
import edu.cmu.pact.miss.SimSt;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mylib.Permutations;

public class Instruction
implements Serializable {
    private static final long serialVersionUID = -2380283129886880784L;
    final int INSTRUCTION_DELIM = 124;
    private transient boolean recent = false;
    private String name = "unnamed";
    private boolean useAllFOAs;
    List possibleFoas;
    int currentFoaIndex = -1;
    private Vector focusOfAttention;
    private transient ProblemNode problemNode;
    private String action;
    private Vector values = null;
    private static int MAX_SEARCH_DEPTH = 6;
    private Vector rhsOpSeq = null;
    private transient ExhaustiveSearchAgent rhsSearchAgent;
    private boolean searchFailed = false;
    private transient RhsExhaustiveGoalTest goalTest;
    transient RhsState lastWorkingRhsState;
    int lastWorkingDepth;
    transient AbstractQueue lastWorkingQueue;

    public void setRecent(boolean isRecent) {
        this.recent = isRecent;
    }

    public boolean isRecent() {
        return this.recent;
    }

    public void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    public void setUseAllFOAs(boolean useAllFOAs) {
        this.useAllFOAs = useAllFOAs;
    }

    boolean getUseAllFOAs() {
        return this.useAllFOAs;
    }

    List getPossibleFoas() {
        return this.possibleFoas;
    }

    void setPossibleFoas(List possibleFoas) {
        this.possibleFoas = possibleFoas;
    }

    void setToFirstPossibleFoa() {
        this.currentFoaIndex = 0;
        this.focusOfAttention = (Vector)this.possibleFoas.get(this.currentFoaIndex);
    }

    public int getCurrentFoaIndex() {
        return this.currentFoaIndex;
    }

    boolean setToNextPossibleFoa() {
        boolean success;
        if (trace.getDebugCode("foasearch")) {
            trace.out("foasearch", "setToNextPossibleFoa: trying next FoA on instruction " + this.getInput());
        }
        if (this.currentFoaIndex != this.possibleFoas.size() - 1) {
            ++this.currentFoaIndex;
            this.focusOfAttention = (Vector)this.possibleFoas.get(this.currentFoaIndex);
            success = true;
            if (trace.getDebugCode("foasearch")) {
                trace.out("foasearch", "setToNextPossibleFoa: new FoA is: " + this.focusOfAttention);
            }
        } else {
            success = false;
            if (trace.getDebugCode("foasearch")) {
                trace.out("foasearch", "setToNextPossibleFoa: there is no next FoA!");
            }
        }
        return success;
    }

    public Vector getFocusOfAttention() {
        return this.focusOfAttention;
    }

    public int getFoilArity() {
        return this.numFocusOfAttention() - 1;
    }

    String getFocusOfAttention(int i) {
        return (String)this.focusOfAttention.get(i);
    }

    void setFocusOfAttention(Vector focusOfAttention) {
        this.focusOfAttention = focusOfAttention;
    }

    void addFocusOfAttention(String foa) {
        this.focusOfAttention.add(foa);
    }

    void addFocusOfAttention(List wmes) {
        for (int i = 0; i < wmes.size(); ++i) {
            this.focusOfAttention.add((String)wmes.get(i));
        }
    }

    int numFocusOfAttention() {
        return this.getFocusOfAttention().size();
    }

    Vector getSeeds() {
        List subList = this.getFocusOfAttention().subList(1, this.numFocusOfAttention());
        return new Vector(subList);
    }

    int numSeeds() {
        return this.numFocusOfAttention() - 1;
    }

    String getSelection() {
        String selectionInput = (String)this.getFocusOfAttention().get(0);
        int valueBorder = selectionInput.lastIndexOf(124);
        return selectionInput.substring(0, valueBorder);
    }

    String getInput() {
        String selectionInput = (String)this.getFocusOfAttention().get(0);
        return this.getInstructionValue(selectionInput);
    }

    public ProblemNode getProblemNode() {
        return this.problemNode;
    }

    private void setProblemNode(ProblemNode problemNode) {
        this.problemNode = problemNode;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Instruction(String name, Vector focusOfAttention) {
        this.setName(name);
        this.setFocusOfAttention(focusOfAttention);
    }

    public Instruction(ProblemNode problemNode, String sai) {
        this.setProblemNode(problemNode);
        this.setFocusOfAttention(new Vector());
        this.addFocusOfAttention(sai);
    }

    String getInstructionValue(String instruction) {
        int begin = instruction.lastIndexOf(124);
        return instruction.substring(begin + 1);
    }

    Vector targetArguments() {
        Vector targetArguments = this.getValues();
        targetArguments.remove(0);
        return targetArguments;
    }

    Vector getValues() {
        if (this.values == null) {
            Vector<String> tmpValues = new Vector<String>();
            for (int i = 0; i < this.getFocusOfAttention().size(); ++i) {
                String instruction = (String)this.getFocusOfAttention().get(i);
                tmpValues.add(this.getInstructionValue(instruction));
            }
            return tmpValues;
        }
        return this.values;
    }

    void setValues(Vector values) {
        this.values = values;
    }

    public String toString() {
        String str = this.getName();
        for (int i = 0; i < this.getFocusOfAttention().size(); ++i) {
            str = str + "\n" + (String)this.getFocusOfAttention().get(i);
        }
        str = str + "\n" + this.getAction();
        return str;
    }

    void initRhsSearch(boolean opCached, boolean heuristicBasedIDS, Vector opList, HashMap fpCache, String wmeTypeFile, String matcher) {
        if (this.isSearchFailed()) {
            trace.err("Initializing a search that has already failed");
            new Exception().printStackTrace();
            this.setSearchFailed(false);
        }
        Collection val = fpCache.values();
        Iterator itr = val.iterator();
        RhsState initState = new RhsState(wmeTypeFile, this.getSeeds(), matcher);
        RhsSuccessorGeneric rhsSucFn = opCached ? (heuristicBasedIDS ? new RhsSuccessorGeneric(opList, fpCache, heuristicBasedIDS) : new RhsSuccessorGeneric(opList, fpCache)) : new RhsSuccessorGeneric(opList);
        RhsExhaustiveGoalTest goalTest = !this.useAllFOAs ? new RhsExhaustiveGoalTest(this) : new RhsExhaustiveGoalTest(this, true);
        this.setGoalTest(goalTest);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)rhsSucFn, (GoalTest)goalTest);
        ExhaustiveIDS search = new ExhaustiveIDS(MAX_SEARCH_DEPTH);
        ExhaustiveSearchAgent rhsSearchAgent = new ExhaustiveSearchAgent(problem, (Search)search);
        this.setRhsSearchAgent(rhsSearchAgent);
    }

    void initRhsSearch(boolean opCached, Vector opList, HashMap fpCache, String wmeTypeFile, String matcher, boolean useAllFOAsFlag) {
        RhsState initState = new RhsState(wmeTypeFile, this.getSeeds(), matcher);
        RhsSuccessorGeneric rhsSucFn = opCached ? new RhsSuccessorGeneric(opList, fpCache) : new RhsSuccessorGeneric(opList);
        RhsExhaustiveGoalTest goalTest = new RhsExhaustiveGoalTest(this, useAllFOAsFlag);
        this.setGoalTest(goalTest);
        Problem problem = new Problem((Object)initState, (SuccessorFunction)rhsSucFn, (GoalTest)goalTest);
        ExhaustiveIDS search = new ExhaustiveIDS(MAX_SEARCH_DEPTH);
        ExhaustiveSearchAgent rhsSearchAgent = new ExhaustiveSearchAgent(problem, (Search)search);
        this.setRhsSearchAgent(rhsSearchAgent);
    }

    public static void setMaxSearchDepth(int depth) {
        MAX_SEARCH_DEPTH = depth;
    }

    void searchRhsOpSeq(AbstractQueue queue) {
    }

    void searchRhsOpSeq() {
        List rhsOps = null;
        try {
            if (trace.getDebugCode("miss-rule")) {
                trace.out("miss-rule", "Calling search() inside Instruction.java");
            }
            rhsOps = this.getRhsSearchAgent().search();
            if (trace.getDebugCode("miss-rule")) {
                trace.out("miss-rule", "Done search() inside Instruction.java");
            }
        }
        catch (StackOverflowError err) {
            trace.err(err.getMessage());
            err.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rhsOps != null && !rhsOps.isEmpty()) {
            this.setRhsOpSeq(new Vector(rhsOps));
        } else {
            this.setSearchFailed(true);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Search failed - RhsOpsSeq is empty as shown below");
            }
            this.setRhsOpSeq(null);
        }
    }

    boolean mapFocusOfAttention(RhsState rhsState) {
        boolean mapFocusOfAttention = false;
        Object[] tmpSeeds = this.getSeeds().toArray();
        if (SimSt.isAutoOrderFOA()) {
            Permutations p = null;
            try {
                p = new Permutations(tmpSeeds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (p.hasMoreElements()) {
                Object[] theSeeds = (Object[])p.nextElement();
                Vector<Object> v = new Vector<Object>();
                v.add(this.getFocusOfAttention(0));
                for (int i = 0; i < this.numSeeds(); ++i) {
                    v.add(theSeeds[i]);
                }
                this.setFocusOfAttention(v);
                if (!rhsState.hasValidOperations(this)) continue;
                mapFocusOfAttention = true;
                break;
            }
        } else {
            Vector<Object> v = new Vector<Object>();
            v.add(this.getFocusOfAttention(0));
            for (int i = 0; i < this.numSeeds(); ++i) {
                v.add(tmpSeeds[i]);
            }
            this.setFocusOfAttention(v);
            mapFocusOfAttention = rhsState.hasValidOperations(this);
        }
        return mapFocusOfAttention;
    }

    RhsState getLastRhsState() {
        return this.getGoalTest().getLastState();
    }

    public void setLastRhsState(RhsState lastRhsState) {
        this.getGoalTest().setLastState(lastRhsState);
    }

    RhsState getLastWorkingRhsState() {
        return this.lastWorkingRhsState;
    }

    void setLastWorkingRhsState(RhsState rhsState) {
        this.lastWorkingRhsState = rhsState;
    }

    public int getLastWorkingDepth() {
        return this.lastWorkingDepth;
    }

    public void setLastWorkingDepth(int lastWorkingDepth) {
        this.lastWorkingDepth = lastWorkingDepth;
    }

    public AbstractQueue getLastWorkingQueue() {
        return this.lastWorkingQueue;
    }

    public void setLastWorkingQueue(AbstractQueue lastWorkingQueue) {
        this.lastWorkingQueue = lastWorkingQueue;
    }

    Vector getRhsOpSeq() {
        return this.rhsOpSeq;
    }

    void setRhsOpSeq(Vector rhsState) {
        this.rhsOpSeq = rhsState;
    }

    public ExhaustiveSearchAgent getRhsSearchAgent() {
        return this.rhsSearchAgent;
    }

    public void setRhsSearchAgent(ExhaustiveSearchAgent rhsSearchAgent) {
        this.rhsSearchAgent = rhsSearchAgent;
    }

    public boolean isSearchFailed() {
        return this.searchFailed;
    }

    public void setSearchFailed(boolean searchFailed) {
        this.searchFailed = searchFailed;
    }

    public RhsExhaustiveGoalTest getGoalTest() {
        return this.goalTest;
    }

    public void setGoalTest(RhsExhaustiveGoalTest goalTest) {
        this.goalTest = goalTest;
    }

    public static String getNameFromFoa(String foa) {
        return foa.split("\\|")[1];
    }

    public void setQueueAndDepthFromWhichToBeginSearch(AbstractQueue queueToStartFrom, int depthToStartFrom) {
        this.getRhsSearchAgent().setQueueAndDepthFromWhichToBeginSearch(queueToStartFrom, depthToStartFrom);
    }

    public Search getSearch() {
        return this.getRhsSearchAgent().getSearch();
    }
}

