/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import cl.tutors.solver.SolverTutor;
import cl.utilities.TestableTutor.InvalidParamException;
import cl.utilities.TestableTutor.SAI;

public class NextStepTutor {
    private SolverTutor solverTutor;
    private static final String HINTMESSAGE = "HINTMESSAGE";
    private int basicSkillApplied = 0;
    private String[] typeinExpressions = new String[2];

    public NextStepTutor() {
        this.initSolverTutor();
    }

    public SolverTutor getSolverTutor() {
        return this.solverTutor;
    }

    public void setSolverTutor(SolverTutor solverTutor) {
        this.solverTutor = solverTutor;
    }

    private void initSolverTutor() {
        try {
            this.setSolverTutor(new SolverTutor());
            this.getSolverTutor().setParameter("Solver", "TypeInMode", "true");
            this.getSolverTutor().setParameter("Solver", "AutoSimplify", "true");
            this.getSolverTutor().setCltPmWholeSide(true);
        }
        catch (InvalidParamException e) {
            e.printStackTrace();
        }
    }

    private boolean isNonBasicSkillApplied() {
        return this.basicSkillApplied < 0;
    }

    public SAI getNextStep() {
        SAI nextStep = this.whatToDoNext();
        String msg = "HINTMESSAGE;" + nextStep.getSelection() + ";" + nextStep.getAction() + ";" + nextStep.getInput();
        System.out.println("getNextStep >> " + msg);
        return nextStep;
    }

    private SAI whatToDoNext() {
        SAI nextStep = null;
        if (this.isNonBasicSkillApplied()) {
            for (int i = 0; i < 2; ++i) {
                if (this.typeinExpressions[i] == null) continue;
                nextStep = new SAI("", i == 0 ? "left" : "right", this.typeinExpressions[i]);
                break;
            }
        } else {
            nextStep = this.solverTutor.getNextStep("tutor");
        }
        return nextStep;
    }
}

