/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.PeerLearning.CurriculumBrowserView;
import edu.cmu.pact.miss.WebStartFileDownloader;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.CannotRealizeException;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

public class CurriculumBrowser {
    private CurriculumBrowserView cbView;
    private boolean htmlSet = false;
    private WebStartFileDownloader fileFinder;

    public WebStartFileDownloader getFileFinder() {
        return this.fileFinder;
    }

    public CurriculumBrowser(Dimension tutorPanelSize) {
        this.cbView = new CurriculumBrowserView(tutorPanelSize);
        this.fileFinder = new WebStartFileDownloader();
    }

    public CurriculumBrowser() {
        this.cbView = new CurriculumBrowserView();
        this.fileFinder = new WebStartFileDownloader();
    }

    public JScrollPane getBrowserPane() {
        JScrollPane panel = new JScrollPane(this.cbView.getBrowserPane());
        return panel;
    }

    public void setBrowserPane(JEditorPane browserPane) {
        this.cbView.setBrowserPane(browserPane);
    }

    public Container getVideoPanel() {
        return this.cbView.getContentPane();
    }

    public boolean isHtmlSet() {
        return this.htmlSet;
    }

    public void setVideoSource(File f) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setVideoSource file: " + f);
        }
        try {
            Player p = Manager.createRealizedPlayer((URL)f.toURI().toURL());
            this.cbView.setLayout(new BorderLayout());
            this.cbView.getContentPane().add(p.getVisualComponent(), "Center");
            this.cbView.getContentPane().add(p.getControlPanelComponent(), "North");
        }
        catch (NoPlayerException e) {
            e.printStackTrace();
        }
        catch (CannotRealizeException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setVideoSource(String src) {
        String fileName = this.getFileFinder().findFile(src);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "setVideoSource fileName: " + fileName);
        }
        File f = new File(fileName);
        try {
            Player p = Manager.createRealizedPlayer((URL)f.toURI().toURL());
            this.cbView.setLayout(new BorderLayout());
            this.cbView.getContentPane().add(p.getVisualComponent(), "Center");
            this.cbView.getContentPane().add(p.getControlPanelComponent(), "North");
        }
        catch (NoPlayerException e) {
            e.printStackTrace();
        }
        catch (CannotRealizeException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHtmlSource(String src) {
        String fileName = this.getFileFinder().findFile(src);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Inside setHtmlSource with fileName: " + fileName);
        }
        try {
            this.cbView.getBrowserPane().setEditorKit(new HTMLEditorKit());
            this.cbView.getBrowserPane().read(new FileReader(fileName), (Object)this.cbView.getBrowserPane().getDocument());
            this.htmlSet = true;
        }
        catch (IOException e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Error setting page of curriculum browser " + e.getMessage());
            }
            e.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.cbView.setTitle(title);
    }

    public String getTitle() {
        return this.cbView.getTitle();
    }

    public void showCB() {
        this.cbView.setVisible(true);
        this.cbView.requestFocus();
    }
}

