/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.miss.PeerLearning.GameShow.Connection;
import edu.cmu.pact.miss.PeerLearning.GameShow.ContestServer;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import edu.cmu.pact.miss.PeerLearning.GameShow.TimeoutDelay;
import edu.cmu.pact.miss.PeerLearning.GameShow.TimeoutRecovery;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Timer;

public class ContestOrganizer
implements TimeoutRecovery {
    private Connection contestant1;
    private Connection contestant2;
    private List<String> problems;
    boolean problemsSubmitted = false;
    boolean answered = false;
    boolean forfeited = false;
    private List<Solution> solutions1;
    private List<Solution> solutions2;
    private ContestServer server;
    public static final String PROBLEM_START_MSG = "Starting problem $1";
    public static final String LEAVE_MSG = "$1 has left the game.";
    public static final String ANS_SUBMIT_MSG = "$1 has locked in an answer.";
    public static final String PROBLEM_REQUEST_MSG = "$1's tutor will be asked to provide problem $2.";
    Timer problemRequestResponse;
    Timer problemAnswerResponse1;
    Timer problemAnswerResponse2;

    public ContestOrganizer(ContestServer serv, Connection cont1, Connection cont2) {
        this.server = serv;
        this.contestant1 = cont1;
        this.contestant2 = cont2;
        this.problems = new LinkedList<String>();
        String problem = GameShowUtilities.generate();
        this.problems.add(problem);
        this.solutions1 = new LinkedList<Solution>();
        this.solutions2 = new LinkedList<Solution>();
        this.contestant1.writer.println("StartContest," + this.contestant2.userid + "," + this.contestant2.img);
        this.contestant2.writer.println("StartContest," + this.contestant1.userid + "," + this.contestant1.img);
        new Thread(new ListenerThread(this.contestant1, this.solutions1)).start();
        new Thread(new ListenerThread(this.contestant2, this.solutions2)).start();
        new Thread(new MessageDelay(this.contestant1, 5000, "StartProblem," + problem)).start();
        new Thread(new MessageDelay(this.contestant2, 5000, "StartProblem," + problem)).start();
        this.startProblemTimers();
        this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(PROBLEM_START_MSG, "" + this.problems.size()));
    }

    public void sendAssessment() {
        Solution solution1 = this.solutions1.get(this.solutions1.size() - 1);
        Solution solution2 = this.solutions2.get(this.solutions2.size() - 1);
        this.contestant1.writer.println("SolutionAssessed," + solution2.answer + "," + solution2.correct);
        this.contestant2.writer.println("SolutionAssessed," + solution1.answer + "," + solution1.correct);
        int successes = 0;
        if (solution1.correct) {
            ++successes;
        }
        if (solution2.correct) {
            ++successes;
        }
        ContestServer.updateProblemStatistics(this.problems.get(this.problems.size() - 1), 2, successes);
        if (this.problems.size() < 5 && !this.forfeited) {
            if (this.problems.size() % 2 == 0) {
                new Thread(new MessageDelay(this.contestant1, 10000, "RequestProblem")).start();
                this.problemRequestResponse = new Timer(60000, new TimeoutDelay(this, "ProblemRequestTimedOut", this.contestant1));
                this.sendPrivateAnnounceMessage(GameShowUtilities.replaceTwoPieces(PROBLEM_REQUEST_MSG, this.contestant1.name, "" + (this.problems.size() + 1)));
            } else {
                new Thread(new MessageDelay(this.contestant2, 10000, "RequestProblem")).start();
                this.problemRequestResponse = new Timer(60000, new TimeoutDelay(this, "ProblemRequestTimedOut", this.contestant2));
                this.sendPrivateAnnounceMessage(GameShowUtilities.replaceTwoPieces(PROBLEM_REQUEST_MSG, this.contestant2.name, "" + (this.problems.size() + 1)));
            }
            this.problemRequestResponse.setRepeats(false);
            this.problemRequestResponse.start();
        } else if (!this.forfeited) {
            this.endContest();
        }
    }

    public void stopProblemRequestResponseTimer() {
        if (this.problemRequestResponse != null) {
            this.problemRequestResponse.stop();
            String problem = GameShowUtilities.generate();
            this.problems.add(problem);
            this.contestant1.writer.println("StartProblem," + problem);
            this.contestant2.writer.println("StartProblem," + problem);
            this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(PROBLEM_START_MSG, "" + this.problems.size()));
        }
    }

    public void forfeitGame(Connection forfeiter, boolean updateScore) {
        this.forfeited = true;
        Connection forfeitee = this.contestant1;
        if (forfeiter == this.contestant1) {
            forfeitee = this.contestant2;
        }
        String result = this.calculateStatsForfeit(forfeitee.name, forfeiter.name, updateScore);
        result = result + this.contestant1.name + ":";
        for (Solution sol : this.solutions1) {
            result = result + sol.solutionPath + ";";
        }
        result = result + "," + this.contestant2.name + ":";
        for (Solution sol : this.solutions2) {
            result = result + sol.solutionPath + ";";
        }
        result = result + "," + this.contestant1.name + ":";
        for (Solution sol : this.solutions1) {
            result = result + sol.correct + ";";
        }
        result = result + "," + this.contestant2.name + ":";
        for (Solution sol : this.solutions2) {
            result = result + sol.correct + ";";
        }
        if (updateScore) {
            this.contestant1.writer.println("GameForfeited," + result);
            this.contestant2.writer.println("GameForfeited," + result);
        } else {
            this.contestant1.writer.println("GameCancelled," + result);
            this.contestant2.writer.println("GameCancelled," + result);
        }
    }

    public void startProblemTimers() {
        this.problemAnswerResponse1 = new Timer(120000, new TimeoutDelay(this, "ProblemAnswerTimedOut", this.contestant1));
        this.problemAnswerResponse2 = new Timer(120000, new TimeoutDelay(this, "ProblemAnswerTimedOut", this.contestant2));
        this.problemAnswerResponse1.start();
        this.problemAnswerResponse2.start();
    }

    public void processSolution(Connection connect, Solution sol) {
        List<Solution> solutionList = connect == this.contestant1 ? this.solutions1 : this.solutions2;
        solutionList.add(sol);
        if (!this.answered) {
            this.answered = true;
        } else {
            this.answered = false;
            this.sendAssessment();
        }
    }

    private void endContest() {
        String result = this.calculateStats();
        result = result + this.contestant1.name + ":";
        for (Solution sol : this.solutions1) {
            result = result + sol.solutionPath + ";";
        }
        result = result + "," + this.contestant2.name + ":";
        for (Solution sol : this.solutions2) {
            result = result + sol.solutionPath + ";";
        }
        result = result + "," + this.contestant1.name + ":";
        for (Solution sol : this.solutions1) {
            result = result + sol.correct + ";";
        }
        result = result + "," + this.contestant2.name + ":";
        for (Solution sol : this.solutions2) {
            result = result + sol.correct + ";";
        }
        new Thread(new MessageDelay(this.contestant1, 10000, "EndContest," + result)).start();
        new Thread(new MessageDelay(this.contestant2, 10000, "EndContest," + result)).start();
    }

    private String calculateStats() {
        String results = "";
        int correct1 = 0;
        int correct2 = 0;
        int stepsOnCorrect1 = 0;
        int stepsOnCorrect2 = 0;
        int totalSteps1 = 0;
        int totalSteps2 = 0;
        int incorrectSteps1 = 0;
        int incorrectSteps2 = 0;
        for (Solution sol : this.solutions1) {
            if (sol.correct) {
                ++correct1;
                stepsOnCorrect1 += sol.numSteps;
            }
            totalSteps1 += sol.numSteps;
            incorrectSteps1 += sol.numIncorrectSteps;
        }
        for (Solution sol : this.solutions2) {
            if (sol.correct) {
                ++correct2;
                stepsOnCorrect2 += sol.numSteps;
            }
            totalSteps2 += sol.numSteps;
            incorrectSteps2 += sol.numIncorrectSteps;
        }
        double avgStepsToCorrect1 = (double)stepsOnCorrect1 / (double)correct1;
        double avgStepsToCorrect2 = (double)stepsOnCorrect2 / (double)correct2;
        if (correct1 == 0) {
            avgStepsToCorrect1 = 0.0;
        }
        if (correct2 == 0) {
            avgStepsToCorrect2 = 0.0;
        }
        if (totalSteps1 == 0) {
            totalSteps1 = 1;
        }
        if (totalSteps2 == 0) {
            totalSteps2 = 1;
        }
        int pctStepsCorrect1 = 100 - 100 * incorrectSteps1 / totalSteps1;
        int pctStepsCorrect2 = 100 - 100 * incorrectSteps2 / totalSteps2;
        String winner = "";
        String loser = "";
        if (correct1 > correct2) {
            winner = this.contestant1.name;
            loser = this.contestant2.name;
        } else if (correct2 > correct1) {
            winner = this.contestant2.name;
            loser = this.contestant1.name;
        } else if (avgStepsToCorrect1 < avgStepsToCorrect2) {
            winner = this.contestant1.name;
            loser = this.contestant2.name;
        } else if (avgStepsToCorrect2 < avgStepsToCorrect1) {
            winner = this.contestant2.name;
            loser = this.contestant1.name;
        } else if (pctStepsCorrect1 > pctStepsCorrect2) {
            winner = this.contestant1.name;
            loser = this.contestant2.name;
        } else if (pctStepsCorrect2 > pctStepsCorrect1) {
            winner = this.contestant2.name;
            loser = this.contestant1.name;
        }
        if (winner.length() > 0 && loser.length() > 0) {
            String winnerID = this.contestant1.getUserID();
            String loserID = this.contestant2.getUserID();
            if (this.contestant1.name.equals(loser)) {
                winnerID = this.contestant2.getUserID();
                loserID = this.contestant1.getUserID();
            }
            ContestServer.updateRating(winnerID, loserID);
        } else {
            ContestServer.updateRatingTie(this.contestant1.userid, this.contestant2.userid);
        }
        int rating1 = ContestServer.competitors.get((Object)this.contestant1.getUserID()).rating;
        int rating2 = ContestServer.competitors.get((Object)this.contestant2.getUserID()).rating;
        results = winner + "," + this.contestant1.name + ":" + rating1 + "," + this.contestant2.name + ":" + rating2 + "," + this.contestant1.name + ":" + correct1 + ";" + avgStepsToCorrect1 + ";" + pctStepsCorrect1 + "," + this.contestant2.name + ":" + correct2 + ";" + avgStepsToCorrect2 + ";" + pctStepsCorrect2 + ",";
        if (winner.length() > 0) {
            this.server.announceWin(winner, loser);
        } else {
            this.server.announceTie(this.contestant1.name, this.contestant2.name);
        }
        return results;
    }

    private String calculateStatsForfeit(String forfeitee, String forfeiter, boolean updateScore) {
        String results = "";
        int correct1 = 0;
        int correct2 = 0;
        int stepsOnCorrect1 = 0;
        int stepsOnCorrect2 = 0;
        int totalSteps1 = 0;
        int totalSteps2 = 0;
        int incorrectSteps1 = 0;
        int incorrectSteps2 = 0;
        for (Solution sol : this.solutions1) {
            if (sol.correct) {
                ++correct1;
                stepsOnCorrect1 += sol.numSteps;
            }
            totalSteps1 += sol.numSteps;
            incorrectSteps1 += sol.numIncorrectSteps;
        }
        for (Solution sol : this.solutions2) {
            if (sol.correct) {
                ++correct2;
                stepsOnCorrect2 += sol.numSteps;
            }
            totalSteps2 += sol.numSteps;
            incorrectSteps2 += sol.numIncorrectSteps;
        }
        double avgStepsToCorrect1 = (double)stepsOnCorrect1 / (double)correct1;
        double avgStepsToCorrect2 = (double)stepsOnCorrect2 / (double)correct2;
        if (correct1 == 0) {
            avgStepsToCorrect1 = 0.0;
        }
        if (correct2 == 0) {
            avgStepsToCorrect2 = 0.0;
        }
        if (totalSteps1 == 0) {
            totalSteps1 = 1;
        }
        if (totalSteps2 == 0) {
            totalSteps2 = 1;
        }
        int pctStepsCorrect1 = 100 - 100 * incorrectSteps1 / totalSteps1;
        int pctStepsCorrect2 = 100 - 100 * incorrectSteps2 / totalSteps2;
        String forfeiteeID = this.contestant1.getUserID();
        String forfeiterID = this.contestant2.getUserID();
        if (this.contestant1.name.equals(forfeiter)) {
            forfeiteeID = this.contestant2.getUserID();
            forfeiterID = this.contestant1.getUserID();
        }
        if (updateScore) {
            ContestServer.updateRating(forfeiteeID, forfeiterID);
        }
        int rating1 = ContestServer.competitors.get((Object)this.contestant1.getUserID()).rating;
        int rating2 = ContestServer.competitors.get((Object)this.contestant2.getUserID()).rating;
        results = forfeitee + "," + this.contestant1.name + ":" + rating1 + "," + this.contestant2.name + ":" + rating2 + "," + this.contestant1.name + ":" + correct1 + ";" + avgStepsToCorrect1 + ";" + pctStepsCorrect1 + "," + this.contestant2.name + ":" + correct2 + ";" + avgStepsToCorrect2 + ";" + pctStepsCorrect2 + ",";
        this.server.announceForfeit(forfeitee, forfeiter);
        return results;
    }

    public void sendPrivateAnnounceMessage(String message) {
        message = "** " + message + " **";
        this.contestant1.writer.println("AnnouncePrivateMessage," + message);
        this.contestant2.writer.println("AnnouncePrivateMessage," + message);
    }

    @Override
    public void timeoutRecovery(String timeoutType, Connection connection1, Connection connection2) {
        if (this.forfeited) {
            return;
        }
        if (timeoutType.equals("ProblemRequestTimedOut")) {
            connection1.writer.println("ProblemRequestTimedOut");
            String problem = GameShowUtilities.generate();
            this.problems.add(problem);
            this.contestant1.writer.println("StartProblem," + problem);
            this.contestant2.writer.println("StartProblem," + problem);
            this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(PROBLEM_START_MSG, "" + this.problems.size()));
        }
        if (timeoutType.equals("ProblemAnswerTimedOut")) {
            connection1.writer.println("ProblemAnswerTimedOut");
            Solution sol = new Solution("?", false, 0, 0, "No Answer Submitted");
            this.processSolution(connection1, sol);
        }
    }

    class ListenerThread
    extends Thread {
        boolean activeListener = true;
        Connection connection;
        List<Solution> solutionList;

        ListenerThread(Connection connect, List<Solution> sols) {
            this.connection = connect;
            this.solutionList = sols;
        }

        @Override
        public void run() {
            try {
                String incomingMsg;
                while (this.activeListener && (incomingMsg = this.connection.reader.readLine()) != null) {
                    System.out.println("Client (organizer): " + incomingMsg);
                    if (!ContestOrganizer.this.forfeited) {
                        if (incomingMsg.startsWith("SolutionMade")) {
                            this.solutionMade(incomingMsg);
                        }
                        if (incomingMsg.startsWith("SubmitProblems")) {
                            this.submitProblems(incomingMsg);
                        }
                        if (incomingMsg.startsWith("RequestProblemBank")) {
                            this.requestProblemBank(incomingMsg);
                        }
                        if (incomingMsg.startsWith("ProblemRequestExited")) {
                            ContestOrganizer.this.stopProblemRequestResponseTimer();
                        }
                    }
                    if (incomingMsg.startsWith("LeaveProgram")) {
                        this.leaveProgram(incomingMsg);
                    }
                    if (incomingMsg.startsWith("JoinProgram")) {
                        ContestOrganizer.this.server.returnConnection(this.connection);
                        this.activeListener = false;
                    }
                    if (!incomingMsg.startsWith("ChatPrivateMessage")) continue;
                    this.sendChatMessage(incomingMsg);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void requestProblemBank(String incomingMsg) {
            String problemBank = ContestServer.requestProblemBank();
            this.connection.writer.println("ProblemBankList," + problemBank);
        }

        private void submitProblems(String incomingMsg) {
            String[] probs = incomingMsg.split(",");
            String problem = probs[1];
            if (ContestOrganizer.this.problemRequestResponse != null) {
                ContestOrganizer.this.problemRequestResponse.stop();
            }
            ContestOrganizer.this.problems.add(problem);
            ((ContestOrganizer)ContestOrganizer.this).contestant1.writer.println("StartProblem," + problem);
            ((ContestOrganizer)ContestOrganizer.this).contestant2.writer.println("StartProblem," + problem);
            ContestOrganizer.this.startProblemTimers();
            ContestOrganizer.this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(ContestOrganizer.PROBLEM_START_MSG, "" + ContestOrganizer.this.problems.size()));
        }

        private void leaveProgram(String args) {
            boolean technical = false;
            if (args.contains("technical")) {
                technical = true;
            }
            this.connection.writer.println("LeaveProgram");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.connection.writer.close();
            try {
                this.connection.reader.close();
                this.connection.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.activeListener = false;
            ContestOrganizer.this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(ContestOrganizer.LEAVE_MSG, this.connection.name));
            if (technical && !ContestOrganizer.this.forfeited && ContestOrganizer.this.solutions1.size() < 5 && ContestOrganizer.this.solutions2.size() < 5) {
                ContestOrganizer.this.forfeitGame(this.connection, false);
            } else if (!ContestOrganizer.this.forfeited && ContestOrganizer.this.solutions1.size() < 5 && ContestOrganizer.this.solutions2.size() < 5) {
                ContestOrganizer.this.forfeitGame(this.connection, true);
            }
        }

        private void solutionMade(String args) {
            String[] solution = args.split(",");
            if (solution.length >= 3) {
                int nIncorrect;
                int nSteps;
                ContestOrganizer.this.sendPrivateAnnounceMessage(GameShowUtilities.replacePiece(ContestOrganizer.ANS_SUBMIT_MSG, this.connection.name));
                if (ContestOrganizer.this.contestant1 == this.connection && ContestOrganizer.this.problemAnswerResponse1 != null) {
                    ContestOrganizer.this.problemAnswerResponse1.stop();
                } else if (ContestOrganizer.this.contestant2 == this.connection && ContestOrganizer.this.problemAnswerResponse2 != null) {
                    ContestOrganizer.this.problemAnswerResponse2.stop();
                }
                String ans = solution[1];
                boolean correct = Boolean.parseBoolean(solution[2]);
                if (solution.length >= 5) {
                    nSteps = Integer.parseInt(solution[3]);
                    nIncorrect = Integer.parseInt(solution[4]);
                } else {
                    nSteps = 0;
                    nIncorrect = 0;
                }
                String path = "";
                if (solution.length >= 6) {
                    path = solution[5];
                }
                Solution sol = new Solution(ans, correct, nSteps, nIncorrect, path);
                ContestOrganizer.this.processSolution(this.connection, sol);
            }
        }

        public void sendChatMessage(String incomingMsg) {
            String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
            chat = this.connection.name + "'s Tutor: " + chat;
            ((ContestOrganizer)ContestOrganizer.this).contestant1.writer.println("ChatPrivateMessage," + chat);
            ((ContestOrganizer)ContestOrganizer.this).contestant2.writer.println("ChatPrivateMessage," + chat);
        }
    }

    class MessageDelay
    extends Thread {
        int timeDelay;
        String message;
        Connection connection;

        MessageDelay(Connection connect, int delay, String messageText) {
            this.timeDelay = delay;
            this.message = messageText;
            this.connection = connect;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeDelay);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (!ContestOrganizer.this.forfeited) {
                this.connection.writer.println(this.message);
            }
        }
    }

    class Solution {
        String answer;
        boolean correct;
        int numSteps;
        int numIncorrectSteps;
        String solutionPath;

        Solution(String ans, boolean corr, int nSteps, int nIncorr, String path) {
            this.answer = ans;
            this.correct = corr;
            this.numSteps = nSteps;
            this.numIncorrectSteps = nIncorr;
            this.solutionPath = path;
        }
    }
}

