/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.PeerLearning.GameShow.Competitor;
import edu.cmu.pact.miss.PeerLearning.GameShow.Connection;
import edu.cmu.pact.miss.PeerLearning.GameShow.ContestExecution;
import edu.cmu.pact.miss.PeerLearning.GameShow.ContestServer;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowPlatform;
import edu.cmu.pact.miss.PeerLearning.GameShow.GameShowUtilities;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.WebStartFileDownloader;
import edu.cmu.pact.miss.console.controller.MissController;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Contestant
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    Socket echoSocket = null;
    PrintWriter out = null;
    BufferedReader in = null;
    GameShowPlatform gameShowPlatform;
    ContestExecution execution;
    ListenerThread listener;
    String nameImg;
    String name;
    String opponentName;
    String opponentID;
    Hashtable<String, Competitor> competitors;
    SimStLogger logger;
    int rating = 0;
    private long startMatchupTime;
    boolean outstandingChallenge = false;
    List<String> recentChallenges = new LinkedList<String>();
    private static String contestServer = "128.2.176.81";
    private static int contestPort = 4444;
    long reviewStart;
    long lastTabViewStart;
    String lastTabViewed;
    long gameShowStart;
    long requestContestStartTime = new Date().getTime();
    public static final String CONTEST_REQUEST_BUTTON = "ContestRequestButton";
    public static final String CONTEST_CHALLENGE_BUTTON = "ContestChallengeButton";
    public static final String REVIEW_CONTINUE_BUTTON = "ReviewContinueButton";
    public static final String INPUT_FIELD = "InputField";
    public static final String GROUP_INPUT_FIELD = "GroupInputField";
    public static final String PROBLEM_INPUT_SUBMIT = "ProblemInputSubmit";
    public static final String PROBLEM_BANK_BUTTON = "ProblemBankButton";
    public static final String LEADERBOARD_BUTTON = "LeaderboardButton";
    public static final String WINDOW_EXIT = "WindowClosed";
    public static final String NUM_CORRECT = "Correct Solutions: ";
    public static final String AVG_STEPS = "Average Steps to a Correct Solution: ";
    public static final String PCT_CORRECT = "Percentage of Steps Correct: ";
    public static final String TIE_MSG = "And it looks like we have<br>a tie!  No winner this round.";
    public static final String WINNER_MSG = "It looks like our winner is<br>$1.  Congratulations!";
    public static final String FORFEIT_MSG = "It looks like our winner is<br>$1, since $2 forfeited.";
    public static final String CANCEL_MSG = "$2 had to forfeit due<br>to a technical issue, which leaves<br>$1 as our default winner,<br>but there will be no penalties.";
    public static final String WIN_MORE_CORRECT = "<br>$1 completed more<br>problems correctly.";
    public static final String WIN_SHORTER = "<br>You had the same number<br>of problems correct, but<br>$1's answers were more<br>concise.";
    public static final String WIN_MORE_STEPS_CORRECT = "<br>You had the same number<br>of problems correct, but<br>$1 made less mistakes<br>overall.";
    public static final String BOTH_GOT = "That's right! You both<br>got it.";
    public static final String ONE_GOT = "$1 gets it!";
    public static final String NONE_GOT = "Oh, too bad!  No one<br>got it right this time.";
    public static final String BEGIN_MSG = "Get ready!  We'll begin<br>shortly.";
    public static final String PROBLEM_START_MSG = "<p>Alright, the next problem</p><p>is $1.  Go!";
    public static final String BLANK_ERROR = "Don't leave either side of the equation blank.";
    public static final int ALLOWABLE_RATING_DIFF = 100;
    public static final String DUPLICATE_USERID_MSG = "Your User ID has been logged on with another session.  Closing this sesion.";
    public static final String PROJECTED_SCORE_MSG = "<html>If you win your new score would be $1 and<br>if you lose your new score would be $2.";
    private final String USER_ID_REQUEST_TITLE = "User ID";
    private final String USER_ID_REQUEST_MSG = "Please enter your User ID:";
    private static final String TOO_RECENT_MSG = "You have already challenged that person recently.";
    private SimSt simSt = null;
    private MissController missController = null;
    private BR_Controller brController = null;
    ContestExecution.Solution lastSolution = null;
    boolean challengeCurrent = false;
    long submitProblemRequestStartTime = -1L;
    Competitor lastSelected = null;

    public static void setContestServer(String server) {
        contestServer = server;
    }

    public static String getContestServer() {
        return contestServer;
    }

    public static void setContestPort(int port) {
        contestPort = port;
    }

    public static int getContestPort() {
        return contestPort;
    }

    public Contestant(BR_Controller brController, GameShowPlatform gameShowPlatform) {
        this.gameShowPlatform = gameShowPlatform;
        this.setBrController(brController);
        this.getBrController().activateMissController(false);
        this.setMissController((MissController)this.getBrController().getMissController());
        SimSt simSt = this.getMissController().getSimSt();
        this.setSimSt(simSt);
        this.logger = new SimStLogger(brController);
        String prodRules = null;
        String user = simSt.getUserID();
        if (user == null) {
            user = JOptionPane.showInputDialog(brController.getActiveWindow(), "Please enter your User ID:", "User ID", 3);
            simSt.setUserID(user);
            this.logger.enableLogging(this.getSimSt().getLoggingEnabled(), this.getSimSt().getLocalLoggingEnabled(), user);
        } else {
            user = simSt.getUserID();
            if (user == null) {
                user = "";
            }
            this.logger.enableLogging(this.getSimSt().getLoggingEnabled(), this.getSimSt().getLocalLoggingEnabled(), user);
        }
        trace.out("miss", "UserID: " + this.getSimSt().getUserID());
        if (!this.getSimSt().isWebStartMode()) {
            trace.out("miss", "Contestant: Running locally and getting account file");
            String str = new WebStartFileDownloader().findFile(this.getSimSt().getUserID() + ".account");
            File accountFile = new File(str);
            if (accountFile != null && accountFile.exists()) {
                trace.out("miss", "Contestant: Running locally and account file exists");
                try {
                    BufferedReader read = new BufferedReader(new FileReader(accountFile));
                    String charName = read.readLine();
                    SimSt.setSimStName(charName);
                    String imgName = read.readLine();
                    this.getSimSt().setSimStImage(imgName);
                    read.close();
                    prodRules = "productionRules-" + user + ".pr";
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            boolean success = false;
            String account = this.getSimSt().getUserID() + ".account";
            trace.out("miss", "account: " + account);
            File accountFile = new File(WebStartFileDownloader.SimStWebStartDir + account);
            trace.out("miss", "Contestant: Running Webstart and getting account file");
            if (!accountFile.exists()) {
                try {
                    trace.out("miss", "Contestant: Running Webstart and getting file from server");
                    success = this.getMissController().getStorageClient().retrieveFile(account, account, WebStartFileDownloader.SimStWebStartDir);
                    if (success) {
                        accountFile = new File(WebStartFileDownloader.SimStWebStartDir + account);
                        trace.out("miss", accountFile.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            trace.out("miss", "accountFile.exists(): " + accountFile.exists());
            if (accountFile != null && accountFile.exists()) {
                try {
                    trace.out("miss", "Contestant: Running Webstart and found account file");
                    BufferedReader read = new BufferedReader(new FileReader(accountFile));
                    String charName = read.readLine();
                    SimSt.setSimStName(charName);
                    trace.out("miss", "setSimStName: " + charName);
                    String imgName = read.readLine();
                    this.getSimSt().setSimStImage(imgName);
                    trace.out("miss", "setSimStImage: " + imgName);
                    read.close();
                    prodRules = WebStartFileDownloader.SimStWebStartDir + "productionRules-" + user + ".pr";
                    trace.out("miss", "prodRules: " + prodRules);
                    File prFile = new File(prodRules);
                    if (!prFile.exists()) {
                        trace.out("miss", "Download production file from the server");
                        this.getMissController().getStorageClient().retrieveFile("productionRules-" + user + ".pr", "productionRules-" + user + ".pr", WebStartFileDownloader.SimStWebStartDir);
                    } else {
                        trace.out("miss", "Production rule file exists");
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.name = SimSt.getSimStName();
        String img = this.getSimSt().getSimStImage();
        trace.out("miss", "name: " + this.name + " img: " + img);
        this.logger.simStShortLog("SSGAME", "Game Show Program Started", this.name, img);
        gameShowPlatform.setName(this.name);
        gameShowPlatform.setImage(img);
        this.competitors = new Hashtable();
        this.getSimSt().setDontShowAllRA(true);
        trace.out("miss", "prodRules: " + prodRules);
        this.execution = new ContestExecution(this.getSimSt(), prodRules, this);
        trace.out("miss", "After init ContestExecution");
        this.nameImg = this.name + "," + img;
        this.init(prodRules);
    }

    Contestant(String prodRules, String name, String img) {
        this.nameImg = name + "," + img;
        this.competitors = new Hashtable();
        this.init(prodRules);
    }

    public void init(String prodRules) {
        trace.out("miss", "init Contestant");
        try {
            this.echoSocket = new Socket(contestServer, contestPort);
            this.out = new PrintWriter(this.echoSocket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host.");
            this.logger.ssGameShowException(e, "Host not found");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection. " + e.getMessage() + " " + e.getCause());
            this.logger.ssGameShowException(e, "Could not connect to server");
            System.exit(1);
        }
        Connection connection = new Connection(this.echoSocket, this.out, this.in);
        this.listener = new ListenerThread(connection);
        new Thread(this.listener).start();
        this.out.println("JoinProgram," + this.nameImg + "," + this.getSimSt().getUserID() + "," + this.getBrController().getLogger().getClassName());
        this.logger.simStLog("SSGAME_MATCHUP", "Joined Matchup Area", "", this.rating);
        this.requestLeaderboard();
        this.startMatchupTime = Calendar.getInstance().getTimeInMillis();
        this.gameShowStart = Calendar.getInstance().getTimeInMillis();
    }

    public SimSt getSimSt() {
        return this.simSt;
    }

    public void setSimSt(SimSt simSt) {
        this.simSt = simSt;
    }

    public MissController getMissController() {
        return this.missController;
    }

    public void setMissController(MissController missController) {
        this.missController = missController;
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    public static void main(String[] args) throws IOException {
        new Contestant(args[0], args[1], args[2]);
    }

    public void outstandingChallenge(String incomingMsg) {
        String[] parts = incomingMsg.split(",");
        this.gameShowPlatform.addGroupNotification(parts[1]);
        this.outstandingChallenge = false;
        this.gameShowPlatform.enableChallengeButton(true);
        this.logger.simStLog("SSGAME_MATCHUP", "Challengee Already has Outstanding Challenge", "", "", (Object)"", null, 0, parts[1], parts[2], this.rating);
        this.recentChallenges.remove(parts[2]);
    }

    public void displayLeaderboard(String incomingMsg) {
        String leaderboard = "<html>" + incomingMsg.replaceAll(",", "<br>") + "</html>";
        this.gameShowPlatform.setLeaderboard(leaderboard);
    }

    public void duplicateID(String incomingMsg) {
        JOptionPane.showMessageDialog(null, DUPLICATE_USERID_MSG);
        this.leave();
        System.exit(0);
    }

    public void problemBankList(String incomingMsg) {
        String problems = incomingMsg.substring(16);
        String[] columns = new String[]{"Problem", "Attempts", "Difficulty"};
        String[] rows = problems.split(",");
        Object[][] data = new Object[rows.length][];
        for (int i = 0; i < data.length; ++i) {
            String[] tmp = rows[i].split(";");
            data[i] = new Object[3];
            data[i][0] = tmp[0];
            data[i][1] = new Integer(tmp[1]);
            data[i][2] = this.gameShowPlatform.createImageIcon("img/" + tmp[2]);
        }
        this.gameShowPlatform.displayProblemBank(columns, data);
    }

    public void problemAnswerTimeout(String incomingMsg) {
        this.lastSolution = this.execution.new ContestExecution.Solution();
        this.lastSolution.correctness = false;
        this.lastSolution.answer = "?";
        this.gameShowPlatform.setAnswer("?");
        this.logger.simStLog("SSGAME_CONTEST", "Problem Submission Timed-Out", "", "", (Object)"", 120000, "", this.opponentID, this.rating);
    }

    public void challengeRequestTimeout(String incomingMsg) {
        String[] parts = incomingMsg.split(",");
        String notif = GameShowUtilities.replacePiece("** Challenge request from $1 timed out.  It has been declined for you. **", parts[2]);
        this.gameShowPlatform.addGroupNotification(notif);
        this.challengeCurrent = false;
        this.logger.simStLog("SSGAME_MATCHUP", "Challenge Request Timed-Out", "", "", (Object)"", 60000, notif, parts[1], this.rating);
    }

    public void problemRequestTimeout(String incomingMsg) {
        this.gameShowPlatform.closeProblemInputDialog();
        this.gameShowPlatform.addPrivateNotification("** Request to provide problem timed out.  A random problem will be used instead. **");
        this.logger.simStLog("SSGAME_CONTEST", "Problem Request Timed-Out", "", "", (Object)"", 60000, "** Request to provide problem timed out.  A random problem will be used instead. **", this.opponentID, this.rating);
    }

    public void problemRequestExit(String incomingMsg, Connection connection) {
        connection.writer.println("ProblemRequestExited");
        this.gameShowPlatform.closeProblemInputDialog();
        this.gameShowPlatform.addPrivateNotification("** Request to provide problem was exited.  A random problem will be used instead. **");
        this.logger.simStLog("SSGAME_CONTEST", incomingMsg, "", "", (Object)"", 0, "** Request to provide problem was exited.  A random problem will be used instead. **", this.opponentID, this.rating);
    }

    public void addPrivateChatMessage(String incomingMsg) {
        String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
        this.gameShowPlatform.addPrivateChatText(chat);
        this.logger.simStLog("SSGAME_CONTEST", "Private Chat Message Added", chat, this.rating);
    }

    public void addGroupChatMessage(String incomingMsg) {
        String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
        this.gameShowPlatform.addGroupChatText(chat);
        this.logger.simStLog("SSGAME_MATCHUP", "Group Chat Message Added", chat, this.rating);
    }

    public void addPrivateAnnouncement(String incomingMsg) {
        String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
        this.gameShowPlatform.addPrivateAnnounceText(chat);
        this.logger.simStLog("SSGAME_CONTEST", "Private Announcement Message Added", chat, this.rating);
    }

    public void addGroupAnnouncement(String incomingMsg) {
        String chat = incomingMsg.substring(incomingMsg.indexOf(44) + 1);
        this.gameShowPlatform.addGroupAnnounceText(chat);
        this.logger.simStLog("SSGAME_MATCHUP", "Group Announcement Message Added", chat, this.rating);
    }

    public void requestProblem(String incomingMsg) {
        this.gameShowPlatform.showProblemInputDialog();
        this.logger.simStLog("SSGAME_CONTEST", "New Problem Requested", "problem" + (this.execution.numProblems + 1), "", (Object)("challenge" + this.opponentName), 0, "", this.rating);
        this.submitProblemRequestStartTime = new Date().getTime();
    }

    public void requestLeaderboard() {
        this.out.println("Leaderboard," + this.brController.getLogger().getClassName());
        this.logger.simStLog("SSGAME_MATCHUP", "Leaderboard Update Requested", "", this.rating);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String input;
        if (arg0.getActionCommand().equals(CONTEST_REQUEST_BUTTON)) {
            this.out.println("RequestContest");
            this.logger.simStShortLog("SSGAME_MATCHUP", "Challenge Issued", "Any", "", "Any", this.rating);
            this.requestContestStartTime = new Date().getTime();
        }
        if (arg0.getActionCommand().equals(CONTEST_CHALLENGE_BUTTON)) {
            final String userid = this.gameShowPlatform.getSelectedParticipant().userid;
            if (this.recentChallenges.contains(userid)) {
                JOptionPane.showMessageDialog(null, TOO_RECENT_MSG);
                return;
            }
            this.out.println("RequestContest," + userid);
            this.logger.simStShortLog("SSGAME_MATCHUP", "Challenge Issued", "" + this.gameShowPlatform.getSelectedParticipant().rating, "", this.gameShowPlatform.getSelectedParticipant().userid);
            this.gameShowPlatform.enableChallengeButton(false);
            this.outstandingChallenge = true;
            boolean worked = this.recentChallenges.add(userid);
            Timer tooRecent = new Timer(60000, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Contestant.this.recentChallenges.remove(userid);
                }
            });
            tooRecent.setRepeats(false);
            tooRecent.start();
            this.requestContestStartTime = new Date().getTime();
        }
        if (arg0.getActionCommand().equals(REVIEW_CONTINUE_BUTTON)) {
            this.gameShowPlatform.viewMatchup();
            int duration = (int)(Calendar.getInstance().getTimeInMillis() - this.lastTabViewStart);
            this.logger.simStLog("SSGAME_REVIEW", "Continue Button Clicked", "", "", (Object)"", duration, this.rating);
            this.out.println("JoinProgram," + this.nameImg + "," + this.getSimSt().getUserID() + "," + this.getBrController().getLogger().getClassName());
            this.logger.simStLog("SSGAME_MATCHUP", "Joined Matchup Area", "");
            this.startMatchupTime = Calendar.getInstance().getTimeInMillis();
            this.requestLeaderboard();
        }
        if (arg0.getActionCommand().equals(INPUT_FIELD)) {
            input = this.gameShowPlatform.takeInput();
            if (input.length() == 0) {
                return;
            }
            this.out.println("ChatPrivateMessage," + input);
        }
        if (arg0.getActionCommand().equals(GROUP_INPUT_FIELD)) {
            input = this.gameShowPlatform.takeGroupInput();
            if (input.length() == 0) {
                return;
            }
            this.out.println("ChatGroupMessage," + input);
        }
        if (arg0.getActionCommand().equals(PROBLEM_INPUT_SUBMIT)) {
            String aLhs = this.gameShowPlatform.getLhsInput();
            String aRhs = this.gameShowPlatform.getRhsInput();
            String lhs = this.simSt.getInputChecker().interpret("commTable1_C1R1", this.gameShowPlatform.getLhsInput());
            String rhs = this.simSt.getInputChecker().interpret("commTable2_C1R1", this.gameShowPlatform.getRhsInput());
            if (lhs == null) {
                String error = this.simSt.getInputChecker().invalidInputMessage("commTable1_C1R1", this.gameShowPlatform.getLhsInput(), null);
                String problem = aLhs + "=" + aRhs;
                long endTime = new Date().getTime();
                long duration = endTime - this.submitProblemRequestStartTime;
                this.logger.simStLog("SSGAME_CONTEST", "Invalid Problem Entered", "problem" + this.execution.numProblems, problem, (Object)"", (int)duration, error);
                this.submitProblemRequestStartTime = new Date().getTime();
                JOptionPane.showMessageDialog(this.gameShowPlatform.problemInputOk, error);
            } else if (rhs == null) {
                String error = this.simSt.getInputChecker().invalidInputMessage("commTable2_C1R1", this.gameShowPlatform.getRhsInput(), null);
                String problem = aLhs + "=" + aRhs;
                long endTime = new Date().getTime();
                long duration = endTime - this.submitProblemRequestStartTime;
                this.logger.simStLog("SSGAME_CONTEST", "Invalid Problem Entered", "problem" + this.execution.numProblems, problem, (Object)"", (int)duration, error);
                this.submitProblemRequestStartTime = new Date().getTime();
                JOptionPane.showMessageDialog(this.gameShowPlatform.problemInputOk, error);
            } else if (!this.simSt.getInputChecker().checkVariables(lhs, rhs)) {
                String error = this.simSt.getInputChecker().invalidVariablesMessage(lhs, rhs);
                String problem = aLhs + "=" + aRhs;
                long endTime = new Date().getTime();
                long duration = endTime - this.submitProblemRequestStartTime;
                this.logger.simStLog("SSGAME_CONTEST", "Invalid Problem Entered", "problem" + this.execution.numProblems, problem, (Object)"", (int)duration, error);
                this.submitProblemRequestStartTime = new Date().getTime();
                JOptionPane.showMessageDialog(this.gameShowPlatform.problemInputOk, error);
            } else if (lhs.length() == 0 || rhs.length() == 0) {
                String error = BLANK_ERROR;
                String problem = aLhs + "=" + aRhs;
                long endTime = new Date().getTime();
                long duration = endTime - this.submitProblemRequestStartTime;
                this.logger.simStLog("SSGAME_CONTEST", "Invalid Problem Entered", "problem" + this.execution.numProblems, problem, (Object)"", (int)duration, BLANK_ERROR);
                this.submitProblemRequestStartTime = new Date().getTime();
                JOptionPane.showMessageDialog(this.gameShowPlatform.problemInputOk, error);
            } else {
                this.gameShowPlatform.closeProblemInputDialog();
                String problem = lhs + "=" + rhs;
                long endTime = new Date().getTime();
                long duration = endTime - this.submitProblemRequestStartTime;
                this.out.println("SubmitProblems," + problem);
                this.logger.simStLog("SSGAME_CONTEST", "New Problem Submitted", "problem" + this.execution.numProblems, problem, (Object)"", (int)duration);
            }
        }
        if (arg0.getActionCommand().equals(PROBLEM_BANK_BUTTON)) {
            this.listener.connection.writer.println("RequestProblemBank");
            this.logger.simStLog("SSGAME_CONTEST", "Generate Problems Button Clicked", "problem" + this.execution.numProblems, "", "");
        }
        if (arg0.getActionCommand().equals(LEADERBOARD_BUTTON)) {
            this.requestLeaderboard();
        }
        if (arg0.getActionCommand().equals(WINDOW_EXIT)) {
            this.problemRequestExit("ProblemRequestExited", this.listener.connection);
        }
    }

    public void leave() {
        int duration = (int)(Calendar.getInstance().getTimeInMillis() - this.gameShowStart);
        this.logger.simStLog("SSGAME", "Game Show Closed", "", "", (Object)"", duration, this.rating);
        this.listener.activeListener = false;
        this.out.println("LeaveProgram");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
            this.logger.ssGameShowException(e1, "Error in leaving");
        }
        try {
            this.out.close();
            this.echoSocket.close();
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.ssGameShowException(e, "Error in shutdown");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        JList list = (JList)arg0.getSource();
        if (list.getSelectedIndex() != -1) {
            Competitor comp = (Competitor)list.getSelectedValue();
            this.gameShowPlatform.setOpponent(comp);
            if (!this.outstandingChallenge) {
                this.gameShowPlatform.enableChallengeButton(true);
                this.gameShowPlatform.colorOpponentRating(Color.black);
            }
            if (this.lastSelected != comp) {
                this.logger.simStShortLog("SSGAME_MATCHUP", "Contestant Details Viewed", "" + comp.rating, comp.name + "-" + comp.stats(), comp.userid, this.rating);
                this.lastSelected = comp;
            }
            int winScore = ContestServer.projectWin(this.rating, comp.rating);
            int loseScore = ContestServer.projectLoss(this.rating, comp.rating);
            this.gameShowPlatform.setMatchupComment(GameShowUtilities.replaceTwoPieces(PROJECTED_SCORE_MSG, "" + winScore, "" + loseScore));
        } else {
            this.gameShowPlatform.setOpponent(null);
            this.gameShowPlatform.enableChallengeButton(false);
            this.gameShowPlatform.setMatchupComment("");
            if (this.lastSelected != null) {
                this.logger.simStLog("SSGAME_MATCHUP", "Contestant Details Viewed", "", "None Selected", "", null, null, "", "", "", "", 0, "", "None");
                this.lastSelected = null;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)event.getSource();
            if (this.lastTabViewed.length() == 0) {
                this.lastTabViewed = tabPane.getTitleAt(0);
            }
            int duration = (int)(Calendar.getInstance().getTimeInMillis() - this.lastTabViewStart);
            this.lastTabViewStart = Calendar.getInstance().getTimeInMillis();
            this.logger.simStLog("SSGAME_REVIEW", "Left Tab", "", this.lastTabViewed, (Object)"", duration, this.rating);
            this.logger.simStLog("SSGAME_REVIEW", "Switched Tab", tabPane.getTitleAt(tabPane.getSelectedIndex()), this.rating);
            this.lastTabViewed = tabPane.getTitleAt(tabPane.getSelectedIndex());
        }
    }

    public Action getReconnectAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int duration = (int)(Calendar.getInstance().getTimeInMillis() - Contestant.this.gameShowStart);
                Contestant.this.listener.activeListener = false;
                Contestant.this.out.println("LeaveProgram,technical");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    Contestant.this.logger.ssGameShowException(e1, "Error in leaving");
                }
                try {
                    Contestant.this.out.close();
                    Contestant.this.echoSocket.close();
                    Contestant.this.in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Contestant.this.logger.ssGameShowException(e, "Error in shutdown");
                }
                trace.out("miss", "reconnect Contestant");
                try {
                    Contestant.this.echoSocket = new Socket(contestServer, contestPort);
                    Contestant.this.out = new PrintWriter(Contestant.this.echoSocket.getOutputStream(), true);
                    Contestant.this.in = new BufferedReader(new InputStreamReader(Contestant.this.echoSocket.getInputStream()));
                }
                catch (UnknownHostException e) {
                    System.err.println("Don't know about host.");
                    Contestant.this.logger.ssGameShowException(e, "Host not found");
                }
                catch (IOException e) {
                    System.err.println("Couldn't get I/O for the connection.");
                    Contestant.this.logger.ssGameShowException(e, "Could not reconnect to server");
                }
                Connection connection = new Connection(Contestant.this.echoSocket, Contestant.this.out, Contestant.this.in);
                Contestant.this.listener = new ListenerThread(connection);
                new Thread(Contestant.this.listener).start();
                Contestant.this.out.println("JoinProgram," + Contestant.this.nameImg + "," + Contestant.this.getSimSt().getUserID() + "," + Contestant.this.getBrController().getLogger().getClassName());
                Contestant.this.logger.simStLog("SSGAME", "Reconnected to Game Show", "", "", (Object)"", duration, Contestant.this.rating);
                Contestant.this.requestLeaderboard();
                Contestant.this.gameShowPlatform.viewMatchup();
                Contestant.this.gameShowPlatform.closeProblemInputDialog();
                Contestant.this.startMatchupTime = Calendar.getInstance().getTimeInMillis();
            }
        };
    }

    class ParticipantListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final String spaces = "                                 ";

        ParticipantListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = "";
            if (value instanceof Competitor) {
                Competitor comp = (Competitor)value;
                s = comp.name + comp.rating;
                s = s.length() < 30 ? comp.name + spaces.substring(0, 30 - s.length()) + comp.rating : comp.name + spaces.substring(0, 1) + comp.rating;
            } else if (value != null) {
                s = value.toString();
            }
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class ListenerThread
    extends Thread {
        boolean activeListener = true;
        Connection connection;
        int contScore = 0;
        int oppScore = 0;
        long contestStartTime = 0L;

        ListenerThread(Connection connect) {
            this.connection = connect;
        }

        @Override
        public void run() {
            try {
                String incomingMsg;
                while (this.activeListener && (incomingMsg = this.connection.reader.readLine()) != null) {
                    System.out.println("Server: " + incomingMsg);
                    if (incomingMsg.startsWith("ListAvailable")) {
                        this.listParticipants(incomingMsg);
                    }
                    if (incomingMsg.startsWith("StartContest")) {
                        this.startContest(incomingMsg);
                    }
                    if (incomingMsg.startsWith("StartProblem")) {
                        this.startProblem(incomingMsg);
                    }
                    if (incomingMsg.startsWith("SolutionAssessed")) {
                        this.solutionAssessed(incomingMsg);
                    }
                    if (incomingMsg.startsWith("EndContest")) {
                        this.endContest(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ContestRequested")) {
                        this.contestRequested(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ContestAgreed")) {
                        this.contestAgreed(incomingMsg);
                    }
                    if (incomingMsg.startsWith("RequestProblem")) {
                        Contestant.this.requestProblem(incomingMsg);
                    }
                    if (incomingMsg.startsWith("LeaveProgram")) {
                        this.activeListener = false;
                        break;
                    }
                    if (incomingMsg.startsWith("ChatPrivateMessage")) {
                        Contestant.this.addPrivateChatMessage(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ChatGroupMessage")) {
                        Contestant.this.addGroupChatMessage(incomingMsg);
                    }
                    if (incomingMsg.startsWith("AnnouncePrivateMessage")) {
                        Contestant.this.addPrivateAnnouncement(incomingMsg);
                    }
                    if (incomingMsg.startsWith("AnnounceMessage")) {
                        Contestant.this.addGroupAnnouncement(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ProblemRequestTimedOut")) {
                        Contestant.this.problemRequestTimeout(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ChallengeRequestTimedOut")) {
                        Contestant.this.challengeRequestTimeout(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ProblemAnswerTimedOut")) {
                        Contestant.this.problemAnswerTimeout(incomingMsg);
                    }
                    if (incomingMsg.startsWith("ProblemBankList")) {
                        Contestant.this.problemBankList(incomingMsg);
                    }
                    if (incomingMsg.startsWith("DuplicateUserID")) {
                        Contestant.this.duplicateID(incomingMsg);
                    }
                    if (incomingMsg.startsWith("GameForfeited")) {
                        this.forfeitContest(incomingMsg, false);
                    }
                    if (incomingMsg.startsWith("GameCancelled")) {
                        this.forfeitContest(incomingMsg, true);
                    }
                    if (incomingMsg.startsWith("Leaderboard")) {
                        Contestant.this.displayLeaderboard(incomingMsg);
                    }
                    if (!incomingMsg.startsWith("Outstanding")) continue;
                    Contestant.this.outstandingChallenge(incomingMsg);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Contestant.this.logger.ssGameShowException(e, "Error receiving message");
            }
        }

        protected void contestAgreed(String incomingMsg) {
            String[] args = incomingMsg.split(",");
            long endTime = new Date().getTime();
            long duration = endTime - Contestant.this.requestContestStartTime;
            Competitor comp = Contestant.this.competitors.get(args[1]);
            if (args.length < 3 || !args[2].equals("true")) {
                JOptionPane.showMessageDialog(Contestant.this.gameShowPlatform, comp.name + " has declined your challenge or did not respond.");
                Contestant.this.logger.simStLog("SSGAME_MATCHUP", "Challenge Refusal Received", "", "" + comp.rating, (Object)"", (int)duration, "", args[1], Contestant.this.rating);
            } else {
                Contestant.this.logger.simStLog("SSGAME_MATCHUP", "Challenge Acceptance Received", "", "" + comp.rating, (Object)"", (int)duration, "", args[1], Contestant.this.rating);
                Contestant.this.recentChallenges.remove(comp.userid);
            }
            Contestant.this.gameShowPlatform.enableChallengeButton(true);
            Contestant.this.outstandingChallenge = false;
        }

        protected void contestRequested(String incomingMsg) {
            String[] args = incomingMsg.split(",");
            new Thread(new AcceptPromptThread(this.connection, args[1])).start();
        }

        protected void endContest(String incomingMsg) {
            String opponentRating;
            String myRating;
            String winMessage;
            String[] ratingsOpp;
            String[] ratingsCont;
            String[] correctOpp;
            String[] correctCont;
            String[] solutionOpp;
            String[] solutionCont;
            Contestant.this.brController.startNewProblem();
            Contestant.this.gameShowPlatform.setProblem("");
            Contestant.this.gameShowPlatform.clearPrivateChat();
            String[] args = incomingMsg.split(",");
            String winner = args[1];
            String[] ratings1 = args[4].split(":");
            String[] ratings2 = args[5].split(":");
            String[] solutions1 = args[6].split(":");
            String[] solutions2 = args[7].split(":");
            String[] corrects1 = args[8].split(":");
            String[] corrects2 = args[9].split(":");
            if (solutions1[0].equals(Contestant.this.name)) {
                solutionCont = solutions1[1].split(";");
                solutionOpp = solutions2[1].split(";");
            } else {
                solutionOpp = solutions1[1].split(";");
                solutionCont = solutions2[1].split(";");
            }
            if (corrects1[0].equals(Contestant.this.name)) {
                correctCont = corrects1[1].split(";");
                correctOpp = corrects2[1].split(";");
            } else {
                correctOpp = corrects1[1].split(";");
                correctCont = corrects2[1].split(";");
            }
            if (ratings1[0].equals(Contestant.this.name)) {
                ratingsCont = ratings1[1].split(";");
                ratingsOpp = ratings2[1].split(";");
            } else {
                ratingsOpp = ratings1[1].split(";");
                ratingsCont = ratings2[1].split(";");
            }
            String whoWin = "";
            if (ratings1[0].equals(winner)) {
                String[] ratingsWin = ratings1[1].split(";");
                String[] ratingsLose = ratings2[1].split(";");
                winMessage = this.getWinMessage(winner, ratingsWin, ratingsLose);
            } else {
                String[] ratingsLose = ratings1[1].split(";");
                String[] ratingsWin = ratings2[1].split(";");
                winMessage = this.getWinMessage(winner, ratingsWin, ratingsLose);
            }
            Contestant.this.gameShowPlatform.setHostSpeech(winMessage);
            if (winner.length() == 0) {
                Contestant.this.gameShowPlatform.setReviewExpression("img/face1.png");
                Contestant.this.gameShowPlatform.setOppReviewExpression("img/face1.png");
                whoWin = "tie";
            } else if (winner.equals(Contestant.this.name)) {
                Contestant.this.gameShowPlatform.setReviewExpression("img/face2.png");
                Contestant.this.gameShowPlatform.setOppReviewExpression("img/face3.png");
                whoWin = "self";
            } else {
                Contestant.this.gameShowPlatform.setOppReviewExpression("img/face2.png");
                Contestant.this.gameShowPlatform.setReviewExpression("img/face3.png");
                whoWin = "opponent";
            }
            String contRating = this.getRatingString(ratingsCont);
            String oppRating = this.getRatingString(ratingsOpp);
            Contestant.this.gameShowPlatform.setRatings(contRating, oppRating);
            Contestant.this.gameShowPlatform.setSolutions(solutionCont, solutionOpp, correctCont, correctOpp);
            long endTime = new Date().getTime();
            long duration = endTime - this.contestStartTime;
            if (winner.length() == 0) {
                winner = "tie";
            }
            Contestant.this.logger.simStLog("SSGAME_REVIEW", "Winner Decided", "", whoWin, (Object)("review" + Contestant.this.opponentName), null, (int)duration, winMessage, Contestant.this.opponentID, Contestant.this.rating);
            Contestant.this.logger.simStShortLog("SSGAME_REVIEW", "Number of Problems Correct Determined", ratingsCont[0], ratingsOpp[0], Contestant.this.opponentID, Contestant.this.rating);
            Contestant.this.logger.simStShortLog("SSGAME_REVIEW", "Problem Lengths Determined", ratingsCont[1], ratingsOpp[1], Contestant.this.opponentID, Contestant.this.rating);
            Contestant.this.logger.simStShortLog("SSGAME_REVIEW", "Percent of Steps Correct Determined", ratingsCont[2], ratingsOpp[2], Contestant.this.opponentID, Contestant.this.rating);
            if (args[2].startsWith(Contestant.this.name)) {
                myRating = args[2];
                opponentRating = args[3];
            } else {
                myRating = args[3];
                opponentRating = args[2];
            }
            String rate = myRating.substring(myRating.indexOf(58) + 1);
            String oppRate = opponentRating.substring(opponentRating.indexOf(58) + 1);
            Contestant.this.rating = Integer.parseInt(rate);
            Contestant.this.logger.simStShortLog("SSGAME_REVIEW", "Rating Changed", rate, oppRate, Contestant.this.rating);
            Contestant.this.gameShowPlatform.viewReview();
            Contestant.this.lastTabViewStart = Calendar.getInstance().getTimeInMillis();
            Contestant.this.lastTabViewed = "";
            Contestant.this.reviewStart = Calendar.getInstance().getTimeInMillis();
        }

        protected void forfeitContest(String incomingMsg, boolean cancel) {
            int rate;
            Contestant.this.brController.startNewProblem();
            Contestant.this.gameShowPlatform.closeProblemInputDialog();
            Contestant.this.gameShowPlatform.setProblem("");
            Contestant.this.gameShowPlatform.clearPrivateChat();
            String[] args = incomingMsg.split(",");
            String forfeitee = args[1];
            String forfeiter = Contestant.this.opponentName;
            if (forfeitee.equals(Contestant.this.opponentName)) {
                forfeiter = Contestant.this.name;
            }
            String[] ratings1 = args[4].split(":");
            String[] ratings2 = args[5].split(":");
            String[] solutions1 = args[6].split(":");
            String[] solutions2 = args[7].split(":");
            String[] corrects1 = args[8].split(":");
            String[] corrects2 = args[9].split(":");
            String[] solutionCont = new String[]{};
            String[] solutionOpp = new String[]{};
            String[] correctCont = new String[]{};
            String[] correctOpp = new String[]{};
            String[] ratingsCont = new String[]{};
            String[] ratingsOpp = new String[]{};
            if (solutions1.length > 1 && solutions2.length > 1) {
                if (solutions1[0].equals(Contestant.this.name)) {
                    solutionCont = solutions1[1].split(";");
                    solutionOpp = solutions2[1].split(";");
                } else {
                    solutionOpp = solutions1[1].split(";");
                    solutionCont = solutions2[1].split(";");
                }
            }
            if (corrects1.length > 1 && corrects2.length > 1) {
                if (corrects1[0].equals(Contestant.this.name)) {
                    correctCont = corrects1[1].split(";");
                    correctOpp = corrects2[1].split(";");
                } else {
                    correctOpp = corrects1[1].split(";");
                    correctCont = corrects2[1].split(";");
                }
            }
            if (ratings1.length > 1 && ratings2.length > 1) {
                if (ratings1[0].equals(Contestant.this.name)) {
                    ratingsCont = ratings1[1].split(";");
                    ratingsOpp = ratings2[1].split(";");
                } else {
                    ratingsOpp = ratings1[1].split(";");
                    ratingsCont = ratings2[1].split(";");
                }
            }
            String winMessage = this.getForfeitMessage(forfeitee, forfeiter, cancel);
            Contestant.this.gameShowPlatform.setHostSpeech(winMessage);
            if (forfeitee.equals(Contestant.this.name)) {
                Contestant.this.gameShowPlatform.setReviewExpression("img/face1.png");
                Contestant.this.gameShowPlatform.setOppReviewExpression("img/face3.png");
            } else {
                Contestant.this.gameShowPlatform.setOppReviewExpression("img/face1.png");
                Contestant.this.gameShowPlatform.setReviewExpression("img/face3.png");
            }
            String contRating = this.getRatingString(ratingsCont);
            String oppRating = this.getRatingString(ratingsOpp);
            Contestant.this.gameShowPlatform.setRatings(contRating, oppRating);
            Contestant.this.gameShowPlatform.setSolutions(solutionCont, solutionOpp, correctCont, correctOpp);
            long endTime = new Date().getTime();
            long duration = endTime - this.contestStartTime;
            String myRating = args[2].startsWith(Contestant.this.name) ? args[2] : args[3];
            Contestant.this.rating = rate = Integer.parseInt(myRating.substring(myRating.indexOf(58) + 1));
            Contestant.this.logger.simStShortLog("SSGAME_REVIEW", "Rating Changed", myRating, oppRating, Contestant.this.rating);
            Contestant.this.gameShowPlatform.viewReview();
            Contestant.this.lastTabViewStart = Calendar.getInstance().getTimeInMillis();
            Contestant.this.lastTabViewed = "";
            Contestant.this.reviewStart = Calendar.getInstance().getTimeInMillis();
        }

        protected String getRatingString(String[] values) {
            String rating = "<html>";
            if (values.length >= 3) {
                rating = rating + Contestant.NUM_CORRECT + values[0] + "<br>";
                rating = rating + Contestant.AVG_STEPS + values[1] + "<br>";
                rating = rating + Contestant.PCT_CORRECT + values[2] + "%<br>";
            }
            rating = rating + "</html>";
            return rating;
        }

        protected String getWinMessage(String winner, String[] valuesWinner, String[] valuesLoser) {
            String win = "<html>";
            if (winner.length() == 0) {
                win = win + Contestant.TIE_MSG;
                win = win + "</html>";
                return win;
            }
            win = win + GameShowUtilities.replacePiece(Contestant.WINNER_MSG, winner);
            if (valuesWinner.length >= 3 && valuesLoser.length >= 3) {
                int correct = Integer.parseInt(valuesWinner[0]) - Integer.parseInt(valuesLoser[0]);
                double steps = Double.parseDouble(valuesWinner[1]) - Double.parseDouble(valuesLoser[1]);
                int percent = Integer.parseInt(valuesWinner[2]) - Integer.parseInt(valuesLoser[2]);
                if (correct > 0) {
                    win = win + GameShowUtilities.replacePiece(Contestant.WIN_MORE_CORRECT, winner);
                } else if (steps < 0.0) {
                    win = win + GameShowUtilities.replacePiece(Contestant.WIN_SHORTER, winner);
                } else if (percent > 0) {
                    win = win + GameShowUtilities.replacePiece(Contestant.WIN_MORE_STEPS_CORRECT, winner);
                }
            }
            win = win + "</html>";
            return win;
        }

        protected String getForfeitMessage(String forfeitee, String forfeiter, boolean cancel) {
            String win = "<html>";
            win = cancel ? win + GameShowUtilities.replaceTwoPieces(Contestant.CANCEL_MSG, forfeitee, forfeiter) : win + GameShowUtilities.replaceTwoPieces(Contestant.FORFEIT_MSG, forfeitee, forfeiter);
            win = win + "</html>";
            return win;
        }

        protected void solutionAssessed(String incomingMsg) {
            String[] solution = incomingMsg.split(",");
            Contestant.this.gameShowPlatform.setOppAnswer(solution[1]);
            boolean oppCorrectness = Boolean.parseBoolean(solution[2]);
            String correct = "";
            correct = oppCorrectness ? "TRUE" : "FALSE";
            Contestant.this.logger.simStLog("SSGAME_CONTEST", "Opponent Answer Submitted", "oppAnswer", solution[1], (Object)"", null, null, correct, "", "", "", 0, "", Contestant.this.opponentID, Contestant.this.rating);
            Contestant.this.gameShowPlatform.setCorrectness(Contestant.this.lastSolution.correctness, oppCorrectness);
            if (Contestant.this.lastSolution.correctness) {
                Contestant.this.gameShowPlatform.setGameShowExpression("img/face2.png");
            } else {
                Contestant.this.gameShowPlatform.setGameShowExpression("img/face3.png");
            }
            if (oppCorrectness) {
                Contestant.this.gameShowPlatform.setOppGameShowExpression("img/face2.png");
            } else {
                Contestant.this.gameShowPlatform.setOppGameShowExpression("img/face3.png");
            }
            String message = "<html>";
            String result = "";
            if (Contestant.this.lastSolution.correctness && oppCorrectness) {
                message = message + Contestant.BOTH_GOT;
                ++this.contScore;
                ++this.oppScore;
                result = "both";
            } else if (Contestant.this.lastSolution.correctness) {
                message = message + GameShowUtilities.replacePiece(Contestant.ONE_GOT, Contestant.this.name);
                ++this.contScore;
                result = "self";
            } else if (oppCorrectness) {
                message = message + GameShowUtilities.replacePiece(Contestant.ONE_GOT, Contestant.this.opponentName);
                ++this.oppScore;
                result = "opponent";
            } else {
                message = message + Contestant.NONE_GOT;
                result = "none";
            }
            message = message + "</html>";
            Contestant.this.gameShowPlatform.setHostSpeech(message);
            Contestant.this.gameShowPlatform.setScores(this.contScore, this.oppScore);
            Contestant.this.logger.simStLog("SSGAME_CONTEST", "Contest Problem Results Determined", "", result, "", null, null, ("" + Contestant.this.lastSolution.correctness).toUpperCase(), "", "", "", 0, "", Contestant.this.opponentID);
        }

        protected void listParticipants(String list) {
            Competitor selected = Contestant.this.gameShowPlatform.getSelectedParticipant();
            if (list.indexOf(44) >= 0) {
                list = list.substring(list.indexOf(44) + 1);
                String[] entries = list.split(",");
                Object[] names = new Competitor[entries.length - 1];
                int count = 0;
                for (int i = 0; i < entries.length; ++i) {
                    String[] details = entries[i].split(";");
                    Competitor competitor = Contestant.this.competitors.containsKey(details[6]) ? Contestant.this.competitors.get(details[6]) : new Competitor(details[0], details[1], details[6]);
                    competitor.name = details[0];
                    competitor.img = details[1];
                    competitor.rating = Integer.parseInt(details[2]);
                    competitor.wins = Integer.parseInt(details[3]);
                    competitor.losses = Integer.parseInt(details[4]);
                    competitor.ties = Integer.parseInt(details[5]);
                    competitor.userid = details[6];
                    Contestant.this.competitors.put(competitor.userid, competitor);
                    if (competitor.userid.equals(Contestant.this.getSimSt().getUserID())) {
                        Contestant.this.gameShowPlatform.setRating(competitor);
                        Contestant.this.rating = competitor.rating;
                        continue;
                    }
                    names[count] = competitor;
                    ++count;
                }
                Contestant.this.gameShowPlatform.setParticipantList(names);
                Object closest = null;
                int closeness = 100;
                for (int i = 0; i < names.length; ++i) {
                    if (closest != null && closeness <= Math.abs(((Competitor)names[i]).rating - Contestant.this.rating)) continue;
                    closest = names[i];
                    closeness = Math.abs(((Competitor)names[i]).rating - Contestant.this.rating);
                }
                if (selected == null && closest != null) {
                    Contestant.this.gameShowPlatform.participantList.setSelectedValue(closest, true);
                    if (Contestant.this.gameShowPlatform.participantList.getSelectedIndex() == -1) {
                        Contestant.this.gameShowPlatform.participantList.setSelectedIndex(0);
                    }
                } else if (selected == null && count > 0) {
                    Contestant.this.gameShowPlatform.participantList.setSelectedIndex(0);
                } else if (count > 0) {
                    Contestant.this.gameShowPlatform.participantList.setSelectedValue(selected, true);
                    if (Contestant.this.gameShowPlatform.participantList.getSelectedIndex() == -1) {
                        Contestant.this.gameShowPlatform.participantList.setSelectedIndex(0);
                    }
                }
            }
        }

        protected void startContest(String msg) {
            Contestant.this.execution.reset();
            Contestant.this.gameShowPlatform.viewGameshow();
            this.contScore = 0;
            this.oppScore = 0;
            String[] msgParts = msg.split(",");
            Contestant.this.opponentID = msgParts[1];
            Competitor comp = null;
            if (Contestant.this.competitors.get(Contestant.this.opponentID) != null) {
                comp = Contestant.this.competitors.get(Contestant.this.opponentID);
                Contestant.this.opponentName = comp.name;
            } else {
                comp = new Competitor(Contestant.this.opponentName, msgParts[2], Contestant.this.opponentID);
                Contestant.this.competitors.put(comp.userid, comp);
            }
            Contestant.this.gameShowPlatform.setOpponent(comp);
            Contestant.this.gameShowPlatform.clearAnswers();
            Contestant.this.gameShowPlatform.setScores(this.contScore, this.oppScore);
            Contestant.this.gameShowPlatform.setHostSpeech("<html>Get ready!  We'll begin<br>shortly.</html>");
            Contestant.this.gameShowPlatform.setGameShowExpression("img/face1.png");
            Contestant.this.gameShowPlatform.setOppGameShowExpression("img/face1.png");
            int duration = (int)(Calendar.getInstance().getTimeInMillis() - Contestant.this.startMatchupTime);
            Contestant.this.logger.simStLog("SSGAME_MATCHUP", "Matchup Successful", "", "", (Object)"", duration, "", Contestant.this.opponentID, Contestant.this.rating);
            Contestant.this.logger.simStLog("SSGAME_CONTEST", "Contest Started", "", "", (Object)("challenge" + Contestant.this.opponentName), 0, "", Contestant.this.opponentID, Contestant.this.rating);
            this.contestStartTime = new Date().getTime();
        }

        protected void startProblem(String msg) {
            String[] msgParts = msg.split(",");
            String problem = msgParts[1];
            Contestant.this.gameShowPlatform.clearAnswers();
            Contestant.this.gameShowPlatform.setHostSpeech("<html>" + GameShowUtilities.replacePiece(Contestant.PROBLEM_START_MSG, problem));
            Contestant.this.gameShowPlatform.setProblem(problem);
            new SolverThread(this.connection, problem).start();
        }
    }

    class AcceptPromptThread
    extends Thread {
        Connection connection;
        String name;

        AcceptPromptThread(Connection connect, String n) {
            this.name = n;
            this.connection = connect;
        }

        @Override
        public void run() {
            Contestant.this.challengeCurrent = true;
            Competitor challenger = Contestant.this.competitors.get(this.name);
            Contestant.this.logger.simStShortLog("SSGAME_MATCHUP", "Challenge Received", "" + challenger.rating, "", this.name, Contestant.this.rating);
            long startTime = new Date().getTime();
            int winScore = ContestServer.projectWin(Contestant.this.rating, challenger.rating);
            int loseScore = ContestServer.projectLoss(Contestant.this.rating, challenger.rating);
            String msg = "<html>" + challenger.name + " has challenged you to a game show.  Will you accept?<br>" + GameShowUtilities.replaceTwoPieces(Contestant.PROJECTED_SCORE_MSG, "" + winScore, "" + loseScore);
            int response = JOptionPane.showConfirmDialog(Contestant.this.gameShowPlatform, msg);
            long endTime = new Date().getTime();
            long duration = endTime - startTime;
            if (Contestant.this.challengeCurrent) {
                if (response == 0) {
                    Contestant.this.logger.simStLog("SSGAME_MATCHUP", "Challenge Accepted", "", "" + challenger.rating, (Object)"", (int)duration, "", this.name, Contestant.this.rating);
                    this.connection.writer.println("AgreeContest," + this.name + ",true");
                } else {
                    Contestant.this.logger.simStLog("SSGAME_MATCHUP", "Challenge Refused", "", "" + challenger.rating, (Object)"", (int)duration, "", this.name, Contestant.this.rating);
                    this.connection.writer.println("AgreeContest," + this.name + ",false");
                }
            } else if (response == 0) {
                JOptionPane.showMessageDialog(Contestant.this.gameShowPlatform, "This challenge is no longer current.");
            }
            Contestant.this.challengeCurrent = false;
        }
    }

    class SolverThread
    extends Thread {
        Connection connection;
        String problem;

        SolverThread(Connection connect, String prob) {
            this.connection = connect;
            this.problem = prob;
        }

        @Override
        public void run() {
            Contestant.this.gameShowPlatform.setGameShowExpression("img/face6.png");
            Contestant.this.gameShowPlatform.setOppGameShowExpression("img/face6.png");
            Contestant.this.lastSolution = Contestant.this.execution.contestOnWholeProblem(this.problem);
            Contestant.this.gameShowPlatform.setGameShowExpression("img/face1.png");
            String answer = Contestant.this.lastSolution.answer;
            boolean isCorrect = Contestant.this.lastSolution.correctness;
            int nSteps = Contestant.this.lastSolution.steps;
            int nIncorrect = Contestant.this.lastSolution.incorrectSteps;
            String path = Contestant.this.lastSolution.solutionPath;
            if (answer.length() == 0) {
                answer = "?";
            }
            Contestant.this.gameShowPlatform.setAnswer(answer);
            this.connection.writer.println("SolutionMade," + answer + "," + isCorrect + "," + nSteps + "," + nIncorrect + "," + path);
        }
    }
}

