/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.PeerLearning.SimStLogAgent;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.minerva_3_1.StepAbstractor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import pact.CommWidgets.JCommTable;

public class SimStHintLogAgent
extends SimStLogAgent {
    public static String PROBLEM = "Problem";
    public static String PROBLEMTYPE = "ProblemType";
    public static String QUIZ = "Quiz";
    public static String COG_FEEDBACK = "Feedback";
    public static String RESOURCE = "Resource";
    private static final String FEEDBACK_REQUEST = "feedback-request";
    private static final String HINT_REQUEST = "hint-request";
    private static final String QUIZ_REQUEST = "take-quiz";
    private static final String COG_DEMONSTRATE = "Demonstrate Step";
    private static final String PROBLEM_TYPE_REQUEST = "problem-type";
    private static final String PROBLEM_FAIL_QUIZ_TYPE_REQUEST = "quizPType";
    private static final String UOVERVIEW_REQUEST = "resource-uoverview";
    private static final String EXAMPLES_REQUEST = "resource-examples";
    private static SimStHintLogAgent instance = null;
    private static final String HINT_FOLLOWED = "Followed";
    private static final String HINT_NOT_FOLLOWED = "Not followed";
    private static final String NOT_TRACKED = "Not Tracked";
    private static final String REPEATED_HINT = "Repeated";
    private LinkedHashMap<String, String> studentStartStateElementsValues = new LinkedHashMap();
    private LinkedHashMap<String, String> mtStartStateElementsValues = new LinkedHashMap();
    private boolean lockMTHash;
    boolean hintFollowed = false;
    protected boolean hintReceived = false;
    private String currentHintType = "none";
    private String anticipatedResource = "";

    private LinkedHashMap<String, String> getStudentStartStateElementsValues() {
        return this.studentStartStateElementsValues;
    }

    public LinkedHashMap<String, String> getMtStartStateElementsValues() {
        return this.mtStartStateElementsValues;
    }

    public void updateMtStartStateElementsValues(String selection, String input) {
        if (!this.lockMTHash) {
            this.getMtStartStateElementsValues().put(selection, input);
        }
    }

    protected void setHintReceived(boolean flag) {
        this.hintReceived = flag;
    }

    protected boolean getHintReceived() {
        return this.hintReceived;
    }

    public SimStHintLogAgent(BR_Controller brController) {
        super(brController);
    }

    public static SimStHintLogAgent getInstance(BR_Controller newBrController) {
        if (instance == null) {
            instance = new SimStHintLogAgent(newBrController);
        }
        return instance;
    }

    public static SimStHintLogAgent getInstance() {
        return instance;
    }

    private String getCurrentHintType() {
        return this.currentHintType;
    }

    private void setCurrentHintType(String result) {
        this.currentHintType = result.contains(QUIZ_REQUEST) ? QUIZ : (result.contains(HINT_REQUEST) ? COG_DEMONSTRATE : (result.contains(FEEDBACK_REQUEST) ? COG_FEEDBACK : (result.contains(RESOURCE) ? RESOURCE : (result.contains(PROBLEM_TYPE_REQUEST) || result.contains(PROBLEM_FAIL_QUIZ_TYPE_REQUEST) ? PROBLEMTYPE : PROBLEM))));
    }

    public void setAnticipatedResource(String result) {
        if (result.contains(EXAMPLES_REQUEST)) {
            this.anticipatedResource = "Examples";
        } else if (result.contains(UOVERVIEW_REQUEST)) {
            this.anticipatedResource = "Unit Overview".replaceAll(" ", "");
        }
    }

    public String getAnticipatedResource() {
        return this.anticipatedResource;
    }

    public boolean manageLogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        boolean returnValue = false;
        if (action.equals("Metatutor Hint Given") && !this.getHintReceived()) {
            this.setHintReceived(true);
            this.setCurrentHintType(result);
            this.storeHintLogEntry(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
            returnValue = true;
        } else if (action.equals("Metatutor Hint Given") && this.getHintReceived()) {
            this.logger.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, false, this.getCurrentHintType(), REPEATED_HINT, event_time);
            returnValue = true;
        } else if (!action.equals("Metatutor Hint Given") && this.getHintReceived()) {
            this.releaseHintLogEntry(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time);
            returnValue = false;
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    public void storeHintLogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        if (this.getCurrentHintType().equals(QUIZ)) {
            this.logBuffer.add(new SimStLogAgent.LogEntry(this, actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time));
        } else if (this.getCurrentHintType().equals(COG_FEEDBACK) || this.getCurrentHintType().equals(COG_DEMONSTRATE)) {
            this.logger.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, false, this.getCurrentHintType(), NOT_TRACKED, event_time);
            this.setHintReceived(false);
        } else if (this.getCurrentHintType().equals(RESOURCE)) {
            this.setAnticipatedResource(result);
            this.logBuffer.add(new SimStLogAgent.LogEntry(this, actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time));
        } else if (this.getCurrentHintType().equals(PROBLEM) || this.getCurrentHintType().equals(PROBLEMTYPE)) {
            this.lockMTHash = true;
            this.logBuffer.add(new SimStLogAgent.LogEntry(this, actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, event_time));
        }
    }

    public boolean releaseHintLogEntry(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, String event_time) {
        if (action.equals("Quiz Button Clicked") || action.equals("Student Initiated Quiz on Untaken Quiz Expand")) {
            this.hintFollowed = this.getCurrentHintType().equals(QUIZ);
            ((SimStLogAgent.LogEntry)this.logBuffer.pop()).log(this.logger, this.getCurrentHintType(), this.hintFollowedBooleanToString(this.hintFollowed));
            this.setHintReceived(false);
            System.out.println("quiz button has been clicked, hint followed is ..." + this.hintFollowed);
        } else if (action.equals("New Problem Entered")) {
            this.updateStudentStartStateElementsValues();
            this.getMtStartStateElementsValues();
            this.hintFollowed = this.getCurrentHintType().equals(PROBLEM) ? this.getStudentStartStateElementsValues().equals(this.getMtStartStateElementsValues()) : this.abstractHash(this.getStudentStartStateElementsValues()).equals(this.abstractHash(this.getMtStartStateElementsValues()));
            this.lockMTHash = false;
            ((SimStLogAgent.LogEntry)this.logBuffer.pop()).log(this.logger, this.getCurrentHintType(), this.hintFollowedBooleanToString(this.hintFollowed));
            this.setHintReceived(false);
            System.out.println("a new problem has been given, hintFollowed is " + this.hintFollowed);
        } else if (action.equals("Switched Tab")) {
            boolean resourceHint;
            boolean bl = resourceHint = this.getCurrentHintType().equals(RESOURCE);
            this.hintFollowed = resourceHint && sai != null ? sai.getS().contains(this.getAnticipatedResource()) : false;
            ((SimStLogAgent.LogEntry)this.logBuffer.pop()).log(this.logger, this.getCurrentHintType(), this.hintFollowedBooleanToString(this.hintFollowed));
            this.setHintReceived(false);
            System.out.println("a new tab has been clicked, hintFollowed is " + this.hintFollowed);
        }
        return this.hintFollowed;
    }

    private String hintFollowedBooleanToString(boolean hintFollowed) {
        return hintFollowed ? HINT_FOLLOWED : HINT_NOT_FOLLOWED;
    }

    private LinkedHashMap<String, String> abstractHash(LinkedHashMap<String, String> hash) {
        StepAbstractor abstractor = new StepAbstractor();
        Set<Map.Entry<String, String>> set = hash.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            String abstracted = abstractor.signedAbstraction(value);
            hash.put(key, abstracted);
        }
        return hash;
    }

    public void updateStudentStartStateElementsValues() {
        ArrayList<String> ssElements = brController.getMissController().getSimStPLE().getStartStateElements();
        for (String s : ssElements) {
            JCommTable.TableExpressionCell cell = (JCommTable.TableExpressionCell)brController.lookupWidgetByName(s);
            this.studentStartStateElementsValues.put(s, cell.getText());
        }
    }
}

