/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LoadFileDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.miss.AskHint;
import edu.cmu.pact.miss.AskHintBrd;
import edu.cmu.pact.miss.AskHintClAlgebraTutor;
import edu.cmu.pact.miss.AskHintFakeClAlgebraTutor;
import edu.cmu.pact.miss.AskHintHumanOracle;
import edu.cmu.pact.miss.AskHintInBuiltClAlgebraTutor;
import edu.cmu.pact.miss.AskHintTutoringServiceFake;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.InquiryClAlgebraTutor;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.MessageDrop;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.SimStPeerTutoringPlatform;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdge;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStGraphNavigator;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStProblemGraph;
import edu.cmu.pact.miss.Rule;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStNodeEdge;
import edu.cmu.pact.miss.SimStTutalk;
import edu.cmu.pact.miss.SimStTutalkContextVariables;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import jess.Fact;
import jess.Value;
import pact.CommWidgets.JCommTable;

public class SimStInteractiveLearning
implements Runnable {
    public final String UNLABELED_SKILLNAME = "unlabeled-interactive-learning";
    private SimSt simSt;
    public static BR_Controller brController;
    private SimStLogger logger;
    private SimStProblemGraph quizGraph = null;
    private Hashtable<String, String> filledInComponents = new Hashtable();
    private boolean runningFromBrd = false;
    public static boolean isWaitingForDemonstration;
    public static boolean isWaitingForRuleLearned;
    private static MessageDrop messageDrop;
    private boolean takingQuiz = false;
    private boolean typeInStepWithNewFoA = false;
    private long problemStartTime = 0L;
    private long problemRecentTime = 0L;
    public boolean foaCorrectness = true;
    private AskHint hint;
    private SimStTutalk tutalkBridge;
    SimStTutalkContextVariables contextVariables = new SimStTutalkContextVariables();

    public SimSt getSimSt() {
        return this.simSt;
    }

    public void setSimSt(SimSt simSt) {
        this.simSt = simSt;
        if (simSt.getSsInteractiveLearning() == null) {
            simSt.setSsInteractiveLearning(this);
        }
    }

    public SimStLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SimStLogger log) {
        this.logger = log;
    }

    public void setQuizGraph(SimStProblemGraph quizGraph) {
        this.quizGraph = quizGraph;
    }

    public SimStProblemGraph getQuizGraph() {
        return this.quizGraph;
    }

    public boolean isRunningFromBrd() {
        return this.runningFromBrd;
    }

    public void setRunningFromBrd(boolean runningFromBrd) {
        this.runningFromBrd = runningFromBrd;
    }

    public MessageDrop getMessageDrop() {
        return messageDrop;
    }

    public void setTakingQuiz(boolean flag) {
        this.takingQuiz = flag;
    }

    public boolean isTakingQuiz() {
        return this.takingQuiz;
    }

    public boolean isTypeInStepWithNewFoA() {
        return this.typeInStepWithNewFoA;
    }

    public void setTypeInStepWithNewFoA(boolean typeInStepWithNewFoA) {
        this.typeInStepWithNewFoA = typeInStepWithNewFoA;
    }

    public void setProblemStartTime(long time) {
        this.problemStartTime = time;
        this.setProblemRecentTime(this.problemStartTime);
    }

    public long getProblemStartTime() {
        return this.problemStartTime;
    }

    public void setProblemRecentTime(long time) {
        this.problemRecentTime = time;
    }

    public long getProblemRecentTime() {
        return this.problemRecentTime;
    }

    public boolean isFoaCorrectness() {
        return this.foaCorrectness;
    }

    private void setFoaCorrectness(boolean foaCorrectness) {
        this.foaCorrectness = foaCorrectness;
    }

    public AskHint getHint() {
        return this.hint;
    }

    public SimStInteractiveLearning(SimSt simSt) {
        this.setSimSt(simSt);
        brController = simSt.getBrController();
        this.setLogger(new SimStLogger(brController));
        if (simSt.getTutalkEnabled()) {
            String[] tutalkParam = simSt.getTutalkParam().split(",");
            String tutalkUid = simSt.getUserID();
            this.tutalkBridge = new SimStTutalk(tutalkUid, this);
            this.tutalkBridge.initialize();
        }
    }

    public SimStTutalk getTutalk() {
        return this.tutalkBridge;
    }

    @Override
    public void run() {
        this.runInteractiveLearning();
    }

    public void ssInteractiveLearningWithBRD(String brdPath) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "Inside ssInteractiveLearningWithBRD");
        }
        this.setRunningFromBrd(true);
        LoadFileDialog.doLoadBRDFile(brController, brdPath, "", true);
        brController.getCtatModeModel().setAuthorMode("Demonstrate");
        ExampleTracerGraph exTracerGraph = brController.getProblemModel().getExampleTracerGraph();
        GroupModel groupModel = exTracerGraph.getGroupModel();
        LinkGroup topLevelGroup = exTracerGraph.getGroupModel().getTopLevelGroup();
        groupModel.setGroupOrdered(topLevelGroup, false);
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        String problemName = startNode.getName();
        this.ssInteractiveLearningOnProblem(problemName);
    }

    public void ssInteractiveLearningOnProblem(String problemName) {
        this.createStartStateOnProblem(problemName);
        this.runInteractiveLearning();
    }

    public void createStartStateQuizProblem(String quizProblem) {
        this.filledInComponents.clear();
        if (this.quizGraph == null) {
            String safeProblemName = SimSt.convertToSafeProblemName(quizProblem);
            this.quizGraph = new SimStProblemGraph();
            SimStNode startNode = new SimStNode(safeProblemName, this.quizGraph);
            this.quizGraph.setStartNode(startNode);
            this.quizGraph.addSSNode(startNode);
        }
    }

    public void createStartStateOnProblem(String problemName) {
        block12: {
            this.filledInComponents.clear();
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "createStartStateOnProblem: " + problemName);
            }
            try {
                if (brController.getProblemModel().getStartNode() == null) {
                    String[] sp = problemName.split("=");
                    String c1r1Value = sp[0].trim();
                    String c2r1Value = sp[1].trim();
                    if (brController.getMissController().isPLEon()) {
                        SimStPLE ple = brController.getMissController().getSimStPLE();
                        ArrayList<String> startElements = ple.getStartStateElements();
                        for (int i = 0; i < startElements.size() && i < sp.length; ++i) {
                            SimStInteractiveLearning.simulateCellTextEntry(startElements.get(i), sp[i].trim());
                        }
                    } else {
                        try {
                            SimStInteractiveLearning.simulateCellTextEntry("dorminTable1_C1R1", c1r1Value);
                            SimStInteractiveLearning.simulateCellTextEntry("dorminTable2_C1R1", c2r1Value);
                        }
                        catch (Exception e) {
                            trace.out("ss", "Using old setup interface format due to failure & no start state info");
                            SimStInteractiveLearning.simulateCellTextEntry("dorminTable1_C1R1", c1r1Value);
                            SimStInteractiveLearning.simulateCellTextEntry("dorminTable1_C2R1", c2r1Value);
                        }
                    }
                    String normalProblemName = SimSt.convertToSafeProblemName(problemName);
                    if (trace.getDebugCode("ss")) {
                        trace.out("ss", "Problem Name created: " + normalProblemName);
                    }
                    this.setProblemStartTime(Calendar.getInstance().getTimeInMillis());
                    brController.createStartState(normalProblemName);
                    break block12;
                }
                ProblemNode node = brController.getProblemModel().getStartNode();
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "ssInteractiveLearningOnProblem: startNode = " + node);
                }
            }
            catch (Exception e) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "ssInteractiveLearningOnProblem: - - - - Exception - - - -");
                }
                e.printStackTrace();
                this.logger.simStLogException(e, "ssInteractiveLearningOnProblem: - - - - Exception - - - -");
            }
        }
    }

    public String createName(Component[] list) {
        String compNames = "";
        for (int i = 0; i < list.length; ++i) {
            if (list[i] instanceof JCommTable) {
                JCommTable table = (JCommTable)list[i];
                JCommTable.TableExpressionCell[][] cells = table.getCells();
                for (int j = 0; j < cells.length; ++j) {
                    for (int k = 0; k < cells[j].length; ++k) {
                        String namePart = cells[j][k].getText();
                        if (namePart.length() <= 0) continue;
                        compNames = compNames.length() > 0 ? compNames + "_" + namePart : compNames + namePart;
                    }
                }
                continue;
            }
            if (!(list[i] instanceof JComponent)) continue;
            JComponent comp = (JComponent)list[i];
            String namePart = this.createName(comp.getComponents());
            if (compNames.length() > 0 && namePart.length() > 0) {
                compNames = compNames + "_" + namePart;
                continue;
            }
            if (namePart.length() <= 0) continue;
            compNames = compNames + namePart;
        }
        return compNames;
    }

    public void createStartState(JComponent studentInterface) {
        this.createStartState(studentInterface, false);
    }

    public void createStartState(JComponent studentInterface, boolean problemRestart) {
        this.filledInComponents.clear();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "createStartState....");
        }
        String problemName = this.createName(studentInterface.getComponents());
        String normalProblemName = "";
        try {
            if (brController.getProblemModel().getStartNode() == null) {
                normalProblemName = SimSt.convertToSafeProblemName(problemName);
                this.setProblemStartTime(Calendar.getInstance().getTimeInMillis());
                brController.createStartState(normalProblemName);
            } else {
                ProblemNode node = brController.getProblemModel().getStartNode();
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "ssInteractiveLearningOnProblem: startNode = " + node);
                }
            }
            if (!problemRestart) {
                this.logger.simStLog("SIM_STUDENT_PROBLEM", "New Problem Entered", normalProblemName, "", "");
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "ssInteractiveLearningOnProblem: - - - - Exception - - - -");
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "ssInteractiveLearningOnProblem: - - - - Exception - - - -");
        }
    }

    public static void simulateCellTextEntry(int row, int col, String value) {
        JCommTable commTable = (JCommTable)brController.lookupWidgetByName("commTable1");
        JCommTable.TableCell cell = commTable.getCell(row, col);
        FocusEvent e = new FocusEvent(cell, 1005, false, cell);
        cell.setText(value);
        commTable.focusLost(e);
    }

    public static void simulateCellTextEntry(String tableCell, String value) {
        JCommTable.TableCell cell = (JCommTable.TableCell)brController.lookupWidgetByName(tableCell);
        FocusEvent e = new FocusEvent(cell, 1005, false, cell);
        cell.setText(value);
        int idx = tableCell.indexOf(95);
        String tableName = tableCell.substring(0, idx);
        JCommTable commTable = (JCommTable)brController.lookupWidgetByName(tableName);
        commTable.focusLost(e);
    }

    public void startQuizProblem() {
        SimStNode startNode = this.quizGraph.getStartNode();
        SimStNode currentNode = null;
        SimStNode nextCurrentNode = null;
        HashMap hm = new HashMap();
        boolean killMessageReceived = false;
        currentNode = startNode;
        this.simSt.setProblemStepString(startNode.getName());
        while (!killMessageReceived) {
            this.simSt.setCurrentSsNode(currentNode);
            Object nextNode = null;
            long activationListStartTime = Calendar.getInstance().getTimeInMillis();
            Vector<RuleActivationNode> activationList = this.simSt.gatherActivationList(currentNode, hm);
            Collection<RuleActivationNode> activList = this.simSt.createOrderedActivationList(activationList);
            int activationListDuration = (int)(Calendar.getInstance().getTimeInMillis() - activationListStartTime);
            nextCurrentNode = this.inspectRuleActivations(currentNode, activList, hm);
            if (this.logger.getLoggingEnabled()) {
                String step = this.simSt.getProblemStepString();
                this.logger.simStLog("SIM_STUDENT_LEARNING", "Activation Rules Determined", step, activList.size() + " rules found", (Object)"", activationListDuration);
                int count = 0;
                this.hint = this.simSt.askForHintQuizGradingOracle(brController, currentNode);
                if (this.hint.skillName != null) {
                    for (RuleActivationNode ran : activList) {
                        ++count;
                        Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
                        if (sai.getI().equals("NotSpecified") || sai.getI().equals("FALSE")) continue;
                        this.logger.simStLog("SIM_STUDENT_LEARNING", "Activation Rule Considered", step, "" + count, (Object)"", sai, currentNode, this.hint.getSelection(), this.hint.getAction(), this.hint.getInput());
                    }
                }
            }
            if (nextCurrentNode != null) {
                ProblemEdge edge;
                String input;
                currentNode = nextCurrentNode;
                if (currentNode.getIncomingEdges().size() > 0 && EqFeaturePredicate.isValidSimpleSkill((input = (edge = (ProblemEdge)currentNode.getIncomingEdges().get(0)).getInput()).split(" ")[0])) {
                    this.simSt.setLastSkillOperand(input);
                }
            } else {
                killMessageReceived = true;
            }
            if (!currentNode.isDoneState()) continue;
            break;
        }
    }

    private SimStNode inspectRuleActivations(SimStNode currentNode, Collection<RuleActivationNode> activationList, HashMap hm) {
        String listAssessment = "";
        SimStNode nextCurrentNode = null;
        SimStNode successiveNode = null;
        RuleActivationNode backUpRAN = null;
        Iterator<RuleActivationNode> itr = activationList.iterator();
        for (RuleActivationNode ran : activationList) {
            if (ran.getActualInput().equalsIgnoreCase("FALSE") || ran.getActualInput().contains("n*i*l") || ran.getActualInput().contains("nil") || (successiveNode = this.inspectActivation(currentNode, ran)) == null) continue;
            hm.put(ran, successiveNode);
            if (nextCurrentNode == null && this.isTakingQuiz()) {
                if (successiveNode.getInDegree() > 0) {
                    String lastSkill = "";
                    if (this.simSt.getLastSkillOperand() != null && this.simSt.getLastSkillOperand().indexOf(32) >= 0) {
                        lastSkill = this.simSt.getLastSkillOperand().substring(0, this.simSt.getLastSkillOperand().indexOf(32));
                    }
                    if (((SimStEdge)successiveNode.getIncomingEdges().get(0)).isCorrect()) {
                        listAssessment = listAssessment + "Correct: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                        nextCurrentNode = successiveNode;
                    } else if (!ran.getActualInput().contains("FALSE")) {
                        listAssessment = listAssessment + "Backup: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                        nextCurrentNode = successiveNode;
                    } else {
                        listAssessment = listAssessment + "Not usable: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                    }
                }
            } else if (nextCurrentNode == null) {
                nextCurrentNode = successiveNode;
            }
            if (nextCurrentNode == null || !this.getSimSt().dontShowAllRA()) continue;
            break;
        }
        if (nextCurrentNode == null && this.isTakingQuiz() && backUpRAN != null) {
            listAssessment = listAssessment + "Backup used: " + backUpRAN.getName() + " " + backUpRAN.getActualInput() + "\n";
            nextCurrentNode = this.inspectActivation(currentNode, backUpRAN);
            hm.put(backUpRAN, nextCurrentNode);
        } else {
            listAssessment = listAssessment + "Not backup used\n";
        }
        trace.out("ss", listAssessment);
        this.simSt.setProblemStepString(this.simSt.getProblemAssessor().calcProblemStepString(this.getQuizGraph().getStartNode(), nextCurrentNode, null));
        return nextCurrentNode;
    }

    private SimStNode inspectActivation(SimStNode currentNode, RuleActivationNode ran) {
        SimStNode nextCurrentNode = null;
        Sai sai = this.getSai(ran);
        if (sai.getS().equals("NotSpecified") || sai.getI().equals("NotSpecified")) {
            return null;
        }
        SimStNode successiveNode = new SimStGraphNavigator().simulatePerformingStep(currentNode, sai);
        if (successiveNode != null) {
            SimStEdge edge = this.getQuizGraph().lookUpSSEdge(currentNode, successiveNode);
            edge.getEdgeData().getRuleNames().add(ran.getName());
            String problemName = this.getQuizGraph().getStartNode().getName();
            String inquiryResult = this.simSt.inquiryRuleActivation(problemName, currentNode, ran);
            if (inquiryResult.equals("Correct Action")) {
                nextCurrentNode = successiveNode;
            } else if (this.isTakingQuiz()) {
                if (!inquiryResult.equals("Correct Action")) {
                    edge.getEdgeData().setActionType("Error Action");
                }
                nextCurrentNode = successiveNode;
            }
        }
        return nextCurrentNode;
    }

    public void runInteractiveLearning() {
        this.simSt.setLastSkillOperand(null);
        ProblemNode currentNode = brController.getProblemModel().getStartNode();
        this.runInteractiveLearning(currentNode, true);
    }

    public void runInteractiveLearning(ProblemNode currentNode, boolean startWithActivations) {
        int numStepsPerformed = 0;
        int numStepsBrd = this.isRunningFromBrd() ? this.brdDepth() : -1;
        boolean killMessageReceived = false;
        boolean activations = startWithActivations;
        boolean askedExplanation = false;
        String lastSkillExplained = null;
        while (!(this.isRunningFromBrd() && numStepsPerformed == numStepsBrd && !brController.getMissController().isBatchModeOn() || killMessageReceived)) {
            if (brController.getMissController().isPLEon()) {
                brController.getMissController().getSimStPLE().getConversation().setBehaviourDiscrepency(false);
            }
            askedExplanation = false;
            String step = this.simSt.getProblemAssessor().calcProblemStepString(currentNode.getProblemModel().getStartNode(), currentNode, this.simSt.getLastSkillOperand());
            this.simSt.setProblemStepString(step);
            this.logger.simStLog("SIM_STUDENT_STEP", "New Step Started", step, "", "");
            long stepStartTime = Calendar.getInstance().getTimeInMillis();
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "----------------" + step + " IL: " + this.simSt.isInteractiveLearning());
            }
            if (brController.getMissController().isPLEon() && !this.isTakingQuiz()) {
                brController.getMissController().getSimStPLE().setAvatarThinking();
            }
            ProblemNode nextCurrentNode = null;
            if (activations) {
                long activationListStartTime = Calendar.getInstance().getTimeInMillis();
                Vector<RuleActivationNode> activationList = this.simSt.gatherActivationList(currentNode);
                Collection<RuleActivationNode> activList = this.simSt.createOrderedActivationList(activationList);
                if (this.simSt.isInteractiveLearning()) {
                    if (trace.getDebugCode("miss")) {
                        trace.out("miss", "activationList for " + brController.getProblemModel().getProblemName() + " >> " + activationList);
                    }
                    int activationListDuration = (int)(Calendar.getInstance().getTimeInMillis() - activationListStartTime);
                    if (this.logger.getLoggingEnabled()) {
                        this.logger.simStLog("SIM_STUDENT_LEARNING", "Activation Rules Determined", step, activList.size() + " rules found", (Object)"", activationListDuration);
                        int count = 0;
                        this.hint = this.simSt.askForHintQuizGradingOracle(brController, currentNode);
                        for (RuleActivationNode ran : activList) {
                            Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
                            if (sai.getI().equals("NotSpecified") || sai.getI().equals("FALSE")) continue;
                            ran.setAgendaIndex(count);
                            this.logger.simStLog("SIM_STUDENT_LEARNING", "Activation Rule Considered", step, "" + count, (Object)"", sai, currentNode, this.hint.getSelection(), this.hint.getAction(), this.hint.getInput());
                            ++count;
                        }
                    }
                    if ((nextCurrentNode = this.inspectAgendaRuleActivations(currentNode, activList)) == null && !this.isTakingQuiz() && !askedExplanation) {
                        for (RuleActivationNode ran : activList) {
                            if (ran.getActualInput().equalsIgnoreCase("FALSE") || ran.getActualInput().equalsIgnoreCase("NotSpecified")) continue;
                            if (lastSkillExplained != null && lastSkillExplained.equals(ran.getName())) break;
                            lastSkillExplained = ran.getName();
                            this.explainWhyWrong(ran);
                            askedExplanation = true;
                            break;
                        }
                    }
                }
            }
            activations = true;
            if (brController.getMissController().isPLEon() && !this.isTakingQuiz()) {
                brController.getMissController().getSimStPLE().setAvatarNormal();
            }
            boolean hintReceived = false;
            if (nextCurrentNode == null && !this.isTakingQuiz() && currentNode != null) {
                if (brController.getMissController().isPLEon()) {
                    brController.getMissController().getSimStPLE().isBehaviourDiscrepencyDetected(brController.getProblemName(), null);
                }
                nextCurrentNode = this.askWhatToDoNext(currentNode);
                hintReceived = true;
                if (trace.getDebugCode("ss")) {
                    trace.out("ss", "Calling askWhatToDoNext  currentNode: " + currentNode + " nextCurrentNode: " + nextCurrentNode);
                }
            }
            if (nextCurrentNode != null) {
                if (!askedExplanation && hintReceived) {
                    this.explainWhyRight(nextCurrentNode);
                }
                currentNode = nextCurrentNode;
                try {
                    Vector<Instruction> instnVector = new Vector<Instruction>();
                    brController.setCurrentNode2(currentNode);
                    Instruction instn = this.simSt.lookupInstructionWithNode(brController.getCurrentNode());
                    instnVector.clear();
                    instnVector.add(instn);
                }
                catch (Exception e) {
                    this.logger.simStLogException(e, "setCurrentNode2 to " + currentNode + " failed");
                }
                ++numStepsPerformed;
                if (currentNode.getIncomingEdges().size() > 0) {
                    ProblemEdge edge = currentNode.getIncomingEdges().get(0);
                    String input = edge.getInput();
                    if (FeaturePredicate.isSkillValid(input.split(" ")[0])) {
                        this.simSt.setLastSkillOperand(input);
                    }
                    if (brController.getMissController().isPLEon()) {
                        final SimStPeerTutoringPlatform platform = brController.getMissController().getSimStPLE().getSimStPeerTutoringPlatform();
                        if (edge.getSelection().equalsIgnoreCase("DONE")) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    platform.setUndoButtonText(brController.getMissController().getSimStPLE().getUndoButtonTitleString("done"));
                                }
                            });
                        } else {
                            final String undoText = brController.getMissController().getSimStPLE().getUndoButtonTitleString(input);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    platform.setUndoButtonText(undoText);
                                }
                            });
                        }
                    }
                }
            } else {
                killMessageReceived = true;
                if (!(this.getSimSt().isSsBatchMode() || this.getSimSt().isInteractiveLearning() || this.getSimSt().isNonInteractiveLearning())) {
                    this.simSt.setIsInteractiveLearning(false);
                    this.simSt.setIsNonInteractiveLearning(false);
                }
                if (trace.getDebugCode("ss")) {
                    trace.out("ss", "killMessageReceived is true.");
                }
                if (brController.getMissController().isPLEon() && !brController.getMissController().getSimStPLE().isStartStatus()) {
                    brController.getMissController().getSimStPLE().blockInput(true);
                }
            }
            int stepDuration = (int)(Calendar.getInstance().getTimeInMillis() - stepStartTime);
            step = brController.getMissController().getSimSt().getProblemStepString();
            this.logger.simStLog("SIM_STUDENT_STEP", "Step Completed", step, "", (Object)"", stepDuration);
            if (!currentNode.getDoneState()) continue;
            String solution = this.simSt.getProblemAssessor().determineSolution(brController.getProblemModel().getProblemName(), brController.getProblemModel().getStartNode());
            boolean correct = this.simSt.getProblemAssessor().isSolution(brController.getProblemModel().getProblemName(), solution);
            int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - this.getProblemStartTime());
            this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Reached Done State", this.simSt.getProblemStepString(), "", (Object)"", problemDuration);
            this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Answer Submitted", new Sai("Answer", "Submit", solution), correct);
            if (this.isTakingQuiz()) break;
            this.simSt.setIsInteractiveLearning(false);
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "Calling checkAnswer: " + brController.getProblemName() + " solution: " + solution + " correct: " + correct);
            }
            boolean verified = this.checkAnswer(brController.getProblemName(), solution, correct);
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "Called checkAnswer: verified " + verified);
            }
            if (brController.getMissController() != null && brController.getMissController().getSimSt() != null && brController.getMissController().getSimSt().isSsMetaTutorMode()) {
                if (verified) {
                    brController.getAmt().handleInterfaceAction("sssolutionCorrectness", "implicit", "correct");
                } else {
                    brController.getAmt().handleInterfaceAction("sssolutionCorrectness", "implicit", "incorrect");
                }
            }
            if (brController.getMissController().isPLEon() && verified) {
                brController.getMissController().getSimStPLE().setAvatarFinished();
                break;
            }
            if (!brController.getMissController().isPLEon()) break;
            brController.getMissController().getSimStPLE().setAvatarFinishedWrong();
            break;
        }
        this.pruneBadRules();
    }

    private boolean checkAnswer(String problem, String solution, boolean correct) {
        if (!this.simSt.isSelfExplainMode()) {
            return true;
        }
        boolean doCheck = false;
        if (Math.random() < 0.5) {
            doCheck = true;
        }
        if (this.simSt.isSs2014FractionAdditionAdhoc()) {
            doCheck = false;
        }
        if (brController.getMissController().isPLEon() && doCheck) {
            SimStPLE ple = brController.getMissController().getSimStPLE();
            ple.setAvatarThinking();
            return this.simSt.getProblemAssessor().performInteractiveAnswerCheck(ple, problem, solution);
        }
        return true;
    }

    private void pruneBadRules() {
        double average = 0.0;
        int total = 0;
        for (Object name : this.simSt.getRuleNames()) {
            String string = (String)name;
            Rule rule = this.simSt.getRule(string);
            int recencyValue = Rule.count;
            double ruleRating = rule.getAcceptedRatio();
            average += (double)(recencyValue -= rule.identity + rule.getAcceptedUses());
            ++total;
        }
        average /= (double)total;
        Vector<String> toRemove = new Vector<String>();
        for (Object e : this.simSt.getRuleNames()) {
            String ruleName = (String)e;
            Rule rule = this.simSt.getRule(ruleName);
            int recencyValue = Rule.count;
            double ruleRating = rule.getAcceptedRatio();
            if (!(ruleRating < 0.25) || !((double)recencyValue >= average) || (recencyValue -= rule.identity + rule.getAcceptedUses()) <= 5) continue;
            toRemove.add(ruleName);
        }
        for (String string : toRemove) {
            this.simSt.removeRule(string);
        }
        this.simSt.saveProductionRules(2);
    }

    private ProblemNode inspectAgendaRuleActivations(ProblemNode currentNode, Collection<RuleActivationNode> activationList) {
        ProblemNode nextCurrentNode = null;
        ProblemNode successiveNode = null;
        RuleActivationNode backupRan = null;
        String listAssessment = "";
        for (RuleActivationNode ran : activationList) {
            trace.out("ss", "Checking RAN: " + ran);
            if (ran.getActualInput().equalsIgnoreCase("FALSE")) continue;
            if (brController.getMissController().isPLEon()) {
                brController.getMissController().getSimStPLE().isBehaviourDiscrepencyDetected(brController.getProblemName(), ran);
            }
            if ((successiveNode = this.inspectRuleActivation(currentNode, ran)) == null) continue;
            if (nextCurrentNode == null && this.isTakingQuiz()) {
                if (successiveNode.getInDegree() > 0) {
                    String lastSkill = "";
                    if (this.simSt.getLastSkillOperand() != null && this.simSt.getLastSkillOperand().indexOf(32) >= 0) {
                        lastSkill = this.simSt.getLastSkillOperand().substring(0, this.simSt.getLastSkillOperand().indexOf(32));
                    }
                    if (successiveNode.getIncomingEdges().get(0).isCorrect()) {
                        listAssessment = listAssessment + "Correct: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                        nextCurrentNode = successiveNode;
                    } else if (!ran.getActualInput().contains("FALSE") && (this.simSt.getLastSkillOperand() == null || !ran.getName().contains(lastSkill)) || ran.getName().contains("typein")) {
                        listAssessment = listAssessment + "Backup: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                        backupRan = ran;
                        if (trace.getDebugCode("miss")) {
                            trace.out("miss", " backupRan: " + backupRan);
                        }
                    } else {
                        listAssessment = listAssessment + "Not usable: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
                    }
                }
            } else if (nextCurrentNode == null) {
                nextCurrentNode = successiveNode;
            }
            if (nextCurrentNode == null || !this.getSimSt().dontShowAllRA()) continue;
            break;
        }
        if (nextCurrentNode == null && this.isTakingQuiz() && backupRan != null) {
            listAssessment = listAssessment + "Backup used: " + backupRan.getName() + " " + backupRan.getActualInput() + "\n";
            nextCurrentNode = this.inspectRuleActivation(currentNode, backupRan);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "Backup used:");
            }
        } else {
            listAssessment = listAssessment + "Not backup used\n";
        }
        return nextCurrentNode;
    }

    private boolean isSelectionValidForSelfExplanation(String selection) {
        return this.simSt.getBrController().getMissController().getSimStPLE().getValidSelections() != null && this.simSt.getBrController().getMissController().getSimStPLE().getValidSelections().contains(selection);
    }

    private void explainWhyRight(ProblemNode node) {
        ProblemEdge edge = null;
        if (node.getInDegree() <= 0) {
            return;
        }
        edge = node.getIncomingEdges().get(0);
        if (edge.getEdgeData().getRuleNames().size() <= 0) {
            return;
        }
        String skillName = edge.getEdgeData().getRuleNames().get(edge.getEdgeData().getRuleNames().size() - 1);
        if (trace.getDebugCode("sstt")) {
            trace.out("sstt", "Why right TutalkI Trace skillName:" + skillName + "SAI = " + edge.getSai().getS() + ";" + edge.getSai().getA() + ";" + edge.getSai().getI());
        }
        if (this.simSt.isSelfExplainMode() && this.isSelectionValidForSelfExplanation(edge.getSelection())) {
            Sai sai = edge.getSai();
            String step = this.simSt.getProblemStepString();
            String question = "What is it about the equation that made you know to put " + sai.getI() + "?";
            if (sai.getS().equalsIgnoreCase("DONE")) {
                question = "How do you know that the problem is done?";
            }
            if (this.simSt.getTutalkEnabled()) {
                this.tutalkBridge.setProblemName(brController.getMissController().getSimSt().getProblemStepString());
                this.contextVariables.clear();
                this.contextVariables.addVariable("%sai_i%", sai.getI());
                String stepCV = step.replaceAll("_", "=");
                if (stepCV.contains("[")) {
                    String operation = "do something";
                    if (stepCV.contains("]")) {
                        operation = stepCV.substring(stepCV.indexOf("[1", stepCV.indexOf("]")));
                    }
                    stepCV = stepCV.substring(0, stepCV.indexOf("["));
                    stepCV = SimSt.convertFromSafeProblemName(stepCV);
                    stepCV = operation + " on " + stepCV;
                } else {
                    stepCV = SimSt.convertFromSafeProblemName(stepCV);
                }
                this.contextVariables.addVariable("%problemStepString%", stepCV);
                if (sai.getS().equalsIgnoreCase("DONE")) {
                    this.tutalkBridge.connect("why_right_done_dialog", this.contextVariables, "Hint Explained");
                } else {
                    this.tutalkBridge.connect("why_right_dialog", this.contextVariables, "Hint Explained");
                }
                while (this.tutalkBridge.getState() != 4) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException operation) {}
                }
                return;
            }
            String explanation = "";
            long explainRequestTime = Calendar.getInstance().getTimeInMillis();
            if (brController.getMissController().getSimStPLE() == null) {
                explanation = JOptionPane.showInputDialog(null, question, "Please Provide an Explanation", -1);
            } else {
                SimStPLE ple = brController.getMissController().getSimStPLE();
                explanation = ple.giveMessageFreeTextResponse(question);
                if (explanation != null && explanation.length() > 0) {
                    ple.giveMessage(ple.getConversation().getMessage("CONFIRM"));
                } else {
                    ple.giveMessage(ple.getConversation().getMessage("SKIPPED"));
                }
            }
            int explainDuration = (int)(Calendar.getInstance().getTimeInMillis() - explainRequestTime);
            step = brController.getMissController().getSimSt().getProblemStepString();
            if (explanation != null && explanation.length() > 0) {
                this.logger.simStLog("SIM_STUDENT_EXPLANATION", "Hint Explained", step, explanation, (Object)question, sai, explainDuration, question);
            } else {
                this.logger.simStLog("SIM_STUDENT_EXPLANATION", "Hint Explained", step, "Explanation Not Given", (Object)question, sai, explainDuration, question);
            }
        }
    }

    private void explainWhyWrong(RuleActivationNode ran) {
        if (this.simSt.isSelfExplainMode()) {
            Object widget;
            Object widget2;
            Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
            String ruleName = ran.getName().replaceAll("MAIN::", "");
            if (trace.getDebugCode("sstt")) {
                trace.out("sstt", "Why wrong TutalkI Trace skillName: " + ran.getName() + "SAI = " + sai.getS() + ";" + sai.getA() + ";" + sai.getI());
            }
            String step = this.simSt.getProblemStepString();
            String question = "Why shouldn't I put " + sai.getI() + "?";
            if (sai.getS().equalsIgnoreCase("DONE")) {
                question = "Why isn't the problem finished?";
            }
            if (this.simSt.getTutalkEnabled()) {
                this.tutalkBridge.setProblemName(step);
                this.contextVariables.clear();
                this.contextVariables.addVariable("%sai_i%", sai.getI());
                String stepCV = step.replaceAll("_", "=");
                if (stepCV.contains("[")) {
                    String operation = "do something";
                    if (stepCV.contains("]")) {
                        trace.out("ss", "Parsing: " + stepCV);
                        operation = stepCV.substring(stepCV.indexOf("[") + 1, stepCV.indexOf("]"));
                    }
                    stepCV = stepCV.substring(0, stepCV.indexOf("["));
                    stepCV = SimSt.convertFromSafeProblemName(stepCV);
                    stepCV = "\"" + operation + "\" and \"" + stepCV + "\"";
                } else {
                    stepCV = SimSt.convertFromSafeProblemName(stepCV);
                    stepCV = "\"" + stepCV + "\"";
                }
                this.contextVariables.addVariable("%problemStepString%", stepCV);
                String[] priorStep = this.getSimSt().instructionStepDesc(ruleName, sai, ran.getRuleFoas());
                this.contextVariables.addVariable("%prior_step%", priorStep[1]);
                this.contextVariables.addVariable("%prior_i%", priorStep[0]);
                if (sai.getS().equalsIgnoreCase("DONE")) {
                    this.tutalkBridge.connect("why_wrong_done_dialog", this.contextVariables, "Non-Confirmed Input Explained");
                } else {
                    this.tutalkBridge.connect("why_wrong_dialog", this.contextVariables, "Non-Confirmed Input Explained");
                }
                while (this.tutalkBridge.getState() != 4) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            if (ruleName.indexOf(38) > 0) {
                ruleName = ruleName.substring(0, ruleName.indexOf(38));
            }
            String explanation = "";
            if (brController.lookupWidgetByName(sai.getS()) != null && (widget2 = brController.lookupWidgetByName(sai.getS())) instanceof JCommTable.TableCell) {
                ((JCommTable.TableCell)widget2).setText(sai.getI());
                ((JCommTable.TableCell)widget2).setBackground(Color.pink);
            }
            long explainRequestTime = Calendar.getInstance().getTimeInMillis();
            if (brController.getMissController().getSimStPLE() == null) {
                explanation = JOptionPane.showInputDialog(null, question, "Please Provide an Explanation", -1);
            } else {
                SimStPLE ple = brController.getMissController().getSimStPLE();
                SimStPLE.QuestionAnswers qa = ple.getMatchingMistakeExplanation(ruleName, sai, this.simSt.getProblemStepString(), ran);
                if (qa == null) {
                    Object widget3;
                    if (brController.lookupWidgetByName(sai.getS()) != null && (widget3 = brController.lookupWidgetByName(sai.getS())) instanceof JCommTable.TableCell) {
                        ((JCommTable.TableCell)widget3).setText("");
                        ((JCommTable.TableCell)widget3).setBackground(Color.white);
                    }
                    return;
                }
                question = qa.getQuestion();
                explanation = ple.giveMessageSelectableResponse(question, qa.getAnswers());
                if (explanation != null && explanation.length() > 0) {
                    ple.giveMessage(ple.getConversation().getMessage("CONFIRM"));
                } else {
                    ple.giveMessage(ple.getConversation().getMessage("SKIPPED"));
                }
            }
            if (brController.lookupWidgetByName(sai.getS()) != null && (widget = brController.lookupWidgetByName(sai.getS())) instanceof JCommTable.TableCell) {
                ((JCommTable.TableCell)widget).setText("");
                ((JCommTable.TableCell)widget).setBackground(Color.white);
            }
            int explainDuration = (int)(Calendar.getInstance().getTimeInMillis() - explainRequestTime);
            if (explanation != null && explanation.length() > 0) {
                this.logger.simStLog("SIM_STUDENT_EXPLANATION", "Non-Confirmed Input Explained", step, explanation, (Object)question, sai, explainDuration, question);
            } else {
                this.logger.simStLog("SIM_STUDENT_EXPLANATION", "Non-Confirmed Input Explained", step, "Explanation Not Given", (Object)question, sai, explainDuration, question);
            }
        }
    }

    private ProblemNode inspectRuleActivation(ProblemNode currentNode, RuleActivationNode ran) {
        ProblemNode nextCurrentNode = null;
        this.secureCurrentNode(currentNode);
        Sai sai = this.getSai(ran);
        if (sai.getS().equals("NotSpecified") || sai.getI().equals("NotSpecified")) {
            return null;
        }
        ProblemNode successiveNode = this.simulatePerformingStep(currentNode, sai);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", " successiveNode: " + successiveNode);
        }
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        String step = startNode.getName();
        if (this.simSt.getProblemAssessor() != null) {
            step = this.simSt.getProblemAssessor().findLastStep(startNode, currentNode);
        }
        this.simSt.setProblemStep(step);
        if (successiveNode != null) {
            ProblemNode childInBRD;
            String skillName = this.removeAmpersand(ran.getName()) + " simStIL";
            ProblemEdge edge = this.updateEdgeSkillName(currentNode, successiveNode, skillName);
            String problemName = brController.getProblemModel().getStartNode().getName();
            edge.getEdgeData().setActionType("Given Action");
            String inquiryResult = this.simSt.inquiryRuleActivation(problemName, currentNode, ran);
            if (!inquiryResult.equals("Correct Action")) {
                SimStPLE ple = brController.getMissController().getSimStPLE();
                brController.getMissController().getSimSt().displayMessage("", ple.getConversation().getMessage("FEEDBACK_NEGATIVE", sai.getS(), sai.getI()));
            }
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "    >>>>> result: " + inquiryResult);
            }
            edge.getEdgeData().setActionType(inquiryResult);
            if (inquiryResult.equals("Correct Action")) {
                if (this.simSt.getHintMethod().equalsIgnoreCase("BRD")) {
                    childInBRD = this.getFirstCorrectChild(currentNode);
                    ProblemEdge edgeInBRD = this.simSt.lookupProblemEdge(currentNode, childInBRD);
                    if (this.doesEdgeMatchRan(edgeInBRD, ran)) {
                        nextCurrentNode = childInBRD;
                    }
                } else {
                    nextCurrentNode = successiveNode;
                }
                if (this.simSt.isILSignalPositive()) {
                    this.signalInstructionAsPositiveExample(ran, nextCurrentNode, sai, null);
                }
            } else if (this.isTakingQuiz()) {
                if (!inquiryResult.equals("Correct Action")) {
                    edge.getEdgeData().setActionType("Error Action");
                }
                if (this.simSt.getHintMethod().equalsIgnoreCase("BRD")) {
                    childInBRD = this.getFirstCorrectChild(currentNode);
                    ProblemEdge edgeInBRD = this.simSt.lookupProblemEdge(currentNode, childInBRD);
                    if (this.doesEdgeMatchRan(edgeInBRD, ran)) {
                        nextCurrentNode = childInBRD;
                    }
                } else {
                    nextCurrentNode = successiveNode;
                }
            } else {
                edge.getEdgeData().setActionType("Buggy Action");
                if (ran.getRuleFoas() != null && this.simSt.isILSignalNegative()) {
                    trace.out("miss", "InteractiveLearning: signalling negative example for " + ran.getName());
                    trace.out("miss", "ran.getRuleFoas() = " + ran.getRuleFoas());
                    this.signalInstructionAsNegativeExample(ran, successiveNode, sai);
                }
                brController.setCurrentNode2(brController.getProblemModel().getStartNode());
                brController.setCurrentNode2(currentNode);
            }
        }
        return nextCurrentNode;
    }

    protected ProblemEdge updateEdgeSkillName(ProblemNode currentNode, ProblemNode successiveNode, String skillName) {
        ProblemEdge edge = this.simSt.lookupProblemEdge(currentNode, successiveNode);
        try {
            if (edge != null) {
                edge.getEdgeData().getRuleLabels().get(0).setText(skillName.replaceAll("MAIN::", ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.simStLogException(e);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "runInteractiveLearning: step performed = " + edge);
        }
        return edge;
    }

    protected void secureCurrentNode(ProblemNode currentNode) {
        if (!brController.getCurrentNode().equals(currentNode)) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "currentNode (" + currentNode + ") disagrees with behavior recorder (" + brController.getCurrentNode() + ")");
            }
            brController.setCurrentNode2(currentNode);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "now it's set back to " + brController.getCurrentNode());
            }
        }
    }

    public ProblemNode askWhatToDoNext(ProblemNode currentNode) {
        String problemName = currentNode.getProblemModel().getProblemName();
        boolean successful = false;
        boolean stillLearning = true;
        ProblemNode node = null;
        trace.out("miss", "runInteractiveLearning: getting a hint on node " + currentNode);
        this.hint = this.simSt.askForHint(brController, currentNode);
        this.simSt.createNewNodeAndEdgeForHintReceived(this.hint, currentNode);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "askHint returning " + this.hint);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "After call to askHint currentNode: " + currentNode + " hint: " + this.hint);
        }
        trace.out("miss", "runInteractiveLearning: learning a skill " + this.hint.skillName);
        long learningStartTime = Calendar.getInstance().getTimeInMillis();
        int repeats = 0;
        do {
            this.foaCorrectness = true;
            learningStartTime = Calendar.getInstance().getTimeInMillis();
            if (this.hint.skillName.equals("-kill-interactive-learning-")) continue;
            if (brController.getMissController().isPLEon()) {
                brController.getMissController().getSimStPLE().setAvatarThinking();
            }
            this.simSt.stepDemonstrated(this.hint.node, this.hint.getSai(), this.hint.edge, null);
            int foaCount = 0;
            for (int i = 0; i < this.simSt.numCurrentFoA(); ++i) {
                ++foaCount;
            }
            if (foaCount >= 1) {
                trace.out("ss", "Hint: " + this.hint + " Node: " + this.hint.node);
                successful = this.simSt.changeInstructionName(this.hint.skillName, this.hint.node);
            } else {
                this.foaCorrectness = false;
            }
            if (successful) {
                node = this.hint.node;
                stillLearning = false;
            }
            if (brController.getMissController().isPLEon()) {
                brController.getMissController().getSimStPLE().setAvatarNormal();
            }
            if (!stillLearning || repeats >= this.simSt.getSsNumBadInputRetries()) continue;
            if (brController.getMissController().isPLEon()) {
                brController.getMissController().getSimStPLE().unblockOnly(this.hint.getSai().getS());
            }
            Instruction badInstr = this.simSt.lookupInstructionWithNode(this.hint.node);
            this.simSt.deleteBadInstruction(badInstr);
            Object widget = null;
            String selection = this.hint.getSai().getS();
            boolean result = false;
            if (currentNode.isStudentBeginsHereState()) {
                brController.goToStartState();
            } else {
                result = brController.goToState(currentNode);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "result: " + result);
                }
            }
            int failToLearnDuration = (int)(Calendar.getInstance().getTimeInMillis() - learningStartTime);
            int noInstructionsForSkill = brController.getMissController().getSimSt().getInstructionsFor(this.hint.skillName).size();
            String noInstructions = "Instruction Vector Size = " + noInstructionsForSkill;
            this.logger.simStLog("SIM_STUDENT_LEARNING", "Sim Student Did Not Learn On Input", this.simSt.getProblemStepString(), "Retries Remaining:" + (this.simSt.getSsNumBadInputRetries() - repeats) + " [" + noInstructions + "]", (Object)"", this.hint.getSai(), failToLearnDuration, this.hint.getRetryMessage()[0]);
            if (brController.getProblemModel() != null && problemName.equals(brController.getProblemModel().getProblemName())) {
                MessageObject mo = MessageObject.create("InterfaceAction");
                mo.setSelection(this.hint.getSelection());
                mo.setAction(this.hint.getAction());
                mo.setInput(this.hint.getInput());
                brController.handleCommMessage(mo);
                this.hint.getRetry(brController, currentNode);
                continue;
            }
            stillLearning = false;
            this.hint.skillName = "-kill-interactive-learning-";
        } while (stillLearning && ++repeats < this.simSt.getSsNumBadInputRetries() + 1);
        if (this.hint.skillName.equals("-kill-interactive-learning-")) {
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "---Kill Message---");
            }
            node = null;
        } else if (stillLearning && brController.getMissController().isPLEon()) {
            if (this.simSt.getSsNumBadInputRetries() != 0) {
                Instruction badInstr = this.simSt.lookupInstructionWithNode(this.hint.node);
                this.simSt.deleteBadInstruction(badInstr);
                this.simSt.setIsInteractiveLearning(false);
                int failToLearnDuration = (int)(Calendar.getInstance().getTimeInMillis() - learningStartTime);
                this.logger.simStLog("SIM_STUDENT_LEARNING", "Sim Student Gave Up Learning On Input", this.simSt.getProblemStepString(), this.hint.skillName, (Object)("Retries Remaining:" + (this.simSt.getSsNumBadInputRetries() - repeats)), this.hint.getSai(), failToLearnDuration, "I still don't get it.  Let's move on to another problem.  Is there an easier one we can try?");
                if (brController.getMissController().isPLEon()) {
                    SimStPLE ple = brController.getMissController().getSimStPLE();
                    ple.setAvatarConfused(true);
                    brController.getMissController().getSimSt().displayMessage("", ple.getConversation().getMessage("FAIL_TO_LEARN_GIVE_UP"));
                } else {
                    brController.getMissController().getSimSt().displayMessage("", "I still don't get it.  Let's move on to another problem.  Is there an easier one we can try?");
                }
                brController.getMissController().getSimStPLE().getSimStPeerTutoringPlatform().setUndoButtonEnabled(false);
            } else {
                int failToLearnDuration = (int)(Calendar.getInstance().getTimeInMillis() - learningStartTime);
                this.logger.simStLog("SIM_STUDENT_LEARNING", "Sim Student Gave Up Learning On Input", this.simSt.getProblemStepString(), this.hint.skillName, (Object)("Retries Remaining:" + (this.simSt.getSsNumBadInputRetries() - repeats)), this.hint.getSai(), failToLearnDuration, "");
            }
            node = null;
        }
        if (trace.getDebugCode("ss")) {
            trace.out("ss", "Node: " + node + " CurrentNode: " + brController.getCurrentNode());
        }
        return node;
    }

    public ProblemNode simulatePerformingStep(ProblemNode currentNode, Sai sai) {
        ProblemNode successiveNode = null;
        SimStNodeEdge nodeEdge = this.lookupNodeWithSai(sai, currentNode);
        if (nodeEdge == null || !nodeEdge.edge.isCorrect()) {
            nodeEdge = this.simSt.makeNewNodeAndEdge(sai, currentNode);
        }
        try {
            brController.setCurrentNode2(nodeEdge.node);
            successiveNode = nodeEdge.node;
            if (brController.getCurrentNode() != currentNode) {
                successiveNode = brController.getCurrentNode();
            } else if (trace.getDebugCode("miss")) {
                trace.out("miss", "getCurrentNode() disagrees with " + currentNode + "...");
            }
        }
        catch (Exception e) {
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "SimStInteractiveLearning.simulatePerformingStep() got " + e + "...");
            }
            e.printStackTrace();
            this.logger.simStLogException(e, "SimStInteractiveLearning.simulatePerformingStep() got " + e + "...");
        }
        return successiveNode;
    }

    private SimStNodeEdge lookupNodeWithSai(Sai sai, ProblemNode currentNode) {
        SimStNodeEdge nodeEdge = null;
        if (trace.getDebugCode("misIL")) {
            trace.out("misIL", "currentNode = " + currentNode);
        }
        if (trace.getDebugCode("misIL")) {
            trace.out("misIL", "sai = " + sai);
        }
        Vector<ProblemNode> children = currentNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ProblemNode child = children.get(i);
            ProblemEdge edge = this.simSt.lookupProblemEdge(currentNode, child);
            Sai edgeSai = edge.getSai();
            if (trace.getDebugCode("misIL")) {
                trace.out("misIL", "edge = " + edge);
            }
            if (trace.getDebugCode("misIL")) {
                trace.out("misIL", "edgeSai = " + edgeSai);
            }
            if (this.matches(edgeSai, sai)) {
                if (trace.getDebugCode("misIL")) {
                    trace.out("misIL", "matched");
                }
                nodeEdge = new SimStNodeEdge(child, edge);
                break;
            }
            if (!trace.getDebugCode("misIL")) continue;
            trace.out("misIL", "no match");
        }
        return nodeEdge;
    }

    public boolean matches(Sai sai1, Sai sai2) {
        return sai1.getS().equals(sai2.getS()) && sai1.getA().equals(sai2.getA()) && this.simSt.compairInput(sai1.getI(), sai2.getI());
    }

    private int brdDepth() {
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        ProblemNode lastNode = startNode.getDeadEnd();
        ProblemNode currNode = startNode;
        int edgeCount = 0;
        while (currNode != lastNode) {
            ++edgeCount;
            currNode = this.getFirstCorrectChild(currNode);
        }
        return edgeCount;
    }

    private boolean doesEdgeMatchRan(ProblemEdge edge, RuleActivationNode ran) {
        boolean result;
        if (trace.getDebugCode("simIL")) {
            trace.outln("simIL", "entered doesEdgeMatchRan.");
        }
        if (edge == null) {
            result = false;
        } else {
            EdgeData edgeData = edge.getEdgeData();
            String modelS = (String)edgeData.getSelection().get(0);
            String modelA = (String)edgeData.getAction().get(0);
            String modelI = (String)edgeData.getInput().get(0);
            String ranS = ran.getActualSelection();
            String ranA = ran.getActualAction();
            String ranI = ran.getActualInput();
            result = this.simSt.isStepModelTraced(ranS, ranA, ranI, modelS, modelA, modelI);
            if (trace.getDebugCode("simIL")) {
                trace.outln("simIL", "doesEdgeMatchRan: returning " + result);
            }
        }
        return result;
    }

    private ProblemNode getFirstCorrectChild(ProblemNode node) {
        ProblemNode result = null;
        Vector<ProblemNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ProblemNode child = (ProblemNode)children.get(i);
            ProblemEdge edge = this.simSt.lookupProblemEdge(node, child);
            if (!edge.getEdgeData().getActionType().equals("Correct Action")) continue;
            result = child;
            break;
        }
        return result;
    }

    protected String removeAmpersand(String ruleActivationName) {
        int index = ruleActivationName.lastIndexOf("&");
        String res = index == -1 ? ruleActivationName : ruleActivationName.substring(0, index);
        return res;
    }

    public static int getSelectionCol(String s) {
        char resChar = s.charAt(s.lastIndexOf("C") + 1);
        int res = Integer.valueOf(String.valueOf(resChar));
        return res;
    }

    public String currentStep(ProblemNode startNode, ProblemNode problemNode) {
        String lastEquation;
        Vector pathEdges = InquiryClAlgebraTutor.findPathDepthFirst(startNode, problemNode);
        String string = lastEquation = pathEdges != null ? this.step(pathEdges) : problemNode.getName();
        if (lastEquation == null) {
            lastEquation = pathEdges != null && pathEdges.size() > 0 ? startNode.getName() + "[" + ((ProblemEdge)pathEdges.get(0)).getInput() + "]" : startNode.getName();
        }
        return lastEquation;
    }

    private String step(Vector pathEdges) {
        String step = null;
        int edgeCount = 0;
        ProblemEdge[] edgeQueue = new ProblemEdge[3];
        for (int i = 0; i < pathEdges.size(); ++i) {
            edgeQueue[edgeCount++] = (ProblemEdge)pathEdges.get(i);
            if (step != null && edgeCount == 1) {
                step = step + "[" + edgeQueue[edgeCount - 1].getInput() + "]";
            }
            if (edgeCount != 3) continue;
            String[] eqSide = new String[2];
            for (int j = 0; j < 2; ++j) {
                String input;
                EdgeData edgeData = edgeQueue[j + 1].getEdgeData();
                eqSide[j] = input = (String)edgeData.getInput().get(0);
            }
            step = eqSide[0] + " = " + eqSide[1];
            edgeCount = 0;
        }
        return step;
    }

    public static int getSelectionRow(String s) {
        char resChar = s.charAt(s.lastIndexOf("R") + 1);
        int res = Integer.valueOf(String.valueOf(resChar));
        return res;
    }

    public AskHint askHint(BR_Controller brController2, ProblemNode currentNode) {
        if (brController.getMissController().getSimStPLE() != null) {
            brController.getMissController().getSimStPLE().setFocusTab(0);
        }
        AskHint hint = null;
        String methodName = this.simSt.getHintMethod();
        if (methodName.equalsIgnoreCase("BRD")) {
            hint = new AskHintBrd(brController, currentNode);
        } else if (methodName.equalsIgnoreCase("humanDemonstration")) {
            hint = new AskHintHumanOracle(brController, currentNode);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "hint has been returned:" + hint);
            }
        } else if (methodName.equalsIgnoreCase("fakeTutoringService")) {
            hint = new AskHintTutoringServiceFake(brController, currentNode, this);
        } else if (methodName.equalsIgnoreCase("clAlgebraTutor")) {
            hint = new AskHintClAlgebraTutor(brController, currentNode);
        } else if (methodName.equalsIgnoreCase("fakeClAlgebraTutor")) {
            hint = new AskHintFakeClAlgebraTutor(brController, currentNode);
        } else if (methodName.equalsIgnoreCase("builtInClSolverTutor")) {
            hint = new AskHintInBuiltClAlgebraTutor(brController, currentNode);
        } else {
            new Exception("No valid hint method was specified!").printStackTrace();
        }
        trace.out("miss", "askHint returning " + hint);
        return hint;
    }

    private void signalInstructionAsPositiveExample(RuleActivationNode ran, ProblemNode node, Sai sai, Vector edgePath) {
        Instruction instruction = this.makeInstruction(node, sai);
        String skillName = Rule.getRuleBaseName(ran.getName()).replaceAll("MAIN::", "");
        instruction.setName(skillName);
        this.simSt.sortInstruction(instruction);
        Rule rule = this.simSt.getRule(skillName);
        if (rule != null) {
            rule.addAcceptedUse(ran.getRuleFoas());
        }
        Vector ruleFoas = ran.getRuleFoas();
        List foaStrs = this.makeFoaStrings(ruleFoas);
        this.simSt.updateInstructionFoa(instruction, foaStrs);
        this.logger.simStLog("SIM_STUDENT_LEARNING", "Positive Example Received", this.simSt.getProblemStepString(), "FOA:" + instruction.getFocusOfAttention().toString(), (Object)"", sai);
        this.simSt.negateBadNegativeExample(instruction);
        this.simSt.updateLhsConditions(skillName);
        this.simSt.saveProductionRules(2);
    }

    private List makeFoaStrings(Vector foas) {
        Vector<String> foaStrs = new Vector<String>();
        MTRete rete = brController.getModelTracer().getRete();
        for (int i = 0; i < foas.size(); ++i) {
            String foa;
            String selection = foa = (String)foas.get(i);
            Fact wmeFact = rete.getFactByName(selection);
            try {
                Value inputValue = wmeFact.getSlotValue("value");
                String input = SimSt.stripQuotes(inputValue.toString());
                String wmeType = wmeFact.getName();
                String foaStr = wmeType + "|" + selection + "|" + input;
                if (trace.getDebugCode("ss")) {
                    trace.out("ss", "---FOA: " + foaStr);
                }
                foaStrs.add(foaStr);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.simStLogException(e);
            }
        }
        return foaStrs;
    }

    private void signalInstructionAsNegativeExample(RuleActivationNode ran, ProblemNode node, Sai sai) {
        Instruction instruction = this.makeInstruction(node, sai);
        Vector foas = ran.getRuleFoas();
        MTRete rete = brController.getModelTracer().getRete();
        String negTuples = "[";
        for (int i = 0; i < foas.size(); ++i) {
            String foa;
            String selection = foa = (String)foas.get(i);
            Fact wmeFact = rete.getFactByName(selection);
            try {
                Value inputValue = wmeFact.getSlotValue("value");
                String input = SimSt.stripQuotes(inputValue.toString());
                String wmeType = wmeFact.getName();
                String foaStr = wmeType + "|" + selection + "|" + input;
                instruction.addFocusOfAttention(foaStr);
                negTuples = negTuples + input + ", ";
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.simStLogException(e);
            }
        }
        negTuples = negTuples.substring(0, negTuples.length() - 2) + "]";
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "signalInstructionAsNegativeExample: " + negTuples);
        }
        this.logger.simStLog("SIM_STUDENT_LEARNING", "Negative Example Received", this.simSt.getProblemStepString(), "FOA:" + negTuples, (Object)"", sai);
        String skillName = Rule.getRuleBaseName(ran.getName()).replaceAll("MAIN::", "");
        instruction.setName(skillName);
        this.simSt.getRule(skillName).addRejectedUse(ran.getRuleFoas());
        this.simSt.negateBadPositiveExample(instruction);
        this.simSt.signalInstructionAsNegativeExample(instruction);
    }

    private Instruction makeInstruction(ProblemNode node, Sai sai) {
        String selection = sai.getS();
        String action = sai.getA();
        String input = sai.getI();
        String wmeType = this.simSt.getRete().wmeType(selection);
        String saiStr = wmeType + "|" + selection + "|" + input;
        Instruction instruction = new Instruction(node, saiStr);
        instruction.setAction(action);
        instruction.setRecent(true);
        return instruction;
    }

    protected Sai getSai(RuleActivationNode ran) {
        return new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
    }

    public Sai askHintAuthorShell(ProblemNode currentNode) {
        Vector[] oracleString = this.askHintHumanOracleShell(currentNode);
        Vector selectionV = oracleString[0];
        Vector actionV = oracleString[1];
        Vector inputV = oracleString[2];
        return new Sai(selectionV, actionV, inputV);
    }

    private Vector[] askHintHumanOracleShell(ProblemNode currentNode) {
        String title = "Please give SimStudent a demonstration";
        String[] message = new String[]{"SimStudent has run out of matching rules for node \"" + currentNode + "\".", "Please give SimStudent a hint in the form of a demonstration.", "Enter the SAI in the shell."};
        AbstractCtatWindow frame = brController.getActiveWindow();
        this.simSt.displayMessage(title, message);
        Vector[] result = null;
        try {
            Vector[] res;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String sai = "";
            String inputMessage = null;
            inputMessage = "enter the SAI>> ";
            while (sai.equals("")) {
                System.out.print(inputMessage);
                sai = br.readLine();
            }
            String[] sp = sai.split(",");
            String[] sArray = new String[]{sp[0]};
            Vector selectionV = this.makeVector(sArray);
            String[] aArray = new String[]{sp[1]};
            Vector actionV = this.makeVector(aArray);
            String[] iArray = new String[]{sp[2]};
            Vector inputV = this.makeVector(iArray);
            result = res = new Vector[]{selectionV, actionV, inputV};
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.simStLogException(e);
        }
        return result;
    }

    Vector makeVector(String[] ss) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < ss.length; ++i) {
            v.add(ss[i]);
        }
        return v;
    }

    Vector makeSingletonVector(String s) {
        String[] sa = new String[]{s};
        return this.makeVector(sa);
    }

    public static void hereIsTheRule(String s) {
        messageDrop.put(s);
    }

    static {
        isWaitingForDemonstration = false;
    }

    public class SaiNodeEdge {
        Sai sai;
        ProblemNode newNode;
        ProblemEdge newEdge;

        public SaiNodeEdge(Vector sV, Vector aV, Vector iV, ProblemNode nNode, ProblemEdge nEdge) {
            this.sai = new Sai(sV, aV, iV);
            this.newNode = nNode;
            this.newEdge = nEdge;
        }

        public SaiNodeEdge(String s, String a, String i, ProblemNode nNode, ProblemEdge nEdge) {
            this.sai = new Sai(s, a, i);
            this.newNode = nNode;
            this.newEdge = nEdge;
        }
    }
}

