/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.cs.lti.tutalk.script.Concept;
import edu.cmu.cs.lti.tutalk.script.Scenario;
import edu.cmu.cs.lti.tutalk.slim.FuzzyTurnEvaluator;
import edu.cmu.cs.lti.tutalk.slim.TuTalkAutomata;
import edu.cmu.cs.lti.tutalk.slim.TurnEvaluator;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.Describable;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import edu.cmu.pact.miss.SimStTutalkContextVariables;
import edu.cmu.pact.miss.WebStartFileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimStTutalk {
    public static final int TUTALK_STATE_INITIALIZING = 0;
    public static final int TUTALK_STATE_EXCEPTION = -1;
    public static final int TUTALK_STATE_DIALOG = 1;
    public static final int TUTALK_STATE_DONE = 4;
    public static final String FINAL_OKAY = "Okay.";
    private int tutalkState = 0;
    private boolean tutalkDebug = false;
    private String problemName = "Undefined";
    private Scenario sc;
    private TuTalkAutomata ttClient;
    private SimStInteractiveLearning interactiveActivity;
    private List<String> confusionStates;
    private Vector<Describable> describableFeatures;
    private Vector<String> queuedConcepts = new Vector();
    private Vector<String> curriculumConcepts;

    public boolean connect(String pScenario, SimStTutalkContextVariables contextVariables, String type) {
        int i;
        this.tutalkState = 1;
        String scFilename = pScenario + ".xml";
        File scFile = new File(scFilename);
        boolean scExists = scFile.exists();
        if (!scExists) {
            if (trace.getDebugCode("sstt")) {
                trace.out("sstt", "Oooops! The scenario " + scFilename + " isn't here. Nevermind!");
            }
            this.tutalkState = 4;
            return false;
        }
        this.sc = Scenario.loadScenario((String)scFilename);
        this.ttClient = new TuTalkAutomata("SimStudent", "InteractiveLearning");
        this.ttClient.setScenario(this.sc);
        this.ttClient.setEvaluator((TurnEvaluator)new FuzzyTurnEvaluator());
        for (i = 0; i < contextVariables.size(); ++i) {
            this.ttClient.addReplacementVariable(contextVariables.getNthVarName(i), contextVariables.getNthVarValue(i));
        }
        List turns = this.ttClient.start();
        while (true) {
            List expected;
            String finalQuestion = "";
            for (i = 0; i < turns.size(); ++i) {
                if (trace.getDebugCode("sstt")) {
                    trace.out("sstt", "\tResponse: " + (String)turns.get(i));
                }
                finalQuestion = (i == 0 ? "" : finalQuestion + "\n") + (String)turns.get(i);
            }
            trace.out("sstt", "Current Concept: " + this.ttClient.getLastConcept().getLabel());
            if (this.confusionStates.contains(this.ttClient.getLastConcept().getLabel()) && this.interactiveActivity.getSimSt().getMissController().getSimStPLE() != null) {
                this.interactiveActivity.getSimSt().getMissController().getSimStPLE().setAvatarConfused(true);
            }
            if ((expected = this.ttClient.getState().getExpected()).size() == 0) {
                if (trace.getDebugCode("sstt")) {
                    trace.out("sstt", "\tExpectedSize = 0; gonna break out!");
                }
                this.interactiveActivity.getSimSt().displayMessage("", finalQuestion);
                break;
            }
            if (finalQuestion.length() == 0) {
                if (trace.getDebugCode("sstt")) {
                    trace.out("sstt", "\tQuestion length = 0; gonna break out!");
                }
                this.interactiveActivity.getSimSt().displayMessage("", FINAL_OKAY);
                break;
            }
            List matchingConcepts = new ArrayList();
            String input = "";
            while (matchingConcepts.size() == 0) {
                input = this.getAnswer(finalQuestion, type);
                if (this.interactiveActivity.getSimSt().getMissController().isPLEon()) {
                    this.interactiveActivity.getSimSt().getMissController().getSimStPLE().setAvatarThinking();
                }
                matchingConcepts = this.ttClient.evaluateTuteeTurn(input);
            }
            turns = this.ttClient.progress((Concept)matchingConcepts.get(0));
            this.interactiveActivity.getLogger().simStLog("SIM_STUDENT_EXPLANATION", "Categorize Explanation", this.problemName, this.ttClient.getLastConcept().getLabel(), (Object)finalQuestion, 0, input);
            if (type.endsWith("-FollowUp")) continue;
            type = type + "-FollowUp";
        }
        while (!this.queuedConcepts.isEmpty()) {
            SimStTutalkContextVariables localContextVariables = new SimStTutalkContextVariables();
            String theConcept = this.queuedConcepts.remove(0);
            localContextVariables.addVariable("%concept%", theConcept);
            this.connect("what_concept", localContextVariables, "concept");
        }
        this.tutalkState = 4;
        return true;
    }

    private void updatePathValue(String filepath) {
        long startTime = System.currentTimeMillis();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            NodeList moduleNodes;
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(filepath);
            Node company = doc.getFirstChild();
            Node configuration = doc.getElementsByTagName("configuration").item(0);
            if (configuration != null && (moduleNodes = ((Element)configuration).getElementsByTagName("module")) != null && moduleNodes.getLength() > 0) {
                for (int i = 0; i < moduleNodes.getLength(); ++i) {
                    NodeList params;
                    Element module = (Element)moduleNodes.item(i);
                    if (!module.getAttribute("kind").equals("model") || (params = module.getElementsByTagName("param")) == null) continue;
                    for (int j = 0; j < params.getLength(); ++j) {
                        Node nodeAttr;
                        String text;
                        Element param = (Element)params.item(j);
                        if (!param.getAttribute("key").equals("path") || (text = (nodeAttr = param.getAttributes().getNamedItem("value")).getTextContent()).contains(WebStartFileDownloader.SimStWebStartDir)) continue;
                        text = text.replace("./", "");
                        nodeAttr.setTextContent(WebStartFileDownloader.SimStWebStartDir + text);
                    }
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filepath));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public SimStTutalk(String pTutalkUid, SimStInteractiveLearning pInteractiveActivity) {
        this.interactiveActivity = pInteractiveActivity;
        this.confusionStates = new LinkedList<String>();
        this.confusionStates.add("response-simst-undo");
        this.confusionStates.add("N5-response-simst");
    }

    public void setProblemName(String pProblemName) {
        this.problemName = pProblemName;
    }

    public void initialize() {
        this.describableFeatures = this.interactiveActivity.getSimSt().getAllFeatureDescriptions();
        for (int i = 0; i < this.describableFeatures.size(); ++i) {
            System.out.println("sstt: Description #" + i + ": " + this.describableFeatures.get(i).getFeatureName() + " -> " + this.describableFeatures.get(i).getDescriptions());
        }
        this.curriculumConcepts = this.interactiveActivity.getSimSt().getUnlearnedConcepts();
    }

    public int getState() {
        return this.tutalkState;
    }

    public void insertFeatureDescription(Describable featureDesc) {
        if (trace.getDebugCode("sstt")) {
            trace.out("sstt", "Got a feature description for " + featureDesc.getFeatureName());
        }
    }

    public String getAnswer(String question, String type) {
        if (trace.getDebugCode("sstt")) {
            trace.out("sstt", "Got question: " + question);
        }
        String explanation = "";
        long explainRequestTime = Calendar.getInstance().getTimeInMillis();
        explanation = this.interactiveActivity.getSimSt().getMissController().getSimStPLE() == null ? JOptionPane.showInputDialog(null, question, "Please Provide an Explanation", -1) : this.interactiveActivity.getSimSt().getMissController().getSimStPLE().giveMessageFreeTextResponse(question);
        int explainDuration = (int)(Calendar.getInstance().getTimeInMillis() - explainRequestTime);
        if (trace.getDebugCode("sstt")) {
            trace.out("sstt", "Got answer, submitting: " + explanation);
        }
        if (explanation != null && explanation.length() > 0) {
            this.interactiveActivity.getLogger().simStLog("SIM_STUDENT_EXPLANATION", type, this.problemName, explanation, (Object)question, explainDuration, question);
            for (int i = 0; i < this.curriculumConcepts.size(); ++i) {
                if (explanation.indexOf(this.curriculumConcepts.get(i)) <= -1) continue;
                if (trace.getDebugCode("sstt")) {
                    trace.out("sstt", "Need to acquire knowledge about: " + this.curriculumConcepts.get(i));
                }
                this.queuedConcepts.add(this.curriculumConcepts.get(i));
            }
        } else {
            this.interactiveActivity.getLogger().simStLog("SIM_STUDENT_EXPLANATION", type, this.problemName, "Explanation Not Given", (Object)question, explainDuration, question);
            explanation = "No answer given";
        }
        return explanation;
    }
}

