/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.AmlRete;
import java.util.StringTokenizer;
import java.util.Vector;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.Value;
import jess.ValueVector;
import jess.Variable;

public class WmePathNode
implements Cloneable {
    private static int varSymNum = 0;
    private WmePathNode child;
    private AmlRete rete;
    private String variable;
    private Fact wme;
    static String[] sensitiveSlots;
    private String parentSlotName;

    private static String genVarSym() {
        return "?var" + varSymNum++;
    }

    private static String genMvSym() {
        return "m" + varSymNum++;
    }

    private AmlRete getRete() {
        return this.rete;
    }

    private void setRete(AmlRete rete) {
        this.rete = rete;
    }

    String getVariable() {
        return this.variable;
    }

    private void setVariable(String var) {
        this.variable = var;
    }

    public Fact getWme() {
        return this.wme;
    }

    private void setWme(Fact wme) {
        this.wme = wme;
    }

    static void setSensitiveSlots(String[] slots) {
        sensitiveSlots = slots;
    }

    private String[] getSensitiveSlots() {
        return sensitiveSlots;
    }

    public WmePathNode(Fact wme, AmlRete rete) {
        this(WmePathNode.genVarSym(), wme, rete);
    }

    public WmePathNode(String var, Fact wme, AmlRete rete) {
        this.setRete(rete);
        this.setVariable(var);
        this.setWme(wme);
    }

    void setChild(WmePathNode myChild) {
        this.child = myChild;
    }

    public WmePathNode getChild() {
        return this.child;
    }

    String replaceVar(Fact targetWme) {
        String var = WmePathNode.genVarSym();
        Fact wme = this.getWme();
        try {
            Context c = this.getRete().getGlobalContext();
            Vector childSlots = this.getRete().getWmeChildSlots(wme.getName());
            for (String childSlot : childSlots) {
                ValueVector children = wme.getSlotValue(childSlot).listValue(c);
                ValueVector vVector = new ValueVector();
                for (int i = 0; i < children.size(); ++i) {
                    Fact fact = children.get(i).factValue(c);
                    if (fact.equals((Object)targetWme)) {
                        vVector.add((Value)new Variable(var.substring(1), 8));
                        continue;
                    }
                    vVector.add((Value)new Variable("", 8));
                }
                wme.setSlotValue(childSlot, new Value(vVector, 512));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return var;
    }

    boolean isUnifiable(WmePathNode node) {
        Fact thisWme = this.getWme();
        Fact thatWme = node.getWme();
        return thisWme.getName().equals(thatWme.getName()) && this.isUnifiable(thisWme, thatWme);
    }

    private boolean isUnifiable(Fact f1, Fact f2) {
        boolean test = true;
        Deftemplate deftemplate = f1.getDeftemplate();
        int nSlots = deftemplate.getNSlots();
        try {
            for (int i = 0; i < nSlots; ++i) {
                Value v2;
                Value v1;
                String slotName = deftemplate.getSlotName(i);
                if (!this.isSensitiveSlot(slotName) || this.isUnifiable(v1 = f1.getSlotValue(slotName), v2 = f2.getSlotValue(slotName))) continue;
                test = false;
                break;
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        return test;
    }

    private boolean isSensitiveSlot(String slotName) {
        boolean test = false;
        String[] sensitiveSlots = this.getSensitiveSlots();
        for (int i = 0; i < sensitiveSlots.length; ++i) {
            if (!slotName.equals(sensitiveSlots[i])) continue;
            test = true;
            break;
        }
        return test;
    }

    private boolean isUnifiable(Value v1, Value v2) {
        boolean test = false;
        try {
            switch (v1.type()) {
                case 512: {
                    Context c = this.getRete().getGlobalContext();
                    test = this.isUnifiable(v1.listValue(c), v2.listValue(c));
                    break;
                }
                default: {
                    test = v1.toString().equals(v2.toString());
                    break;
                }
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        return test;
    }

    private boolean isUnifiable(ValueVector v1, ValueVector v2) {
        boolean test = true;
        StringTokenizer st1 = new StringTokenizer(v1.toString());
        StringTokenizer st2 = new StringTokenizer(v2.toString());
        Vector<String> vs1 = new Vector<String>();
        while (st1.hasMoreTokens()) {
            vs1.add(st1.nextToken());
        }
        Vector<String> vs2 = new Vector<String>();
        while (st2.hasMoreTokens()) {
            vs2.add(st2.nextToken());
        }
        try {
            test = this.isUnifiable(this.car(vs1), this.cdr(vs1), this.car(vs2), this.cdr(vs2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return test;
    }

    private boolean isUnifiable(String s1, Vector vs1, String s2, Vector vs2) throws Exception {
        if (vs1.isEmpty() && vs2.isEmpty()) {
            return this.isUnifiable(s1, s2);
        }
        if (this.isUnifiable(s1, s2)) {
            if (this.isMultiVariable(s1)) {
                if (this.isVariable(s2)) {
                    return this.isUnifiable(this.car(vs1), this.cdr(vs1), s2, vs2);
                }
                if (!this.isMultiVariable(s2)) {
                    while (!vs2.isEmpty() && !this.isVariable(this.car(vs2))) {
                        vs2 = this.cdr(vs2);
                    }
                }
            }
            return this.isUnifiable(this.car(vs1), this.cdr(vs1), this.car(vs2), this.cdr(vs2));
        }
        return false;
    }

    private boolean isUnifiable(String s1, String s2) {
        boolean test = false;
        if (s1 == s2 || s1.equals(s2) || this.isMultiVariable(s1) || this.isVariable(s1) && this.isVariable(s2) || this.isAnonymousVar(s1) && this.isAnonymousVar(s2)) {
            test = true;
        }
        return test;
    }

    private boolean isMultiVariable(String s) {
        return s.startsWith("$?");
    }

    private boolean isVariable(String s) {
        return s.charAt(0) == '?' && s.length() > 1;
    }

    private boolean isAnonymousVar(String s) {
        return s.equals("?");
    }

    private String car(Vector v) {
        return v.isEmpty() ? null : (String)v.get(0);
    }

    private Vector cdr(Vector v) {
        return v.isEmpty() ? new Vector() : new Vector(v.subList(1, v.size()));
    }

    boolean isMostSpecific() {
        boolean test = false;
        if (this.rete.isTerminalWmeType(this.getWme().getName())) {
            test = true;
        } else {
            try {
                Context c = this.getRete().getGlobalContext();
                String slot = this.getChild().getParentSlotName();
                Value value = this.getWme().getSlotValue(slot);
                ValueVector children = value.listValue(c);
                String firstElement = children.get(0).toString();
                if (this.isAnonymousVar(firstElement) || this.isVariable(firstElement)) {
                    test = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return test;
    }

    WmePathNode generalize() {
        WmePathNode generalizedNode = (WmePathNode)this.clone();
        try {
            Context c = this.getRete().getGlobalContext();
            String childSlot = this.getChild().getParentSlotName();
            Value value = this.getWme().getSlotValue(childSlot);
            ValueVector children = value.listValue(c);
            if (children.size() == 1) {
                return null;
            }
            String var = null;
            for (int i = 0; i < children.size(); ++i) {
                String element2 = children.get(i).toString();
                if (!this.isVariable(element2)) continue;
                var = element2;
                break;
            }
            ValueVector generalizedValue = new ValueVector();
            generalizedValue.add((Value)new Variable(WmePathNode.genMvSym(), 8192));
            generalizedValue.add((Value)new Variable(var.substring(1), 8));
            generalizedValue.add((Value)new Variable("", 8192));
            Value gValue = new Value(generalizedValue, 512);
            generalizedNode.getWme().setSlotValue(childSlot, gValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return generalizedNode;
    }

    public String getParentSlotName() {
        return this.parentSlotName;
    }

    boolean isWmeType(String type) {
        return this.getWme().getName().equals(type);
    }

    boolean hasSameFact(Fact fact) {
        boolean test = false;
        if (this.getWme().getName().equals(fact.getName())) {
            try {
                String thisName = this.getWme().getSlotValue("name").toString();
                String thatName = fact.getSlotValue("name").toString();
                if (thisName.equals(thatName)) {
                    test = true;
                }
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        return test;
    }

    boolean hasSameWmeType(WmePathNode node) {
        return this.getWme().getName().equals(node.getWme().getName());
    }

    boolean hasSameSymbol(WmePathNode node) {
        return this.getVariable().equals(node.getVariable());
    }

    boolean hasMultivariable() {
        boolean test = false;
        Fact wme = this.getWme();
        Deftemplate deftemplate = wme.getDeftemplate();
        int nSlots = deftemplate.getNSlots();
        try {
            block2: for (int i = 0; i < nSlots && !test; ++i) {
                Value value;
                String slotName = deftemplate.getSlotName(i);
                if (!this.isSensitiveSlot(slotName) || (value = wme.getSlotValue(slotName)).type() != 512) continue;
                Context c = this.getRete().getGlobalContext();
                ValueVector vv = value.listValue(c);
                String vvStr = vv.toString();
                StringTokenizer tokens = new StringTokenizer(vvStr);
                while (tokens.hasMoreTokens()) {
                    String var = tokens.nextToken();
                    if (!this.isMultiVariable(var)) continue;
                    test = true;
                    continue block2;
                }
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        return test;
    }

    public Object clone() {
        WmePathNode cloneNode = null;
        try {
            cloneNode = (WmePathNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Fact cloneWme = (Fact)this.getWme().clone();
        cloneNode.setWme(cloneWme);
        Context c = this.getRete().getGlobalContext();
        try {
            Deftemplate deftemplate = this.wme.getDeftemplate();
            for (int i = 0; i < deftemplate.getNSlots(); ++i) {
                String slotName = deftemplate.getSlotName(i);
                Value originalValue = this.wme.getSlotValue(slotName);
                if (originalValue.type() != 512) continue;
                ValueVector originalVector = originalValue.listValue(c);
                ValueVector cloneVec = (ValueVector)originalVector.clone();
                Value cloneValue = new Value(cloneVec, 512);
                cloneWme.setSlotValue(slotName, cloneValue);
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        return cloneNode;
    }

    public String toString() {
        return this.getVariable() + " <- " + this.getWme();
    }

    public void setParentSlot(String slotName) {
        this.parentSlotName = slotName;
    }
}

