/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.MetaTutor.MetaTutorAvatarComponent;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Vector;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Value;
import jess.ValueVector;

public class APlusModelTracing {
    private static final long serialVersionUID = 1L;
    public static final String JESS_RULES_FILE = "mtbehavior.clp";
    public static final String WME_TYPES_MT_FILE = "wmeTypesMT.clp";
    public static final String PRODUCTION_RULES_MT_FILE = "productionRulesMT.pr";
    public static final String INIT_WM_MT_FILE = "initMT.wme";
    public static final int NOT_APPLICABLE = -1;
    static final int CORRECT = 1;
    static final int NOMODEL = 2;
    static final int BUGGY = 3;
    static final int FIREABLE = 4;
    static final int HINT = 5;
    private CTAT_Controller controller;
    private SimStLogger logger;
    private transient Fact studentValuesFact = null;
    private boolean modelTraceMode = false;
    private boolean isHint = false;
    private boolean isCLHint = false;
    private RuleActivationNode rootActivation;
    private RuleActivationTree tree;
    private RuleActivationNode nodeNowFiring;
    private int maxDepth;
    private ArrayList nodeSeq = new ArrayList();
    private SimStRete ssRete;
    private String hintSelection;
    private String studentSelection;
    private ArrayList<ArrayList<String>> menuOptionMessages = new ArrayList();
    private String studentAction;
    private String studentInput;
    private RuleActivationNode matchedNode;
    private RuleActivationNode hintNode;
    private Queue<Boolean> traceHistory;
    private int traceHistorySize = 10;
    private int incorrectCount = 0;
    HashMap<String, Integer> correctFirings;

    public CTAT_Controller getController() {
        return this.controller;
    }

    public void setController(CTAT_Controller controller) {
        this.controller = controller;
    }

    public void setLogger(SimStLogger log) {
        this.logger = log;
    }

    public SimStLogger getLogger() {
        return this.logger;
    }

    public boolean isModelTraceMode() {
        return this.modelTraceMode;
    }

    public void setModelTraceMode(boolean modelTraceMode) {
        this.modelTraceMode = modelTraceMode;
    }

    public boolean isHintTrace() {
        return this.isHint;
    }

    public boolean isCLHintTrace() {
        return this.isCLHint;
    }

    public RuleActivationNode getRootActivation() {
        return this.rootActivation;
    }

    public void setRootActivation(RuleActivationNode rootActivation) {
        this.rootActivation = rootActivation;
    }

    public RuleActivationTree getTree() {
        return this.tree;
    }

    public void setTree(RuleActivationTree tree) {
        this.tree = tree;
    }

    public RuleActivationNode getNodeNowFiring() {
        return this.nodeNowFiring;
    }

    public void setNodeNowFiring(RuleActivationNode nodeNowFiring) {
        this.nodeNowFiring = nodeNowFiring;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public SimStRete getSsRete() {
        return this.ssRete;
    }

    public void setSsRete(SimStRete ssRete) {
        this.ssRete = ssRete;
    }

    public String getStudentSelection() {
        return this.studentSelection;
    }

    public void setStudentSelection(String studentSelection) {
        this.studentSelection = studentSelection;
    }

    public ArrayList<ArrayList<String>> getMenuOptionMessages() {
        return this.menuOptionMessages;
    }

    public void setMenuOptionMessages(ArrayList<ArrayList<String>> menuOptionMessages) {
        this.menuOptionMessages = menuOptionMessages;
    }

    public String getStudentAction() {
        return this.studentAction;
    }

    public void setStudentAction(String studentAction) {
        this.studentAction = studentAction;
    }

    public String getStudentInput() {
        return this.studentInput;
    }

    public void setStudentInput(String studentInput) {
        this.studentInput = studentInput;
    }

    public RuleActivationNode getMatchedNode() {
        return this.matchedNode;
    }

    public void setMatchedNode(RuleActivationNode node) {
        this.matchedNode = node;
    }

    public RuleActivationNode getHintNode() {
        return this.hintNode;
    }

    public void setHintNode(RuleActivationNode node) {
        this.hintNode = node;
    }

    public void addTraceHistory(boolean trace2) {
        boolean remove;
        this.traceHistory.add(trace2);
        if (!trace2) {
            ++this.incorrectCount;
        }
        if (this.traceHistory.size() > this.traceHistorySize && !(remove = this.traceHistory.remove().booleanValue())) {
            --this.incorrectCount;
        }
    }

    public void setTraceHistorySize(int n) {
        this.traceHistorySize = n;
    }

    public int getTraceHistorySize() {
        return this.traceHistorySize;
    }

    public int getTraceHistoryIncorrectCount() {
        return this.incorrectCount;
    }

    private void addCorrectFiring(String rulename) {
        if (!this.correctFirings.containsKey(rulename)) {
            this.correctFirings.put(rulename, new Integer(1));
        } else {
            int val = this.correctFirings.get(rulename);
            int n = ++val;
            ++val;
            this.correctFirings.put(rulename, n);
        }
    }

    public HashMap<String, Integer> getCorrectFirings() {
        return this.correctFirings;
    }

    public APlusModelTracing(SimStRete rete) {
        this.ssRete = rete;
        this.traceHistory = new LinkedList<Boolean>();
    }

    public APlusModelTracing(SimStRete rete, CTAT_Controller controller) {
        this(rete);
        this.controller = controller;
        if (controller == null) {
            return;
        }
        this.logger = controller.getMissController().getSimStPLE().getSsInteractiveLearning().getLogger();
        this.tree = new RuleActivationTree(controller);
        this.setTree(this.tree);
        this.traceHistory = new LinkedList<Boolean>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runModelTrace(boolean isHint, boolean isCLHint, String selection, String action, String input, Vector messages) {
        this.setModelTraceMode(true);
        int rtnVal = Integer.MIN_VALUE;
        long startTime = new Date().getTime();
        APlusModelTracing aPlusModelTracing = this;
        synchronized (aPlusModelTracing) {
            rtnVal = this.modelTrace(isHint, isCLHint, selection, action, input, messages);
        }
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        this.setModelTraceMode(false);
        return rtnVal;
    }

    public int modelTrace(boolean isHint, boolean isCLHint, String selection, String action, String input, Vector messages) {
        this.isHint = isHint;
        this.isCLHint = isCLHint;
        this.studentSelection = selection;
        this.studentAction = action;
        this.studentInput = input;
        this.nodeSeq.clear();
        try {
            this.ssRete.setUp(new String[]{WME_TYPES_MT_FILE, INIT_WM_MT_FILE, PRODUCTION_RULES_MT_FILE});
            this.ssRete.add(this.getController().getMissController().getSimSt().getModelTraceWM());
            if (!(this.controller != null && this.controller.getMissController() != null && this.controller.getMissController().getSimSt() != null && this.controller.getMissController().getSimSt().getSsInteractiveLearning() != null && this.controller.getMissController().getSimSt().getSsInteractiveLearning().isTakingQuiz() || this.controller == null || this.controller.getMissController() == null || this.controller.getMissController().getSimSt() == null || this.controller.getMissController().getSimSt().getSsInteractiveLearning() == null)) {
                SimSt simStudent = this.controller.getMissController().getSimSt();
                ProblemNode currentNode = simStudent.getBrController().getSolutionState().getCurrentNode();
                if (currentNode != null && currentNode.getParents() != null && currentNode.getParents().isEmpty()) {
                    this.ssRete.init(currentNode.getName(), false);
                } else if (currentNode != null && currentNode.getParents() != null && !currentNode.getParents().isEmpty()) {
                    ProblemNode startNode = simStudent.getBrController().getProblemModel().getStartNode();
                    ProblemNode endNode = currentNode;
                    Vector pathEdges = MetaTutorAvatarComponent.findPathDepthFirst(startNode, endNode);
                    this.ssRete.goToWMState(startNode, pathEdges, false);
                }
            }
            this.studentValuesFact = new Fact(this.ssRete.findDeftemplate("studentValues"));
            this.studentValuesFact.setSlotValue("selection", new Value(selection, 2));
            this.studentValuesFact.setSlotValue("action", new Value(action, 2));
            this.studentValuesFact.setSlotValue("input", new Value(input, 2));
            this.ssRete.assertFact(this.studentValuesFact);
            ArrayList activations = new ArrayList();
            Iterator itr = this.ssRete.listActivations();
            while (itr.hasNext()) {
                activations.add(itr.next());
            }
            if (MetaTutorAvatarComponent.isWaitingForActivationList && selection.equalsIgnoreCase("activations")) {
                MetaTutorAvatarComponent.getaListDrop().put(activations);
                return 5;
            }
            if (isHint || isCLHint) {
                this.ssRete.eval("(bind ?*hintRequest* true)");
            } else {
                this.ssRete.eval("(bind ?*hintRequest* false)");
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.iterativeDeepening(this.ssRete.getMaxDepth(), selection, action, input);
        if (this.nodeSeq.size() > 0) {
            this.setMatchedNode((RuleActivationNode)this.nodeSeq.get(0));
            if (messages != null) {
                messages.addAll(this.getMessages(isHint, this.nodeSeq));
            }
            if (messages != null) {
                messages.addAll(this.getCLHintMessages(isCLHint, this.nodeSeq));
            }
            int rtnVal = isHint ? 5 : (this.isBuggyRuleSequence(this.nodeSeq) ? 3 : 1);
            return rtnVal;
        }
        return 2;
    }

    private Vector<String> getMessages(boolean isHint, List<RuleActivationNode> nodeSeq) {
        Vector<String> msgs = new Vector<String>();
        for (RuleActivationNode node : nodeSeq) {
            if (!isHint) continue;
            msgs.addAll(node.getHintMessages());
        }
        return msgs;
    }

    private Vector<String> getCLHintMessages(boolean isCLHint, List<RuleActivationNode> nodeSeq) {
        Vector<String> msgs = new Vector<String>();
        for (RuleActivationNode node : nodeSeq) {
            if (!isCLHint) continue;
            msgs.addAll(node.getCLHintMessages());
        }
        return msgs;
    }

    boolean isBuggyRuleSequence(List nodeSeq) {
        for (RuleActivationNode ruleActivationNode : nodeSeq) {
        }
        return false;
    }

    private boolean iterativeDeepening(int maxDepth, String selection, String action, String input) {
        this.maxDepth = maxDepth;
        int depth = 1;
        boolean searchSucceeded = false;
        boolean hint = false;
        boolean successfulTrace = false;
        boolean traced = false;
        String ruleSuccess = "";
        String ruleFail = "";
        String step = this.controller.getMissController().getSimSt().getProblemStepString();
        if (this.correctFirings == null) {
            this.correctFirings = new HashMap();
        }
        if (this.isCLHint || this.isHint) {
            hint = true;
        }
        try {
            do {
                this.rootActivation = RuleActivationNode.create(null, 0);
                if (this.tree != null) {
                    this.tree.reset(this.rootActivation);
                }
                RuleActivationNode root = this.rootActivation;
                root.saveState(this.ssRete);
                this.ssRete.add(this.getController().getMissController().getSimSt().getModelTraceWM());
                List wholeAgenda = this.ssRete.getAgendaAsList(null);
                root.createChildren(wholeAgenda, false);
                List children = root.getChildren();
                for (int i = 0; !searchSucceeded && i < children.size(); ++i) {
                    String ruleName;
                    RuleActivationNode child = (RuleActivationNode)children.get(i);
                    root.setUpState(this.ssRete, i);
                    searchSucceeded = this.newDepthLimited(child, hint, depth, selection, action, input);
                    if (searchSucceeded && !this.isHint && !this.isCLHint) {
                        this.addCorrectFiring(child.getName());
                    }
                    Sai sai = new Sai(selection, action, input);
                    if (searchSucceeded && !this.isHint && !this.isCLHint) {
                        if (child.getName().contains("update")) continue;
                        ruleName = child.getName().replaceAll("MAIN::", "");
                        if (trace.getDebugCode("rr")) {
                            trace.err("Success for rule: " + ruleName + "  for selection: " + selection);
                        }
                        this.logger.simStLog("SIM_STUDENT_METATUTOR", "Metatutor Model Traced", step, ruleName, (Object)"", sai, true);
                        if (ruleName.startsWith("BUG")) continue;
                        successfulTrace = true;
                        traced = true;
                        ruleSuccess = ruleName;
                        continue;
                    }
                    if (this.isHint || this.isCLHint || child.getName().contains("update")) continue;
                    ruleName = child.getName().replaceAll("MAIN::", "");
                    if (trace.getDebugCode("rr")) {
                        trace.err("Failure for rule: " + ruleName);
                    }
                    this.logger.simStLog("SIM_STUDENT_METATUTOR", "Metatutor Model Traced", step, ruleName, (Object)"", sai, false, child.getActualSelection(), child.getActualAction(), child.getActualInput());
                    if (ruleName.startsWith("BUG")) continue;
                    traced = true;
                    ruleFail = ruleName;
                }
                ++this.maxDepth;
            } while (!searchSucceeded && this.maxDepth <= this.ssRete.getMaxDepth());
            if (traced) {
                this.addTraceHistory(successfulTrace);
            }
            return searchSucceeded;
        }
        catch (Exception e) {
            trace.err("Error from interativeDeepening at depth: " + depth + ": " + e);
            e.printStackTrace();
            return false;
        }
    }

    private boolean newDepthLimited(RuleActivationNode node, boolean isHint, int depth, String selection, String action, String input) throws Exception {
        if (depth > this.maxDepth) {
            return false;
        }
        node.setStudentSAI(selection, action, input);
        this.nodeNowFiring = node;
        List childActivations = node.fire(this.ssRete);
        this.nodeNowFiring = null;
        int result = node.getMatchResult();
        if (result == 4) {
            result = isHint ? node.isStudentSelectionFound(selection, this.ssRete.getGlobalContext()) : node.isStudentSAIFound(selection, action, input, isHint, this.ssRete.getGlobalContext());
        }
        this.setHintSelection(isHint, result, node);
        node.saveState(this.ssRete);
        if (this.searchSucceeded(isHint, result)) {
            node.getNodeSequence(this.nodeSeq);
            return true;
        }
        if (this.endSearch(isHint, result)) {
            return false;
        }
        if (depth >= this.maxDepth) {
            return false;
        }
        return false;
    }

    private boolean endSearch(boolean isHint, int result) {
        boolean outcome = false;
        if (this.searchSucceeded(isHint, result)) {
            outcome = true;
        } else if (result == 2) {
            outcome = true;
        }
        return outcome;
    }

    private boolean searchSucceeded(boolean isHint, int result) {
        if (isHint) {
            return result == 1 || result == 2;
        }
        return result == 1;
    }

    public static boolean isSAIToBeModelTraced(String sel, String act) {
        return act.indexOf("UpdateTable") != -1 || act.indexOf("ButtonPressed") != -1 || act.indexOf("TabClicked") != -1 || act.indexOf("StartProblem") != -1 || act.indexOf("implicit") != -1 && !sel.equalsIgnoreCase("hint") && !sel.equalsIgnoreCase("help") && !sel.equalsIgnoreCase("activations");
    }

    public void setRuleSAI(String predictedSelection, String predictedAction, String predictedInput) {
        if (this.nodeNowFiring == null) {
            trace.err("setRuleSAI called with (" + predictedSelection + ", " + predictedAction + ", " + predictedInput + " ) when nodeNowFiring is null");
        } else {
            this.nodeNowFiring.setRuleSAI(predictedSelection, predictedAction, predictedInput, "NotSpecified");
        }
    }

    private void setHintSelection(boolean isHint, int result, RuleActivationNode node) {
        if (!isHint) {
            return;
        }
        if (result == 1) {
            this.hintSelection = node.getActualSelection();
        } else if (this.hintSelection == null && result == 2) {
            this.hintSelection = node.getActualSelection();
        }
    }

    public void setFiringNodeMessages(ValueVector msgVV, Context context) {
        if (this.nodeNowFiring == null) {
            trace.err("setFiringNodeMessages called (" + msgVV.toStringWithParens() + ", " + context + ") when nodeNowFiring is null");
        } else {
            try {
                this.nodeNowFiring.setHintMessages(msgVV, context);
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
    }

    public void setFiringNodeCLHintMessages(ValueVector msgVV, Context context) {
        if (this.nodeNowFiring == null) {
            trace.err("setFiringNodeMessages called (" + msgVV.toStringWithParens() + ", " + context + ") when nodeNowFiring is null");
        } else {
            try {
                this.nodeNowFiring.setCLHintMessages(msgVV, context);
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
    }

    public void setMenuOptionMessages(ValueVector msgVV, Context context) {
        this.menuOptionMessages = new ArrayList();
        try {
            this.setMenuMessages(this.menuOptionMessages, msgVV, context);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
    }

    private void setMenuMessages(ArrayList<ArrayList<String>> menuOptionMessages, ValueVector msgVV, Context context) throws JessException {
        for (int i = 0; i < msgVV.size(); ++i) {
            Value msgV = msgVV.get(i);
            Value resolvedV = msgV.resolveValue(context);
            String msg = resolvedV.stringValue(context);
            if (msg != null) {
                msg = msg.trim();
            }
            if (msg.length() <= 0) continue;
            String[] tokens = msg.split(":");
            if (tokens.length == 2) {
                ArrayList<String> msgContent = new ArrayList<String>();
                msgContent.add(tokens[0]);
                msgContent.add(tokens[1]);
                menuOptionMessages.add(msgContent);
                continue;
            }
            trace.err("Format of menuMessages is incorrect");
        }
    }
}

