/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import cl.utilities.sm.BadExpressionError;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.InquiryClSolverTutor;
import edu.cmu.pact.miss.SAIConverter;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import pact.CommWidgets.JCommTable;

public class CheckCorrectnessSimStStep
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CHECK_CORRECTNESS_SIMSTSTEP = "check-correctness-simststep";
    private static final String NOT_SPECIFIED = "NotSpecified";
    protected transient APlusModelTracing amt;
    protected transient Context context;

    public CheckCorrectnessSimStStep() {
    }

    public CheckCorrectnessSimStStep(APlusModelTracing amt) {
        this.amt = amt;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        ProblemNode currentNode = null;
        String result = "";
        this.context = context;
        if (!vv.get(0).stringValue(context).equals(CHECK_CORRECTNESS_SIMSTSTEP)) {
            throw new JessException(CHECK_CORRECTNESS_SIMSTSTEP, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        if (context.getEngine() instanceof SimStRete) {
            if (this.amt == null) {
                this.amt = ((SimStRete)context.getEngine()).getAmt();
            }
            if (this.amt != null && this.amt.getController() != null && this.amt.getController() instanceof BR_Controller && this.amt.getController().getMissController() != null && this.amt.getController().getMissController().getSimSt() != null && (currentNode = ((BR_Controller)this.amt.getController()).getCurrentNode()) != null && currentNode != this.amt.getController().getProblemModel().getStartNode()) {
                SimSt ss = this.amt.getController().getMissController().getSimSt();
                InquiryClSolverTutor inBuiltCLSolverTutor = new InquiryClSolverTutor();
                ProblemNode prevNode = (ProblemNode)currentNode.getParents().get(0);
                if (ss.isSaiConverterDefined()) {
                    try {
                        inBuiltCLSolverTutor.setSAIConverter((SAIConverter)ss.getSaiConverterClass().newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (prevNode != null) {
                    Enumeration<ProblemEdge> edges = ((BR_Controller)this.amt.getController()).getProblemModel().getProblemGraph().getIncomingEdges(currentNode);
                    while (edges.hasMoreElements()) {
                        ProblemEdge edge = edges.nextElement();
                        if (edge.source != prevNode || edge.dest != currentNode) continue;
                        Sai edgeSAI = edge.getSai();
                        int numPrevSteps = inBuiltCLSolverTutor.goToState((BR_Controller)this.amt.getController(), prevNode);
                        if (edgeSAI.getS().equalsIgnoreCase(NOT_SPECIFIED)) {
                            return Funcall.FALSE;
                        }
                        if (edgeSAI.getS().equalsIgnoreCase("DONE")) {
                            String nextStep = inBuiltCLSolverTutor.askNextStep();
                            String clAction = nextStep.split(";")[1];
                            if (edgeSAI.getS().equalsIgnoreCase(clAction)) {
                                return Funcall.TRUE;
                            }
                            return Funcall.FALSE;
                        }
                        try {
                            if (inBuiltCLSolverTutor.getSAIConverter().validSelection(edgeSAI.getS(), numPrevSteps)) {
                                String string = result = inBuiltCLSolverTutor.isCorrectStep(edgeSAI.getS(), edgeSAI.getA(), edgeSAI.getI()) ? "Correct Action" : "Error Action";
                                if (result.equals("Error Action")) {
                                    result = this.validateCLResponse(edgeSAI.getS(), edgeSAI.getA(), edgeSAI.getI(), inBuiltCLSolverTutor);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (result.equalsIgnoreCase("Correct Action")) {
                            return Funcall.TRUE;
                        }
                        if (!result.equalsIgnoreCase("Error Action")) continue;
                        return Funcall.FALSE;
                    }
                }
            }
        }
        return Funcall.FALSE;
    }

    private String validateCLResponse(String selection, String action, String input, InquiryClSolverTutor bist) {
        String result = "Error Action";
        String exp1 = null;
        String exp2 = null;
        if ((BR_Controller)this.amt.getController() != null && ((BR_Controller)this.amt.getController()).getMissController() != null && ((BR_Controller)this.amt.getController()).getMissController().getSimSt() != null) {
            if (input.contains(" ") || !((BR_Controller)this.amt.getController()).getMissController().getSimSt().isFoaGetterDefined()) {
                return result;
            }
            Vector foas = ((BR_Controller)this.amt.getController()).getMissController().getSimSt().getFoaGetter().foaGetter((BR_Controller)this.amt.getController(), selection, action, input, null);
            if (foas.size() < 2) {
                return result;
            }
            JCommTable.TableExpressionCell skillCell = (JCommTable.TableExpressionCell)foas.get(0);
            JCommTable.TableExpressionCell sideCell = (JCommTable.TableExpressionCell)foas.get(1);
            if (skillCell != null && (skillCell.getText().startsWith("combine") || skillCell.getText().startsWith("clt") || skillCell.getText().startsWith("distribute"))) {
                if (sideCell.getText().equals(input)) {
                    result = "Correct Action";
                    return result;
                }
                result = "Error Action";
                return result;
            }
            if (sideCell != null && (sideCell.getText().startsWith("combine") || sideCell.getText().startsWith("clt") || sideCell.getText().startsWith("distribute"))) {
                if (skillCell.getText().equals(input)) {
                    result = "Correct Action";
                    return result;
                }
                result = "Error Action";
                return result;
            }
            boolean correctNess = false;
            try {
                exp1 = bist.getSm().standardize(input, true);
                exp2 = bist.getSm().standardize(bist.askNextStep().split(";")[2], true);
                correctNess = bist.getSm().algebraicEqual(exp1, exp2);
            }
            catch (BadExpressionError err) {
                err.printStackTrace();
            }
            if (correctNess) {
                result = "Correct Action";
                return result;
            }
        }
        return result;
    }

    public String getName() {
        return CHECK_CORRECTNESS_SIMSTSTEP;
    }
}

