/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.storage;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.WebStartFileDownloader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileZipper {
    private static final int BUFFER_SIZE = 2048;
    private static final String FOIL_LOG_DIR = "foil-log";
    private static final String LOG_DIR = "log";
    private static final String PR_AGE_DIR = "PR-age";
    private static String[] files = new String[]{WebStartFileDownloader.SimStWebStartDir + "foil-log", WebStartFileDownloader.SimStWebStartDir + "log", WebStartFileDownloader.SimStWebStartDir + "PR-age"};
    private static boolean formattedDateInitialized = false;
    private static String fmtDate = "";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static boolean removeOldFiles = true;

    public static void archiveFiles(String userID) throws IOException {
        long startTime = System.currentTimeMillis();
        FileOutputStream dest = null;
        CheckedOutputStream checksum = null;
        ZipOutputStream zos = null;
        Object origin = null;
        dest = new FileOutputStream(WebStartFileDownloader.SimStWebStartDir + userID + "_" + FileZipper.formattedDate() + ".zip");
        checksum = new CheckedOutputStream(dest, new Adler32());
        zos = new ZipOutputStream(new BufferedOutputStream(checksum));
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i] + "_" + userID + "_" + FileZipper.formattedDate();
            File f = new File(fileName);
            FileZipper.visitAllFiles("", f, zos);
        }
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "Time to archive files took: " + (System.currentTimeMillis() - startTime) + " msec.");
        }
        zos.flush();
        zos.close();
    }

    public static String formattedDate() {
        if (formattedDateInitialized) {
            return fmtDate;
        }
        formattedDateInitialized = true;
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        fmtDate = dateFormat.format(cal.getTime());
        return fmtDate;
    }

    public static void removeOldFiles() {
        if (removeOldFiles) {
            for (int i = 0; i < files.length; ++i) {
                FileZipper.deleteDir(new File(files[i]));
            }
            removeOldFiles = false;
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] files = dir.list();
            for (int i = 0; i < files.length; ++i) {
                boolean result = FileZipper.deleteDir(new File(dir, files[i]));
                if (result) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void visitAllFiles(String path, File dir, ZipOutputStream zos) throws IOException {
        if (dir != null && dir.list() != null && dir.list().length == 0) {
            zos.putNextEntry(new ZipEntry(path + FILE_SEPARATOR + dir.getName() + "/"));
            return;
        }
        if (dir != null && dir.list() != null) {
            for (String fileName : dir.list()) {
                if (path.equals("")) {
                    FileZipper.addFileToZip(dir.getName(), dir.getAbsolutePath() + FILE_SEPARATOR + fileName, zos);
                    continue;
                }
                FileZipper.addFileToZip(path + FILE_SEPARATOR + dir.getName(), dir.getAbsolutePath() + FILE_SEPARATOR + fileName, zos);
            }
        }
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zos) throws IOException {
        File file = new File(srcFile);
        if (file.isDirectory()) {
            FileZipper.visitAllFiles(path, file, zos);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zos.putNextEntry(new ZipEntry(path + FILE_SEPARATOR + file.getName()));
            while ((len = in.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        long startTime = System.currentTimeMillis();
        FileOutputStream dest = null;
        CheckedOutputStream checksum = null;
        ZipOutputStream zos = null;
        Object origin = null;
        String[] files = new String[]{"C:\\pact-cvs-tree\\Tutors\\SimSt\\WebStart\\SimStAlgebraV8\\foil-log", "C:\\pact-cvs-tree\\Tutors\\SimSt\\WebStart\\SimStAlgebraV8\\log", "C:\\pact-cvs-tree\\Tutors\\SimSt\\WebStart\\SimStAlgebraV8\\PR-age"};
        dest = new FileOutputStream("C:\\pact-cvs-tree\\Tutors\\SimSt\\WebStart\\SimStAlgebraV8\\archive-TestSS.zip");
        checksum = new CheckedOutputStream(dest, new Adler32());
        zos = new ZipOutputStream(new BufferedOutputStream(checksum));
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            FileZipper.visitAllFiles("", f, zos);
        }
        System.out.println("CheckSum: " + checksum.getChecksum().getValue() + " duration: " + (System.currentTimeMillis() - startTime));
        zos.flush();
        zos.close();
    }
}

