/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra;

import cl.utilities.sm.BadExpressionError;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.InquiryClSolverTutor;
import edu.cmu.pact.miss.RhsGoalTest;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.io.IOException;
import java.util.Vector;
import mylib.MathLib;

public abstract class EqFeaturePredicate
extends FeaturePredicate {
    private static final long serialVersionUID = 5920731597367735107L;
    public String s;
    public String sLO;
    public String sRO;
    private static final float OLD_ALLOWANCE = 0.01f;
    private static final float ALLOWANCE = new Float(1.0E-4).floatValue();
    private static final String LIST_SEPARATOR = " ";
    public static String[] basicArithmeticSkills = new String[]{"add", "divide", "subtract", "multiply"};
    public static String[] operandArithmeticSkills = new String[]{"add", "divide", "subtract", "multiply", "clt", "mt", "distribute", "rf"};
    public static String[] validSimpleSkillNames = new String[]{"add", "clt", "combine", "divide", "rf", "subtract", "mt", "distribute", "rds", "aproot", "ivm", "multiply", "done"};
    public static String[] validSimplificationSkillNames = new String[]{"clt", "rf", "mt", "rds", "distribute"};

    public static boolean isBasicArithmeticSkill(String name) {
        return EqFeaturePredicate.isListMember(name, basicArithmeticSkills);
    }

    public static boolean isOperandArithmeticSkill(String name) {
        return EqFeaturePredicate.isListMember(name, operandArithmeticSkills);
    }

    public static boolean isValidSimpleSkill(String exp) {
        return EqFeaturePredicate.isListMember(exp, validSimpleSkillNames);
    }

    public static boolean isValidSimplificationSkill(String skill) {
        return EqFeaturePredicate.isListMember(skill, validSimplificationSkillNames);
    }

    public static boolean isListMember(String name, String[] list) {
        boolean isListMember = false;
        if (name != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!name.equals(list[i])) continue;
                isListMember = true;
                break;
            }
        }
        return isListMember;
    }

    public static boolean isArithmeticExpression(String exp) {
        if (exp.length() < 1) {
            return false;
        }
        if (exp.toUpperCase().indexOf("FALSE") > -1) {
            return false;
        }
        if (exp.indexOf(32) > -1) {
            return false;
        }
        if (EqFeaturePredicate.isValidSimpleSkill(exp)) {
            return false;
        }
        return !EqFeaturePredicate.isExprList(exp);
    }

    public static boolean isSkillOperand(String exp) {
        String[] token;
        boolean isSkillOperand = false;
        int spaceIdx = exp.indexOf(32);
        if (spaceIdx > 0 && (token = exp.split(LIST_SEPARATOR)).length == 2 && EqFeaturePredicate.isValidSimpleSkill(token[0]) && EqFeaturePredicate.isArithmeticExpression(token[1])) {
            isSkillOperand = true;
        }
        return isSkillOperand;
    }

    public static String getSkillOperandSkill(String skillOperand) {
        String skill = null;
        if (EqFeaturePredicate.isSkillOperand(skillOperand)) {
            skill = skillOperand.split(LIST_SEPARATOR)[0];
        }
        return skill;
    }

    public static String getSkillOperandOperand(String skillOperand) {
        String operand = null;
        if (EqFeaturePredicate.isSkillOperand(skillOperand)) {
            operand = skillOperand.split(LIST_SEPARATOR)[1];
        }
        return operand;
    }

    public static boolean isExprList(String s) {
        boolean isExprList = false;
        if (s != null && s.length() > 0 && s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
            isExprList = true;
        }
        return isExprList;
    }

    public String subTerm(String expString1, String expString2) {
        if (expString1.equalsIgnoreCase(expString2)) {
            return "0";
        }
        String subTerm = null;
        if (EqFeaturePredicate.isArithmeticExpression(expString1) && EqFeaturePredicate.isArithmeticExpression(expString2)) {
            String negExpString2 = this.reverseSign(expString2);
            subTerm = this.addTerm(expString1, negExpString2);
        }
        return subTerm;
    }

    public String addTerm(String expString1, String expString2) {
        String addTerm = null;
        if (EqFeaturePredicate.isArithmeticExpression(expString1) && EqFeaturePredicate.isArithmeticExpression(expString2)) {
            try {
                AlgExp e1 = AlgExp.parseExp(expString1);
                AlgExp e2 = AlgExp.parseExp(expString2);
                AlgExp result = e1.add(e2);
                addTerm = result.isPolynomial() ? ((Polynomial)result).evalAdd().toString() : result.toString();
            }
            catch (ExpParseException e) {
                e.printStackTrace();
            }
        }
        return addTerm;
    }

    public ComplexTerm[] getTerms(Polynomial p) {
        ComplexTerm[] result = null;
        return result;
    }

    public Polynomial makePolynomial() {
        return null;
    }

    public String mulTerm(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        String mulTerm = null;
        try {
            AlgExp result;
            AlgExp e1 = AlgExp.parseExp(expString1);
            AlgExp e2 = AlgExp.parseExp(expString2);
            if (e1.isPolynomial() || e2.isPolynomial()) {
                return null;
            }
            if (e1.isFraction()) {
                AlgExp d1 = ((ComplexFraction)e1).getDenominator();
                AlgExp n1 = ((ComplexFraction)e1).getNumerator();
                if (!d1.isSimple() || !n1.isSimple()) {
                    return null;
                }
            }
            if (e2.isFraction()) {
                AlgExp d2 = ((ComplexFraction)e2).getDenominator();
                AlgExp n2 = ((ComplexFraction)e2).getNumerator();
                if (!d2.isSimple() || !n2.isSimple()) {
                    return null;
                }
            }
            if (e1.hasVariable() && e2.hasVariable()) {
                Object[] vars1 = e1.getAllVars().toArray();
                Object[] vars2 = e2.getAllVars().toArray();
                for (int outer = 0; outer < vars1.length; ++outer) {
                    for (int inner = 0; inner < vars2.length; ++inner) {
                        if (((String)vars1[outer]).equalsIgnoreCase((String)vars2[inner])) continue;
                        return null;
                    }
                }
            }
            mulTerm = (result = e1.mul(e2)) instanceof ComplexTerm ? ((ComplexTerm)result).evalMul().toString() : EqFeaturePredicate.evalArithmetic(result.toString());
        }
        catch (ExpParseException e) {
            System.out.println("mulTerm(" + expString1 + "," + expString2 + ")");
            if (RhsGoalTest.getGoalTest() == null) {
                System.out.println("!! Uncomment setGoalTest at RhsState.evalExp() to read current GoalTest!!");
            } else {
                System.out.println(RhsGoalTest.getGoalTest());
            }
            if (RhsGoalTest.getRhsState() == null) {
                System.out.println("!! Uncomment setGoalTest at RhsExhaustiveGoalTest.isGoalState() and RhsGoalTest.isGoalState to read current RhsState!!");
            } else {
                System.out.println(RhsGoalTest.getRhsState());
            }
            e.printStackTrace();
            try {
                System.in.read();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return mulTerm;
    }

    public String divTerm(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        try {
            expString1 = EqFeaturePredicate.evalArithmetic(expString1);
            expString2 = EqFeaturePredicate.evalArithmetic(expString2);
            AlgExp e1 = AlgExp.parseExp(expString1);
            AlgExp e2 = AlgExp.parseExp(expString2);
            if (e1.equals(AlgExp.ZERO)) {
                return "0";
            }
            if (e1.equals(e2)) {
                return "1";
            }
            if (e1.isPolynomial()) {
                return null;
            }
            if (!e2.isSimple() || e2.equals(AlgExp.ZERO)) {
                return null;
            }
            return e1.div(e2).toString();
        }
        catch (ExpParseException e) {
            System.out.println("divTerm(" + expString1 + "," + expString2 + ")...");
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("divTerm(" + expString1 + "," + expString2 + ")...");
            e.printStackTrace();
            return null;
        }
    }

    public String divTermDecimal(String divisor, String divident) {
        if (!EqFeaturePredicate.isArithmeticExpression(divisor) || !EqFeaturePredicate.isArithmeticExpression(divident)) {
            return null;
        }
        String divDecimal = null;
        try {
            AlgExp div1 = AlgExp.parseExp(divisor);
            AlgExp div2 = AlgExp.parseExp(divident);
            divDecimal = div1.divDecimal(div2).toString();
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return divDecimal;
    }

    public static String coefficient(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isVariable()) {
                return "1";
            }
            if (exp.isTerm()) {
                if (exp.isSimpleTerm()) {
                    return ((SimpleTerm)exp).getConstant().toString();
                }
                return EqFeaturePredicate.coefficient(((ComplexTerm)exp).getFirstTerm().toString());
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String firstVarTerm(String expString) {
        String firstVarTerm = null;
        if (EqFeaturePredicate.isArithmeticExpression(expString)) {
            try {
                Polynomial p;
                AlgExp varTerm;
                AlgExp exp = AlgExp.parseExp(expString);
                if (exp.isPolynomial() && (varTerm = (p = (Polynomial)exp).getFirstVarTerm()) != null) {
                    firstVarTerm = varTerm.toString();
                }
            }
            catch (ExpParseException e) {
                e.printStackTrace();
            }
        }
        return firstVarTerm;
    }

    public String lastVarTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            Polynomial p;
            AlgExp term;
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isPolynomial() && (term = (p = (Polynomial)exp).getLastVarTerm()) != null) {
                return term.toString();
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String firstTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            Polynomial p;
            AlgExp term;
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isPolynomial() && (term = (p = (Polynomial)exp).getFirstTerm()) != null) {
                return term.toString();
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String lastTerm(String expString) {
        String lastTerm = null;
        if (EqFeaturePredicate.isArithmeticExpression(expString)) {
            try {
                Polynomial p;
                AlgExp term;
                AlgExp exp = AlgExp.parseExp(expString);
                if (exp.isPolynomial() && (term = (p = (Polynomial)exp).getLastTerm()) != null) {
                    lastTerm = term.toString();
                }
            }
            catch (ExpParseException e) {
                e.printStackTrace();
            }
        }
        return lastTerm;
    }

    public String lastConstTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            Polynomial p;
            AlgExp constant;
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isPolynomial() && (constant = (p = (Polynomial)exp).getLastConstTerm()) != null) {
                return constant.toString();
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String addTermBy(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        String withOp = expString2.charAt(0) == '-' ? expString2 : "+" + expString2;
        return expString1 + withOp;
    }

    public String mulTermBy(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        try {
            AlgExp exp1 = AlgExp.parseExp(expString1);
            AlgExp exp2 = AlgExp.parseExp(expString2);
            String rep1 = expString1;
            String rep2 = expString2;
            if (exp1.isPolynomial() || exp1.isFraction()) {
                rep1 = "(" + expString1 + ")";
            }
            if (exp2.isPolynomial() || exp2.isFraction()) {
                rep2 = "(" + expString2 + ")";
            }
            return rep1 + "*" + rep2;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String divTermBy(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        try {
            AlgExp exp1 = AlgExp.parseExp(expString1);
            AlgExp exp2 = AlgExp.parseExp(expString2);
            String rep1 = expString1;
            String rep2 = expString2;
            if (!exp1.isSimple() || exp1.isNegative()) {
                rep1 = "(" + expString1 + ")";
            }
            if (!exp2.isSimple() || exp2.isSimpleTerm() || exp2.isNegative()) {
                rep2 = "(" + expString2 + ")";
            }
            return rep1 + "/" + rep2;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String reverseSign(String expString) {
        if (expString.indexOf(61) != -1) {
            return null;
        }
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            return exp.negate().toString();
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String varName(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isVariable()) {
                return ((Variable)exp).getName();
            }
            if (exp.isSimpleTerm()) {
                return ((SimpleTerm)exp).getVariable().getName();
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String numerator(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isSimpleTerm()) {
                SimpleTerm t = (SimpleTerm)exp;
                Constant coe = t.getConstant();
                if (coe.isConstantFraction()) {
                    return ((ConstantFraction)coe).getNumerator().toString().concat(t.getVariable().toString());
                }
                if (!coe.isFraction()) {
                    return t.toString();
                }
            }
            if (exp.isConstant()) {
                return ((ConstantFraction)exp).getNumerator().toString();
            }
            return ((ComplexFraction)exp).getNumerator().toString();
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String denominator(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String denominator = null;
        try {
            Constant coe;
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isFraction() && !(exp instanceof SimpleTerm)) {
                if (exp.isConstant()) {
                    denominator = ((ConstantFraction)exp).getDenominator().toString();
                } else if (exp instanceof ComplexFraction) {
                    denominator = ((ComplexFraction)exp).getDenominator().toString();
                } else {
                    System.out.println("What about a fraction " + exp + "?");
                }
            } else if (exp instanceof SimpleTerm && (coe = ((SimpleTerm)exp).getConstant()) != null && coe.isFraction()) {
                denominator = ((ConstantFraction)coe).getDenominator().toString();
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return denominator;
    }

    public String copyTerm(String expString) {
        return expString;
    }

    public String ripCoefficient(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isVariable()) {
                return ((Variable)exp).getName();
            }
            if (exp.isSimpleTerm()) {
                return ((SimpleTerm)exp).getVariable().getName();
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String gcd(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        try {
            AlgExp exp1 = AlgExp.parseExp(expString1);
            AlgExp exp2 = AlgExp.parseExp(expString2);
            if (!exp1.isInt() || !exp2.isInt()) {
                return null;
            }
            int v1 = (int)((IntConst)exp1).getVal();
            int v2 = (int)((IntConst)exp2).getVal();
            if (v1 == 0) {
                return null;
            }
            try {
                int gcd = MathLib.gcd((int)v1, (int)v2);
                if (gcd == 1) {
                    return null;
                }
                return String.valueOf(gcd);
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String lcm(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        try {
            AlgExp exp1 = AlgExp.parseExp(expString1);
            AlgExp exp2 = AlgExp.parseExp(expString2);
            if (!exp1.isInt() || !exp2.isInt()) {
                return null;
            }
            int v1 = (int)((IntConst)exp1).getVal();
            int v2 = (int)((IntConst)exp2).getVal();
            try {
                int lcm2 = MathLib.lcm((int)v1, (int)v2);
                if (lcm2 == 0) {
                    return null;
                }
                return String.valueOf(lcm2);
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String divTen(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String divTen = null;
        try {
            Double dbExp = Double.parseDouble(expString);
            divTen = dbExp / 10.0 % 1.0 == 0.0 ? "" + (int)(dbExp / 10.0) : "" + dbExp / 10.0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return divTen;
    }

    public String mulTen(String exp) {
        String mulTen = null;
        try {
            int intExp = Integer.parseInt(exp);
            mulTen = "" + intExp * 10;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return mulTen;
    }

    public String modTen(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String modTen = null;
        try {
            int intExp = Integer.parseInt(expString);
            modTen = "" + intExp % 10;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return modTen;
    }

    public String inverseTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString) || expString.equals("0")) {
            return null;
        }
        String inverseTerm = null;
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isFraction()) {
                inverseTerm = exp.invert().toString();
            } else if (exp.isSimple()) {
                inverseTerm = exp.invert().toString();
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return inverseTerm;
    }

    public static String evalArithmetic(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String evalArithmetic = null;
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.isConstant() || exp.isFraction()) {
                AlgExp evalExp = exp.eval();
                evalArithmetic = evalExp.toString();
            } else {
                evalArithmetic = AlgExp.cancelDoubleMinus(expString);
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return evalArithmetic;
    }

    public String polynomial(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isPolynomial()) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String hasParentheses(String expString) {
        for (int i = 0; i < expString.length(); ++i) {
            if (expString.charAt(i) != '(') continue;
            return "T";
        }
        return null;
    }

    public String isNegative(String expString) {
        if (expString != null) {
            if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
                return null;
            }
            try {
                AlgExp exp = AlgExp.parseExp(expString);
                if (exp.isNegative()) {
                    return "T";
                }
                return null;
            }
            catch (ExpParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String hasCoefficient(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String coefficient = EqFeaturePredicate.coefficient(expString);
        if (coefficient != null && !coefficient.equals("1")) {
            return "T";
        }
        return null;
    }

    public String hasVarTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.isPolynomial()) {
                return null;
            }
            if (exp.hasVariable()) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String isAVarTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isMonomial() && exp.hasVariable()) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String varTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.isPolynomial() && exp.hasVariable()) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String isVariable(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isVariable()) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String monomial(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isMonomial()) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String hasConstTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isPolynomial() && ((Polynomial)exp).hasConstTerm()) {
                return "T";
            }
            if (exp.isMonomial() && exp.isConstant()) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String isFractionTerm(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isFraction()) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String homogeneous(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isSimple()) {
                return "T";
            }
            if (!exp.isPolynomial()) {
                return null;
            }
            Polynomial p = (Polynomial)exp;
            AlgExp firstHalf = p.getFirstHalf();
            AlgExp secondHalf = p.getSecondHalf();
            String firstString = p.getFirstHalf().toString();
            String secondString = p.getSecondHalf().toString();
            if (this.homogeneous(firstString) != null && this.homogeneous(secondString) != null) {
                String secondVar;
                String firstVar;
                if (!(this.isAVarTerm(firstString) == null && this.hasVarTerm(firstString) == null || this.isAVarTerm(secondString) == null && this.hasVarTerm(secondString) == null || !(firstVar = this.getFirstVar(firstString)).equals(secondVar = this.getFirstVar(secondString)))) {
                    return "T";
                }
                if (this.isAVarTerm(firstString) == null && this.hasVarTerm(firstString) == null && this.isAVarTerm(secondString) == null && this.hasVarTerm(secondString) == null) {
                    return "T";
                }
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String canBeSimplified(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.eval().equals(exp)) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String likeTerms(String term1, String term2) {
        AlgExp exp2;
        AlgExp exp1;
        if (!EqFeaturePredicate.isArithmeticExpression(term1) || !EqFeaturePredicate.isArithmeticExpression(term2)) {
            return null;
        }
        try {
            exp1 = AlgExp.parseExp(term1);
            exp2 = AlgExp.parseExp(term2);
        }
        catch (ExpParseException e) {
            return null;
        }
        if (exp1.isVariable()) {
            exp1 = new SimpleTerm(AlgExp.ONE, (AlgExp)((Variable)exp1));
        }
        if (exp2.isVariable()) {
            exp1 = new SimpleTerm(AlgExp.ONE, (AlgExp)((Variable)exp2));
        }
        if (exp1.isConstant() && exp2.isConstant()) {
            return "T";
        }
        if (exp1.isSimpleTerm() && exp2.isSimpleTerm() && ((SimpleTerm)exp1).getVariable().equals(((SimpleTerm)exp2).getVariable())) {
            return "T";
        }
        return null;
    }

    public String isATermOf(String termString, String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(termString) || !EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp term = AlgExp.parseExp(termString);
            AlgExp exp = AlgExp.parseExp(expString);
            if (!exp.isPolynomial() || term.isPolynomial()) {
                return null;
            }
            Polynomial p = (Polynomial)exp;
            if (p.containsTerm(term)) {
                return "T";
            }
            return null;
        }
        catch (ExpParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String isAFactorOf(String factorString, String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(factorString) || !EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            ComplexTerm ct;
            AlgExp exp = AlgExp.parseExp(expString);
            AlgExp factor = AlgExp.parseExp(factorString);
            if (exp.isSimpleTerm()) {
                SimpleTerm t = (SimpleTerm)exp;
                if (t.getConstant().equals(factor) || t.getVariable().equals(factor)) {
                    return "T";
                }
                return null;
            }
            if (exp.isTerm() && (ct = (ComplexTerm)exp).containsFactor(factor)) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String isNumeratorOf(String numeratorString, String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(numeratorString) || !EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isFraction()) {
                AlgExp numerator = AlgExp.parseExp(numeratorString);
                if (exp.isConstant() ? ((ConstantFraction)exp).getNumerator().equals(numerator) : ((ComplexFraction)exp).getNumerator().equals(numerator)) {
                    return "T";
                }
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String isDenominatorOf(String denominatorString, String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(denominatorString) || !EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(expString);
            if (exp.isFraction()) {
                AlgExp denominator = AlgExp.parseExp(denominatorString);
                if (exp.isConstant() ? ((ConstantFraction)exp).getDenominator().equals(denominator) : ((ComplexFraction)exp).getNumerator().equals(denominator)) {
                    return "T";
                }
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String isConstant(String expString) {
        if (expString.indexOf(61) != -1) {
            return null;
        }
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        try {
            if (AlgExp.parseExp(expString).isConstant()) {
                return "T";
            }
        }
        catch (ExpParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isInteger(String exp) {
        try {
            Integer.parseInt(exp);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isDouble(String exp) {
        try {
            Double.parseDouble(exp);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isFloatingPointNumber(String exp) {
        try {
            Float.parseFloat(exp);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isFloatingPointNumber_nonstatic(String exp) {
        try {
            Float.parseFloat(exp);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean inputMatcher(Polynomial poly1, Polynomial poly2) {
        if (poly1.equals(poly2)) {
            return true;
        }
        return EqFeaturePredicate.inputMatcher(poly1.getFirstHalf(), poly2.getFirstHalf()) && EqFeaturePredicate.inputMatcher(poly1.getSecondHalf(), poly2.getSecondHalf());
    }

    public static boolean inputMatcher(AlgExp exp1, AlgExp exp2) {
        if (exp1.equals(exp2)) {
            return true;
        }
        if (exp1.getClass() != exp2.getClass()) {
            return false;
        }
        if (exp1.isPolynomial() && exp2.isPolynomial()) {
            return EqFeaturePredicate.inputMatcher((Polynomial)exp1, (Polynomial)exp2);
        }
        return false;
    }

    @Override
    public String inputMatcher(String exp1, String exp2) {
        if (exp1 == null || exp2 == null) {
            return null;
        }
        if (EqFeaturePredicate.isSkillOperand(exp1) && EqFeaturePredicate.isSkillOperand(exp2)) {
            if (this.inputMatcher(exp1.split(LIST_SEPARATOR)[1], exp2.split(LIST_SEPARATOR)[1]) != null) {
                return exp1.split(LIST_SEPARATOR)[0].equalsIgnoreCase(exp2.split(LIST_SEPARATOR)[0]) ? "T" : null;
            }
            return null;
        }
        if (exp1.equalsIgnoreCase("slip") || exp2.equalsIgnoreCase("slip")) {
            return "T";
        }
        String result = null;
        int idx1 = exp1.indexOf(46);
        int idx2 = exp2.indexOf(46);
        if (EqFeaturePredicate.isFloatingPointNumber(exp1) && EqFeaturePredicate.isFloatingPointNumber(exp2) && idx1 != -1 && idx2 != -1) {
            Float f1 = new Float(exp1);
            Float f2 = new Float(exp2);
            float diff = Math.abs(f1.floatValue() - f2.floatValue());
            if (diff < 0.01f && diff > ALLOWANCE) {
                System.exit(1);
            }
            if (diff < ALLOWANCE) {
                return "T";
            }
            return null;
        }
        if (exp1.indexOf(32) >= 0 && exp2.indexOf(32) >= 0) {
            result = exp1.equalsIgnoreCase(exp2) ? "T" : null;
        } else {
            try {
                AlgExp algExp1 = AlgExp.parseExp(exp1).eval();
                AlgExp algExp2 = AlgExp.parseExp(exp2).eval();
                if (idx1 >= 0 && algExp2.isConstantFraction()) {
                    String canoExp1 = algExp1.toString();
                    return EqFeaturePredicate.isEqualDecimal(canoExp1, (ConstantFraction)algExp2);
                }
                if (idx2 >= 0 && algExp1.isConstantFraction()) {
                    String canoExp2 = algExp2.toString();
                    return EqFeaturePredicate.isEqualDecimal(canoExp2, (ConstantFraction)algExp1);
                }
                boolean res = false;
                try {
                    InquiryClSolverTutor icst = SimSt.iclSolverTutorForEqFeaturePredicate;
                    String clexp1 = icst.getSm().standardize(exp1, true);
                    String clexp2 = icst.getSm().standardize(exp2, true);
                    res = icst.getSm().algebraicEqual(clexp1, clexp2);
                }
                catch (BadExpressionError err) {
                    err.printStackTrace();
                }
                if (res) {
                    return "T";
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static String isEqualDecimal(String decimalNum, ConstantFraction fraction) {
        String isEqualDecimal = null;
        Constant numerator = fraction.getNumerator();
        Constant denominator = fraction.getDenominator();
        if (numerator.isConstant() && denominator.isConstant()) {
            AlgExp quotient = new IntConst(numerator.getVal()).divDecimal(new IntConst(denominator.getVal()));
            int idx = decimalNum.indexOf(46);
            int sflen = decimalNum.length() - idx - 1;
            int sf = sflen < 3 ? sflen : 3;
            String decimalNumStr = decimalNum.substring(0, sf + idx + 1);
            String quotientStr = quotient.toString();
            int idx2 = quotientStr.indexOf(46);
            if (decimalNumStr.equals(quotientStr = quotientStr.substring(0, sf + idx2 + 1))) {
                isEqualDecimal = "T";
            }
        }
        return isEqualDecimal;
    }

    public static String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    public String removeParens(String s) {
        if (!EqFeaturePredicate.isArithmeticExpression(s)) {
            return null;
        }
        return EqFeaturePredicate.removeChar(EqFeaturePredicate.removeChar(s, ')'), '(');
    }

    public String addTermBy_keepMinus(String expString1, String expString2) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString1) || !EqFeaturePredicate.isArithmeticExpression(expString2)) {
            return null;
        }
        String withOp = "+" + expString2;
        return expString1 + withOp;
    }

    public String[] parseList(String listString) {
        if (!EqFeaturePredicate.isExprList(listString)) {
            return null;
        }
        int length = listString.length();
        if (listString.charAt(0) != '[' || listString.charAt(length - 1) != ']') {
            return null;
        }
        String bracketlessListString = listString.substring(1, length - 1);
        return bracketlessListString.split(LIST_SEPARATOR);
    }

    public String makeList(String[] l) {
        String listString;
        int length = l.length;
        if (length == 0) {
            listString = "";
        } else {
            listString = l[0];
            for (int i = 1; i < l.length; ++i) {
                listString = listString + LIST_SEPARATOR + l[i];
            }
        }
        return "[" + listString + "]";
    }

    public String makeList(Vector v) {
        String[] l = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            l[i] = v.get(i).toString();
        }
        return this.makeList(l);
    }

    public String listAddTerm(String listString) {
        String result;
        if (!EqFeaturePredicate.isExprList(listString)) {
            return null;
        }
        String[] l = this.parseList(listString);
        int length = l.length;
        if (length == 0) {
            result = null;
        } else {
            result = l[0];
            for (int i = 1; i < length; ++i) {
                result = this.addTerm(result, l[i]);
            }
        }
        return result;
    }

    public String listAddTermBy(String listString) {
        String result;
        if (!EqFeaturePredicate.isExprList(listString)) {
            return null;
        }
        String[] l = this.parseList(listString);
        int length = l.length;
        if (length == 0) {
            result = null;
        } else {
            result = l[0];
            for (int i = 1; i < length; ++i) {
                result = this.addTermBy(result, l[i]);
            }
        }
        return result;
    }

    public String getNumSymbolsList(String expString) {
        String numberString;
        int i;
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        Vector<String> numbers = new Vector<String>();
        boolean state = false;
        int j = -1;
        for (i = 0; i < expString.length(); ++i) {
            char c = expString.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' && !state || c == '.') {
                state = true;
                continue;
            }
            if (state) {
                numberString = expString.substring(j + 1, i);
                numbers.add(numberString);
            }
            state = false;
            j = c == '-' ? i - 1 : i;
        }
        if (state) {
            numberString = expString.substring(j + 1, i);
            numbers.add(numberString);
        }
        return this.makeList(numbers);
    }

    public String getFirstVar(String expString) {
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String s = expString.toLowerCase();
        char c = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c < 'a' || c > 'z') continue;
            return "" + c;
        }
        return null;
    }

    public String getVariableSymbol(String expString) {
        return this.getFirstVar(expString);
    }

    public String algebraTest(String s) {
        return "";
    }

    public String[] getExpListTokens(String expList) {
        String tokens = expList.substring(1, expList.length() - 1);
        return tokens.split(LIST_SEPARATOR);
    }

    public String appendVarSymbol(String s, String var) {
        if (!"T".equals(this.isConstant(s)) || !this.isVarExpression(var)) {
            return null;
        }
        return s + var;
    }

    private boolean isVarExpression(String var) {
        char varChar = var.toLowerCase().charAt(0);
        return var.length() == 1 && 'a' <= varChar && varChar <= 'z';
    }

    public boolean hasNumber(String s) {
        char c = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c < '0' || c > '9') continue;
            return true;
        }
        return false;
    }

    public void IfHasNumberAddToTerms(int state, String expString, int i, int j, Vector terms) {
        String termString;
        if (state == 1 && this.hasNumber(termString = expString.substring(j + 1, i))) {
            terms.add(termString);
        }
    }

    public String dropSimpleVarSymbol(String expString) {
        int i;
        if (!EqFeaturePredicate.isArithmeticExpression(expString)) {
            return null;
        }
        String s = expString.toLowerCase();
        Vector terms = new Vector();
        int state = 0;
        int j = -1;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' && state == 0 || c == '.' || c >= 'a' && c <= 'z') {
                state = 1;
                continue;
            }
            this.IfHasNumberAddToTerms(state, expString, i, j, terms);
            state = 0;
            j = c == '-' ? i - 1 : i;
        }
        this.IfHasNumberAddToTerms(state, expString, i, j, terms);
        return this.listAddTermBy(this.makeList(terms));
    }

    public String getVarTermSymbols(String s) {
        if (!EqFeaturePredicate.isArithmeticExpression(s)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(s);
            if (!exp.isPolynomial()) {
                if (exp.hasVariable()) {
                    return s;
                }
                return "";
            }
            if (exp.isPolynomial()) {
                Polynomial p = (Polynomial)exp;
                Vector terms = p.getAllTerms();
                Vector<AlgExp> varterms = new Vector<AlgExp>();
                for (AlgExp a : terms) {
                    if (!a.hasVariable()) continue;
                    varterms.add(a);
                }
                String m = this.makeList(varterms);
                return this.listAddTermBy(m);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String getConstTermSymbols(String s) {
        if (!EqFeaturePredicate.isArithmeticExpression(s)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(s);
            if (!exp.isPolynomial()) {
                if (!exp.hasVariable()) {
                    return s;
                }
                return "";
            }
            if (exp.isPolynomial()) {
                Polynomial p = (Polynomial)exp;
                Vector terms = p.getAllTerms();
                Vector<AlgExp> varterms = new Vector<AlgExp>();
                for (AlgExp a : terms) {
                    if (a.hasVariable()) continue;
                    varterms.add(a);
                }
                String m = this.makeList(varterms);
                return this.listAddTermBy(m);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String listFirstNegativeFunnyAdd(String listString) {
        boolean firstNegative;
        if (!EqFeaturePredicate.isExprList(listString)) {
            return null;
        }
        String[] l = this.parseList(listString);
        int length = l.length;
        if (length == 0) {
            return null;
        }
        String result = l[0];
        boolean bl = firstNegative = result.charAt(0) == '-';
        if (firstNegative) {
            result = this.reverseSign(result);
        }
        for (int i = 1; i < length; ++i) {
            result = this.addTerm(result, l[i]);
        }
        if (firstNegative) {
            result = this.reverseSign(result);
        }
        return result;
    }

    public String listAddSymbols(String s) {
        return this.listAddTerm(s);
    }

    public String butLastTerm(String s) {
        if (!EqFeaturePredicate.isArithmeticExpression(s)) {
            return null;
        }
        try {
            AlgExp exp = AlgExp.parseExp(s);
            if (!exp.isPolynomial()) {
                return "";
            }
            if (exp.isPolynomial()) {
                Polynomial p = (Polynomial)exp;
                Vector terms = p.getAllTerms();
                Vector<AlgExp> varterms = new Vector<AlgExp>();
                for (AlgExp a : terms) {
                    varterms.add(a);
                }
                varterms.remove(varterms.size() - 1);
                String m = this.makeList(varterms);
                return this.listAddTermBy(m);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    String getFirstNumberString(String string) {
        String number = null;
        boolean hasGottenNumber = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                if (!hasGottenNumber) {
                    number = "";
                    hasGottenNumber = true;
                }
                number = number + c;
                continue;
            }
            if (hasGottenNumber) break;
        }
        return number;
    }

    String getFirstVarString(String string) {
        String var = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char lc = Character.toLowerCase(c);
            if ('a' > lc || lc > 'z') continue;
            var = "" + lc;
            break;
        }
        return var;
    }

    String calcNumbers(String string) {
        String numString = null;
        int num = 0;
        int sum2 = 0;
        int sign = 1;
        boolean gottenSignAlready = false;
        boolean gottenNumberAlready = false;
        boolean gottenSum = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-' || c == '+') {
                if (gottenSignAlready) {
                    return null;
                }
                if (gottenNumberAlready) {
                    System.out.println("sum = " + (sum2 += num * sign));
                    gottenSum = true;
                    gottenNumberAlready = false;
                }
                sign = c == '-' ? -1 : 1;
                gottenSignAlready = true;
                continue;
            }
            if (Character.isDigit(c)) {
                if (!gottenNumberAlready) {
                    num = 0;
                    gottenNumberAlready = true;
                }
                num = num * 10 + (c - 48);
                continue;
            }
            if (!gottenNumberAlready) continue;
            System.out.println("sum = " + (sum2 += num * sign));
            sign = 1;
            gottenSum = true;
            gottenNumberAlready = false;
            gottenSignAlready = false;
        }
        if (gottenNumberAlready) {
            System.out.println("sum = " + (sum2 += num * sign));
            gottenSum = true;
        }
        if (gottenSum) {
            numString = "" + sum2;
        }
        return numString;
    }
}

