/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import java.util.HashSet;
import java.util.Set;

public class Variable
extends AlgExp {
    protected String name;
    protected AlgExp order;

    public Variable(String s) {
        this.name = s;
        this.isVariable = true;
        this.isSimple = true;
        this.order = AlgExp.ONE;
        this.hasVariable = true;
        this.isMonomial = true;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public AlgExp mul(Variable v) {
        return new ComplexTerm(this, v);
    }

    @Override
    public AlgExp add(Variable v) {
        if (v.getName().equals(this.name)) {
            return new SimpleTerm(AlgExp.TWO, (AlgExp)this);
        }
        return new Polynomial(this, v);
    }

    @Override
    public AlgExp div(Variable v) {
        if (v.equals(this)) {
            return AlgExp.ONE;
        }
        return new ComplexFraction(this, v);
    }

    @Override
    public AlgExp div(IntConst c) {
        return new SimpleTerm(c.invert(), (AlgExp)this);
    }

    @Override
    public AlgExp div(DoubleConst c) {
        if (c.equals(AlgExp.ONE)) {
            return this;
        }
        if (c.equals(AlgExp.ZERO)) {
            return AlgExp.ZERO;
        }
        return new SimpleTerm(c, this);
    }

    @Override
    public AlgExp add(IntConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp mul(IntConst c) {
        if (c.equals(AlgExp.ONE)) {
            return this;
        }
        if (c.equals(AlgExp.ZERO)) {
            return AlgExp.ZERO;
        }
        return new SimpleTerm(c, this).eval();
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        if (c.equals(AlgExp.ONE)) {
            return this;
        }
        if (c.equals(AlgExp.ZERO)) {
            return AlgExp.ZERO;
        }
        return new SimpleTerm(c, this);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return new SimpleTerm(f.getDenominator(), this).add(f.getNumerator());
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        return new SimpleTerm(f, this);
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return new SimpleTerm(f.invert(), (AlgExp)this);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return t.add(this);
    }

    @Override
    public AlgExp add(Polynomial e) {
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return ct.add(this);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return e.mul(this);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return ct.mul(this);
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return t.mul(this);
    }

    @Override
    public AlgExp invert() {
        return new ComplexFraction(AlgExp.ONE, this);
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        return this.mul(t.invert());
    }

    @Override
    public AlgExp div(Polynomial e) {
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return cf.add(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    public boolean equals(Object o) {
        return this.equals((Variable)o);
    }

    @Override
    public boolean equals(Variable v) {
        return v.getName().equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Constant c) {
        return false;
    }

    @Override
    public boolean equals(ConstantFraction f) {
        return false;
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return t.equals(this);
    }

    @Override
    public boolean equals(Polynomial e) {
        return e.equals(this);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return ct.equals(this);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return cf.equals(this);
    }

    @Override
    public boolean equals(IntConst c) {
        return false;
    }

    @Override
    public boolean equals(DoubleConst c) {
        return false;
    }

    @Override
    public AlgExp eval() {
        return this;
    }

    @Override
    public boolean hasVariable(String varName) {
        return this.name.equalsIgnoreCase(varName);
    }

    @Override
    public Set getAllVars() {
        HashSet<String> var = new HashSet<String>();
        var.add(this.name);
        return var;
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

