/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.oldpredicates;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExp;
import edu.cmu.pact.miss.userDef.oldpredicates.AlgebraExpTerm;
import java.text.ParseException;
import mylib.MathLib;

public class AlgebraExpPoly
extends AlgebraExp {
    @Override
    public boolean isPolynomial() {
        return true;
    }

    @Override
    public boolean isTerm() {
        return this.getOp().equals("*") || this.getOp().equals("/");
    }

    @Override
    public boolean isValidPolynomial() {
        return this.getFirstTerm() != null && this.getSecondTerm() != null;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    public AlgebraExpPoly() {
    }

    public AlgebraExpPoly(String op, AlgebraExp firstT, AlgebraExp secondT) {
        this.setOp(op);
        this.setFirstTerm(firstT);
        this.setSecondTerm(secondT);
        this.containsDecimals = firstT.isDecimal() || secondT.isDecimal();
    }

    @Override
    String getVarName() {
        String exp = this.getFirstTerm().getVarName();
        if (exp == null) {
            exp = this.getSecondTerm().getVarName();
        }
        return exp;
    }

    @Override
    String getCoefficient() {
        String c1;
        String coefficient = null;
        if (this.getFirstTerm().isTerm() && this.getSecondTerm().isTerm() && (this.getOp().equals("*") || this.getOp().equals("/")) && (c1 = this.getFirstTerm().getCoefficient()) != null) {
            String c2 = this.getSecondTerm().isConstTerm() ? this.getSecondTerm().getExp() : this.getSecondTerm().getCoefficient();
            coefficient = c1 + this.getOp() + c2;
        }
        return coefficient;
    }

    @Override
    public AlgebraExp evalArithmetic() {
        AlgebraExp normalSecond;
        AlgebraExp evalArithmetic = null;
        evalArithmetic = this.getSecondTerm().isTerm() ? this.doArithmetic() : ((normalSecond = this.getSecondTerm().evalArithmetic()).isZero() ? this.getFirstTerm().evalArithmetic() : this.doArithmetic(this.getOp(), this.getFirstTerm().evalArithmetic(), normalSecond));
        return evalArithmetic;
    }

    AlgebraExp doArithmetic() {
        return this.doArithmetic(this.getOp(), this.getFirstTerm().evalArithmetic(), this.getSecondTerm().evalArithmetic());
    }

    AlgebraExp doArithmetic(String op, AlgebraExp t1, AlgebraExp t2) {
        AlgebraExp doArithmetic = null;
        if (op.equals("+")) {
            if (t2.isZero()) {
                doArithmetic = t1;
            } else if (t1.isTerm() && t2.isTerm() || t1.isSimpleFraction() && t2.isSimpleFraction()) {
                doArithmetic = this.evalArithmeticAdd(t1, t2);
            } else if (!t1.isTerm() && t2.isTerm()) {
                doArithmetic = this.doArithmetic(op, t2, t1);
            } else if (!t1.isTerm() && !t2.isTerm()) {
                doArithmetic = this.doArithmetic(op, t1.getSecondTerm(), this.doArithmetic(op, t1.getFirstTerm(), t2));
            } else {
                AlgebraExp sameTerm = t2.lookupSameTypeTerm("+", t1);
                if (sameTerm != null) {
                    AlgebraExp newTerm = this.evalArithmeticAdd(t1, sameTerm);
                    doArithmetic = t2.replaceTerm(sameTerm, newTerm);
                } else {
                    doArithmetic = new AlgebraExpPoly(op, t1, t2);
                }
            }
        } else if (op.equals("*")) {
            doArithmetic = this.evalArithmeticMult(t1, t2);
        } else if (op.equals("/")) {
            doArithmetic = this.evalArithmeticDiv(t1, t2);
        } else {
            String msg = "Invalid expression: " + this.toString();
            RuntimeException e = new RuntimeException(msg);
            e.printStackTrace();
        }
        if (doArithmetic != null && doArithmetic.isPolynomial() && !doArithmetic.isValidPolynomial()) {
            doArithmetic = null;
        }
        return doArithmetic;
    }

    public AlgebraExp evalArithmetic_obsolete() {
        AlgebraExp t1 = this.getFirstTerm();
        AlgebraExp t2 = this.getSecondTerm();
        if (this.getOp().equals("+")) {
            return this.evalArithmeticAdd(t1, t2);
        }
        if (this.getOp().equals("*")) {
            return this.evalArithmeticMult(t1, t2);
        }
        if (this.getOp().equals("/")) {
            return this.evalArithmeticDiv(t1, t2);
        }
        String msg = "Invalid expression: " + this.toString();
        RuntimeException e = new RuntimeException(msg);
        e.printStackTrace();
        return null;
    }

    @Override
    public AlgebraExp addTerm(AlgebraExp term) {
        AlgebraExpPoly t1 = this;
        AlgebraExp t2 = term;
        trace.out("eqfp", "addTerm(" + term + ") called upon " + this);
        if (((AlgebraExp)t1).equals(t2)) {
            return new AlgebraExpPoly("*", t1, new AlgebraExpTerm("2"));
        }
        if (t1.isParenQuanity() && t2.isParenQuanity()) {
            String s1 = ((Object)t1).toString();
            String s2 = t2.toString();
            int leftParenIndex1 = s1.indexOf("(");
            int leftParenIndex2 = s2.indexOf("(");
            int rightParenIndex1 = s1.indexOf(")");
            int rightParenIndex2 = s1.indexOf(")");
            try {
                AlgebraExp withoutCoe1 = AlgebraExp.parseExp(s1.substring(leftParenIndex1 + 1, rightParenIndex1));
                AlgebraExp withoutCoe2 = AlgebraExp.parseExp(s2.substring(leftParenIndex2 + 1, rightParenIndex2));
                if (withoutCoe1.equals(withoutCoe2)) {
                    AlgebraExp coe1 = AlgebraExp.parseExp(s1.substring(0, leftParenIndex1));
                    AlgebraExp coe2 = AlgebraExp.parseExp(s2.substring(0, leftParenIndex2));
                    return new AlgebraExpPoly("*", coe1.addTerm(coe2), t1);
                }
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (t1.isSimpleFraction() && t2.isSimpleFraction()) {
            AlgebraExp d1 = t1.getDenominator();
            AlgebraExp d2 = t2.getDenominator();
            if (!d1.isDecimal() && !d2.isDecimal()) {
                if (d1.isVarTerm()) {
                    return null;
                }
                int d1value = Integer.parseInt(d1.toString());
                if (d2.isVarTerm()) {
                    return null;
                }
                int d2value = Integer.parseInt(d2.toString());
                int commonDenominator = MathLib.lcm((int)d1value, (int)d2value);
                try {
                    AlgebraExp multiplier1 = AlgebraExp.parseExp(String.valueOf(commonDenominator / d1value));
                    AlgebraExp multiplier2 = AlgebraExp.parseExp(String.valueOf(commonDenominator / d2value));
                    return new AlgebraExpPoly("/", t1.getNumerator().multTerm(multiplier1).addTerm(t2.getNumerator().multTerm(multiplier2)), AlgebraExp.parseExp(String.valueOf(commonDenominator)));
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public AlgebraExp divTerm(AlgebraExp term) {
        AlgebraExp divTerm = null;
        AlgebraExp inverseTerm = null;
        if (term.isZero()) {
            return null;
        }
        if (this.equals(term)) {
            return new AlgebraExpTerm("1");
        }
        if (term.isFraction() && !term.getNumerator().isZero()) {
            inverseTerm = new AlgebraExpPoly("/", term.getDenominator(), term.getNumerator());
            divTerm = this.multTerm(inverseTerm);
        } else if (this.isFraction()) {
            inverseTerm = this.getNumerator().divTerm(term);
            if (inverseTerm != null) {
                if (inverseTerm.isFraction()) {
                    AlgebraExp denominator = this.getDenominator().multTerm(inverseTerm.getDenominator());
                    if (denominator != null && !denominator.isZero()) {
                        divTerm = new AlgebraExpPoly("/", inverseTerm.getNumerator(), denominator);
                    }
                } else {
                    divTerm = new AlgebraExpPoly("/", inverseTerm, this.getDenominator());
                }
            }
        } else {
            divTerm = new AlgebraExpPoly("/", this, term);
        }
        return divTerm;
    }

    @Override
    public AlgebraExp multTerm(AlgebraExp term) {
        AlgebraExp multTerm = null;
        if (term.isTerm()) {
            term = term.evalArithmetic();
        }
        if (this.isFraction()) {
            AlgebraExp multiplier = term.divTerm(this.getDenominator());
            if (multiplier != null) {
                if (multiplier.isFraction()) {
                    AlgebraExp numerator = this.getNumerator().multTerm(multiplier.getNumerator());
                    if (numerator != null) {
                        multTerm = new AlgebraExpPoly("/", numerator, multiplier.getDenominator());
                    }
                } else {
                    multTerm = this.getNumerator().multTerm(multiplier);
                }
            }
        } else if (this.isAddition()) {
            AlgebraExp exp1 = this.getFirstTerm().multTerm(term);
            AlgebraExp exp2 = this.getSecondTerm().multTerm(term);
            if (exp1 != null && exp2 != null) {
                multTerm = new AlgebraExpPoly(this.getOp(), exp1, exp2);
            }
        } else {
            AlgebraExp exp = this.getSecondTerm().multTerm(term);
            if (exp != null) {
                multTerm = new AlgebraExpPoly(this.getOp(), this.getFirstTerm(), exp);
            }
        }
        return multTerm;
    }

    @Override
    boolean isConstTerm() {
        return this.getFirstTerm().isConstTerm() && this.getSecondTerm().isConstTerm();
    }

    @Override
    boolean isVarTerm() {
        return this.getFirstTerm().isVarTerm() || this.getSecondTerm().isVarTerm();
    }

    @Override
    boolean equals(AlgebraExp term) {
        return term.isPolynomial() && this.getOp().equals(term.getOp()) && this.getFirstTerm().equals(term.getFirstTerm()) && this.getSecondTerm().equals(term.getSecondTerm());
    }

    @Override
    public String parseTree() {
        String parseTree = "(" + this.getOp() + " " + this.getFirstTerm().parseTree() + " " + this.getSecondTerm().parseTree() + ")";
        return parseTree;
    }

    public String toString() {
        String term1 = this.getFirstTerm().toString();
        String term2 = this.getSecondTerm().toString();
        if (this.getFirstTerm().isAddition()) {
            term1 = "(" + term1 + ")";
        }
        if (this.secondTermNeedParenthesis()) {
            term2 = "(" + term2 + ")";
        }
        String op = this.getOp().equals("+") && term2.charAt(0) == '-' ? "" : this.getOp();
        return term1 + op + term2;
    }

    private boolean secondTermNeedParenthesis() {
        boolean answer = false;
        if (!this.getOp().equals("+") && this.getSecondTerm().isPolynomial()) {
            answer = true;
        } else if (this.getOp().equals("/")) {
            if (this.getSecondTerm().isVarTerm() && !this.getSecondTerm().getCoefficient().equals("1")) {
                answer = true;
            } else if (this.getSecondTerm().isConstTerm() && this.getSecondTerm().toString().charAt(0) == '-') {
                answer = true;
            }
        }
        return answer;
    }
}

