/*
 * Decompiled with CFR 0.152.
 */
package org.tiling.scheduling.examples;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.tiling.scheduling.ScheduleIterator;
import org.tiling.scheduling.Scheduler;
import org.tiling.scheduling.SchedulerTask;
import org.tiling.scheduling.examples.iterators.CompositeIterator;
import org.tiling.scheduling.examples.iterators.RestrictedDailyIterator;

public class HeatingController {
    private final Scheduler scheduler = new Scheduler();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
    private final int weekdayHourOfDay;
    private final int weekdayMinute;
    private final int weekdaySecond;
    private final int weekendHourOfDay;
    private final int weekendMinute;
    private final int weekendSecond;

    public HeatingController(int weekdayHourOfDay, int weekdayMinute, int weekdaySecond, int weekendHourOfDay, int weekendMinute, int weekendSecond) {
        this.weekdayHourOfDay = weekdayHourOfDay;
        this.weekdayMinute = weekdayMinute;
        this.weekdaySecond = weekdaySecond;
        this.weekendHourOfDay = weekendHourOfDay;
        this.weekendMinute = weekendMinute;
        this.weekendSecond = weekendSecond;
    }

    public void start() {
        int[] weekdays = new int[]{2, 3, 4, 5, 6};
        int[] weekend = new int[]{7, 1};
        CompositeIterator i = new CompositeIterator(new ScheduleIterator[]{new RestrictedDailyIterator(this.weekdayHourOfDay, this.weekdayMinute, this.weekdaySecond, weekdays), new RestrictedDailyIterator(this.weekendHourOfDay, this.weekendMinute, this.weekendSecond, weekend)});
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                this.switchHeatingOn();
            }

            private void switchHeatingOn() {
                System.out.println("Switch heating on at " + HeatingController.this.dateFormat.format(new Date()));
            }
        }, i);
    }

    public static void main(String[] args) {
        HeatingController heatingController = new HeatingController(8, 0, 0, 9, 0, 0);
        heatingController.start();
    }
}

