/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import pact.CommWidgets.JCommWidget;
import pact.EconGraph.GraphPanel;
import pact.EconGraph.Line;
import pact.EconGraph.ParameterProvider;
import pact.EconGraph.Point;
import pact.EconGraph.PointListener;

public class EconGraphingTool
extends JCommWidget
implements PointListener,
ParameterProvider {
    protected GraphPanel graphPanel;
    protected String imageName;
    private Color oldColor;
    private int lastX;
    private int lastY;
    private int lastPointNum;
    private String lastLine;
    private String parameterString;
    private boolean initialized;
    private String[] parameters;
    private Hashtable parameterTable = new Hashtable();

    @Override
    public void updatePointListener(String lineName, int pointNum, int newX, int newY) {
        this.lastLine = lineName;
        this.lastX = newX;
        this.lastY = newY;
        this.lastPointNum = pointNum;
        this.dirty = true;
        this.sendValue();
        this.dirty = false;
    }

    @Override
    public String getCommNameToSend() {
        return new String(this.commName + "_" + this.lastLine + "_" + this.lastPointNum);
    }

    @Override
    public void reset(TutorController controller) {
        this.graphPanel.reset();
    }

    public EconGraphingTool() {
        this.setLayout(new GridLayout(1, 1));
        this.graphPanel = new GraphPanel();
        this.add(this.graphPanel);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.actionName = "UpdateEGT";
        Point.addPointListener(this);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "EconGraphingTool");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateEGT")) {
            this.doCorrectAction(selection, input);
        }
    }

    @Override
    public void doCorrectAction(String selection, String input) {
        trace.out(5, this, "in doCORRECT");
        String line = this.getLine(selection);
        int point = this.getPoint(selection);
        int x = this.getX(input);
        int y = this.getY(input);
        Line l = (Line)this.graphPanel.hashtable.get(line);
        trace.out(5, this, "selection = " + selection);
        trace.out(5, this, "input = " + input);
        trace.out(5, this, "line l = " + l);
        Point oldPoint = l.point[point];
        trace.out(5, this, "oldPoint" + oldPoint);
        oldPoint.setName(line);
        oldPoint.isCorrect = true;
        if (this.graphPanel.getDragLine()) {
            for (int a = 0; a < l.point.length; ++a) {
                l.point[a].color = this.correctColor;
            }
            this.graphPanel.dragLine(new Point(x, y), l.point[point], true);
        } else {
            l.point[point].move(new Point(x, y));
            if (this.lastX == l.point[point].x && this.lastY == l.point[point].y) {
                l.point[point].useTemp = true;
                l.point[point].setTempColor(this.correctColor);
            }
        }
        this.graphPanel.makeGraph();
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        trace.out(5, this, "in doINCORRECT");
        String line = this.getLine(selection);
        int point = this.getPoint(selection);
        int x = this.getX(input);
        int y = this.getY(input);
        Line l = (Line)this.graphPanel.hashtable.get(line);
        Point oldPoint = l.point[point];
        oldPoint.setName(line);
        oldPoint.isCorrect = false;
        if (this.graphPanel.getDragLine()) {
            for (int a = 0; a < l.point.length; ++a) {
                l.point[a].color = this.incorrectColor;
            }
            this.graphPanel.dragLine(new Point(x, y), l.point[point], true);
        } else {
            l.point[point].move(new Point(x, y));
            l.point[point].color = this.incorrectColor;
        }
        this.graphPanel.makeGraph();
    }

    private int getX(String input) {
        return Integer.valueOf(input.substring(0, input.indexOf(",")));
    }

    private int getY(String input) {
        return Integer.valueOf(input.substring(input.indexOf(", ") + 2, input.indexOf(": ")));
    }

    private String getLine(String selection) {
        return selection.substring(selection.indexOf("_") + 1, selection.lastIndexOf("_"));
    }

    private int getPoint(String selection) {
        return Integer.valueOf(selection.substring(selection.lastIndexOf("_") + 1, selection.length()));
    }

    @Override
    public String getParameter(String name) {
        if (this.parameters == null) {
            throw new Error("Parameters property must be set.");
        }
        return (String)this.parameterTable.get(name);
    }

    public String getParameters() {
        return this.parameterString;
    }

    public void setParameters(String parameterString) {
        trace.out(5, this, "setting parameters to " + this.parameters);
        this.parameterString = parameterString;
    }

    public void parseParameters() {
        trace.out(5, this, "parameter string = " + this.parameterString);
        if (this.parameterString == null) {
            trace.out(5, this, "Error: parameterString property of EconGraphingTool not set.  Cannot init this EconGraphingTool");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.parameterString);
        this.parameters = new String[tokenizer.countTokens()];
        trace.out(5, this, "b " + tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            for (int k = 0; k < this.parameters.length; ++k) {
                this.parameters[k] = new String();
                this.parameters[k] = tokenizer.nextToken();
                trace.out(5, this, "tokenizing " + this.parameters[k]);
            }
        }
        System.out.print(this.parameters.length);
        for (int i = 0; i < this.parameters.length - 1; i += 2) {
            trace.out(5, this, "adding paramter " + this.parameters[i] + ", " + this.parameters[i + 1]);
            this.parameterTable.put(this.parameters[i], this.parameters[i + 1]);
        }
    }

    public boolean initialize() {
        if (this.initialized) {
            return true;
        }
        this.initialized = true;
        boolean b = super.initialize(this.getController());
        this.graphPanel.setParameterProvider(this);
        this.parseParameters();
        this.graphPanel.init();
        for (int i = 0; i < this.graphPanel.line.length; ++i) {
            for (int j = 0; j < this.graphPanel.line[i].point.length; ++j) {
                this.addCommWidgetName(this.commName + "_" + this.graphPanel.line[i].name + "_" + j);
            }
        }
        this.parseParameters();
        return b;
    }

    @Override
    public boolean isChangedFromResetState() {
        return true;
    }

    @Override
    public Object getValue() {
        return new String("" + this.lastX + ", " + this.lastY + ": " + this.oldColor);
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        block0: for (int i = 0; i < this.graphPanel.line.length; ++i) {
            for (int j = 0; j < this.graphPanel.line[i].point.length; ++j) {
                if (!this.graphPanel.line[i].point[j].hasBeenMoved) continue;
                this.graphPanel.line[i].point[j].useTemp = false;
                this.lastX = this.graphPanel.line[i].point[j].x;
                this.lastY = this.graphPanel.line[i].point[j].y;
                this.lastLine = this.graphPanel.line[i].name;
                this.lastPointNum = j;
                v.addElement(this.getCurrentStateMessage());
                continue block0;
            }
        }
        return v;
    }

    @Override
    public void setToolTipText(String text) {
        this.graphPanel.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.graphPanel.getToolTipText();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

