/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.ComponentDescription;
import edu.cmu.pact.Utilities.StringTokenizerItemValues;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class JCommMultipleChoice
extends JCommQuestion
implements ActionListener,
MouseListener {
    boolean choicesCreated;
    boolean choicesInitialized;
    private static int HORIZONTAL_LAYOUT = 1;
    private static int VERTICAL_LAYOUT = 2;
    private int nChoices = 4;
    private int choiceLayout = 2;
    MultipleChoiceRadioButton[] choices;
    JPanel choicesPanel = new JPanel();
    ButtonGroup choiceGroup = new ButtonGroup();
    int currentChoice = -1;
    protected ArrayList choiceTexts = new ArrayList();
    String choiceTextsStr;
    private int dialogOrder = 1;
    MultipleChoiceRadioButton dummyButton = new MultipleChoiceRadioButton();
    private static int counter = 0;
    private boolean alreadyDone = false;
    static Vector selectedCellsList = new Vector();
    static Vector selectedValues = new Vector();
    static JFrame selectedCellsFrame;
    static JList nameList;
    static JList valuesList;
    static DefaultListModel nameModel;
    static DefaultListModel valuesModel;
    protected Font questionFont = new Font("", 1, 13);
    protected Font choiceTextFont;

    public JCommMultipleChoice() {
        this.setActionName("UpdateMultipleChoice");
        this.locked = false;
        this.backgroundNormalColor = new MultipleChoiceRadioButton().getBackground();
        this.choiceTextsStr = "Option0,Option1,Option2,Option3";
        for (int i = 0; i < this.nChoices; ++i) {
            this.choiceTexts.add(i, "Option" + i);
        }
        this.questionText = "Question?";
        this.createChoices();
        this.constructSelectedCellsFrame();
        this.addMouseListener(this);
    }

    private void sendSelectedCells() {
        if (this.getUniversalToolProxy() == null) {
            JOptionPane.showMessageDialog(null, "Warning: The Connection to the Production System should be made before sending the selection elements. \n Open the Behavior Recorder to establish a connection.", "Warning", 2);
        } else {
            MessageObject mo = MessageObject.create("SendSelectedElements");
            mo.setVerb("SendSelectedElements");
            mo.setProperty("SelectedElements", selectedCellsList);
            mo.setProperty("SelectedElementsValues", selectedValues);
            this.getController().getUniversalToolProxy().sendMessage(mo);
        }
    }

    private void constructSelectedCellsFrame() {
        selectedCellsFrame = new JFrame();
        nameModel = new DefaultListModel();
        valuesModel = new DefaultListModel();
        nameList = new JList(nameModel);
        valuesList = new JList(valuesModel);
        selectedCellsFrame.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)new JLabel("Name"), "North");
        namePanel.add((Component)nameList, "Center");
        namePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel valuesPanel = new JPanel();
        valuesPanel.setLayout(new BorderLayout());
        valuesPanel.add((Component)new JLabel("Value"), "North");
        valuesPanel.add((Component)valuesList, "Center");
        valuesPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton okBtn = new JButton("Send");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCommMultipleChoice.this.sendSelectedCells();
                selectedCellsFrame.hide();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selectedCellsFrame.hide();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        centerPanel.setLayout(new GridLayout(1, 1));
        centerPanel.add(namePanel);
        centerPanel.add(valuesPanel);
        selectedCellsFrame.getContentPane().add((Component)centerPanel, "Center");
        selectedCellsFrame.getContentPane().add((Component)btnPanel, "South");
    }

    public void createChoices() {
        this.removeAll();
        this.choicesPanel.removeAll();
        this.choiceGroup = null;
        this.choiceGroup = new ButtonGroup();
        this.choices = null;
        this.choices = new MultipleChoiceRadioButton[this.nChoices];
        this.setLayout(new BorderLayout());
        this.setQuestionText(this.questionText);
        this.questionLbl.setFocusable(false);
        this.questionLbl.setFont(this.questionFont);
        this.add(this.questionLbl);
        if (this.choiceLayout == HORIZONTAL_LAYOUT) {
            this.choicesPanel.setLayout(new FlowLayout());
        } else {
            this.choicesPanel.setLayout(new GridLayout(0, 1));
        }
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i] = new MultipleChoiceRadioButton();
            this.choices[i].setFont(this.choiceTextFont);
            this.choices[i].addActionListener(this);
            if (this.currentChoice == i) {
                this.choices[i].setSelected(true);
            }
            this.choiceGroup.add(this.choices[i]);
            this.choicesPanel.add(this.choices[i]);
            this.choices[i].addMouseListener(new MouseListenerClass());
        }
        this.setChoiceText();
        this.add((Component)this.questionLbl, "North");
        this.add(this.choicesPanel);
        this.setBackground(this.backgroundNormalColor);
        this.choicesCreated = true;
        this.choicesPanel.validate();
        this.validate();
    }

    @Override
    protected boolean initialize() {
        if (this.choicesInitialized) {
            return true;
        }
        if (!super.initialize()) {
            return false;
        }
        this.addStudentActionListener((StudentActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addIncorrectActionListener((IncorrectActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addCommListener();
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        this.choicesInitialized = true;
        return true;
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (this.getController().getUniversalToolProxy() == null) {
            return mo;
        }
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo = this.formDescriptionMessage();
        return mo;
    }

    public MessageObject formDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommMultipleChoice");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("Question", this.getQuestionText());
        mo.setProperty("nChoices", new Integer(this.nChoices));
        mo.setProperty("ChoicesValues", this.getChoiceTexts());
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    protected void doAction(String input, Color color, Font font) {
        this.resetChoiceColors();
        int index = this.choiceTexts.indexOf(input);
        for (int i = 0; i < this.choices.length; ++i) {
            if (i != index) continue;
            this.choices[i].setSelected(true);
            MultipleChoiceRadioButton b = this.choices[i];
            b.setForeground(color);
        }
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.doAction(input, this.correctColor, this.correctFont);
            if (this.getUniversalToolProxy().lockWidget()) {
                this.locked = true;
                for (int i = 0; i < this.choices.length; ++i) {
                    if (this.choices[i].isSelected()) continue;
                    this.choices[i].setEnabled(false);
                }
            }
            if (!this.alreadyDone) {
                this.fireStudentAction(new StudentActionEvent(this));
                this.alreadyDone = true;
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.doAction(input, this.LISPCheckColor, this.correctFont);
        if (this.getUniversalToolProxy().lockWidget()) {
            this.locked = true;
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.doAction(input, this.incorrectColor, this.incorrectFont);
        this.locked = false;
        this.alreadyDone = false;
        this.fireIncorrectAction(new IncorrectActionEvent(this));
    }

    @Override
    public void doInterfaceDescription(MessageObject messageObject) {
        ComponentDescription cd = new ComponentDescription(this);
        cd.executeGraphicalProperties(messageObject);
        String question = (String)messageObject.getProperty("Question");
        if (question == null) {
            return;
        }
        this.setQuestionText(question.trim());
        String choicesValues = (String)messageObject.getProperty("ChoicesValues");
        Object nChoices = messageObject.getProperty("nChoices");
        if (choicesValues == null || nChoices == null) {
            return;
        }
        int nChoicesInt = Integer.parseInt(nChoices.toString());
        if (nChoicesInt <= 0) {
            return;
        }
        this.setChoiceTexts(choicesValues);
        this.setNChoices(nChoicesInt);
        this.createChoices();
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    public void setQuestionFont(Font questionFont) {
        this.questionFont = questionFont;
        this.questionLbl.setFont(questionFont);
    }

    public Font getQuestionFont() {
        return this.questionFont;
    }

    public void setChoiceTextFont(Font choiceTextFont) {
        this.choiceTextFont = choiceTextFont;
        if (this.choicesCreated) {
            for (int i = 0; i < this.nChoices; ++i) {
                this.choices[i].setFont(choiceTextFont);
            }
        }
    }

    public Font getChoiceTextFont() {
        return this.choiceTextFont;
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.requestFocus();
    }

    public MultipleChoiceRadioButton getSelectedChoice() {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].isSelected()) continue;
            return this.choices[i];
        }
        return null;
    }

    public int getSelectedChoiceIndex() {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void resetChoiceColors() {
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i].setForeground(this.startColor);
            this.choices[i].setFont(JCommMultipleChoice.getDefaultFont());
        }
    }

    @Override
    public Object getValue() {
        int index = this.getSelectedChoiceIndex();
        if (index != -1) {
            return this.choiceTexts.get(index);
        }
        return null;
    }

    @Override
    public boolean isChangedFromResetState() {
        MultipleChoiceRadioButton btn = this.getSelectedChoice();
        if (this.currentChoice != -1 && btn != null) {
            return !this.choices[this.currentChoice].equals(btn);
        }
        return false;
    }

    @Override
    public void reset(TutorController controller) {
        this.alreadyDone = false;
        this.initialize();
        this.setEnabled(true);
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i].setEnabled(true);
        }
        MultipleChoiceRadioButton btn = this.getSelectedChoice();
        if (btn != null) {
            btn.setSelected(false);
            btn.setForeground(this.startColor);
        }
        this.choiceGroup.setSelected(this.dummyButton.getModel(), true);
        if (this.currentChoice != -1 && this.currentChoice < this.choices.length) {
            this.choices[this.currentChoice].setSelected(true);
        }
        this.locked = false;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.nChoices > 0) {
            this.createChoices();
        }
    }

    public void setNChoices(int n) {
        if (n <= 0) {
            return;
        }
        this.nChoices = n;
        this.createChoices();
    }

    public int getNChoices() {
        return this.nChoices;
    }

    public String getChoiceTexts() {
        trace.out(5, this, "choiceTextsStr = " + this.choiceTextsStr);
        if (this.choiceTextsStr == null) {
            return "";
        }
        return this.choiceTextsStr;
    }

    private boolean isMatchNChoiceTexts(int choiceNumber, String choiceTexts) {
        if (choiceTexts == null) {
            return false;
        }
        int choiceTextsNum = 0;
        StringTokenizerItemValues st = new StringTokenizerItemValues(choiceTexts, ',', '/');
        while (st.hasMoreTokens()) {
            st.nextToken();
            ++choiceTextsNum;
        }
        return choiceNumber == choiceTextsNum;
    }

    public void setChoiceTexts(String texts) {
        if (texts == null) {
            return;
        }
        this.choiceTextsStr = texts;
        StringTokenizerItemValues st = new StringTokenizerItemValues(texts, ',', '/');
        this.choiceTexts.clear();
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            this.choiceTexts.add(str);
        }
        this.setChoiceText();
    }

    public void setChoiceText() {
        Iterator it = this.choiceTexts.iterator();
        for (int i = 0; i < this.choices.length && it.hasNext(); ++i) {
            this.choices[i].setText(Utils.replaceImg((String)it.next()));
        }
        this.choicesPanel.validate();
    }

    @Override
    public String getCommNameToSend() {
        String s = this.commName;
        return s;
    }

    @Override
    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String choiceTemplate = "(deftemplate multipleChoice  (slot name) (multislot choices) (slot value) (slot question))";
        deftemplates.add(choiceTemplate);
        return deftemplates;
    }

    @Override
    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String choicesStr = "";
        for (int j = 0; j < this.getNChoices(); ++j) {
            choicesStr = choicesStr + "\"" + this.choices[j].getText() + "\" ";
        }
        String value = null;
        MultipleChoiceRadioButton btn = this.getSelectedChoice();
        int index = this.getSelectedChoiceIndex();
        if (index != -1) {
            value = (String)this.choiceTexts.get(index);
        }
        trace.out("index=" + index + ", value=" + value);
        String str = "(bind ?" + this.getCommName() + " (assert (multipleChoice (name " + this.getCommName() + ") (choices " + choicesStr + ") (question \"" + this.questionText + "\") (value " + (value == null ? "nil" : "\"" + value + "\"") + "))))";
        instances.add(str);
        return instances;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JCommMultipleChoice multipleChoice = new JCommMultipleChoice();
        frame.getContentPane().add(multipleChoice);
        frame.pack();
        frame.show();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        trace.err("action performed");
        this.removeHighlight(this.commName);
        if (!this.locked && ((MultipleChoiceRadioButton)ae.getSource()).isSelected()) {
            this.dirty = true;
            this.sendValue();
        }
    }

    @Override
    public void setBackground(Color c) {
        this.setBackgroundTemporary(c);
        this.backgroundNormalColor = c;
    }

    public void setBackgroundTemporary(Color c) {
        super.setBackground(c);
        if (this.choicesPanel != null) {
            this.choicesPanel.setBackground(c);
        }
        if (this.choices == null) {
            return;
        }
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i].setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.choicesPanel != null) {
            this.choicesPanel.setForeground(c);
        }
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public synchronized int getCurrentChoice() {
        return this.currentChoice;
    }

    public synchronized void setCurrentChoice(int currentChoice) {
        this.currentChoice = currentChoice;
    }

    public synchronized int getChoiceLayout() {
        return this.choiceLayout;
    }

    public synchronized void setChoiceLayout(int layout) {
        this.choiceLayout = layout;
        this.choicesPanel.removeAll();
        if (this.choiceLayout == HORIZONTAL_LAYOUT) {
            this.choicesPanel.setLayout(new FlowLayout());
        } else {
            this.choicesPanel.setLayout(new GridLayout(0, 1));
        }
        for (int i = 0; i < this.choices.length; ++i) {
            this.choicesPanel.add(this.choices[i]);
        }
        this.choicesPanel.validate();
    }

    public synchronized int getDialogOrder() {
        return this.dialogOrder;
    }

    public synchronized void setDialogOrder(int dialogOrder) {
        this.dialogOrder = dialogOrder;
    }

    @Override
    public void hideAllComponents(boolean b) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(!b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.questionLbl.setEnabled(b);
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i].setEnabled(b);
        }
    }

    public StartUpdateDialog createStartUpdateDialog() {
        return new StartUpdateDialog();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "JCMultipleChoice.mouseClicked(" + e.paramString() + "): ctlr.isDefiningStartState() " + this.getController().isDefiningStartState());
        }
        if (this.getController().isDefiningStartState() && SwingUtilities.isRightMouseButton(e)) {
            this.createStartUpdateDialog();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class MouseListenerClass
    implements MouseListener {
        private MouseListenerClass() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "JCMultipleChoice.MouseLisCls.mouseClicked(" + me.paramString() + "): ctlr.isDefiningStartState() " + JCommMultipleChoice.this.getController().isDefiningStartState());
            }
            if (JCommMultipleChoice.this.getController().isDefiningStartState() && SwingUtilities.isRightMouseButton(me)) {
                JCommMultipleChoice.this.createStartUpdateDialog();
            }
            if (me.isControlDown()) {
                MultipleChoiceRadioButton tc = (MultipleChoiceRadioButton)me.getComponent();
                JCommMultipleChoice.this.repaint();
                if (tc.selected) {
                    tc.setBackground(Color.WHITE);
                    tc.selected = false;
                    selectedCellsList.remove(JCommMultipleChoice.this.getCommNameToSend());
                    selectedValues.remove(JCommMultipleChoice.this.getValue());
                    nameModel.removeElement(JCommMultipleChoice.this.getCommNameToSend());
                    valuesModel.removeElement(JCommMultipleChoice.this.getValue());
                } else {
                    tc.setBackground(Color.PINK);
                    tc.selected = true;
                    this.addToSelectedList(JCommMultipleChoice.this.getCommNameToSend());
                    this.addToSelectedValues(JCommMultipleChoice.this.getValue());
                }
                selectedCellsFrame.validate();
                selectedCellsFrame.pack();
                selectedCellsFrame.show();
            }
            if (me.getClickCount() == 2) {
                // empty if block
            }
        }

        private void clearSelectedValues() {
            selectedValues.removeAll(selectedValues);
        }

        private void addToSelectedValues(Object o) {
            selectedValues.add(o);
            valuesModel.addElement(o);
        }

        private void clearSelectedList() {
            selectedCellsList.removeAll(selectedCellsList);
        }

        private void addToSelectedList(String cellName) {
            selectedCellsList.add(cellName);
            nameModel.addElement(cellName);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    class StartUpdateDialog
    extends JDialog
    implements ActionListener {
        private JPanel titlePanel;
        private JLabel optionJLabel;
        private JPanel optionValuesJPanel;
        private Container contentPane;
        private JLabel questiobJLabel;
        private JLabel nChoiceJLabel;
        private JLabel choiceTextsJLabel;
        private JTextField questionJTextField;
        private JTextField nChoiceJTextField;
        private JTextField choiceTextsJTextField;
        private JPanel resetCancelPanel;
        private JButton resetJButton;
        private JButton cancelJButton;
        private final int DIALOG_LCATION_X = 300;
        private final int DIALOG_LCATION_Y = 200;
        private final int LABEL_WIDTH = 80;
        private final int FIELD_WIDTH = 250;
        private final int ROW_HEIGHT = 20;
        private final int ROW_START_Y = 20;
        private final int ROW_START_X = 10;
        private final int ROW_SPACE = 10;
        private final int HEAD_FOOT_HEIGHT = 130;
        private final int LEFT_RIGHT_SPACE = 10;
        int rowNumber;

        public JButton getSetButton() {
            return this.resetJButton;
        }

        public StartUpdateDialog() {
            super((Frame)JCommMultipleChoice.this.getController().getActiveWindow(), true);
            this.contentPane = this.getContentPane();
            this.questiobJLabel = new JLabel("Question:");
            this.nChoiceJLabel = new JLabel("nChoice:");
            this.choiceTextsJLabel = new JLabel("ChoiceTexts:");
            this.questionJTextField = new JTextField();
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.questionJTextField);
            this.nChoiceJTextField = new JTextField();
            jTextUndoPacket = JUndo.makeTextUndoable(this.nChoiceJTextField);
            this.choiceTextsJTextField = new JTextField();
            jTextUndoPacket = JUndo.makeTextUndoable(this.choiceTextsJTextField);
            this.resetJButton = new JButton("Set");
            this.cancelJButton = new JButton("Cancel");
            this.DIALOG_LCATION_X = 300;
            this.DIALOG_LCATION_Y = 200;
            this.LABEL_WIDTH = 80;
            this.FIELD_WIDTH = 250;
            this.ROW_HEIGHT = 20;
            this.ROW_START_Y = 20;
            this.ROW_START_X = 10;
            this.ROW_SPACE = 10;
            this.HEAD_FOOT_HEIGHT = 130;
            this.LEFT_RIGHT_SPACE = 10;
            this.rowNumber = 0;
            this.setTitle("Set Widget Start Values");
            this.contentPane.setLayout(new BorderLayout());
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new FlowLayout());
            String labelText = "Please set your values for widget ";
            labelText = labelText + JCommMultipleChoice.this.commName + ":";
            this.optionJLabel = new JLabel(labelText);
            this.titlePanel.add(this.optionJLabel);
            this.contentPane.add((Component)this.titlePanel, "North");
            this.optionValuesJPanel = new JPanel();
            this.optionValuesJPanel.setLayout(null);
            this.rowNumber = 1;
            this.questiobJLabel.setSize(80, 20);
            this.questiobJLabel.setLocation(10, 20 + 30 * (this.rowNumber - 1));
            this.optionValuesJPanel.add(this.questiobJLabel);
            this.questionJTextField.setSize(250, 20);
            this.questionJTextField.setLocation(90, 20 + 30 * (this.rowNumber - 1));
            this.questionJTextField.setText(JCommMultipleChoice.this.questionText);
            this.optionValuesJPanel.add(this.questionJTextField);
            this.rowNumber = 2;
            this.nChoiceJLabel.setSize(80, 20);
            this.nChoiceJLabel.setLocation(10, 20 + 30 * (this.rowNumber - 1));
            this.optionValuesJPanel.add(this.nChoiceJLabel);
            this.nChoiceJTextField.setSize(250, 20);
            this.nChoiceJTextField.setLocation(90, 20 + 30 * (this.rowNumber - 1));
            this.nChoiceJTextField.setText(JCommMultipleChoice.this.nChoices + "");
            this.optionValuesJPanel.add(this.nChoiceJTextField);
            this.rowNumber = 3;
            this.choiceTextsJLabel.setSize(80, 20);
            this.choiceTextsJLabel.setLocation(10, 20 + 30 * (this.rowNumber - 1));
            this.optionValuesJPanel.add(this.choiceTextsJLabel);
            this.choiceTextsJTextField.setText(JCommMultipleChoice.this.getChoiceTexts());
            this.choiceTextsJTextField.setSize(250, 20);
            this.choiceTextsJTextField.setLocation(90, 20 + 30 * (this.rowNumber - 1));
            this.optionValuesJPanel.add(this.choiceTextsJTextField);
            this.contentPane.add((Component)this.optionValuesJPanel, "Center");
            this.resetCancelPanel = new JPanel();
            this.resetCancelPanel.setLayout(new FlowLayout());
            this.resetJButton.addActionListener(this);
            this.cancelJButton.addActionListener(this);
            this.resetCancelPanel.add(this.resetJButton);
            this.resetCancelPanel.add(this.cancelJButton);
            this.contentPane.add((Component)this.resetCancelPanel, "South");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StartUpdateDialog.this.dispose();
                }
            });
            this.setSize(360, 20 + 30 * (this.rowNumber - 1) + 130);
            this.setLocation(300, 200);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.resetJButton) {
                String choiceTexts;
                String choiceNumberString = this.nChoiceJTextField.getText().trim();
                int choiceNumber = Integer.parseInt(choiceNumberString);
                if (!JCommMultipleChoice.this.isMatchNChoiceTexts(choiceNumber, choiceTexts = this.choiceTextsJTextField.getText().trim())) {
                    JOptionPane.showMessageDialog(null, "OptionNumber and OptionValues don't match.", "Warning", 1);
                    return;
                }
                JCommMultipleChoice.this.setQuestionText(this.questionJTextField.getText().trim());
                JCommMultipleChoice.this.setNChoices(choiceNumber);
                JCommMultipleChoice.this.setChoiceTexts(choiceTexts);
                MessageObject mo = JCommMultipleChoice.this.getDescriptionMessage();
                JCommMultipleChoice.this.getUniversalToolProxy().sendMessage(mo);
            }
            this.dispose();
        }
    }

    protected class MultipleChoiceRadioButton
    extends JRadioButton {
        boolean selected = false;

        protected MultipleChoiceRadioButton() {
        }
    }
}

