/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditLabelNameDialog;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import pact.CommWidgets.HighlightThread;
import pact.CommWidgets.JCommPicture;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.StudentActionEvent;

public class JCommRadioButton
extends JCommWidget
implements ActionListener {
    protected JRadioButton radioButton;
    protected boolean previousValue = false;
    protected boolean resetValue = false;
    protected static Hashtable buttonGroupTable;
    protected static Hashtable buttonGroupMembersTable;
    protected Vector buttonGroupMembers = new Vector();
    protected String buttonGroupName;
    protected ButtonGroup buttonGroup;
    protected JPanel container;
    protected boolean actionFromBRFlag;
    protected boolean locked;
    private boolean alreadyDone = false;
    protected boolean selected = false;
    static Vector selectedCellsList;
    static Vector selectedValues;
    static JFrame selectedCellsFrame;
    static JList nameList;
    static JList valuesList;
    static DefaultListModel nameModel;
    static DefaultListModel valuesModel;
    private boolean useOldMessageFormat = true;
    protected String imageName;
    public ImageIcon image;
    public String imageFile = "NoImage.gif";

    public JCommRadioButton() {
        this.radioButton = new JRadioButton();
        this.add(this.radioButton);
        GridLayout g = new GridLayout(1, 1);
        this.setLayout(g);
        try {
            this.radioButton.addActionListener(this);
            this.initialized = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.locked = false;
        this.actionName = "UpdateRadioButton";
        buttonGroupTable = new Hashtable();
        buttonGroupMembersTable = new Hashtable();
        this.backgroundNormalColor = this.radioButton.getBackground();
        this.addFocusListener(this);
        this.originalBorder = this.getBorder();
        this.buttonGroupName = "RadioGroup1";
        this.setText("Comm Radio Button");
        this.constructSelectedCellsFrame();
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    private void constructSelectedCellsFrame() {
        selectedCellsFrame = new JFrame();
        nameModel = new DefaultListModel();
        valuesModel = new DefaultListModel();
        nameList = new JList(nameModel);
        valuesList = new JList(valuesModel);
        selectedCellsFrame.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)new JLabel("Name"), "North");
        namePanel.add((Component)nameList, "Center");
        namePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel valuesPanel = new JPanel();
        valuesPanel.setLayout(new BorderLayout());
        valuesPanel.add((Component)new JLabel("Value"), "North");
        valuesPanel.add((Component)valuesList, "Center");
        valuesPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton okBtn = new JButton("Send");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCommRadioButton.this.sendSelectedCells();
                selectedCellsFrame.hide();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selectedCellsFrame.hide();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        centerPanel.setLayout(new GridLayout(1, 1));
        centerPanel.add(namePanel);
        centerPanel.add(valuesPanel);
        selectedCellsFrame.getContentPane().add((Component)centerPanel, "Center");
        selectedCellsFrame.getContentPane().add((Component)btnPanel, "South");
    }

    private void sendSelectedCells() {
        if (this.getUniversalToolProxy() == null) {
            JOptionPane.showMessageDialog(null, "Warning: The Connection to the Production System should be made before sending the selection elements. \n Open the Behavior Recorder to establish a connection.", "Warning", 2);
        } else {
            MessageObject mo = MessageObject.create("SendSelectedElements");
            mo.setVerb("SendSelectedElements");
            mo.setProperty("SelectedElements", selectedCellsList);
            mo.setProperty("SelectedElementsValues", selectedValues);
            this.getUniversalToolProxy().sendMessage(mo);
        }
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateRadioButton")) {
            this.actionFromBRFlag = true;
            this.radioButton.setEnabled(true);
            if (input.equalsIgnoreCase("true")) {
                this.previousValue = true;
                this.radioButton.setSelected(true);
            } else if (input.equalsIgnoreCase("false")) {
                this.radioButton.setSelected(false);
            }
            for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
                JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
                tempCommRadioButton.setEnabled(true);
                tempCommRadioButton.setLock(false);
                tempCommRadioButton.setForeground(this.startColor);
            }
            return;
        }
        if (action.equalsIgnoreCase("UpdateText")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateText: " + input);
            }
            this.setText(input);
        } else if (action.equalsIgnoreCase("UpdateIcon")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "update Image: " + input);
            }
            this.setImageFile(input);
        } else if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        }
        trace.out(5, this, "**Error**: don't know interface action " + action);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommRadioButton");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate radioButton (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (radioButton (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.actionFromBRFlag = true;
            this.radioButton.setSelected(this.previousValue);
            this.radioButton.setForeground(this.correctColor);
            for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
                JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
                if (this.getController().getUniversalToolProxy().lockWidget()) {
                    tempCommRadioButton.setLock(true);
                }
                if (tempCommRadioButton == this) continue;
                tempCommRadioButton.setForeground(this.startColor);
                if (!this.getController().getUniversalToolProxy().lockWidget()) continue;
                tempCommRadioButton.setEnabled(false);
            }
            this.actionFromBRFlag = false;
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "DRB.doCorrectAction: !" + this.alreadyDone);
            }
            if (!this.alreadyDone) {
                this.fireStudentAction(new StudentActionEvent(this));
                this.alreadyDone = true;
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.actionFromBRFlag = true;
        if (input.equalsIgnoreCase("true")) {
            this.previousValue = true;
        } else if (input.equalsIgnoreCase("false")) {
            this.previousValue = false;
        }
        this.radioButton.setSelected(this.previousValue);
        this.radioButton.setForeground(this.LISPCheckColor);
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                tempCommRadioButton.setLock(true);
            }
            if (tempCommRadioButton == this) continue;
            tempCommRadioButton.setForeground(this.startColor);
            if (!this.getController().getUniversalToolProxy().lockWidget()) continue;
            tempCommRadioButton.setEnabled(false);
        }
        this.actionFromBRFlag = false;
        this.alreadyDone = false;
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.actionFromBRFlag = true;
        if (input.equalsIgnoreCase("true")) {
            this.previousValue = true;
        } else if (input.equalsIgnoreCase("false")) {
            this.previousValue = false;
        }
        this.radioButton.setEnabled(true);
        this.radioButton.setSelected(this.previousValue);
        this.radioButton.setForeground(this.incorrectColor);
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            tempCommRadioButton.setEnabled(true);
            tempCommRadioButton.setLock(false);
            if (tempCommRadioButton == this) continue;
            tempCommRadioButton.setForeground(this.startColor);
        }
        this.actionFromBRFlag = false;
        this.alreadyDone = false;
        this.fireIncorrectAction(new IncorrectActionEvent(this));
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase("UpdateText") && this.getText() != null && this.getText().length() > 0) {
            return this.getText();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateIcon")) {
            return this.getImageFile();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isInvisible();
        }
        if (this.useOldMessageFormat) {
            return new Boolean(this.radioButton.isSelected()).toString();
        }
        return this.commName;
    }

    @Override
    public String getCommNameToSend() {
        if (this.useOldMessageFormat) {
            return this.commName;
        }
        return this.buttonGroupName;
    }

    public boolean getUseOldMessageFormat() {
        return this.useOldMessageFormat;
    }

    public void setUseOldMessageFormat(boolean useOldMessageFormat) {
        this.useOldMessageFormat = useOldMessageFormat;
    }

    @Override
    public void setFont(Font f) {
        if (this.radioButton != null) {
            this.radioButton.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public boolean isChangedFromResetState() {
        return this.radioButton.isSelected();
    }

    @Override
    public void reset(TutorController controller) {
        this.actionFromBRFlag = false;
        this.initialize();
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            tempCommRadioButton.setEnabled(true);
            tempCommRadioButton.setLock(false);
            tempCommRadioButton.setForeground(this.startColor);
        }
        this.radioButton.setSelected(this.resetValue);
        this.previousValue = this.resetValue;
        this.locked = false;
        this.alreadyDone = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setGroup(String buttonGroupName) {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "button group = " + buttonGroupName);
        }
        this.buttonGroupName = buttonGroupName;
    }

    public boolean initialize() {
        boolean b = super.initialize(this.getController());
        this.updateGroup();
        return b;
    }

    private void updateGroup() {
        Vector bGroupMembers;
        ButtonGroup bg;
        if (buttonGroupTable == null || this.buttonGroupName == null) {
            return;
        }
        if (buttonGroupTable.containsKey(this.buttonGroupName)) {
            bg = (ButtonGroup)buttonGroupTable.get(this.buttonGroupName);
            bg.add(this.radioButton);
            this.buttonGroup = bg;
        } else {
            bg = new ButtonGroup();
            bg.add(this.radioButton);
            buttonGroupTable.put(this.buttonGroupName, bg);
            this.buttonGroup = bg;
        }
        if (buttonGroupMembersTable.containsKey(this.buttonGroupName)) {
            bGroupMembers = (Vector)buttonGroupMembersTable.get(this.buttonGroupName);
            bGroupMembers.addElement(this);
            this.buttonGroupMembers = bGroupMembers;
        } else {
            bGroupMembers = new Vector();
            bGroupMembers.addElement(this);
            buttonGroupMembersTable.put(this.buttonGroupName, bGroupMembers);
            this.buttonGroupMembers = bGroupMembers;
        }
    }

    public String getGroup() {
        return this.buttonGroupName;
    }

    @Override
    public boolean getLock(String selection) {
        return this.locked;
    }

    public void setLock(boolean lockFlag) {
        this.locked = lockFlag;
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            if (tempCommRadioButton.getImageFile() != null) {
                tempCommRadioButton.setActionName("UpdateIcon");
                v.addElement(tempCommRadioButton.getCurrentStateMessage());
            }
            if (tempCommRadioButton.getText() != null && tempCommRadioButton.getText().length() > 0) {
                tempCommRadioButton.setActionName("UpdateText");
                v.addElement(tempCommRadioButton.getCurrentStateMessage());
            }
            if (this.isInvisible()) {
                this.setActionName("UpdateInVisible");
                v.addElement(this.getCurrentStateMessage());
            }
            this.setActionName("UpdateRadioButton");
        }
        return v;
    }

    public void setText(String text) {
        this.radioButton.setText(text);
    }

    public String getText() {
        return this.radioButton.getText();
    }

    public void setSelected(boolean flag) {
        this.radioButton.setSelected(flag);
    }

    public boolean getSelected() {
        return this.radioButton.isSelected();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.radioButton != null) {
            this.radioButton.setBackground(c);
        }
        this.backgroundNormalColor = c;
    }

    public void setBackgroundTemporary(Color c) {
        super.setBackground(c);
        if (this.radioButton != null) {
            this.radioButton.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.radioButton != null) {
            this.radioButton.setForeground(c);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.radioButton.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.radioButton.getToolTipText();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.radioButton != null) {
            this.radioButton.addFocusListener(l);
        }
    }

    @Override
    public void startHighlight(String subElement) {
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            HighlightThread t = new HighlightThread(tempCommRadioButton, tempCommRadioButton.getCommName());
            t.start();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    @Override
    public void highlight(String commComponentName, Border highlightBorder) {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "highlight");
        }
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            if (trace.getDebugCode("mps")) {
                trace.out("mps", "radio button = " + tempCommRadioButton.getCommName());
            }
            tempCommRadioButton.setBorder(highlightBorder);
        }
    }

    @Override
    public void removeHighlight(String commComponentName) {
        for (int i = 0; i < this.buttonGroupMembers.size(); ++i) {
            JCommRadioButton tempCommRadioButton = (JCommRadioButton)this.buttonGroupMembers.elementAt(i);
            tempCommRadioButton.setBorder(this.originalBorder);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.radioButton.setEnabled(b);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.radioButton != null) {
            this.radioButton.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.radioButton != null) {
            this.radioButton.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.radioButton != null) {
            return this.radioButton.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.radioButton != null) {
            return this.radioButton.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.radioButton != null) {
            this.radioButton.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.radioButton != null) {
            this.radioButton.removeMouseListener(l);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "mouseClicked: isDefiningStartState = " + this.getController().isDefiningStartState() + " isSelected = " + this.radioButton.isSelected() + " locked = " + this.locked + " actionFromBRFlag = " + this.actionFromBRFlag);
        }
        this.removeHighlight("");
        if (arg0.isControlDown() && this.getController().isDefiningStartState()) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", " in mouseClicked first branch");
            }
            JFrame frame = new JFrame("Modify Label Text");
            String currentDir = System.getProperty("user.dir");
            String title = "Please set the Label for widget " + this.commName + " : ";
            EditLabelNameDialog t = new EditLabelNameDialog(frame, title, this.getText(), this.imageFile, currentDir, this.isInvisible(), true);
            if (!t.getNewLabel().equals(this.getText())) {
                this.setText(t.getNewLabel());
                this.dirty = true;
                this.setActionName("UpdateText");
                this.sendValue();
            }
            if (t.getIcon() != null) {
                this.setImage(t.getIcon());
                this.imageFile = t.getImageName();
                this.dirty = true;
                this.setActionName("UpdateIcon");
                this.sendValue();
            }
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
        } else if (!this.getController().isDefiningStartState() && this.radioButton.isSelected() && !this.locked) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", " in mouseClicked second branch");
            }
            if (this.actionFromBRFlag) {
                this.actionFromBRFlag = false;
            } else {
                this.dirty = true;
                this.setActionName("UpdateRadioButton");
                this.sendValue();
            }
            this.previousValue = this.radioButton.isSelected();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setIcon(Icon icon) {
        if (this.radioButton != null) {
            this.radioButton.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.radioButton != null) {
            return this.radioButton.getIcon();
        }
        return null;
    }

    public String getImageName() {
        return this.imageName;
    }

    private ImageIcon getImage() {
        return this.image;
    }

    public void setImage(ImageIcon image) {
        System.out.println("image = " + image);
        this.image = image;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile != null ? imageFile : "NoImage";
        System.out.println("imageFile = " + imageFile);
        this.setImage(this.loadImage(imageFile));
    }

    protected ImageIcon loadImage(String imageName) {
        URL imageURL;
        block9: {
            if (imageName == null || imageName.length() < 1) {
                return null;
            }
            File imgFile = null;
            imageURL = null;
            try {
                if (!imageName.startsWith("file:") && (imgFile = new File(imageName)).exists()) {
                    System.err.println("Creat icon from physical/relative address");
                    return new ImageIcon(imageName);
                }
            }
            catch (Exception e) {
                trace.err("Can't find file " + imageName);
            }
            try {
                imageURL = new URL(imageName);
                System.err.println("Creat icon from URL address");
            }
            catch (MalformedURLException mal) {
                if (!trace.getDebugCode("log")) break block9;
                trace.out("log", "MalformedURLException message = " + mal.getMessage());
            }
        }
        if (imageURL == null) {
            imageURL = Utils.getURL(imageName, this);
            System.err.println("Creat icon from resource .jar file");
        }
        if (imageURL == null) {
            imageURL = JCommPicture.class.getResource(imageName);
            System.err.println("Creat icon from resource .jar file");
        }
        if (imageURL == null) {
            trace.err("Error: cannot find image " + new File(imageName).getAbsolutePath());
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        ImageIcon imageIcon = new ImageIcon(image, imageName);
        return imageIcon;
    }

    protected ImageIcon oldloadImage(String imageName) {
        URL imageURL;
        block5: {
            if (imageName == null || imageName.length() < 1) {
                return null;
            }
            imageURL = null;
            try {
                imageURL = imageName.startsWith("file:") ? new URL(imageName) : Utils.getURL(imageName, this);
            }
            catch (MalformedURLException mal) {
                if (!trace.getDebugCode("log")) break block5;
                trace.out("log", "MalformedURLException message = " + mal.getMessage());
            }
        }
        if (imageURL == null) {
            imageURL = JCommPicture.class.getResource(imageName);
        }
        if (imageURL == null) {
            trace.err("Error: cannot find image " + new File(imageName).getAbsolutePath());
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        ImageIcon imageIcon = new ImageIcon(image, imageName);
        return imageIcon;
    }

    static {
        selectedCellsList = new Vector();
        selectedValues = new Vector();
    }

    private class MouseListenerClass
    implements MouseListener {
        private MouseListenerClass() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isControlDown()) {
                JCommRadioButton dt = (JCommRadioButton)me.getComponent().getParent();
                if (dt.selected) {
                    dt.setBackground(Color.WHITE);
                    dt.selected = false;
                    selectedCellsList.remove(JCommRadioButton.this.getCommNameToSend());
                    selectedValues.remove(JCommRadioButton.this.getValue());
                    nameModel.removeElement(JCommRadioButton.this.getCommNameToSend());
                    valuesModel.removeElement(JCommRadioButton.this.getValue());
                } else {
                    dt.setBackground(Color.PINK);
                    dt.selected = true;
                    this.addToSelectedList(JCommRadioButton.this.getCommNameToSend());
                    this.addToSelectedValues(JCommRadioButton.this.getValue());
                }
                selectedCellsFrame.validate();
                selectedCellsFrame.pack();
                selectedCellsFrame.show();
            }
        }

        private void clearSelectedValues() {
            selectedValues.removeAll(selectedValues);
        }

        private void addToSelectedValues(Object o) {
            selectedValues.add(o);
            valuesModel.addElement(o);
        }

        private void clearSelectedList() {
            selectedCellsList.removeAll(selectedCellsList);
        }

        private void addToSelectedList(String cellName) {
            selectedCellsList.add(cellName);
            nameModel.addElement(cellName);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

