/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.old_pact.skillometer.SkillometerFrame;
import edu.cmu.pact.Utilities.trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SkillometerManager {
    private SkillometerFrame skillometerFrame;
    private static SkillometerManager instance;
    private Hashtable skillsTable = new Hashtable();
    public static final float MASTERY = 0.95f;

    public float getSkillValue(String skill) {
        float[] estimates = (float[])this.skillsTable.get(skill);
        if (estimates == null) {
            return -1.0f;
        }
        return estimates[0];
    }

    public boolean atMastery(String skill) {
        return this.getSkillValue(skill) > 0.95f;
    }

    public Vector getSkillNames() {
        Vector v = new Vector();
        Enumeration i = this.skillsTable.keys();
        while (i.hasMoreElements()) {
            v.addElement(i.nextElement());
        }
        return v;
    }

    public void updateSkill(String skill, float newPKnown) {
        float[] estimates = (float[])this.skillsTable.get(skill);
        if (estimates == null) {
            trace.out(5, this, "Error: updating nonexistent skill: " + skill);
            return;
        }
        estimates[0] = newPKnown;
        trace.out(5, this, "UPDATE SKILL VALUE " + skill + "new value = " + newPKnown);
        this.skillsTable.put(skill, estimates);
        this.getSkillometerFrame().updateSkillValue(skill, estimates[0]);
    }

    public void updateSkill(String skill, boolean success) {
        float cur_prevL;
        float[] estimates = (float[])this.skillsTable.get(skill);
        if (estimates == null) {
            trace.out(5, this, "Error: updating nonexistent skill: " + skill);
            return;
        }
        float cur_L = estimates[0];
        float cur_T = estimates[1];
        float cur_G = estimates[2];
        float cur_S = estimates[3];
        float last2 = cur_prevL = estimates[0];
        if (success) {
            cur_prevL = cur_prevL * (1.0f - cur_S) / (cur_prevL * (1.0f - cur_S) + (1.0f - cur_prevL) * cur_G);
            cur_L = cur_prevL + cur_T * (1.0f - cur_prevL);
        } else {
            cur_prevL = cur_prevL * cur_S / (cur_prevL * cur_S + (1.0f - cur_prevL) * (1.0f - cur_G));
            cur_L = cur_prevL + cur_T * (1.0f - cur_prevL);
        }
        estimates[0] = cur_L;
        trace.out(5, this, "UPDATE SKILL " + skill + "success = " + success + " old value = " + last2 + " new value = " + cur_L);
        this.skillsTable.remove(skill);
        this.skillsTable.put(skill, estimates);
        this.getSkillometerFrame().updateSkillValue(skill, estimates[0]);
    }

    public void initializeSkill(String skill, float l, float t, float g, float s) {
        float[] params = new float[]{l, t, g, s};
        trace.out(5, this, "Initializing skill " + skill);
        this.skillsTable.put(skill, params);
        this.getSkillometerFrame().addSkill(skill);
        this.getSkillometerFrame().updateSkillValue(skill, l);
    }

    public void initializeSkill(String skill) {
        float l = 0.1f;
        float t = 0.1f;
        float g = 0.3f;
        float s = 0.4f;
        this.initializeSkill(skill, l, t, g, s);
    }

    public void test() {
        this.initializeSkill("Murgling");
        trace.out(5, this, "Murgling = " + this.getSkillValue("Murgling"));
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        trace.out(5, this, "Murgling = " + this.getSkillValue("Murgling"));
        this.updateSkill("Murgling", false);
        trace.out(5, this, "Murgling = " + this.getSkillValue("Murgling"));
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        this.updateSkill("Murgling", true);
        trace.out(5, this, "Murgling = " + this.getSkillValue("Murgling"));
        trace.out(5, this, "Murgling mastery = " + this.atMastery("Murgling"));
        this.initializeSkill("xxx");
        this.updateSkill("xxx", true);
    }

    public void reset() {
        this.skillsTable = new Hashtable();
        this.getSkillometerFrame().clearSkills();
    }

    public void show() {
        this.getSkillometerFrame().show();
    }

    public void hide() {
        this.getSkillometerFrame().hide();
    }

    private SkillometerFrame getSkillometerFrame() {
        if (this.skillometerFrame == null) {
            this.skillometerFrame = new SkillometerFrame("Skillometer");
        }
        return this.skillometerFrame;
    }
}

