/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.ArrayList;
import pact.CommWidgets.Interval;

class TimeLine
extends Canvas {
    protected int locX = 24;
    protected int locY = 20;
    protected int length = 288;
    protected int timeLineFontSize = 10;
    protected int startHour = 0;
    protected int startMinutes = 0;
    protected int endHour = 0;
    protected int endMinutes = 0;
    private ArrayList intervals = new ArrayList();
    private Image greenArrow;
    private Image redArrow;

    public TimeLine() {
        MediaTracker media = new MediaTracker(this);
        this.greenArrow = Toolkit.getDefaultToolkit().getImage(".\\green_arrow.gif");
        this.redArrow = Toolkit.getDefaultToolkit().getImage(".\\red_arrow.gif");
        media.addImage(this.greenArrow, 0);
        media.addImage(this.redArrow, 0);
        try {
            media.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TimeLine(int startHour, int startMinutes, int endHour, int endMinutes) {
        this();
        this.startHour = startHour;
        this.startMinutes = startMinutes;
        this.endHour = endHour;
        this.endMinutes = endMinutes;
    }

    public void setStartTime(int startHour, int startMinutes) {
        this.startHour = startHour;
        this.startMinutes = startMinutes;
        this.repaint();
    }

    public void setEndTime(int endHour, int endMinutes) {
        this.endHour = endHour;
        this.endMinutes = endMinutes;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.drawTimeLine(g);
        this.drawStartEnd(g);
        this.drawIntervals(g);
    }

    public void drawTimeLine(Graphics g) {
        int i;
        for (i = this.locY - 3; i <= this.locY + 3; ++i) {
            g.drawLine(this.locX, i, this.length * 2 + this.locX, i);
        }
        for (i = this.locX; i <= this.length * 2 + this.locX; i += 24) {
            g.drawLine(i, this.locY - 10, i, this.locY + 10);
        }
        g.setFont(new Font(null, 0, this.timeLineFontSize));
        FontMetrics f = g.getFontMetrics();
        for (int i2 = this.locX; i2 <= this.length * 2 + this.locX; i2 += 24) {
            String s = null;
            s = i2 / 24 - 1 > 12 ? Integer.toString(i2 / 24 - 13) : Integer.toString(i2 / 24 - 1);
            if (s.equals("0")) {
                s = new String("12am");
            }
            if (i2 == this.length + 24) {
                s = new String("12pm");
            }
            if (i2 == this.length * 2 + 24) {
                s = new String("12am");
            }
            g.drawString(s, (int)((double)i2 - (double)f.stringWidth(s) / 2.0), this.locY - f.getFont().getSize() - 2);
        }
    }

    public void drawStartEnd(Graphics g) {
        int i;
        g.setColor(Color.gray);
        if (this.startHour == this.endHour && this.startMinutes < this.endMinutes || this.startHour < this.endHour) {
            for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                g.drawLine(this.locX, i, this.locX + this.startHour * 24 + this.startMinutes / 5 * 2, i);
            }
            for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                g.drawLine(this.locX + this.endHour * 24 + this.endMinutes / 5 * 2, i, this.length * 2 + this.locX, i);
            }
        }
        if (this.startHour == this.endHour && this.endMinutes < this.startMinutes || this.endHour < this.startHour) {
            for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                g.drawLine(this.locX + this.endHour * 24 + this.endMinutes / 5 * 2, i, this.locX + this.startHour * 24 + this.startMinutes / 5 * 2, i);
            }
        }
        g.drawImage(this.redArrow, this.locX - 3 + this.endHour * 24 + this.endMinutes / 5 * 2, this.locY + 10, this);
        g.drawImage(this.greenArrow, this.locX - 3 + this.startHour * 24 + this.startMinutes / 5 * 2, this.locY + 10, this);
    }

    public void drawIntervals(Graphics g) {
        g.setColor(Color.red);
        for (int j = 0; j < this.intervals.size(); ++j) {
            int i;
            Interval interval = (Interval)this.intervals.get(j);
            if (interval.getStartHour() == interval.getEndHour() && interval.getStartMinutes() < interval.getEndMinutes() || interval.getStartHour() < interval.getEndHour()) {
                for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                    g.drawLine(this.locX + interval.getStartHour() * 24 + interval.getStartMinutes() / 5 * 2, i, this.locX + interval.getEndHour() * 24 + interval.getEndMinutes() / 5 * 2, i);
                }
            }
            if ((interval.getStartHour() != interval.getEndHour() || interval.getEndMinutes() >= interval.getStartMinutes()) && interval.getEndHour() >= interval.getStartHour()) continue;
            for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                g.drawLine(this.locX + interval.getStartHour() * 24 + interval.getStartMinutes() / 5 * 2, i, this.length * 2 + this.locX, i);
            }
            for (i = this.locY - 3; i <= this.locY + 3; ++i) {
                g.drawLine(this.locX, i, this.locX + interval.getEndHour() * 24 + interval.getEndMinutes() / 5 * 2, i);
            }
        }
    }

    public void addInterval(int startHour, int startMinutes, int endHour, int endMinutes) {
        Interval i = new Interval(startHour, startMinutes, endHour, endMinutes);
        this.intervals.add(i);
    }

    public void timelineClear() {
        this.intervals.clear();
        this.repaint();
    }
}

